// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed under the Creative Commons Public Domain, for
// any use, without warranty, 2008 by Mahesh Kumashikar
// SPDX-License-Identifier: CC0-1.0

module t_math_synmul_mul (/*AUTOARG*/
  // Outputs
  product_d4,
  // Inputs
  clk, enable, negate, datA, datB
  );
  input clk;
  input enable;
  input negate;

  input [31:0] datA;
  input [31:0] datB;

  // verilator lint_off UNOPTFLAT

  output reg [64:0] product_d4;

  reg [33:0] datA_d1r;
  reg [33:0] datB_d1r;

  always @ (posedge clk) begin
    if (enable) begin
      datA_d1r <= {2'b0,datA};
      datB_d1r <= {2'b0,datB};
      // The extra multiplier bits were for signed, for this
      // test we've ripped that out
      if (negate) $stop;
    end
  end

  reg en_d1;
  reg en_d2;
  reg en_d3;
  always @ (posedge clk) begin
    en_d1 <= enable;
    en_d2 <= en_d1;
    en_d3 <= en_d2;
  end

  wire [63:0] prod_d3;

  smmultiplier_34_34 mul (.OPA(datA_d1r),
                          .OPB(datB_d1r),
                          .RESULT(prod_d3),
                          /*AUTOINST*/
                          // Inputs
                          .clk                  (clk),
                          .en_d1                (en_d1),
                          .en_d2                (en_d2));

  always @ (posedge clk) begin
    if (en_d3) begin
      product_d4 <= {1'b0,prod_d3};
    end
  end

endmodule

// The below was originally generated by the "Synthesizable Arithmetic Module Generator"
// at http://modgen.fysel.ntnu.no/~pihl/iwlas98/ then cleaned up by hand.
// Unfortunately the generator no longer appears available.  Please contact
// us if you know otherwise.

// verilog_format: off
module smmultiplier_34_34
  (
  input clk,
  input en_d1,
  input en_d2,

  input [33:0] OPA,
  input [33:0] OPB,
  output [63:0] RESULT
  );

  wire [628:0] PPBIT;
  wire [66:0] INT_CARRY;
  wire [66:0] INT_SUM;
  smboothcoder_34_34 db (.OPA(OPA[33:0]), .OPB(OPB[33:0]), .SUMMAND(PPBIT[628:0]) );
  smwallace_34_34 dw (.SUMMAND(PPBIT[628:0]), .CARRY(INT_CARRY[66:1]), .SUM(INT_SUM[66:0]),
                /*AUTOINST*/
                      // Inputs
                      .clk              (clk),
                      .en_d1            (en_d1),
                      .en_d2            (en_d2));
  assign INT_CARRY[0] = 1'b0;
  smdblcadder_128_128 dd (.OPA(INT_SUM[63:0]), .OPB(INT_CARRY[63:0]), .CIN (1'b0), .SUM(RESULT));
endmodule

module smdblcadder_128_128 (OPA, OPB, CIN, SUM);
  input [63:0] OPA;
  input [63:0] OPB;
  input CIN;
  output [63:0] SUM;
  wire [63:0] INTPROP;
  wire [63:0] INTGEN;
  wire [0:0] PBIT;
  wire [63:0] CARRY;
  smprestage_128 dp (OPA[63:0], OPB[63:0], CIN, INTPROP, INTGEN);
  smdblctree_128 dd (INTPROP[63:0], INTGEN[63:0], CARRY[63:0], PBIT);
  smxorstage_128 dx (OPA[63:0], OPB[63:0], PBIT[0], CARRY[63:0], SUM);
endmodule

module smdblctree_128 (PIN, GIN, GOUT, POUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [63:0] GOUT;
  output [0:0] POUT;
  wire [63:0] INTPROP_0;
  wire [63:0] INTGEN_0;
  wire [63:0] INTPROP_1;
  wire [63:0] INTGEN_1;
  wire [63:0] INTPROP_2;
  wire [63:0] INTGEN_2;
  wire [63:0] INTPROP_3;
  wire [63:0] INTGEN_3;
  wire [63:0] INTPROP_4;
  wire [63:0] INTGEN_4;
  wire [63:0] INTPROP_5;
  wire [63:0] INTGEN_5;
  smdblc_0_128 ddb0 (.PIN(PIN), .GIN(GIN), .POUT(INTPROP_0), .GOUT(INTGEN_0) );
  smdblc_1_128 ddb1 (.PIN(INTPROP_0), .GIN(INTGEN_0), .POUT(INTPROP_1), .GOUT(INTGEN_1) );
  smdblc_2_128 ddb2 (.PIN(INTPROP_1), .GIN(INTGEN_1), .POUT(INTPROP_2), .GOUT(INTGEN_2) );
  smdblc_3_128 ddb3 (.PIN(INTPROP_2), .GIN(INTGEN_2), .POUT(INTPROP_3), .GOUT(INTGEN_3) );
  smdblc_4_128 ddb4 (.PIN(INTPROP_3), .GIN(INTGEN_3), .POUT(INTPROP_4), .GOUT(INTGEN_4) );
  smdblc_5_128 ddb5 (.PIN(INTPROP_4), .GIN(INTGEN_4), .POUT(INTPROP_5), .GOUT(INTGEN_5) );
  smdblc_6_128 ddb6 (.PIN(INTPROP_5), .GIN(INTGEN_5), .POUT(POUT), .GOUT(GOUT) );
endmodule

module smwallace_34_34
  (
  input clk,
  input en_d1,
  input en_d2,

  input  [628:0] SUMMAND,
  output [65:0] CARRY,
  output [66:0] SUM
  );

  wire [628:0] LATCHED_PP;
  wire [551:0] INT_CARRY;
  wire [687:0] INT_SUM;
  smffa  dla0 (.D(SUMMAND[0]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[0]) );
  smffa  dla1 (.D(SUMMAND[1]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[1]) );
  smhalfadder dha0 (.DATA_A (LATCHED_PP[0]), .DATA_B (LATCHED_PP[1]), .SAVE (INT_SUM[0]), .CARRY (INT_CARRY[0]) );
  smffb  dla2 (.D(INT_SUM[0]), .clk(clk), .en_d2(en_d2), .Q(SUM[0]) );
  smffb  dla3 (.D(INT_CARRY[0]), .clk(clk), .en_d2(en_d2), .Q(CARRY[0]) );
  smffa  dla4 (.D(SUMMAND[2]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[2]) );
  assign INT_SUM[1] = LATCHED_PP[2];
  assign CARRY[1] = 1'b0;
  smffb  dla5 (.D(INT_SUM[1]), .clk(clk), .en_d2(en_d2), .Q(SUM[1]) );
  smffa  dla6 (.D(SUMMAND[3]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[3]) );
  smffa  dla7 (.D(SUMMAND[4]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[4]) );
  smffa  dla8 (.D(SUMMAND[5]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[5]) );
  smfulladder dfa0 (.DATA_A (LATCHED_PP[3]), .DATA_B (LATCHED_PP[4]), .DATA_C (LATCHED_PP[5]), .SAVE (INT_SUM[2]), .CARRY (INT_CARRY[1]) );
  smffb  dla9 (.D(INT_SUM[2]), .clk(clk), .en_d2(en_d2), .Q(SUM[2]) );
  smffb  dla10 (.D(INT_CARRY[1]), .clk(clk), .en_d2(en_d2), .Q(CARRY[2]) );
  smffa  dla11 (.D(SUMMAND[6]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[6]) );
  smffa  dla12 (.D(SUMMAND[7]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[7]) );
  smhalfadder dha1 (.DATA_A (LATCHED_PP[6]), .DATA_B (LATCHED_PP[7]), .SAVE (INT_SUM[3]), .CARRY (INT_CARRY[2]) );
  smffb  dla13 (.D(INT_SUM[3]), .clk(clk), .en_d2(en_d2), .Q(SUM[3]) );
  smffb  dla14 (.D(INT_CARRY[2]), .clk(clk), .en_d2(en_d2), .Q(CARRY[3]) );
  smffa  dla15 (.D(SUMMAND[8]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[8]) );
  smffa  dla16 (.D(SUMMAND[9]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[9]) );
  smffa  dla17 (.D(SUMMAND[10]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[10]) );
  smfulladder dfa1 (.DATA_A (LATCHED_PP[8]), .DATA_B (LATCHED_PP[9]), .DATA_C (LATCHED_PP[10]), .SAVE (INT_SUM[4]), .CARRY (INT_CARRY[4]) );
  smffa  dla18 (.D(SUMMAND[11]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[11]) );
  assign INT_SUM[5] = LATCHED_PP[11];
  smhalfadder dha2 (.DATA_A (INT_SUM[4]), .DATA_B (INT_SUM[5]), .SAVE (INT_SUM[6]), .CARRY (INT_CARRY[3]) );
  smffb  dla19 (.D(INT_SUM[6]), .clk(clk), .en_d2(en_d2), .Q(SUM[4]) );
  smffb  dla20 (.D(INT_CARRY[3]), .clk(clk), .en_d2(en_d2), .Q(CARRY[4]) );
  smffa  dla21 (.D(SUMMAND[12]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[12]) );
  smffa  dla22 (.D(SUMMAND[13]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[13]) );
  smffa  dla23 (.D(SUMMAND[14]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[14]) );
  smfulladder dfa2 (.DATA_A (LATCHED_PP[12]), .DATA_B (LATCHED_PP[13]), .DATA_C (LATCHED_PP[14]), .SAVE (INT_SUM[7]), .CARRY (INT_CARRY[6]) );
  smhalfadder dha3 (.DATA_A (INT_SUM[7]), .DATA_B (INT_CARRY[4]), .SAVE (INT_SUM[8]), .CARRY (INT_CARRY[5]) );
  smffb  dla24 (.D(INT_SUM[8]), .clk(clk), .en_d2(en_d2), .Q(SUM[5]) );
  smffb  dla25 (.D(INT_CARRY[5]), .clk(clk), .en_d2(en_d2), .Q(CARRY[5]) );
  smffa  dla26 (.D(SUMMAND[15]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[15]) );
  smffa  dla27 (.D(SUMMAND[16]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[16]) );
  smffa  dla28 (.D(SUMMAND[17]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[17]) );
  smfulladder dfa3 (.DATA_A (LATCHED_PP[15]), .DATA_B (LATCHED_PP[16]), .DATA_C (LATCHED_PP[17]), .SAVE (INT_SUM[9]), .CARRY (INT_CARRY[8]) );
  smffa  dla29 (.D(SUMMAND[18]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[18]) );
  smffa  dla30 (.D(SUMMAND[19]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[19]) );
  smhalfadder dha4 (.DATA_A (LATCHED_PP[18]), .DATA_B (LATCHED_PP[19]), .SAVE (INT_SUM[10]), .CARRY (INT_CARRY[9]) );
  smfulladder dfa4 (.DATA_A (INT_SUM[9]), .DATA_B (INT_SUM[10]), .DATA_C (INT_CARRY[6]), .SAVE (INT_SUM[11]), .CARRY (INT_CARRY[7]) );
  smffb  dla31 (.D(INT_SUM[11]), .clk(clk), .en_d2(en_d2), .Q(SUM[6]) );
  smffb  dla32 (.D(INT_CARRY[7]), .clk(clk), .en_d2(en_d2), .Q(CARRY[6]) );
  smffa  dla33 (.D(SUMMAND[20]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[20]) );
  smffa  dla34 (.D(SUMMAND[21]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[21]) );
  smffa  dla35 (.D(SUMMAND[22]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[22]) );
  smfulladder dfa5 (.DATA_A (LATCHED_PP[20]), .DATA_B (LATCHED_PP[21]), .DATA_C (LATCHED_PP[22]), .SAVE (INT_SUM[12]), .CARRY (INT_CARRY[11]) );
  smffa  dla36 (.D(SUMMAND[23]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[23]) );
  assign INT_SUM[13] = LATCHED_PP[23];
  smfulladder dfa6 (.DATA_A (INT_SUM[12]), .DATA_B (INT_SUM[13]), .DATA_C (INT_CARRY[8]), .SAVE (INT_SUM[14]), .CARRY (INT_CARRY[12]) );
  assign INT_SUM[15] = INT_CARRY[9];
  smhalfadder dha5 (.DATA_A (INT_SUM[14]), .DATA_B (INT_SUM[15]), .SAVE (INT_SUM[16]), .CARRY (INT_CARRY[10]) );
  smffb  dla37 (.D(INT_SUM[16]), .clk(clk), .en_d2(en_d2), .Q(SUM[7]) );
  smffb  dla38 (.D(INT_CARRY[10]), .clk(clk), .en_d2(en_d2), .Q(CARRY[7]) );
  smffa  dla39 (.D(SUMMAND[24]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[24]) );
  smffa  dla40 (.D(SUMMAND[25]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[25]) );
  smffa  dla41 (.D(SUMMAND[26]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[26]) );
  smfulladder dfa7 (.DATA_A (LATCHED_PP[24]), .DATA_B (LATCHED_PP[25]), .DATA_C (LATCHED_PP[26]), .SAVE (INT_SUM[17]), .CARRY (INT_CARRY[14]) );
  smffa  dla42 (.D(SUMMAND[27]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[27]) );
  smffa  dla43 (.D(SUMMAND[28]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[28]) );
  smffa  dla44 (.D(SUMMAND[29]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[29]) );
  smfulladder dfa8 (.DATA_A (LATCHED_PP[27]), .DATA_B (LATCHED_PP[28]), .DATA_C (LATCHED_PP[29]), .SAVE (INT_SUM[18]), .CARRY (INT_CARRY[15]) );
  smfulladder dfa9 (.DATA_A (INT_SUM[17]), .DATA_B (INT_SUM[18]), .DATA_C (INT_CARRY[11]), .SAVE (INT_SUM[19]), .CARRY (INT_CARRY[16]) );
  smhalfadder dha6 (.DATA_A (INT_SUM[19]), .DATA_B (INT_CARRY[12]), .SAVE (INT_SUM[20]), .CARRY (INT_CARRY[13]) );
  smffb  dla45 (.D(INT_SUM[20]), .clk(clk), .en_d2(en_d2), .Q(SUM[8]) );
  smffb  dla46 (.D(INT_CARRY[13]), .clk(clk), .en_d2(en_d2), .Q(CARRY[8]) );
  smffa  dla47 (.D(SUMMAND[30]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[30]) );
  smffa  dla48 (.D(SUMMAND[31]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[31]) );
  smffa  dla49 (.D(SUMMAND[32]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[32]) );
  smfulladder dfa10 (.DATA_A (LATCHED_PP[30]), .DATA_B (LATCHED_PP[31]), .DATA_C (LATCHED_PP[32]), .SAVE (INT_SUM[21]), .CARRY (INT_CARRY[18]) );
  smffa  dla50 (.D(SUMMAND[33]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[33]) );
  smffa  dla51 (.D(SUMMAND[34]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[34]) );
  smhalfadder dha7 (.DATA_A (LATCHED_PP[33]), .DATA_B (LATCHED_PP[34]), .SAVE (INT_SUM[22]), .CARRY (INT_CARRY[19]) );
  smfulladder dfa11 (.DATA_A (INT_SUM[21]), .DATA_B (INT_SUM[22]), .DATA_C (INT_CARRY[14]), .SAVE (INT_SUM[23]), .CARRY (INT_CARRY[20]) );
  assign INT_SUM[24] = INT_CARRY[15];
  smfulladder dfa12 (.DATA_A (INT_SUM[23]), .DATA_B (INT_SUM[24]), .DATA_C (INT_CARRY[16]), .SAVE (INT_SUM[25]), .CARRY (INT_CARRY[17]) );
  smffb  dla52 (.D(INT_SUM[25]), .clk(clk), .en_d2(en_d2), .Q(SUM[9]) );
  smffb  dla53 (.D(INT_CARRY[17]), .clk(clk), .en_d2(en_d2), .Q(CARRY[9]) );
  smffa  dla54 (.D(SUMMAND[35]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[35]) );
  smffa  dla55 (.D(SUMMAND[36]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[36]) );
  smffa  dla56 (.D(SUMMAND[37]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[37]) );
  smfulladder dfa13 (.DATA_A (LATCHED_PP[35]), .DATA_B (LATCHED_PP[36]), .DATA_C (LATCHED_PP[37]), .SAVE (INT_SUM[26]), .CARRY (INT_CARRY[22]) );
  smffa  dla57 (.D(SUMMAND[38]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[38]) );
  smffa  dla58 (.D(SUMMAND[39]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[39]) );
  smffa  dla59 (.D(SUMMAND[40]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[40]) );
  smfulladder dfa14 (.DATA_A (LATCHED_PP[38]), .DATA_B (LATCHED_PP[39]), .DATA_C (LATCHED_PP[40]), .SAVE (INT_SUM[27]), .CARRY (INT_CARRY[23]) );
  smffa  dla60 (.D(SUMMAND[41]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[41]) );
  assign INT_SUM[28] = LATCHED_PP[41];
  smfulladder dfa15 (.DATA_A (INT_SUM[26]), .DATA_B (INT_SUM[27]), .DATA_C (INT_SUM[28]), .SAVE (INT_SUM[29]), .CARRY (INT_CARRY[24]) );
  smhalfadder dha8 (.DATA_A (INT_CARRY[18]), .DATA_B (INT_CARRY[19]), .SAVE (INT_SUM[30]), .CARRY (INT_CARRY[25]) );
  smfulladder dfa16 (.DATA_A (INT_SUM[29]), .DATA_B (INT_SUM[30]), .DATA_C (INT_CARRY[20]), .SAVE (INT_SUM[31]), .CARRY (INT_CARRY[21]) );
  smffb  dla61 (.D(INT_SUM[31]), .clk(clk), .en_d2(en_d2), .Q(SUM[10]) );
  smffb  dla62 (.D(INT_CARRY[21]), .clk(clk), .en_d2(en_d2), .Q(CARRY[10]) );
  smffa  dla63 (.D(SUMMAND[42]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[42]) );
  smffa  dla64 (.D(SUMMAND[43]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[43]) );
  smffa  dla65 (.D(SUMMAND[44]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[44]) );
  smfulladder dfa17 (.DATA_A (LATCHED_PP[42]), .DATA_B (LATCHED_PP[43]), .DATA_C (LATCHED_PP[44]), .SAVE (INT_SUM[32]), .CARRY (INT_CARRY[27]) );
  smffa  dla66 (.D(SUMMAND[45]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[45]) );
  smffa  dla67 (.D(SUMMAND[46]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[46]) );
  smffa  dla68 (.D(SUMMAND[47]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[47]) );
  smfulladder dfa18 (.DATA_A (LATCHED_PP[45]), .DATA_B (LATCHED_PP[46]), .DATA_C (LATCHED_PP[47]), .SAVE (INT_SUM[33]), .CARRY (INT_CARRY[28]) );
  smfulladder dfa19 (.DATA_A (INT_SUM[32]), .DATA_B (INT_SUM[33]), .DATA_C (INT_CARRY[22]), .SAVE (INT_SUM[34]), .CARRY (INT_CARRY[29]) );
  assign INT_SUM[35] = INT_CARRY[23];
  smfulladder dfa20 (.DATA_A (INT_SUM[34]), .DATA_B (INT_SUM[35]), .DATA_C (INT_CARRY[24]), .SAVE (INT_SUM[36]), .CARRY (INT_CARRY[30]) );
  assign INT_SUM[37] = INT_CARRY[25];
  smhalfadder dha9 (.DATA_A (INT_SUM[36]), .DATA_B (INT_SUM[37]), .SAVE (INT_SUM[38]), .CARRY (INT_CARRY[26]) );
  smffb  dla69 (.D(INT_SUM[38]), .clk(clk), .en_d2(en_d2), .Q(SUM[11]) );
  smffb  dla70 (.D(INT_CARRY[26]), .clk(clk), .en_d2(en_d2), .Q(CARRY[11]) );
  smffa  dla71 (.D(SUMMAND[48]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[48]) );
  smffa  dla72 (.D(SUMMAND[49]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[49]) );
  smffa  dla73 (.D(SUMMAND[50]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[50]) );
  smfulladder dfa21 (.DATA_A (LATCHED_PP[48]), .DATA_B (LATCHED_PP[49]), .DATA_C (LATCHED_PP[50]), .SAVE (INT_SUM[39]), .CARRY (INT_CARRY[32]) );
  smffa  dla74 (.D(SUMMAND[51]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[51]) );
  smffa  dla75 (.D(SUMMAND[52]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[52]) );
  smffa  dla76 (.D(SUMMAND[53]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[53]) );
  smfulladder dfa22 (.DATA_A (LATCHED_PP[51]), .DATA_B (LATCHED_PP[52]), .DATA_C (LATCHED_PP[53]), .SAVE (INT_SUM[40]), .CARRY (INT_CARRY[33]) );
  smffa  dla77 (.D(SUMMAND[54]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[54]) );
  assign INT_SUM[41] = LATCHED_PP[54];
  smffa  dla78 (.D(SUMMAND[55]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[55]) );
  assign INT_SUM[42] = LATCHED_PP[55];
  smfulladder dfa23 (.DATA_A (INT_SUM[39]), .DATA_B (INT_SUM[40]), .DATA_C (INT_SUM[41]), .SAVE (INT_SUM[43]), .CARRY (INT_CARRY[34]) );
  smfulladder dfa24 (.DATA_A (INT_SUM[42]), .DATA_B (INT_CARRY[27]), .DATA_C (INT_CARRY[28]), .SAVE (INT_SUM[44]), .CARRY (INT_CARRY[35]) );
  smfulladder dfa25 (.DATA_A (INT_SUM[43]), .DATA_B (INT_SUM[44]), .DATA_C (INT_CARRY[29]), .SAVE (INT_SUM[45]), .CARRY (INT_CARRY[36]) );
  smhalfadder dha10 (.DATA_A (INT_SUM[45]), .DATA_B (INT_CARRY[30]), .SAVE (INT_SUM[46]), .CARRY (INT_CARRY[31]) );
  smffb  dla79 (.D(INT_SUM[46]), .clk(clk), .en_d2(en_d2), .Q(SUM[12]) );
  smffb  dla80 (.D(INT_CARRY[31]), .clk(clk), .en_d2(en_d2), .Q(CARRY[12]) );
  smffa  dla81 (.D(SUMMAND[56]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[56]) );
  smffa  dla82 (.D(SUMMAND[57]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[57]) );
  smffa  dla83 (.D(SUMMAND[58]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[58]) );
  smfulladder dfa26 (.DATA_A (LATCHED_PP[56]), .DATA_B (LATCHED_PP[57]), .DATA_C (LATCHED_PP[58]), .SAVE (INT_SUM[47]), .CARRY (INT_CARRY[38]) );
  smffa  dla84 (.D(SUMMAND[59]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[59]) );
  smffa  dla85 (.D(SUMMAND[60]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[60]) );
  smffa  dla86 (.D(SUMMAND[61]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[61]) );
  smfulladder dfa27 (.DATA_A (LATCHED_PP[59]), .DATA_B (LATCHED_PP[60]), .DATA_C (LATCHED_PP[61]), .SAVE (INT_SUM[48]), .CARRY (INT_CARRY[39]) );
  smffa  dla87 (.D(SUMMAND[62]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[62]) );
  assign INT_SUM[49] = LATCHED_PP[62];
  smfulladder dfa28 (.DATA_A (INT_SUM[47]), .DATA_B (INT_SUM[48]), .DATA_C (INT_SUM[49]), .SAVE (INT_SUM[50]), .CARRY (INT_CARRY[40]) );
  smhalfadder dha11 (.DATA_A (INT_CARRY[32]), .DATA_B (INT_CARRY[33]), .SAVE (INT_SUM[51]), .CARRY (INT_CARRY[41]) );
  smfulladder dfa29 (.DATA_A (INT_SUM[50]), .DATA_B (INT_SUM[51]), .DATA_C (INT_CARRY[34]), .SAVE (INT_SUM[52]), .CARRY (INT_CARRY[42]) );
  assign INT_SUM[53] = INT_CARRY[35];
  smfulladder dfa30 (.DATA_A (INT_SUM[52]), .DATA_B (INT_SUM[53]), .DATA_C (INT_CARRY[36]), .SAVE (INT_SUM[54]), .CARRY (INT_CARRY[37]) );
  smffb  dla88 (.D(INT_SUM[54]), .clk(clk), .en_d2(en_d2), .Q(SUM[13]) );
  smffb  dla89 (.D(INT_CARRY[37]), .clk(clk), .en_d2(en_d2), .Q(CARRY[13]) );
  smffa  dla90 (.D(SUMMAND[63]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[63]) );
  smffa  dla91 (.D(SUMMAND[64]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[64]) );
  smffa  dla92 (.D(SUMMAND[65]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[65]) );
  smfulladder dfa31 (.DATA_A (LATCHED_PP[63]), .DATA_B (LATCHED_PP[64]), .DATA_C (LATCHED_PP[65]), .SAVE (INT_SUM[55]), .CARRY (INT_CARRY[44]) );
  smffa  dla93 (.D(SUMMAND[66]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[66]) );
  smffa  dla94 (.D(SUMMAND[67]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[67]) );
  smffa  dla95 (.D(SUMMAND[68]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[68]) );
  smfulladder dfa32 (.DATA_A (LATCHED_PP[66]), .DATA_B (LATCHED_PP[67]), .DATA_C (LATCHED_PP[68]), .SAVE (INT_SUM[56]), .CARRY (INT_CARRY[45]) );
  smffa  dla96 (.D(SUMMAND[69]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[69]) );
  smffa  dla97 (.D(SUMMAND[70]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[70]) );
  smffa  dla98 (.D(SUMMAND[71]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[71]) );
  smfulladder dfa33 (.DATA_A (LATCHED_PP[69]), .DATA_B (LATCHED_PP[70]), .DATA_C (LATCHED_PP[71]), .SAVE (INT_SUM[57]), .CARRY (INT_CARRY[46]) );
  smfulladder dfa34 (.DATA_A (INT_SUM[55]), .DATA_B (INT_SUM[56]), .DATA_C (INT_SUM[57]), .SAVE (INT_SUM[58]), .CARRY (INT_CARRY[47]) );
  smhalfadder dha12 (.DATA_A (INT_CARRY[38]), .DATA_B (INT_CARRY[39]), .SAVE (INT_SUM[59]), .CARRY (INT_CARRY[48]) );
  smfulladder dfa35 (.DATA_A (INT_SUM[58]), .DATA_B (INT_SUM[59]), .DATA_C (INT_CARRY[40]), .SAVE (INT_SUM[60]), .CARRY (INT_CARRY[49]) );
  assign INT_SUM[61] = INT_CARRY[41];
  smfulladder dfa36 (.DATA_A (INT_SUM[60]), .DATA_B (INT_SUM[61]), .DATA_C (INT_CARRY[42]), .SAVE (INT_SUM[62]), .CARRY (INT_CARRY[43]) );
  smffb  dla99 (.D(INT_SUM[62]), .clk(clk), .en_d2(en_d2), .Q(SUM[14]) );
  smffb  dla100 (.D(INT_CARRY[43]), .clk(clk), .en_d2(en_d2), .Q(CARRY[14]) );
  smffa  dla101 (.D(SUMMAND[72]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[72]) );
  smffa  dla102 (.D(SUMMAND[73]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[73]) );
  smffa  dla103 (.D(SUMMAND[74]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[74]) );
  smfulladder dfa37 (.DATA_A (LATCHED_PP[72]), .DATA_B (LATCHED_PP[73]), .DATA_C (LATCHED_PP[74]), .SAVE (INT_SUM[63]), .CARRY (INT_CARRY[51]) );
  smffa  dla104 (.D(SUMMAND[75]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[75]) );
  smffa  dla105 (.D(SUMMAND[76]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[76]) );
  smffa  dla106 (.D(SUMMAND[77]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[77]) );
  smfulladder dfa38 (.DATA_A (LATCHED_PP[75]), .DATA_B (LATCHED_PP[76]), .DATA_C (LATCHED_PP[77]), .SAVE (INT_SUM[64]), .CARRY (INT_CARRY[52]) );
  smffa  dla107 (.D(SUMMAND[78]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[78]) );
  smffa  dla108 (.D(SUMMAND[79]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[79]) );
  smhalfadder dha13 (.DATA_A (LATCHED_PP[78]), .DATA_B (LATCHED_PP[79]), .SAVE (INT_SUM[65]), .CARRY (INT_CARRY[53]) );
  smfulladder dfa39 (.DATA_A (INT_SUM[63]), .DATA_B (INT_SUM[64]), .DATA_C (INT_SUM[65]), .SAVE (INT_SUM[66]), .CARRY (INT_CARRY[54]) );
  smfulladder dfa40 (.DATA_A (INT_CARRY[44]), .DATA_B (INT_CARRY[45]), .DATA_C (INT_CARRY[46]), .SAVE (INT_SUM[67]), .CARRY (INT_CARRY[55]) );
  smfulladder dfa41 (.DATA_A (INT_SUM[66]), .DATA_B (INT_SUM[67]), .DATA_C (INT_CARRY[47]), .SAVE (INT_SUM[68]), .CARRY (INT_CARRY[56]) );
  assign INT_SUM[69] = INT_CARRY[48];
  smfulladder dfa42 (.DATA_A (INT_SUM[68]), .DATA_B (INT_SUM[69]), .DATA_C (INT_CARRY[49]), .SAVE (INT_SUM[70]), .CARRY (INT_CARRY[50]) );
  smffb  dla109 (.D(INT_SUM[70]), .clk(clk), .en_d2(en_d2), .Q(SUM[15]) );
  smffb  dla110 (.D(INT_CARRY[50]), .clk(clk), .en_d2(en_d2), .Q(CARRY[15]) );
  smffa  dla111 (.D(SUMMAND[80]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[80]) );
  smffa  dla112 (.D(SUMMAND[81]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[81]) );
  smffa  dla113 (.D(SUMMAND[82]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[82]) );
  smfulladder dfa43 (.DATA_A (LATCHED_PP[80]), .DATA_B (LATCHED_PP[81]), .DATA_C (LATCHED_PP[82]), .SAVE (INT_SUM[71]), .CARRY (INT_CARRY[58]) );
  smffa  dla114 (.D(SUMMAND[83]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[83]) );
  smffa  dla115 (.D(SUMMAND[84]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[84]) );
  smffa  dla116 (.D(SUMMAND[85]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[85]) );
  smfulladder dfa44 (.DATA_A (LATCHED_PP[83]), .DATA_B (LATCHED_PP[84]), .DATA_C (LATCHED_PP[85]), .SAVE (INT_SUM[72]), .CARRY (INT_CARRY[59]) );
  smffa  dla117 (.D(SUMMAND[86]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[86]) );
  smffa  dla118 (.D(SUMMAND[87]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[87]) );
  smffa  dla119 (.D(SUMMAND[88]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[88]) );
  smfulladder dfa45 (.DATA_A (LATCHED_PP[86]), .DATA_B (LATCHED_PP[87]), .DATA_C (LATCHED_PP[88]), .SAVE (INT_SUM[73]), .CARRY (INT_CARRY[60]) );
  smffa  dla120 (.D(SUMMAND[89]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[89]) );
  assign INT_SUM[74] = LATCHED_PP[89];
  smfulladder dfa46 (.DATA_A (INT_SUM[71]), .DATA_B (INT_SUM[72]), .DATA_C (INT_SUM[73]), .SAVE (INT_SUM[75]), .CARRY (INT_CARRY[61]) );
  smfulladder dfa47 (.DATA_A (INT_SUM[74]), .DATA_B (INT_CARRY[51]), .DATA_C (INT_CARRY[52]), .SAVE (INT_SUM[76]), .CARRY (INT_CARRY[62]) );
  assign INT_SUM[77] = INT_CARRY[53];
  smfulladder dfa48 (.DATA_A (INT_SUM[75]), .DATA_B (INT_SUM[76]), .DATA_C (INT_SUM[77]), .SAVE (INT_SUM[78]), .CARRY (INT_CARRY[63]) );
  smhalfadder dha14 (.DATA_A (INT_CARRY[54]), .DATA_B (INT_CARRY[55]), .SAVE (INT_SUM[79]), .CARRY (INT_CARRY[64]) );
  smfulladder dfa49 (.DATA_A (INT_SUM[78]), .DATA_B (INT_SUM[79]), .DATA_C (INT_CARRY[56]), .SAVE (INT_SUM[80]), .CARRY (INT_CARRY[57]) );
  smffb  dla121 (.D(INT_SUM[80]), .clk(clk), .en_d2(en_d2), .Q(SUM[16]) );
  smffb  dla122 (.D(INT_CARRY[57]), .clk(clk), .en_d2(en_d2), .Q(CARRY[16]) );
  smffa  dla123 (.D(SUMMAND[90]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[90]) );
  smffa  dla124 (.D(SUMMAND[91]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[91]) );
  smffa  dla125 (.D(SUMMAND[92]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[92]) );
  smfulladder dfa50 (.DATA_A (LATCHED_PP[90]), .DATA_B (LATCHED_PP[91]), .DATA_C (LATCHED_PP[92]), .SAVE (INT_SUM[81]), .CARRY (INT_CARRY[66]) );
  smffa  dla126 (.D(SUMMAND[93]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[93]) );
  smffa  dla127 (.D(SUMMAND[94]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[94]) );
  smffa  dla128 (.D(SUMMAND[95]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[95]) );
  smfulladder dfa51 (.DATA_A (LATCHED_PP[93]), .DATA_B (LATCHED_PP[94]), .DATA_C (LATCHED_PP[95]), .SAVE (INT_SUM[82]), .CARRY (INT_CARRY[67]) );
  smffa  dla129 (.D(SUMMAND[96]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[96]) );
  smffa  dla130 (.D(SUMMAND[97]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[97]) );
  smffa  dla131 (.D(SUMMAND[98]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[98]) );
  smfulladder dfa52 (.DATA_A (LATCHED_PP[96]), .DATA_B (LATCHED_PP[97]), .DATA_C (LATCHED_PP[98]), .SAVE (INT_SUM[83]), .CARRY (INT_CARRY[68]) );
  smfulladder dfa53 (.DATA_A (INT_SUM[81]), .DATA_B (INT_SUM[82]), .DATA_C (INT_SUM[83]), .SAVE (INT_SUM[84]), .CARRY (INT_CARRY[69]) );
  smfulladder dfa54 (.DATA_A (INT_CARRY[58]), .DATA_B (INT_CARRY[59]), .DATA_C (INT_CARRY[60]), .SAVE (INT_SUM[85]), .CARRY (INT_CARRY[70]) );
  smfulladder dfa55 (.DATA_A (INT_SUM[84]), .DATA_B (INT_SUM[85]), .DATA_C (INT_CARRY[61]), .SAVE (INT_SUM[86]), .CARRY (INT_CARRY[71]) );
  assign INT_SUM[87] = INT_CARRY[62];
  smfulladder dfa56 (.DATA_A (INT_SUM[86]), .DATA_B (INT_SUM[87]), .DATA_C (INT_CARRY[63]), .SAVE (INT_SUM[88]), .CARRY (INT_CARRY[72]) );
  assign INT_SUM[89] = INT_CARRY[64];
  smhalfadder dha15 (.DATA_A (INT_SUM[88]), .DATA_B (INT_SUM[89]), .SAVE (INT_SUM[90]), .CARRY (INT_CARRY[65]) );
  smffb  dla132 (.D(INT_SUM[90]), .clk(clk), .en_d2(en_d2), .Q(SUM[17]) );
  smffb  dla133 (.D(INT_CARRY[65]), .clk(clk), .en_d2(en_d2), .Q(CARRY[17]) );
  smffa  dla134 (.D(SUMMAND[99]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[99]) );
  smffa  dla135 (.D(SUMMAND[100]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[100]) );
  smffa  dla136 (.D(SUMMAND[101]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[101]) );
  smfulladder dfa57 (.DATA_A (LATCHED_PP[99]), .DATA_B (LATCHED_PP[100]), .DATA_C (LATCHED_PP[101]), .SAVE (INT_SUM[91]), .CARRY (INT_CARRY[74]) );
  smffa  dla137 (.D(SUMMAND[102]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[102]) );
  smffa  dla138 (.D(SUMMAND[103]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[103]) );
  smffa  dla139 (.D(SUMMAND[104]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[104]) );
  smfulladder dfa58 (.DATA_A (LATCHED_PP[102]), .DATA_B (LATCHED_PP[103]), .DATA_C (LATCHED_PP[104]), .SAVE (INT_SUM[92]), .CARRY (INT_CARRY[75]) );
  smffa  dla140 (.D(SUMMAND[105]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[105]) );
  smffa  dla141 (.D(SUMMAND[106]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[106]) );
  smffa  dla142 (.D(SUMMAND[107]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[107]) );
  smfulladder dfa59 (.DATA_A (LATCHED_PP[105]), .DATA_B (LATCHED_PP[106]), .DATA_C (LATCHED_PP[107]), .SAVE (INT_SUM[93]), .CARRY (INT_CARRY[76]) );
  smffa  dla143 (.D(SUMMAND[108]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[108]) );
  assign INT_SUM[94] = LATCHED_PP[108];
  smffa  dla144 (.D(SUMMAND[109]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[109]) );
  assign INT_SUM[95] = LATCHED_PP[109];
  smfulladder dfa60 (.DATA_A (INT_SUM[91]), .DATA_B (INT_SUM[92]), .DATA_C (INT_SUM[93]), .SAVE (INT_SUM[96]), .CARRY (INT_CARRY[77]) );
  smfulladder dfa61 (.DATA_A (INT_SUM[94]), .DATA_B (INT_SUM[95]), .DATA_C (INT_CARRY[66]), .SAVE (INT_SUM[97]), .CARRY (INT_CARRY[78]) );
  assign INT_SUM[98] = INT_CARRY[67];
  assign INT_SUM[99] = INT_CARRY[68];
  smfulladder dfa62 (.DATA_A (INT_SUM[96]), .DATA_B (INT_SUM[97]), .DATA_C (INT_SUM[98]), .SAVE (INT_SUM[100]), .CARRY (INT_CARRY[79]) );
  smfulladder dfa63 (.DATA_A (INT_SUM[99]), .DATA_B (INT_CARRY[69]), .DATA_C (INT_CARRY[70]), .SAVE (INT_SUM[101]), .CARRY (INT_CARRY[80]) );
  smfulladder dfa64 (.DATA_A (INT_SUM[100]), .DATA_B (INT_SUM[101]), .DATA_C (INT_CARRY[71]), .SAVE (INT_SUM[102]), .CARRY (INT_CARRY[81]) );
  smhalfadder dha16 (.DATA_A (INT_SUM[102]), .DATA_B (INT_CARRY[72]), .SAVE (INT_SUM[103]), .CARRY (INT_CARRY[73]) );
  smffb  dla145 (.D(INT_SUM[103]), .clk(clk), .en_d2(en_d2), .Q(SUM[18]) );
  smffb  dla146 (.D(INT_CARRY[73]), .clk(clk), .en_d2(en_d2), .Q(CARRY[18]) );
  smffa  dla147 (.D(SUMMAND[110]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[110]) );
  smffa  dla148 (.D(SUMMAND[111]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[111]) );
  smffa  dla149 (.D(SUMMAND[112]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[112]) );
  smfulladder dfa65 (.DATA_A (LATCHED_PP[110]), .DATA_B (LATCHED_PP[111]), .DATA_C (LATCHED_PP[112]), .SAVE (INT_SUM[104]), .CARRY (INT_CARRY[83]) );
  smffa  dla150 (.D(SUMMAND[113]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[113]) );
  smffa  dla151 (.D(SUMMAND[114]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[114]) );
  smffa  dla152 (.D(SUMMAND[115]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[115]) );
  smfulladder dfa66 (.DATA_A (LATCHED_PP[113]), .DATA_B (LATCHED_PP[114]), .DATA_C (LATCHED_PP[115]), .SAVE (INT_SUM[105]), .CARRY (INT_CARRY[84]) );
  smffa  dla153 (.D(SUMMAND[116]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[116]) );
  smffa  dla154 (.D(SUMMAND[117]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[117]) );
  smffa  dla155 (.D(SUMMAND[118]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[118]) );
  smfulladder dfa67 (.DATA_A (LATCHED_PP[116]), .DATA_B (LATCHED_PP[117]), .DATA_C (LATCHED_PP[118]), .SAVE (INT_SUM[106]), .CARRY (INT_CARRY[85]) );
  smffa  dla156 (.D(SUMMAND[119]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[119]) );
  assign INT_SUM[107] = LATCHED_PP[119];
  smfulladder dfa68 (.DATA_A (INT_SUM[104]), .DATA_B (INT_SUM[105]), .DATA_C (INT_SUM[106]), .SAVE (INT_SUM[108]), .CARRY (INT_CARRY[86]) );
  smfulladder dfa69 (.DATA_A (INT_SUM[107]), .DATA_B (INT_CARRY[74]), .DATA_C (INT_CARRY[75]), .SAVE (INT_SUM[109]), .CARRY (INT_CARRY[87]) );
  assign INT_SUM[110] = INT_CARRY[76];
  smfulladder dfa70 (.DATA_A (INT_SUM[108]), .DATA_B (INT_SUM[109]), .DATA_C (INT_SUM[110]), .SAVE (INT_SUM[111]), .CARRY (INT_CARRY[88]) );
  smhalfadder dha17 (.DATA_A (INT_CARRY[77]), .DATA_B (INT_CARRY[78]), .SAVE (INT_SUM[112]), .CARRY (INT_CARRY[89]) );
  smfulladder dfa71 (.DATA_A (INT_SUM[111]), .DATA_B (INT_SUM[112]), .DATA_C (INT_CARRY[79]), .SAVE (INT_SUM[113]), .CARRY (INT_CARRY[90]) );
  assign INT_SUM[114] = INT_CARRY[80];
  smfulladder dfa72 (.DATA_A (INT_SUM[113]), .DATA_B (INT_SUM[114]), .DATA_C (INT_CARRY[81]), .SAVE (INT_SUM[115]), .CARRY (INT_CARRY[82]) );
  smffb  dla157 (.D(INT_SUM[115]), .clk(clk), .en_d2(en_d2), .Q(SUM[19]) );
  smffb  dla158 (.D(INT_CARRY[82]), .clk(clk), .en_d2(en_d2), .Q(CARRY[19]) );
  smffa  dla159 (.D(SUMMAND[120]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[120]) );
  smffa  dla160 (.D(SUMMAND[121]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[121]) );
  smffa  dla161 (.D(SUMMAND[122]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[122]) );
  smfulladder dfa73 (.DATA_A (LATCHED_PP[120]), .DATA_B (LATCHED_PP[121]), .DATA_C (LATCHED_PP[122]), .SAVE (INT_SUM[116]), .CARRY (INT_CARRY[92]) );
  smffa  dla162 (.D(SUMMAND[123]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[123]) );
  smffa  dla163 (.D(SUMMAND[124]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[124]) );
  smffa  dla164 (.D(SUMMAND[125]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[125]) );
  smfulladder dfa74 (.DATA_A (LATCHED_PP[123]), .DATA_B (LATCHED_PP[124]), .DATA_C (LATCHED_PP[125]), .SAVE (INT_SUM[117]), .CARRY (INT_CARRY[93]) );
  smffa  dla165 (.D(SUMMAND[126]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[126]) );
  smffa  dla166 (.D(SUMMAND[127]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[127]) );
  smffa  dla167 (.D(SUMMAND[128]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[128]) );
  smfulladder dfa75 (.DATA_A (LATCHED_PP[126]), .DATA_B (LATCHED_PP[127]), .DATA_C (LATCHED_PP[128]), .SAVE (INT_SUM[118]), .CARRY (INT_CARRY[94]) );
  smffa  dla168 (.D(SUMMAND[129]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[129]) );
  smffa  dla169 (.D(SUMMAND[130]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[130]) );
  smffa  dla170 (.D(SUMMAND[131]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[131]) );
  smfulladder dfa76 (.DATA_A (LATCHED_PP[129]), .DATA_B (LATCHED_PP[130]), .DATA_C (LATCHED_PP[131]), .SAVE (INT_SUM[119]), .CARRY (INT_CARRY[95]) );
  smfulladder dfa77 (.DATA_A (INT_SUM[116]), .DATA_B (INT_SUM[117]), .DATA_C (INT_SUM[118]), .SAVE (INT_SUM[120]), .CARRY (INT_CARRY[96]) );
  smfulladder dfa78 (.DATA_A (INT_SUM[119]), .DATA_B (INT_CARRY[83]), .DATA_C (INT_CARRY[84]), .SAVE (INT_SUM[121]), .CARRY (INT_CARRY[97]) );
  assign INT_SUM[122] = INT_CARRY[85];
  smfulladder dfa79 (.DATA_A (INT_SUM[120]), .DATA_B (INT_SUM[121]), .DATA_C (INT_SUM[122]), .SAVE (INT_SUM[123]), .CARRY (INT_CARRY[98]) );
  smhalfadder dha18 (.DATA_A (INT_CARRY[86]), .DATA_B (INT_CARRY[87]), .SAVE (INT_SUM[124]), .CARRY (INT_CARRY[99]) );
  smfulladder dfa80 (.DATA_A (INT_SUM[123]), .DATA_B (INT_SUM[124]), .DATA_C (INT_CARRY[88]), .SAVE (INT_SUM[125]), .CARRY (INT_CARRY[100]) );
  assign INT_SUM[126] = INT_CARRY[89];
  smfulladder dfa81 (.DATA_A (INT_SUM[125]), .DATA_B (INT_SUM[126]), .DATA_C (INT_CARRY[90]), .SAVE (INT_SUM[127]), .CARRY (INT_CARRY[91]) );
  smffb  dla171 (.D(INT_SUM[127]), .clk(clk), .en_d2(en_d2), .Q(SUM[20]) );
  smffb  dla172 (.D(INT_CARRY[91]), .clk(clk), .en_d2(en_d2), .Q(CARRY[20]) );
  smffa  dla173 (.D(SUMMAND[132]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[132]) );
  smffa  dla174 (.D(SUMMAND[133]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[133]) );
  smffa  dla175 (.D(SUMMAND[134]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[134]) );
  smfulladder dfa82 (.DATA_A (LATCHED_PP[132]), .DATA_B (LATCHED_PP[133]), .DATA_C (LATCHED_PP[134]), .SAVE (INT_SUM[128]), .CARRY (INT_CARRY[102]) );
  smffa  dla176 (.D(SUMMAND[135]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[135]) );
  smffa  dla177 (.D(SUMMAND[136]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[136]) );
  smffa  dla178 (.D(SUMMAND[137]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[137]) );
  smfulladder dfa83 (.DATA_A (LATCHED_PP[135]), .DATA_B (LATCHED_PP[136]), .DATA_C (LATCHED_PP[137]), .SAVE (INT_SUM[129]), .CARRY (INT_CARRY[103]) );
  smffa  dla179 (.D(SUMMAND[138]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[138]) );
  smffa  dla180 (.D(SUMMAND[139]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[139]) );
  smffa  dla181 (.D(SUMMAND[140]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[140]) );
  smfulladder dfa84 (.DATA_A (LATCHED_PP[138]), .DATA_B (LATCHED_PP[139]), .DATA_C (LATCHED_PP[140]), .SAVE (INT_SUM[130]), .CARRY (INT_CARRY[104]) );
  smffa  dla182 (.D(SUMMAND[141]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[141]) );
  assign INT_SUM[131] = LATCHED_PP[141];
  smffa  dla183 (.D(SUMMAND[142]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[142]) );
  assign INT_SUM[132] = LATCHED_PP[142];
  smfulladder dfa85 (.DATA_A (INT_SUM[128]), .DATA_B (INT_SUM[129]), .DATA_C (INT_SUM[130]), .SAVE (INT_SUM[133]), .CARRY (INT_CARRY[105]) );
  smfulladder dfa86 (.DATA_A (INT_SUM[131]), .DATA_B (INT_SUM[132]), .DATA_C (INT_CARRY[92]), .SAVE (INT_SUM[134]), .CARRY (INT_CARRY[106]) );
  smfulladder dfa87 (.DATA_A (INT_CARRY[93]), .DATA_B (INT_CARRY[94]), .DATA_C (INT_CARRY[95]), .SAVE (INT_SUM[135]), .CARRY (INT_CARRY[107]) );
  smfulladder dfa88 (.DATA_A (INT_SUM[133]), .DATA_B (INT_SUM[134]), .DATA_C (INT_SUM[135]), .SAVE (INT_SUM[136]), .CARRY (INT_CARRY[108]) );
  smhalfadder dha19 (.DATA_A (INT_CARRY[96]), .DATA_B (INT_CARRY[97]), .SAVE (INT_SUM[137]), .CARRY (INT_CARRY[109]) );
  smfulladder dfa89 (.DATA_A (INT_SUM[136]), .DATA_B (INT_SUM[137]), .DATA_C (INT_CARRY[98]), .SAVE (INT_SUM[138]), .CARRY (INT_CARRY[110]) );
  assign INT_SUM[139] = INT_CARRY[99];
  smfulladder dfa90 (.DATA_A (INT_SUM[138]), .DATA_B (INT_SUM[139]), .DATA_C (INT_CARRY[100]), .SAVE (INT_SUM[140]), .CARRY (INT_CARRY[101]) );
  smffb  dla184 (.D(INT_SUM[140]), .clk(clk), .en_d2(en_d2), .Q(SUM[21]) );
  smffb  dla185 (.D(INT_CARRY[101]), .clk(clk), .en_d2(en_d2), .Q(CARRY[21]) );
  smffa  dla186 (.D(SUMMAND[143]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[143]) );
  smffa  dla187 (.D(SUMMAND[144]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[144]) );
  smffa  dla188 (.D(SUMMAND[145]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[145]) );
  smfulladder dfa91 (.DATA_A (LATCHED_PP[143]), .DATA_B (LATCHED_PP[144]), .DATA_C (LATCHED_PP[145]), .SAVE (INT_SUM[141]), .CARRY (INT_CARRY[112]) );
  smffa  dla189 (.D(SUMMAND[146]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[146]) );
  smffa  dla190 (.D(SUMMAND[147]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[147]) );
  smffa  dla191 (.D(SUMMAND[148]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[148]) );
  smfulladder dfa92 (.DATA_A (LATCHED_PP[146]), .DATA_B (LATCHED_PP[147]), .DATA_C (LATCHED_PP[148]), .SAVE (INT_SUM[142]), .CARRY (INT_CARRY[113]) );
  smffa  dla192 (.D(SUMMAND[149]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[149]) );
  smffa  dla193 (.D(SUMMAND[150]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[150]) );
  smffa  dla194 (.D(SUMMAND[151]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[151]) );
  smfulladder dfa93 (.DATA_A (LATCHED_PP[149]), .DATA_B (LATCHED_PP[150]), .DATA_C (LATCHED_PP[151]), .SAVE (INT_SUM[143]), .CARRY (INT_CARRY[114]) );
  smffa  dla195 (.D(SUMMAND[152]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[152]) );
  smffa  dla196 (.D(SUMMAND[153]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[153]) );
  smffa  dla197 (.D(SUMMAND[154]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[154]) );
  smfulladder dfa94 (.DATA_A (LATCHED_PP[152]), .DATA_B (LATCHED_PP[153]), .DATA_C (LATCHED_PP[154]), .SAVE (INT_SUM[144]), .CARRY (INT_CARRY[115]) );
  smffa  dla198 (.D(SUMMAND[155]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[155]) );
  assign INT_SUM[145] = LATCHED_PP[155];
  smfulladder dfa95 (.DATA_A (INT_SUM[141]), .DATA_B (INT_SUM[142]), .DATA_C (INT_SUM[143]), .SAVE (INT_SUM[146]), .CARRY (INT_CARRY[116]) );
  smfulladder dfa96 (.DATA_A (INT_SUM[144]), .DATA_B (INT_SUM[145]), .DATA_C (INT_CARRY[102]), .SAVE (INT_SUM[147]), .CARRY (INT_CARRY[117]) );
  smhalfadder dha20 (.DATA_A (INT_CARRY[103]), .DATA_B (INT_CARRY[104]), .SAVE (INT_SUM[148]), .CARRY (INT_CARRY[118]) );
  smfulladder dfa97 (.DATA_A (INT_SUM[146]), .DATA_B (INT_SUM[147]), .DATA_C (INT_SUM[148]), .SAVE (INT_SUM[149]), .CARRY (INT_CARRY[119]) );
  smfulladder dfa98 (.DATA_A (INT_CARRY[105]), .DATA_B (INT_CARRY[106]), .DATA_C (INT_CARRY[107]), .SAVE (INT_SUM[150]), .CARRY (INT_CARRY[120]) );
  smfulladder dfa99 (.DATA_A (INT_SUM[149]), .DATA_B (INT_SUM[150]), .DATA_C (INT_CARRY[108]), .SAVE (INT_SUM[151]), .CARRY (INT_CARRY[121]) );
  assign INT_SUM[152] = INT_CARRY[109];
  smfulladder dfa100 (.DATA_A (INT_SUM[151]), .DATA_B (INT_SUM[152]), .DATA_C (INT_CARRY[110]), .SAVE (INT_SUM[153]), .CARRY (INT_CARRY[111]) );
  smffb  dla199 (.D(INT_SUM[153]), .clk(clk), .en_d2(en_d2), .Q(SUM[22]) );
  smffb  dla200 (.D(INT_CARRY[111]), .clk(clk), .en_d2(en_d2), .Q(CARRY[22]) );
  smffa  dla201 (.D(SUMMAND[156]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[156]) );
  smffa  dla202 (.D(SUMMAND[157]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[157]) );
  smffa  dla203 (.D(SUMMAND[158]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[158]) );
  smfulladder dfa101 (.DATA_A (LATCHED_PP[156]), .DATA_B (LATCHED_PP[157]), .DATA_C (LATCHED_PP[158]), .SAVE (INT_SUM[154]), .CARRY (INT_CARRY[123]) );
  smffa  dla204 (.D(SUMMAND[159]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[159]) );
  smffa  dla205 (.D(SUMMAND[160]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[160]) );
  smffa  dla206 (.D(SUMMAND[161]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[161]) );
  smfulladder dfa102 (.DATA_A (LATCHED_PP[159]), .DATA_B (LATCHED_PP[160]), .DATA_C (LATCHED_PP[161]), .SAVE (INT_SUM[155]), .CARRY (INT_CARRY[124]) );
  smffa  dla207 (.D(SUMMAND[162]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[162]) );
  smffa  dla208 (.D(SUMMAND[163]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[163]) );
  smffa  dla209 (.D(SUMMAND[164]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[164]) );
  smfulladder dfa103 (.DATA_A (LATCHED_PP[162]), .DATA_B (LATCHED_PP[163]), .DATA_C (LATCHED_PP[164]), .SAVE (INT_SUM[156]), .CARRY (INT_CARRY[125]) );
  smffa  dla210 (.D(SUMMAND[165]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[165]) );
  smffa  dla211 (.D(SUMMAND[166]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[166]) );
  smffa  dla212 (.D(SUMMAND[167]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[167]) );
  smfulladder dfa104 (.DATA_A (LATCHED_PP[165]), .DATA_B (LATCHED_PP[166]), .DATA_C (LATCHED_PP[167]), .SAVE (INT_SUM[157]), .CARRY (INT_CARRY[126]) );
  smfulladder dfa105 (.DATA_A (INT_SUM[154]), .DATA_B (INT_SUM[155]), .DATA_C (INT_SUM[156]), .SAVE (INT_SUM[158]), .CARRY (INT_CARRY[127]) );
  smfulladder dfa106 (.DATA_A (INT_SUM[157]), .DATA_B (INT_CARRY[112]), .DATA_C (INT_CARRY[113]), .SAVE (INT_SUM[159]), .CARRY (INT_CARRY[128]) );
  smhalfadder dha21 (.DATA_A (INT_CARRY[114]), .DATA_B (INT_CARRY[115]), .SAVE (INT_SUM[160]), .CARRY (INT_CARRY[129]) );
  smfulladder dfa107 (.DATA_A (INT_SUM[158]), .DATA_B (INT_SUM[159]), .DATA_C (INT_SUM[160]), .SAVE (INT_SUM[161]), .CARRY (INT_CARRY[130]) );
  smfulladder dfa108 (.DATA_A (INT_CARRY[116]), .DATA_B (INT_CARRY[117]), .DATA_C (INT_CARRY[118]), .SAVE (INT_SUM[162]), .CARRY (INT_CARRY[131]) );
  smfulladder dfa109 (.DATA_A (INT_SUM[161]), .DATA_B (INT_SUM[162]), .DATA_C (INT_CARRY[119]), .SAVE (INT_SUM[163]), .CARRY (INT_CARRY[132]) );
  assign INT_SUM[164] = INT_CARRY[120];
  smfulladder dfa110 (.DATA_A (INT_SUM[163]), .DATA_B (INT_SUM[164]), .DATA_C (INT_CARRY[121]), .SAVE (INT_SUM[165]), .CARRY (INT_CARRY[122]) );
  smffb  dla213 (.D(INT_SUM[165]), .clk(clk), .en_d2(en_d2), .Q(SUM[23]) );
  smffb  dla214 (.D(INT_CARRY[122]), .clk(clk), .en_d2(en_d2), .Q(CARRY[23]) );
  smffa  dla215 (.D(SUMMAND[168]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[168]) );
  smffa  dla216 (.D(SUMMAND[169]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[169]) );
  smffa  dla217 (.D(SUMMAND[170]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[170]) );
  smfulladder dfa111 (.DATA_A (LATCHED_PP[168]), .DATA_B (LATCHED_PP[169]), .DATA_C (LATCHED_PP[170]), .SAVE (INT_SUM[166]), .CARRY (INT_CARRY[134]) );
  smffa  dla218 (.D(SUMMAND[171]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[171]) );
  smffa  dla219 (.D(SUMMAND[172]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[172]) );
  smffa  dla220 (.D(SUMMAND[173]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[173]) );
  smfulladder dfa112 (.DATA_A (LATCHED_PP[171]), .DATA_B (LATCHED_PP[172]), .DATA_C (LATCHED_PP[173]), .SAVE (INT_SUM[167]), .CARRY (INT_CARRY[135]) );
  smffa  dla221 (.D(SUMMAND[174]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[174]) );
  smffa  dla222 (.D(SUMMAND[175]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[175]) );
  smffa  dla223 (.D(SUMMAND[176]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[176]) );
  smfulladder dfa113 (.DATA_A (LATCHED_PP[174]), .DATA_B (LATCHED_PP[175]), .DATA_C (LATCHED_PP[176]), .SAVE (INT_SUM[168]), .CARRY (INT_CARRY[136]) );
  smffa  dla224 (.D(SUMMAND[177]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[177]) );
  smffa  dla225 (.D(SUMMAND[178]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[178]) );
  smffa  dla226 (.D(SUMMAND[179]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[179]) );
  smfulladder dfa114 (.DATA_A (LATCHED_PP[177]), .DATA_B (LATCHED_PP[178]), .DATA_C (LATCHED_PP[179]), .SAVE (INT_SUM[169]), .CARRY (INT_CARRY[137]) );
  smffa  dla227 (.D(SUMMAND[180]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[180]) );
  smffa  dla228 (.D(SUMMAND[181]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[181]) );
  smhalfadder dha22 (.DATA_A (LATCHED_PP[180]), .DATA_B (LATCHED_PP[181]), .SAVE (INT_SUM[170]), .CARRY (INT_CARRY[138]) );
  smfulladder dfa115 (.DATA_A (INT_SUM[166]), .DATA_B (INT_SUM[167]), .DATA_C (INT_SUM[168]), .SAVE (INT_SUM[171]), .CARRY (INT_CARRY[139]) );
  smfulladder dfa116 (.DATA_A (INT_SUM[169]), .DATA_B (INT_SUM[170]), .DATA_C (INT_CARRY[123]), .SAVE (INT_SUM[172]), .CARRY (INT_CARRY[140]) );
  smfulladder dfa117 (.DATA_A (INT_CARRY[124]), .DATA_B (INT_CARRY[125]), .DATA_C (INT_CARRY[126]), .SAVE (INT_SUM[173]), .CARRY (INT_CARRY[141]) );
  smfulladder dfa118 (.DATA_A (INT_SUM[171]), .DATA_B (INT_SUM[172]), .DATA_C (INT_SUM[173]), .SAVE (INT_SUM[174]), .CARRY (INT_CARRY[142]) );
  smfulladder dfa119 (.DATA_A (INT_CARRY[127]), .DATA_B (INT_CARRY[128]), .DATA_C (INT_CARRY[129]), .SAVE (INT_SUM[175]), .CARRY (INT_CARRY[143]) );
  smfulladder dfa120 (.DATA_A (INT_SUM[174]), .DATA_B (INT_SUM[175]), .DATA_C (INT_CARRY[130]), .SAVE (INT_SUM[176]), .CARRY (INT_CARRY[144]) );
  assign INT_SUM[177] = INT_CARRY[131];
  smfulladder dfa121 (.DATA_A (INT_SUM[176]), .DATA_B (INT_SUM[177]), .DATA_C (INT_CARRY[132]), .SAVE (INT_SUM[178]), .CARRY (INT_CARRY[133]) );
  smffb  dla229 (.D(INT_SUM[178]), .clk(clk), .en_d2(en_d2), .Q(SUM[24]) );
  smffb  dla230 (.D(INT_CARRY[133]), .clk(clk), .en_d2(en_d2), .Q(CARRY[24]) );
  smffa  dla231 (.D(SUMMAND[182]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[182]) );
  smffa  dla232 (.D(SUMMAND[183]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[183]) );
  smffa  dla233 (.D(SUMMAND[184]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[184]) );
  smfulladder dfa122 (.DATA_A (LATCHED_PP[182]), .DATA_B (LATCHED_PP[183]), .DATA_C (LATCHED_PP[184]), .SAVE (INT_SUM[179]), .CARRY (INT_CARRY[146]) );
  smffa  dla234 (.D(SUMMAND[185]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[185]) );
  smffa  dla235 (.D(SUMMAND[186]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[186]) );
  smffa  dla236 (.D(SUMMAND[187]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[187]) );
  smfulladder dfa123 (.DATA_A (LATCHED_PP[185]), .DATA_B (LATCHED_PP[186]), .DATA_C (LATCHED_PP[187]), .SAVE (INT_SUM[180]), .CARRY (INT_CARRY[147]) );
  smffa  dla237 (.D(SUMMAND[188]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[188]) );
  smffa  dla238 (.D(SUMMAND[189]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[189]) );
  smffa  dla239 (.D(SUMMAND[190]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[190]) );
  smfulladder dfa124 (.DATA_A (LATCHED_PP[188]), .DATA_B (LATCHED_PP[189]), .DATA_C (LATCHED_PP[190]), .SAVE (INT_SUM[181]), .CARRY (INT_CARRY[148]) );
  smffa  dla240 (.D(SUMMAND[191]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[191]) );
  smffa  dla241 (.D(SUMMAND[192]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[192]) );
  smffa  dla242 (.D(SUMMAND[193]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[193]) );
  smfulladder dfa125 (.DATA_A (LATCHED_PP[191]), .DATA_B (LATCHED_PP[192]), .DATA_C (LATCHED_PP[193]), .SAVE (INT_SUM[182]), .CARRY (INT_CARRY[149]) );
  smffa  dla243 (.D(SUMMAND[194]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[194]) );
  assign INT_SUM[183] = LATCHED_PP[194];
  smfulladder dfa126 (.DATA_A (INT_SUM[179]), .DATA_B (INT_SUM[180]), .DATA_C (INT_SUM[181]), .SAVE (INT_SUM[184]), .CARRY (INT_CARRY[150]) );
  smfulladder dfa127 (.DATA_A (INT_SUM[182]), .DATA_B (INT_SUM[183]), .DATA_C (INT_CARRY[134]), .SAVE (INT_SUM[185]), .CARRY (INT_CARRY[151]) );
  smfulladder dfa128 (.DATA_A (INT_CARRY[135]), .DATA_B (INT_CARRY[136]), .DATA_C (INT_CARRY[137]), .SAVE (INT_SUM[186]), .CARRY (INT_CARRY[152]) );
  assign INT_SUM[187] = INT_CARRY[138];
  smfulladder dfa129 (.DATA_A (INT_SUM[184]), .DATA_B (INT_SUM[185]), .DATA_C (INT_SUM[186]), .SAVE (INT_SUM[188]), .CARRY (INT_CARRY[153]) );
  smfulladder dfa130 (.DATA_A (INT_SUM[187]), .DATA_B (INT_CARRY[139]), .DATA_C (INT_CARRY[140]), .SAVE (INT_SUM[189]), .CARRY (INT_CARRY[154]) );
  assign INT_SUM[190] = INT_CARRY[141];
  smfulladder dfa131 (.DATA_A (INT_SUM[188]), .DATA_B (INT_SUM[189]), .DATA_C (INT_SUM[190]), .SAVE (INT_SUM[191]), .CARRY (INT_CARRY[155]) );
  smhalfadder dha23 (.DATA_A (INT_CARRY[142]), .DATA_B (INT_CARRY[143]), .SAVE (INT_SUM[192]), .CARRY (INT_CARRY[156]) );
  smfulladder dfa132 (.DATA_A (INT_SUM[191]), .DATA_B (INT_SUM[192]), .DATA_C (INT_CARRY[144]), .SAVE (INT_SUM[193]), .CARRY (INT_CARRY[145]) );
  smffb  dla244 (.D(INT_SUM[193]), .clk(clk), .en_d2(en_d2), .Q(SUM[25]) );
  smffb  dla245 (.D(INT_CARRY[145]), .clk(clk), .en_d2(en_d2), .Q(CARRY[25]) );
  smffa  dla246 (.D(SUMMAND[195]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[195]) );
  smffa  dla247 (.D(SUMMAND[196]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[196]) );
  smffa  dla248 (.D(SUMMAND[197]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[197]) );
  smfulladder dfa133 (.DATA_A (LATCHED_PP[195]), .DATA_B (LATCHED_PP[196]), .DATA_C (LATCHED_PP[197]), .SAVE (INT_SUM[194]), .CARRY (INT_CARRY[158]) );
  smffa  dla249 (.D(SUMMAND[198]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[198]) );
  smffa  dla250 (.D(SUMMAND[199]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[199]) );
  smffa  dla251 (.D(SUMMAND[200]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[200]) );
  smfulladder dfa134 (.DATA_A (LATCHED_PP[198]), .DATA_B (LATCHED_PP[199]), .DATA_C (LATCHED_PP[200]), .SAVE (INT_SUM[195]), .CARRY (INT_CARRY[159]) );
  smffa  dla252 (.D(SUMMAND[201]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[201]) );
  smffa  dla253 (.D(SUMMAND[202]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[202]) );
  smffa  dla254 (.D(SUMMAND[203]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[203]) );
  smfulladder dfa135 (.DATA_A (LATCHED_PP[201]), .DATA_B (LATCHED_PP[202]), .DATA_C (LATCHED_PP[203]), .SAVE (INT_SUM[196]), .CARRY (INT_CARRY[160]) );
  smffa  dla255 (.D(SUMMAND[204]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[204]) );
  smffa  dla256 (.D(SUMMAND[205]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[205]) );
  smffa  dla257 (.D(SUMMAND[206]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[206]) );
  smfulladder dfa136 (.DATA_A (LATCHED_PP[204]), .DATA_B (LATCHED_PP[205]), .DATA_C (LATCHED_PP[206]), .SAVE (INT_SUM[197]), .CARRY (INT_CARRY[161]) );
  smffa  dla258 (.D(SUMMAND[207]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[207]) );
  smffa  dla259 (.D(SUMMAND[208]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[208]) );
  smffa  dla260 (.D(SUMMAND[209]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[209]) );
  smfulladder dfa137 (.DATA_A (LATCHED_PP[207]), .DATA_B (LATCHED_PP[208]), .DATA_C (LATCHED_PP[209]), .SAVE (INT_SUM[198]), .CARRY (INT_CARRY[162]) );
  smfulladder dfa138 (.DATA_A (INT_SUM[194]), .DATA_B (INT_SUM[195]), .DATA_C (INT_SUM[196]), .SAVE (INT_SUM[199]), .CARRY (INT_CARRY[163]) );
  smfulladder dfa139 (.DATA_A (INT_SUM[197]), .DATA_B (INT_SUM[198]), .DATA_C (INT_CARRY[146]), .SAVE (INT_SUM[200]), .CARRY (INT_CARRY[164]) );
  smfulladder dfa140 (.DATA_A (INT_CARRY[147]), .DATA_B (INT_CARRY[148]), .DATA_C (INT_CARRY[149]), .SAVE (INT_SUM[201]), .CARRY (INT_CARRY[165]) );
  smfulladder dfa141 (.DATA_A (INT_SUM[199]), .DATA_B (INT_SUM[200]), .DATA_C (INT_SUM[201]), .SAVE (INT_SUM[202]), .CARRY (INT_CARRY[166]) );
  smfulladder dfa142 (.DATA_A (INT_CARRY[150]), .DATA_B (INT_CARRY[151]), .DATA_C (INT_CARRY[152]), .SAVE (INT_SUM[203]), .CARRY (INT_CARRY[167]) );
  smfulladder dfa143 (.DATA_A (INT_SUM[202]), .DATA_B (INT_SUM[203]), .DATA_C (INT_CARRY[153]), .SAVE (INT_SUM[204]), .CARRY (INT_CARRY[168]) );
  assign INT_SUM[205] = INT_CARRY[154];
  smfulladder dfa144 (.DATA_A (INT_SUM[204]), .DATA_B (INT_SUM[205]), .DATA_C (INT_CARRY[155]), .SAVE (INT_SUM[206]), .CARRY (INT_CARRY[169]) );
  assign INT_SUM[207] = INT_CARRY[156];
  smhalfadder dha24 (.DATA_A (INT_SUM[206]), .DATA_B (INT_SUM[207]), .SAVE (INT_SUM[208]), .CARRY (INT_CARRY[157]) );
  smffb  dla261 (.D(INT_SUM[208]), .clk(clk), .en_d2(en_d2), .Q(SUM[26]) );
  smffb  dla262 (.D(INT_CARRY[157]), .clk(clk), .en_d2(en_d2), .Q(CARRY[26]) );
  smffa  dla263 (.D(SUMMAND[210]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[210]) );
  smffa  dla264 (.D(SUMMAND[211]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[211]) );
  smffa  dla265 (.D(SUMMAND[212]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[212]) );
  smfulladder dfa145 (.DATA_A (LATCHED_PP[210]), .DATA_B (LATCHED_PP[211]), .DATA_C (LATCHED_PP[212]), .SAVE (INT_SUM[209]), .CARRY (INT_CARRY[171]) );
  smffa  dla266 (.D(SUMMAND[213]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[213]) );
  smffa  dla267 (.D(SUMMAND[214]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[214]) );
  smffa  dla268 (.D(SUMMAND[215]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[215]) );
  smfulladder dfa146 (.DATA_A (LATCHED_PP[213]), .DATA_B (LATCHED_PP[214]), .DATA_C (LATCHED_PP[215]), .SAVE (INT_SUM[210]), .CARRY (INT_CARRY[172]) );
  smffa  dla269 (.D(SUMMAND[216]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[216]) );
  smffa  dla270 (.D(SUMMAND[217]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[217]) );
  smffa  dla271 (.D(SUMMAND[218]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[218]) );
  smfulladder dfa147 (.DATA_A (LATCHED_PP[216]), .DATA_B (LATCHED_PP[217]), .DATA_C (LATCHED_PP[218]), .SAVE (INT_SUM[211]), .CARRY (INT_CARRY[173]) );
  smffa  dla272 (.D(SUMMAND[219]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[219]) );
  smffa  dla273 (.D(SUMMAND[220]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[220]) );
  smffa  dla274 (.D(SUMMAND[221]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[221]) );
  smfulladder dfa148 (.DATA_A (LATCHED_PP[219]), .DATA_B (LATCHED_PP[220]), .DATA_C (LATCHED_PP[221]), .SAVE (INT_SUM[212]), .CARRY (INT_CARRY[174]) );
  smffa  dla275 (.D(SUMMAND[222]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[222]) );
  smffa  dla276 (.D(SUMMAND[223]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[223]) );
  smhalfadder dha25 (.DATA_A (LATCHED_PP[222]), .DATA_B (LATCHED_PP[223]), .SAVE (INT_SUM[213]), .CARRY (INT_CARRY[175]) );
  smfulladder dfa149 (.DATA_A (INT_SUM[209]), .DATA_B (INT_SUM[210]), .DATA_C (INT_SUM[211]), .SAVE (INT_SUM[214]), .CARRY (INT_CARRY[176]) );
  smfulladder dfa150 (.DATA_A (INT_SUM[212]), .DATA_B (INT_SUM[213]), .DATA_C (INT_CARRY[158]), .SAVE (INT_SUM[215]), .CARRY (INT_CARRY[177]) );
  smfulladder dfa151 (.DATA_A (INT_CARRY[159]), .DATA_B (INT_CARRY[160]), .DATA_C (INT_CARRY[161]), .SAVE (INT_SUM[216]), .CARRY (INT_CARRY[178]) );
  assign INT_SUM[217] = INT_CARRY[162];
  smfulladder dfa152 (.DATA_A (INT_SUM[214]), .DATA_B (INT_SUM[215]), .DATA_C (INT_SUM[216]), .SAVE (INT_SUM[218]), .CARRY (INT_CARRY[179]) );
  smfulladder dfa153 (.DATA_A (INT_SUM[217]), .DATA_B (INT_CARRY[163]), .DATA_C (INT_CARRY[164]), .SAVE (INT_SUM[219]), .CARRY (INT_CARRY[180]) );
  assign INT_SUM[220] = INT_CARRY[165];
  smfulladder dfa154 (.DATA_A (INT_SUM[218]), .DATA_B (INT_SUM[219]), .DATA_C (INT_SUM[220]), .SAVE (INT_SUM[221]), .CARRY (INT_CARRY[181]) );
  assign INT_SUM[222] = INT_CARRY[166];
  assign INT_SUM[223] = INT_CARRY[167];
  smfulladder dfa155 (.DATA_A (INT_SUM[221]), .DATA_B (INT_SUM[222]), .DATA_C (INT_SUM[223]), .SAVE (INT_SUM[224]), .CARRY (INT_CARRY[182]) );
  assign INT_SUM[225] = INT_CARRY[168];
  smfulladder dfa156 (.DATA_A (INT_SUM[224]), .DATA_B (INT_SUM[225]), .DATA_C (INT_CARRY[169]), .SAVE (INT_SUM[226]), .CARRY (INT_CARRY[170]) );
  smffb  dla277 (.D(INT_SUM[226]), .clk(clk), .en_d2(en_d2), .Q(SUM[27]) );
  smffb  dla278 (.D(INT_CARRY[170]), .clk(clk), .en_d2(en_d2), .Q(CARRY[27]) );
  smffa  dla279 (.D(SUMMAND[224]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[224]) );
  smffa  dla280 (.D(SUMMAND[225]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[225]) );
  smffa  dla281 (.D(SUMMAND[226]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[226]) );
  smfulladder dfa157 (.DATA_A (LATCHED_PP[224]), .DATA_B (LATCHED_PP[225]), .DATA_C (LATCHED_PP[226]), .SAVE (INT_SUM[227]), .CARRY (INT_CARRY[184]) );
  smffa  dla282 (.D(SUMMAND[227]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[227]) );
  smffa  dla283 (.D(SUMMAND[228]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[228]) );
  smffa  dla284 (.D(SUMMAND[229]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[229]) );
  smfulladder dfa158 (.DATA_A (LATCHED_PP[227]), .DATA_B (LATCHED_PP[228]), .DATA_C (LATCHED_PP[229]), .SAVE (INT_SUM[228]), .CARRY (INT_CARRY[185]) );
  smffa  dla285 (.D(SUMMAND[230]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[230]) );
  smffa  dla286 (.D(SUMMAND[231]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[231]) );
  smffa  dla287 (.D(SUMMAND[232]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[232]) );
  smfulladder dfa159 (.DATA_A (LATCHED_PP[230]), .DATA_B (LATCHED_PP[231]), .DATA_C (LATCHED_PP[232]), .SAVE (INT_SUM[229]), .CARRY (INT_CARRY[186]) );
  smffa  dla288 (.D(SUMMAND[233]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[233]) );
  smffa  dla289 (.D(SUMMAND[234]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[234]) );
  smffa  dla290 (.D(SUMMAND[235]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[235]) );
  smfulladder dfa160 (.DATA_A (LATCHED_PP[233]), .DATA_B (LATCHED_PP[234]), .DATA_C (LATCHED_PP[235]), .SAVE (INT_SUM[230]), .CARRY (INT_CARRY[187]) );
  smffa  dla291 (.D(SUMMAND[236]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[236]) );
  smffa  dla292 (.D(SUMMAND[237]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[237]) );
  smffa  dla293 (.D(SUMMAND[238]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[238]) );
  smfulladder dfa161 (.DATA_A (LATCHED_PP[236]), .DATA_B (LATCHED_PP[237]), .DATA_C (LATCHED_PP[238]), .SAVE (INT_SUM[231]), .CARRY (INT_CARRY[188]) );
  smffa  dla294 (.D(SUMMAND[239]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[239]) );
  assign INT_SUM[232] = LATCHED_PP[239];
  smfulladder dfa162 (.DATA_A (INT_SUM[227]), .DATA_B (INT_SUM[228]), .DATA_C (INT_SUM[229]), .SAVE (INT_SUM[233]), .CARRY (INT_CARRY[189]) );
  smfulladder dfa163 (.DATA_A (INT_SUM[230]), .DATA_B (INT_SUM[231]), .DATA_C (INT_SUM[232]), .SAVE (INT_SUM[234]), .CARRY (INT_CARRY[190]) );
  smfulladder dfa164 (.DATA_A (INT_CARRY[171]), .DATA_B (INT_CARRY[172]), .DATA_C (INT_CARRY[173]), .SAVE (INT_SUM[235]), .CARRY (INT_CARRY[191]) );
  assign INT_SUM[236] = INT_CARRY[174];
  assign INT_SUM[237] = INT_CARRY[175];
  smfulladder dfa165 (.DATA_A (INT_SUM[233]), .DATA_B (INT_SUM[234]), .DATA_C (INT_SUM[235]), .SAVE (INT_SUM[238]), .CARRY (INT_CARRY[192]) );
  smfulladder dfa166 (.DATA_A (INT_SUM[236]), .DATA_B (INT_SUM[237]), .DATA_C (INT_CARRY[176]), .SAVE (INT_SUM[239]), .CARRY (INT_CARRY[193]) );
  assign INT_SUM[240] = INT_CARRY[177];
  assign INT_SUM[241] = INT_CARRY[178];
  smfulladder dfa167 (.DATA_A (INT_SUM[238]), .DATA_B (INT_SUM[239]), .DATA_C (INT_SUM[240]), .SAVE (INT_SUM[242]), .CARRY (INT_CARRY[194]) );
  smfulladder dfa168 (.DATA_A (INT_SUM[241]), .DATA_B (INT_CARRY[179]), .DATA_C (INT_CARRY[180]), .SAVE (INT_SUM[243]), .CARRY (INT_CARRY[195]) );
  smfulladder dfa169 (.DATA_A (INT_SUM[242]), .DATA_B (INT_SUM[243]), .DATA_C (INT_CARRY[181]), .SAVE (INT_SUM[244]), .CARRY (INT_CARRY[196]) );
  smhalfadder dha26 (.DATA_A (INT_SUM[244]), .DATA_B (INT_CARRY[182]), .SAVE (INT_SUM[245]), .CARRY (INT_CARRY[183]) );
  smffb  dla295 (.D(INT_SUM[245]), .clk(clk), .en_d2(en_d2), .Q(SUM[28]) );
  smffb  dla296 (.D(INT_CARRY[183]), .clk(clk), .en_d2(en_d2), .Q(CARRY[28]) );
  smffa  dla297 (.D(SUMMAND[240]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[240]) );
  smffa  dla298 (.D(SUMMAND[241]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[241]) );
  smffa  dla299 (.D(SUMMAND[242]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[242]) );
  smfulladder dfa170 (.DATA_A (LATCHED_PP[240]), .DATA_B (LATCHED_PP[241]), .DATA_C (LATCHED_PP[242]), .SAVE (INT_SUM[246]), .CARRY (INT_CARRY[198]) );
  smffa  dla300 (.D(SUMMAND[243]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[243]) );
  smffa  dla301 (.D(SUMMAND[244]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[244]) );
  smffa  dla302 (.D(SUMMAND[245]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[245]) );
  smfulladder dfa171 (.DATA_A (LATCHED_PP[243]), .DATA_B (LATCHED_PP[244]), .DATA_C (LATCHED_PP[245]), .SAVE (INT_SUM[247]), .CARRY (INT_CARRY[199]) );
  smffa  dla303 (.D(SUMMAND[246]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[246]) );
  smffa  dla304 (.D(SUMMAND[247]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[247]) );
  smffa  dla305 (.D(SUMMAND[248]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[248]) );
  smfulladder dfa172 (.DATA_A (LATCHED_PP[246]), .DATA_B (LATCHED_PP[247]), .DATA_C (LATCHED_PP[248]), .SAVE (INT_SUM[248]), .CARRY (INT_CARRY[200]) );
  smffa  dla306 (.D(SUMMAND[249]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[249]) );
  smffa  dla307 (.D(SUMMAND[250]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[250]) );
  smffa  dla308 (.D(SUMMAND[251]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[251]) );
  smfulladder dfa173 (.DATA_A (LATCHED_PP[249]), .DATA_B (LATCHED_PP[250]), .DATA_C (LATCHED_PP[251]), .SAVE (INT_SUM[249]), .CARRY (INT_CARRY[201]) );
  smffa  dla309 (.D(SUMMAND[252]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[252]) );
  smffa  dla310 (.D(SUMMAND[253]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[253]) );
  smffa  dla311 (.D(SUMMAND[254]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[254]) );
  smfulladder dfa174 (.DATA_A (LATCHED_PP[252]), .DATA_B (LATCHED_PP[253]), .DATA_C (LATCHED_PP[254]), .SAVE (INT_SUM[250]), .CARRY (INT_CARRY[202]) );
  smfulladder dfa175 (.DATA_A (INT_SUM[246]), .DATA_B (INT_SUM[247]), .DATA_C (INT_SUM[248]), .SAVE (INT_SUM[251]), .CARRY (INT_CARRY[203]) );
  smfulladder dfa176 (.DATA_A (INT_SUM[249]), .DATA_B (INT_SUM[250]), .DATA_C (INT_CARRY[184]), .SAVE (INT_SUM[252]), .CARRY (INT_CARRY[204]) );
  smfulladder dfa177 (.DATA_A (INT_CARRY[185]), .DATA_B (INT_CARRY[186]), .DATA_C (INT_CARRY[187]), .SAVE (INT_SUM[253]), .CARRY (INT_CARRY[205]) );
  assign INT_SUM[254] = INT_CARRY[188];
  smfulladder dfa178 (.DATA_A (INT_SUM[251]), .DATA_B (INT_SUM[252]), .DATA_C (INT_SUM[253]), .SAVE (INT_SUM[255]), .CARRY (INT_CARRY[206]) );
  smfulladder dfa179 (.DATA_A (INT_SUM[254]), .DATA_B (INT_CARRY[189]), .DATA_C (INT_CARRY[190]), .SAVE (INT_SUM[256]), .CARRY (INT_CARRY[207]) );
  assign INT_SUM[257] = INT_CARRY[191];
  smfulladder dfa180 (.DATA_A (INT_SUM[255]), .DATA_B (INT_SUM[256]), .DATA_C (INT_SUM[257]), .SAVE (INT_SUM[258]), .CARRY (INT_CARRY[208]) );
  smhalfadder dha27 (.DATA_A (INT_CARRY[192]), .DATA_B (INT_CARRY[193]), .SAVE (INT_SUM[259]), .CARRY (INT_CARRY[209]) );
  smfulladder dfa181 (.DATA_A (INT_SUM[258]), .DATA_B (INT_SUM[259]), .DATA_C (INT_CARRY[194]), .SAVE (INT_SUM[260]), .CARRY (INT_CARRY[210]) );
  assign INT_SUM[261] = INT_CARRY[195];
  smfulladder dfa182 (.DATA_A (INT_SUM[260]), .DATA_B (INT_SUM[261]), .DATA_C (INT_CARRY[196]), .SAVE (INT_SUM[262]), .CARRY (INT_CARRY[197]) );
  smffb  dla312 (.D(INT_SUM[262]), .clk(clk), .en_d2(en_d2), .Q(SUM[29]) );
  smffb  dla313 (.D(INT_CARRY[197]), .clk(clk), .en_d2(en_d2), .Q(CARRY[29]) );
  smffa  dla314 (.D(SUMMAND[255]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[255]) );
  smffa  dla315 (.D(SUMMAND[256]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[256]) );
  smffa  dla316 (.D(SUMMAND[257]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[257]) );
  smfulladder dfa183 (.DATA_A (LATCHED_PP[255]), .DATA_B (LATCHED_PP[256]), .DATA_C (LATCHED_PP[257]), .SAVE (INT_SUM[263]), .CARRY (INT_CARRY[212]) );
  smffa  dla317 (.D(SUMMAND[258]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[258]) );
  smffa  dla318 (.D(SUMMAND[259]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[259]) );
  smffa  dla319 (.D(SUMMAND[260]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[260]) );
  smfulladder dfa184 (.DATA_A (LATCHED_PP[258]), .DATA_B (LATCHED_PP[259]), .DATA_C (LATCHED_PP[260]), .SAVE (INT_SUM[264]), .CARRY (INT_CARRY[213]) );
  smffa  dla320 (.D(SUMMAND[261]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[261]) );
  smffa  dla321 (.D(SUMMAND[262]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[262]) );
  smffa  dla322 (.D(SUMMAND[263]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[263]) );
  smfulladder dfa185 (.DATA_A (LATCHED_PP[261]), .DATA_B (LATCHED_PP[262]), .DATA_C (LATCHED_PP[263]), .SAVE (INT_SUM[265]), .CARRY (INT_CARRY[214]) );
  smffa  dla323 (.D(SUMMAND[264]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[264]) );
  smffa  dla324 (.D(SUMMAND[265]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[265]) );
  smffa  dla325 (.D(SUMMAND[266]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[266]) );
  smfulladder dfa186 (.DATA_A (LATCHED_PP[264]), .DATA_B (LATCHED_PP[265]), .DATA_C (LATCHED_PP[266]), .SAVE (INT_SUM[266]), .CARRY (INT_CARRY[215]) );
  smffa  dla326 (.D(SUMMAND[267]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[267]) );
  smffa  dla327 (.D(SUMMAND[268]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[268]) );
  smffa  dla328 (.D(SUMMAND[269]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[269]) );
  smfulladder dfa187 (.DATA_A (LATCHED_PP[267]), .DATA_B (LATCHED_PP[268]), .DATA_C (LATCHED_PP[269]), .SAVE (INT_SUM[267]), .CARRY (INT_CARRY[216]) );
  smffa  dla329 (.D(SUMMAND[270]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[270]) );
  assign INT_SUM[268] = LATCHED_PP[270];
  smffa  dla330 (.D(SUMMAND[271]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[271]) );
  assign INT_SUM[269] = LATCHED_PP[271];
  smfulladder dfa188 (.DATA_A (INT_SUM[263]), .DATA_B (INT_SUM[264]), .DATA_C (INT_SUM[265]), .SAVE (INT_SUM[270]), .CARRY (INT_CARRY[217]) );
  smfulladder dfa189 (.DATA_A (INT_SUM[266]), .DATA_B (INT_SUM[267]), .DATA_C (INT_SUM[268]), .SAVE (INT_SUM[271]), .CARRY (INT_CARRY[218]) );
  smfulladder dfa190 (.DATA_A (INT_SUM[269]), .DATA_B (INT_CARRY[198]), .DATA_C (INT_CARRY[199]), .SAVE (INT_SUM[272]), .CARRY (INT_CARRY[219]) );
  smfulladder dfa191 (.DATA_A (INT_CARRY[200]), .DATA_B (INT_CARRY[201]), .DATA_C (INT_CARRY[202]), .SAVE (INT_SUM[273]), .CARRY (INT_CARRY[220]) );
  smfulladder dfa192 (.DATA_A (INT_SUM[270]), .DATA_B (INT_SUM[271]), .DATA_C (INT_SUM[272]), .SAVE (INT_SUM[274]), .CARRY (INT_CARRY[221]) );
  smfulladder dfa193 (.DATA_A (INT_SUM[273]), .DATA_B (INT_CARRY[203]), .DATA_C (INT_CARRY[204]), .SAVE (INT_SUM[275]), .CARRY (INT_CARRY[222]) );
  assign INT_SUM[276] = INT_CARRY[205];
  smfulladder dfa194 (.DATA_A (INT_SUM[274]), .DATA_B (INT_SUM[275]), .DATA_C (INT_SUM[276]), .SAVE (INT_SUM[277]), .CARRY (INT_CARRY[223]) );
  smhalfadder dha28 (.DATA_A (INT_CARRY[206]), .DATA_B (INT_CARRY[207]), .SAVE (INT_SUM[278]), .CARRY (INT_CARRY[224]) );
  smfulladder dfa195 (.DATA_A (INT_SUM[277]), .DATA_B (INT_SUM[278]), .DATA_C (INT_CARRY[208]), .SAVE (INT_SUM[279]), .CARRY (INT_CARRY[225]) );
  assign INT_SUM[280] = INT_CARRY[209];
  smfulladder dfa196 (.DATA_A (INT_SUM[279]), .DATA_B (INT_SUM[280]), .DATA_C (INT_CARRY[210]), .SAVE (INT_SUM[281]), .CARRY (INT_CARRY[211]) );
  smffb  dla331 (.D(INT_SUM[281]), .clk(clk), .en_d2(en_d2), .Q(SUM[30]) );
  smffb  dla332 (.D(INT_CARRY[211]), .clk(clk), .en_d2(en_d2), .Q(CARRY[30]) );
  smffa  dla333 (.D(SUMMAND[272]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[272]) );
  smffa  dla334 (.D(SUMMAND[273]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[273]) );
  smffa  dla335 (.D(SUMMAND[274]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[274]) );
  smfulladder dfa197 (.DATA_A (LATCHED_PP[272]), .DATA_B (LATCHED_PP[273]), .DATA_C (LATCHED_PP[274]), .SAVE (INT_SUM[282]), .CARRY (INT_CARRY[227]) );
  smffa  dla336 (.D(SUMMAND[275]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[275]) );
  smffa  dla337 (.D(SUMMAND[276]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[276]) );
  smffa  dla338 (.D(SUMMAND[277]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[277]) );
  smfulladder dfa198 (.DATA_A (LATCHED_PP[275]), .DATA_B (LATCHED_PP[276]), .DATA_C (LATCHED_PP[277]), .SAVE (INT_SUM[283]), .CARRY (INT_CARRY[228]) );
  smffa  dla339 (.D(SUMMAND[278]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[278]) );
  smffa  dla340 (.D(SUMMAND[279]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[279]) );
  smffa  dla341 (.D(SUMMAND[280]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[280]) );
  smfulladder dfa199 (.DATA_A (LATCHED_PP[278]), .DATA_B (LATCHED_PP[279]), .DATA_C (LATCHED_PP[280]), .SAVE (INT_SUM[284]), .CARRY (INT_CARRY[229]) );
  smffa  dla342 (.D(SUMMAND[281]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[281]) );
  smffa  dla343 (.D(SUMMAND[282]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[282]) );
  smffa  dla344 (.D(SUMMAND[283]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[283]) );
  smfulladder dfa200 (.DATA_A (LATCHED_PP[281]), .DATA_B (LATCHED_PP[282]), .DATA_C (LATCHED_PP[283]), .SAVE (INT_SUM[285]), .CARRY (INT_CARRY[230]) );
  smffa  dla345 (.D(SUMMAND[284]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[284]) );
  smffa  dla346 (.D(SUMMAND[285]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[285]) );
  smffa  dla347 (.D(SUMMAND[286]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[286]) );
  smfulladder dfa201 (.DATA_A (LATCHED_PP[284]), .DATA_B (LATCHED_PP[285]), .DATA_C (LATCHED_PP[286]), .SAVE (INT_SUM[286]), .CARRY (INT_CARRY[231]) );
  smffa  dla348 (.D(SUMMAND[287]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[287]) );
  assign INT_SUM[287] = LATCHED_PP[287];
  smfulladder dfa202 (.DATA_A (INT_SUM[282]), .DATA_B (INT_SUM[283]), .DATA_C (INT_SUM[284]), .SAVE (INT_SUM[288]), .CARRY (INT_CARRY[232]) );
  smfulladder dfa203 (.DATA_A (INT_SUM[285]), .DATA_B (INT_SUM[286]), .DATA_C (INT_SUM[287]), .SAVE (INT_SUM[289]), .CARRY (INT_CARRY[233]) );
  smfulladder dfa204 (.DATA_A (INT_CARRY[212]), .DATA_B (INT_CARRY[213]), .DATA_C (INT_CARRY[214]), .SAVE (INT_SUM[290]), .CARRY (INT_CARRY[234]) );
  assign INT_SUM[291] = INT_CARRY[215];
  assign INT_SUM[292] = INT_CARRY[216];
  smfulladder dfa205 (.DATA_A (INT_SUM[288]), .DATA_B (INT_SUM[289]), .DATA_C (INT_SUM[290]), .SAVE (INT_SUM[293]), .CARRY (INT_CARRY[235]) );
  smfulladder dfa206 (.DATA_A (INT_SUM[291]), .DATA_B (INT_SUM[292]), .DATA_C (INT_CARRY[217]), .SAVE (INT_SUM[294]), .CARRY (INT_CARRY[236]) );
  smfulladder dfa207 (.DATA_A (INT_CARRY[218]), .DATA_B (INT_CARRY[219]), .DATA_C (INT_CARRY[220]), .SAVE (INT_SUM[295]), .CARRY (INT_CARRY[237]) );
  smfulladder dfa208 (.DATA_A (INT_SUM[293]), .DATA_B (INT_SUM[294]), .DATA_C (INT_SUM[295]), .SAVE (INT_SUM[296]), .CARRY (INT_CARRY[238]) );
  smhalfadder dha29 (.DATA_A (INT_CARRY[221]), .DATA_B (INT_CARRY[222]), .SAVE (INT_SUM[297]), .CARRY (INT_CARRY[239]) );
  smfulladder dfa209 (.DATA_A (INT_SUM[296]), .DATA_B (INT_SUM[297]), .DATA_C (INT_CARRY[223]), .SAVE (INT_SUM[298]), .CARRY (INT_CARRY[240]) );
  assign INT_SUM[299] = INT_CARRY[224];
  smfulladder dfa210 (.DATA_A (INT_SUM[298]), .DATA_B (INT_SUM[299]), .DATA_C (INT_CARRY[225]), .SAVE (INT_SUM[300]), .CARRY (INT_CARRY[226]) );
  smffb  dla349 (.D(INT_SUM[300]), .clk(clk), .en_d2(en_d2), .Q(SUM[31]) );
  smffb  dla350 (.D(INT_CARRY[226]), .clk(clk), .en_d2(en_d2), .Q(CARRY[31]) );
  smffa  dla351 (.D(SUMMAND[288]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[288]) );
  smffa  dla352 (.D(SUMMAND[289]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[289]) );
  smffa  dla353 (.D(SUMMAND[290]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[290]) );
  smfulladder dfa211 (.DATA_A (LATCHED_PP[288]), .DATA_B (LATCHED_PP[289]), .DATA_C (LATCHED_PP[290]), .SAVE (INT_SUM[301]), .CARRY (INT_CARRY[242]) );
  smffa  dla354 (.D(SUMMAND[291]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[291]) );
  smffa  dla355 (.D(SUMMAND[292]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[292]) );
  smffa  dla356 (.D(SUMMAND[293]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[293]) );
  smfulladder dfa212 (.DATA_A (LATCHED_PP[291]), .DATA_B (LATCHED_PP[292]), .DATA_C (LATCHED_PP[293]), .SAVE (INT_SUM[302]), .CARRY (INT_CARRY[243]) );
  smffa  dla357 (.D(SUMMAND[294]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[294]) );
  smffa  dla358 (.D(SUMMAND[295]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[295]) );
  smffa  dla359 (.D(SUMMAND[296]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[296]) );
  smfulladder dfa213 (.DATA_A (LATCHED_PP[294]), .DATA_B (LATCHED_PP[295]), .DATA_C (LATCHED_PP[296]), .SAVE (INT_SUM[303]), .CARRY (INT_CARRY[244]) );
  smffa  dla360 (.D(SUMMAND[297]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[297]) );
  smffa  dla361 (.D(SUMMAND[298]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[298]) );
  smffa  dla362 (.D(SUMMAND[299]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[299]) );
  smfulladder dfa214 (.DATA_A (LATCHED_PP[297]), .DATA_B (LATCHED_PP[298]), .DATA_C (LATCHED_PP[299]), .SAVE (INT_SUM[304]), .CARRY (INT_CARRY[245]) );
  smffa  dla363 (.D(SUMMAND[300]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[300]) );
  smffa  dla364 (.D(SUMMAND[301]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[301]) );
  smffa  dla365 (.D(SUMMAND[302]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[302]) );
  smfulladder dfa215 (.DATA_A (LATCHED_PP[300]), .DATA_B (LATCHED_PP[301]), .DATA_C (LATCHED_PP[302]), .SAVE (INT_SUM[305]), .CARRY (INT_CARRY[246]) );
  smffa  dla366 (.D(SUMMAND[303]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[303]) );
  smffa  dla367 (.D(SUMMAND[304]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[304]) );
  smffa  dla368 (.D(SUMMAND[305]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[305]) );
  smfulladder dfa216 (.DATA_A (LATCHED_PP[303]), .DATA_B (LATCHED_PP[304]), .DATA_C (LATCHED_PP[305]), .SAVE (INT_SUM[306]), .CARRY (INT_CARRY[247]) );
  smfulladder dfa217 (.DATA_A (INT_SUM[301]), .DATA_B (INT_SUM[302]), .DATA_C (INT_SUM[303]), .SAVE (INT_SUM[307]), .CARRY (INT_CARRY[248]) );
  smfulladder dfa218 (.DATA_A (INT_SUM[304]), .DATA_B (INT_SUM[305]), .DATA_C (INT_SUM[306]), .SAVE (INT_SUM[308]), .CARRY (INT_CARRY[249]) );
  smfulladder dfa219 (.DATA_A (INT_CARRY[227]), .DATA_B (INT_CARRY[228]), .DATA_C (INT_CARRY[229]), .SAVE (INT_SUM[309]), .CARRY (INT_CARRY[250]) );
  smhalfadder dha30 (.DATA_A (INT_CARRY[230]), .DATA_B (INT_CARRY[231]), .SAVE (INT_SUM[310]), .CARRY (INT_CARRY[251]) );
  smfulladder dfa220 (.DATA_A (INT_SUM[307]), .DATA_B (INT_SUM[308]), .DATA_C (INT_SUM[309]), .SAVE (INT_SUM[311]), .CARRY (INT_CARRY[252]) );
  smfulladder dfa221 (.DATA_A (INT_SUM[310]), .DATA_B (INT_CARRY[232]), .DATA_C (INT_CARRY[233]), .SAVE (INT_SUM[312]), .CARRY (INT_CARRY[253]) );
  assign INT_SUM[313] = INT_CARRY[234];
  smfulladder dfa222 (.DATA_A (INT_SUM[311]), .DATA_B (INT_SUM[312]), .DATA_C (INT_SUM[313]), .SAVE (INT_SUM[314]), .CARRY (INT_CARRY[254]) );
  smfulladder dfa223 (.DATA_A (INT_CARRY[235]), .DATA_B (INT_CARRY[236]), .DATA_C (INT_CARRY[237]), .SAVE (INT_SUM[315]), .CARRY (INT_CARRY[255]) );
  smfulladder dfa224 (.DATA_A (INT_SUM[314]), .DATA_B (INT_SUM[315]), .DATA_C (INT_CARRY[238]), .SAVE (INT_SUM[316]), .CARRY (INT_CARRY[256]) );
  assign INT_SUM[317] = INT_CARRY[239];
  smfulladder dfa225 (.DATA_A (INT_SUM[316]), .DATA_B (INT_SUM[317]), .DATA_C (INT_CARRY[240]), .SAVE (INT_SUM[318]), .CARRY (INT_CARRY[241]) );
  smffb  dla369 (.D(INT_SUM[318]), .clk(clk), .en_d2(en_d2), .Q(SUM[32]) );
  smffb  dla370 (.D(INT_CARRY[241]), .clk(clk), .en_d2(en_d2), .Q(CARRY[32]) );
  smffa  dla371 (.D(SUMMAND[306]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[306]) );
  smffa  dla372 (.D(SUMMAND[307]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[307]) );
  smffa  dla373 (.D(SUMMAND[308]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[308]) );
  smfulladder dfa226 (.DATA_A (LATCHED_PP[306]), .DATA_B (LATCHED_PP[307]), .DATA_C (LATCHED_PP[308]), .SAVE (INT_SUM[319]), .CARRY (INT_CARRY[258]) );
  smffa  dla374 (.D(SUMMAND[309]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[309]) );
  smffa  dla375 (.D(SUMMAND[310]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[310]) );
  smffa  dla376 (.D(SUMMAND[311]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[311]) );
  smfulladder dfa227 (.DATA_A (LATCHED_PP[309]), .DATA_B (LATCHED_PP[310]), .DATA_C (LATCHED_PP[311]), .SAVE (INT_SUM[320]), .CARRY (INT_CARRY[259]) );
  smffa  dla377 (.D(SUMMAND[312]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[312]) );
  smffa  dla378 (.D(SUMMAND[313]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[313]) );
  smffa  dla379 (.D(SUMMAND[314]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[314]) );
  smfulladder dfa228 (.DATA_A (LATCHED_PP[312]), .DATA_B (LATCHED_PP[313]), .DATA_C (LATCHED_PP[314]), .SAVE (INT_SUM[321]), .CARRY (INT_CARRY[260]) );
  smffa  dla380 (.D(SUMMAND[315]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[315]) );
  smffa  dla381 (.D(SUMMAND[316]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[316]) );
  smffa  dla382 (.D(SUMMAND[317]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[317]) );
  smfulladder dfa229 (.DATA_A (LATCHED_PP[315]), .DATA_B (LATCHED_PP[316]), .DATA_C (LATCHED_PP[317]), .SAVE (INT_SUM[322]), .CARRY (INT_CARRY[261]) );
  smffa  dla383 (.D(SUMMAND[318]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[318]) );
  smffa  dla384 (.D(SUMMAND[319]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[319]) );
  smffa  dla385 (.D(SUMMAND[320]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[320]) );
  smfulladder dfa230 (.DATA_A (LATCHED_PP[318]), .DATA_B (LATCHED_PP[319]), .DATA_C (LATCHED_PP[320]), .SAVE (INT_SUM[323]), .CARRY (INT_CARRY[262]) );
  smffa  dla386 (.D(SUMMAND[321]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[321]) );
  assign INT_SUM[324] = LATCHED_PP[321];
  smffa  dla387 (.D(SUMMAND[322]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[322]) );
  assign INT_SUM[325] = LATCHED_PP[322];
  smfulladder dfa231 (.DATA_A (INT_SUM[319]), .DATA_B (INT_SUM[320]), .DATA_C (INT_SUM[321]), .SAVE (INT_SUM[326]), .CARRY (INT_CARRY[263]) );
  smfulladder dfa232 (.DATA_A (INT_SUM[322]), .DATA_B (INT_SUM[323]), .DATA_C (INT_SUM[324]), .SAVE (INT_SUM[327]), .CARRY (INT_CARRY[264]) );
  smfulladder dfa233 (.DATA_A (INT_SUM[325]), .DATA_B (INT_CARRY[242]), .DATA_C (INT_CARRY[243]), .SAVE (INT_SUM[328]), .CARRY (INT_CARRY[265]) );
  smfulladder dfa234 (.DATA_A (INT_CARRY[244]), .DATA_B (INT_CARRY[245]), .DATA_C (INT_CARRY[246]), .SAVE (INT_SUM[329]), .CARRY (INT_CARRY[266]) );
  assign INT_SUM[330] = INT_CARRY[247];
  smfulladder dfa235 (.DATA_A (INT_SUM[326]), .DATA_B (INT_SUM[327]), .DATA_C (INT_SUM[328]), .SAVE (INT_SUM[331]), .CARRY (INT_CARRY[267]) );
  smfulladder dfa236 (.DATA_A (INT_SUM[329]), .DATA_B (INT_SUM[330]), .DATA_C (INT_CARRY[248]), .SAVE (INT_SUM[332]), .CARRY (INT_CARRY[268]) );
  smfulladder dfa237 (.DATA_A (INT_CARRY[249]), .DATA_B (INT_CARRY[250]), .DATA_C (INT_CARRY[251]), .SAVE (INT_SUM[333]), .CARRY (INT_CARRY[269]) );
  smfulladder dfa238 (.DATA_A (INT_SUM[331]), .DATA_B (INT_SUM[332]), .DATA_C (INT_SUM[333]), .SAVE (INT_SUM[334]), .CARRY (INT_CARRY[270]) );
  smhalfadder dha31 (.DATA_A (INT_CARRY[252]), .DATA_B (INT_CARRY[253]), .SAVE (INT_SUM[335]), .CARRY (INT_CARRY[271]) );
  smfulladder dfa239 (.DATA_A (INT_SUM[334]), .DATA_B (INT_SUM[335]), .DATA_C (INT_CARRY[254]), .SAVE (INT_SUM[336]), .CARRY (INT_CARRY[272]) );
  assign INT_SUM[337] = INT_CARRY[255];
  smfulladder dfa240 (.DATA_A (INT_SUM[336]), .DATA_B (INT_SUM[337]), .DATA_C (INT_CARRY[256]), .SAVE (INT_SUM[338]), .CARRY (INT_CARRY[257]) );
  smffb  dla388 (.D(INT_SUM[338]), .clk(clk), .en_d2(en_d2), .Q(SUM[33]) );
  smffb  dla389 (.D(INT_CARRY[257]), .clk(clk), .en_d2(en_d2), .Q(CARRY[33]) );
  smffa  dla390 (.D(SUMMAND[323]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[323]) );
  smffa  dla391 (.D(SUMMAND[324]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[324]) );
  smffa  dla392 (.D(SUMMAND[325]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[325]) );
  smfulladder dfa241 (.DATA_A (LATCHED_PP[323]), .DATA_B (LATCHED_PP[324]), .DATA_C (LATCHED_PP[325]), .SAVE (INT_SUM[339]), .CARRY (INT_CARRY[274]) );
  smffa  dla393 (.D(SUMMAND[326]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[326]) );
  smffa  dla394 (.D(SUMMAND[327]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[327]) );
  smffa  dla395 (.D(SUMMAND[328]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[328]) );
  smfulladder dfa242 (.DATA_A (LATCHED_PP[326]), .DATA_B (LATCHED_PP[327]), .DATA_C (LATCHED_PP[328]), .SAVE (INT_SUM[340]), .CARRY (INT_CARRY[275]) );
  smffa  dla396 (.D(SUMMAND[329]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[329]) );
  smffa  dla397 (.D(SUMMAND[330]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[330]) );
  smffa  dla398 (.D(SUMMAND[331]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[331]) );
  smfulladder dfa243 (.DATA_A (LATCHED_PP[329]), .DATA_B (LATCHED_PP[330]), .DATA_C (LATCHED_PP[331]), .SAVE (INT_SUM[341]), .CARRY (INT_CARRY[276]) );
  smffa  dla399 (.D(SUMMAND[332]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[332]) );
  smffa  dla400 (.D(SUMMAND[333]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[333]) );
  smffa  dla401 (.D(SUMMAND[334]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[334]) );
  smfulladder dfa244 (.DATA_A (LATCHED_PP[332]), .DATA_B (LATCHED_PP[333]), .DATA_C (LATCHED_PP[334]), .SAVE (INT_SUM[342]), .CARRY (INT_CARRY[277]) );
  smffa  dla402 (.D(SUMMAND[335]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[335]) );
  smffa  dla403 (.D(SUMMAND[336]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[336]) );
  smffa  dla404 (.D(SUMMAND[337]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[337]) );
  smfulladder dfa245 (.DATA_A (LATCHED_PP[335]), .DATA_B (LATCHED_PP[336]), .DATA_C (LATCHED_PP[337]), .SAVE (INT_SUM[343]), .CARRY (INT_CARRY[278]) );
  smffa  dla405 (.D(SUMMAND[338]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[338]) );
  smffa  dla406 (.D(SUMMAND[339]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[339]) );
  smffa  dla407 (.D(SUMMAND[340]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[340]) );
  smfulladder dfa246 (.DATA_A (LATCHED_PP[338]), .DATA_B (LATCHED_PP[339]), .DATA_C (LATCHED_PP[340]), .SAVE (INT_SUM[344]), .CARRY (INT_CARRY[279]) );
  smfulladder dfa247 (.DATA_A (INT_SUM[339]), .DATA_B (INT_SUM[340]), .DATA_C (INT_SUM[341]), .SAVE (INT_SUM[345]), .CARRY (INT_CARRY[280]) );
  smfulladder dfa248 (.DATA_A (INT_SUM[342]), .DATA_B (INT_SUM[343]), .DATA_C (INT_SUM[344]), .SAVE (INT_SUM[346]), .CARRY (INT_CARRY[281]) );
  smfulladder dfa249 (.DATA_A (INT_CARRY[258]), .DATA_B (INT_CARRY[259]), .DATA_C (INT_CARRY[260]), .SAVE (INT_SUM[347]), .CARRY (INT_CARRY[282]) );
  assign INT_SUM[348] = INT_CARRY[261];
  assign INT_SUM[349] = INT_CARRY[262];
  smfulladder dfa250 (.DATA_A (INT_SUM[345]), .DATA_B (INT_SUM[346]), .DATA_C (INT_SUM[347]), .SAVE (INT_SUM[350]), .CARRY (INT_CARRY[283]) );
  smfulladder dfa251 (.DATA_A (INT_SUM[348]), .DATA_B (INT_SUM[349]), .DATA_C (INT_CARRY[263]), .SAVE (INT_SUM[351]), .CARRY (INT_CARRY[284]) );
  smfulladder dfa252 (.DATA_A (INT_CARRY[264]), .DATA_B (INT_CARRY[265]), .DATA_C (INT_CARRY[266]), .SAVE (INT_SUM[352]), .CARRY (INT_CARRY[285]) );
  smfulladder dfa253 (.DATA_A (INT_SUM[350]), .DATA_B (INT_SUM[351]), .DATA_C (INT_SUM[352]), .SAVE (INT_SUM[353]), .CARRY (INT_CARRY[286]) );
  smfulladder dfa254 (.DATA_A (INT_CARRY[267]), .DATA_B (INT_CARRY[268]), .DATA_C (INT_CARRY[269]), .SAVE (INT_SUM[354]), .CARRY (INT_CARRY[287]) );
  smfulladder dfa255 (.DATA_A (INT_SUM[353]), .DATA_B (INT_SUM[354]), .DATA_C (INT_CARRY[270]), .SAVE (INT_SUM[355]), .CARRY (INT_CARRY[288]) );
  assign INT_SUM[356] = INT_CARRY[271];
  smfulladder dfa256 (.DATA_A (INT_SUM[355]), .DATA_B (INT_SUM[356]), .DATA_C (INT_CARRY[272]), .SAVE (INT_SUM[357]), .CARRY (INT_CARRY[273]) );
  smffb  dla408 (.D(INT_SUM[357]), .clk(clk), .en_d2(en_d2), .Q(SUM[34]) );
  smffb  dla409 (.D(INT_CARRY[273]), .clk(clk), .en_d2(en_d2), .Q(CARRY[34]) );
  smffa  dla410 (.D(SUMMAND[341]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[341]) );
  smffa  dla411 (.D(SUMMAND[342]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[342]) );
  smffa  dla412 (.D(SUMMAND[343]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[343]) );
  smfulladder dfa257 (.DATA_A (LATCHED_PP[341]), .DATA_B (LATCHED_PP[342]), .DATA_C (LATCHED_PP[343]), .SAVE (INT_SUM[358]), .CARRY (INT_CARRY[290]) );
  smffa  dla413 (.D(SUMMAND[344]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[344]) );
  smffa  dla414 (.D(SUMMAND[345]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[345]) );
  smffa  dla415 (.D(SUMMAND[346]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[346]) );
  smfulladder dfa258 (.DATA_A (LATCHED_PP[344]), .DATA_B (LATCHED_PP[345]), .DATA_C (LATCHED_PP[346]), .SAVE (INT_SUM[359]), .CARRY (INT_CARRY[291]) );
  smffa  dla416 (.D(SUMMAND[347]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[347]) );
  smffa  dla417 (.D(SUMMAND[348]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[348]) );
  smffa  dla418 (.D(SUMMAND[349]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[349]) );
  smfulladder dfa259 (.DATA_A (LATCHED_PP[347]), .DATA_B (LATCHED_PP[348]), .DATA_C (LATCHED_PP[349]), .SAVE (INT_SUM[360]), .CARRY (INT_CARRY[292]) );
  smffa  dla419 (.D(SUMMAND[350]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[350]) );
  smffa  dla420 (.D(SUMMAND[351]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[351]) );
  smffa  dla421 (.D(SUMMAND[352]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[352]) );
  smfulladder dfa260 (.DATA_A (LATCHED_PP[350]), .DATA_B (LATCHED_PP[351]), .DATA_C (LATCHED_PP[352]), .SAVE (INT_SUM[361]), .CARRY (INT_CARRY[293]) );
  smffa  dla422 (.D(SUMMAND[353]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[353]) );
  smffa  dla423 (.D(SUMMAND[354]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[354]) );
  smffa  dla424 (.D(SUMMAND[355]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[355]) );
  smfulladder dfa261 (.DATA_A (LATCHED_PP[353]), .DATA_B (LATCHED_PP[354]), .DATA_C (LATCHED_PP[355]), .SAVE (INT_SUM[362]), .CARRY (INT_CARRY[294]) );
  smffa  dla425 (.D(SUMMAND[356]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[356]) );
  smffa  dla426 (.D(SUMMAND[357]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[357]) );
  smhalfadder dha32 (.DATA_A (LATCHED_PP[356]), .DATA_B (LATCHED_PP[357]), .SAVE (INT_SUM[363]), .CARRY (INT_CARRY[295]) );
  smfulladder dfa262 (.DATA_A (INT_SUM[358]), .DATA_B (INT_SUM[359]), .DATA_C (INT_SUM[360]), .SAVE (INT_SUM[364]), .CARRY (INT_CARRY[296]) );
  smfulladder dfa263 (.DATA_A (INT_SUM[361]), .DATA_B (INT_SUM[362]), .DATA_C (INT_SUM[363]), .SAVE (INT_SUM[365]), .CARRY (INT_CARRY[297]) );
  smfulladder dfa264 (.DATA_A (INT_CARRY[274]), .DATA_B (INT_CARRY[275]), .DATA_C (INT_CARRY[276]), .SAVE (INT_SUM[366]), .CARRY (INT_CARRY[298]) );
  smfulladder dfa265 (.DATA_A (INT_CARRY[277]), .DATA_B (INT_CARRY[278]), .DATA_C (INT_CARRY[279]), .SAVE (INT_SUM[367]), .CARRY (INT_CARRY[299]) );
  smfulladder dfa266 (.DATA_A (INT_SUM[364]), .DATA_B (INT_SUM[365]), .DATA_C (INT_SUM[366]), .SAVE (INT_SUM[368]), .CARRY (INT_CARRY[300]) );
  smfulladder dfa267 (.DATA_A (INT_SUM[367]), .DATA_B (INT_CARRY[280]), .DATA_C (INT_CARRY[281]), .SAVE (INT_SUM[369]), .CARRY (INT_CARRY[301]) );
  assign INT_SUM[370] = INT_CARRY[282];
  smfulladder dfa268 (.DATA_A (INT_SUM[368]), .DATA_B (INT_SUM[369]), .DATA_C (INT_SUM[370]), .SAVE (INT_SUM[371]), .CARRY (INT_CARRY[302]) );
  smfulladder dfa269 (.DATA_A (INT_CARRY[283]), .DATA_B (INT_CARRY[284]), .DATA_C (INT_CARRY[285]), .SAVE (INT_SUM[372]), .CARRY (INT_CARRY[303]) );
  smfulladder dfa270 (.DATA_A (INT_SUM[371]), .DATA_B (INT_SUM[372]), .DATA_C (INT_CARRY[286]), .SAVE (INT_SUM[373]), .CARRY (INT_CARRY[304]) );
  assign INT_SUM[374] = INT_CARRY[287];
  smfulladder dfa271 (.DATA_A (INT_SUM[373]), .DATA_B (INT_SUM[374]), .DATA_C (INT_CARRY[288]), .SAVE (INT_SUM[375]), .CARRY (INT_CARRY[289]) );
  smffb  dla427 (.D(INT_SUM[375]), .clk(clk), .en_d2(en_d2), .Q(SUM[35]) );
  smffb  dla428 (.D(INT_CARRY[289]), .clk(clk), .en_d2(en_d2), .Q(CARRY[35]) );
  smffa  dla429 (.D(SUMMAND[358]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[358]) );
  smffa  dla430 (.D(SUMMAND[359]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[359]) );
  smffa  dla431 (.D(SUMMAND[360]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[360]) );
  smfulladder dfa272 (.DATA_A (LATCHED_PP[358]), .DATA_B (LATCHED_PP[359]), .DATA_C (LATCHED_PP[360]), .SAVE (INT_SUM[376]), .CARRY (INT_CARRY[306]) );
  smffa  dla432 (.D(SUMMAND[361]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[361]) );
  smffa  dla433 (.D(SUMMAND[362]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[362]) );
  smffa  dla434 (.D(SUMMAND[363]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[363]) );
  smfulladder dfa273 (.DATA_A (LATCHED_PP[361]), .DATA_B (LATCHED_PP[362]), .DATA_C (LATCHED_PP[363]), .SAVE (INT_SUM[377]), .CARRY (INT_CARRY[307]) );
  smffa  dla435 (.D(SUMMAND[364]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[364]) );
  smffa  dla436 (.D(SUMMAND[365]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[365]) );
  smffa  dla437 (.D(SUMMAND[366]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[366]) );
  smfulladder dfa274 (.DATA_A (LATCHED_PP[364]), .DATA_B (LATCHED_PP[365]), .DATA_C (LATCHED_PP[366]), .SAVE (INT_SUM[378]), .CARRY (INT_CARRY[308]) );
  smffa  dla438 (.D(SUMMAND[367]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[367]) );
  smffa  dla439 (.D(SUMMAND[368]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[368]) );
  smffa  dla440 (.D(SUMMAND[369]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[369]) );
  smfulladder dfa275 (.DATA_A (LATCHED_PP[367]), .DATA_B (LATCHED_PP[368]), .DATA_C (LATCHED_PP[369]), .SAVE (INT_SUM[379]), .CARRY (INT_CARRY[309]) );
  smffa  dla441 (.D(SUMMAND[370]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[370]) );
  smffa  dla442 (.D(SUMMAND[371]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[371]) );
  smffa  dla443 (.D(SUMMAND[372]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[372]) );
  smfulladder dfa276 (.DATA_A (LATCHED_PP[370]), .DATA_B (LATCHED_PP[371]), .DATA_C (LATCHED_PP[372]), .SAVE (INT_SUM[380]), .CARRY (INT_CARRY[310]) );
  smffa  dla444 (.D(SUMMAND[373]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[373]) );
  assign INT_SUM[381] = LATCHED_PP[373];
  smfulladder dfa277 (.DATA_A (INT_SUM[376]), .DATA_B (INT_SUM[377]), .DATA_C (INT_SUM[378]), .SAVE (INT_SUM[382]), .CARRY (INT_CARRY[311]) );
  smfulladder dfa278 (.DATA_A (INT_SUM[379]), .DATA_B (INT_SUM[380]), .DATA_C (INT_SUM[381]), .SAVE (INT_SUM[383]), .CARRY (INT_CARRY[312]) );
  smfulladder dfa279 (.DATA_A (INT_CARRY[290]), .DATA_B (INT_CARRY[291]), .DATA_C (INT_CARRY[292]), .SAVE (INT_SUM[384]), .CARRY (INT_CARRY[313]) );
  smfulladder dfa280 (.DATA_A (INT_CARRY[293]), .DATA_B (INT_CARRY[294]), .DATA_C (INT_CARRY[295]), .SAVE (INT_SUM[385]), .CARRY (INT_CARRY[314]) );
  smfulladder dfa281 (.DATA_A (INT_SUM[382]), .DATA_B (INT_SUM[383]), .DATA_C (INT_SUM[384]), .SAVE (INT_SUM[386]), .CARRY (INT_CARRY[315]) );
  smfulladder dfa282 (.DATA_A (INT_SUM[385]), .DATA_B (INT_CARRY[296]), .DATA_C (INT_CARRY[297]), .SAVE (INT_SUM[387]), .CARRY (INT_CARRY[316]) );
  assign INT_SUM[388] = INT_CARRY[298];
  assign INT_SUM[389] = INT_CARRY[299];
  smfulladder dfa283 (.DATA_A (INT_SUM[386]), .DATA_B (INT_SUM[387]), .DATA_C (INT_SUM[388]), .SAVE (INT_SUM[390]), .CARRY (INT_CARRY[317]) );
  smfulladder dfa284 (.DATA_A (INT_SUM[389]), .DATA_B (INT_CARRY[300]), .DATA_C (INT_CARRY[301]), .SAVE (INT_SUM[391]), .CARRY (INT_CARRY[318]) );
  smfulladder dfa285 (.DATA_A (INT_SUM[390]), .DATA_B (INT_SUM[391]), .DATA_C (INT_CARRY[302]), .SAVE (INT_SUM[392]), .CARRY (INT_CARRY[319]) );
  assign INT_SUM[393] = INT_CARRY[303];
  smfulladder dfa286 (.DATA_A (INT_SUM[392]), .DATA_B (INT_SUM[393]), .DATA_C (INT_CARRY[304]), .SAVE (INT_SUM[394]), .CARRY (INT_CARRY[305]) );
  smffb  dla445 (.D(INT_SUM[394]), .clk(clk), .en_d2(en_d2), .Q(SUM[36]) );
  smffb  dla446 (.D(INT_CARRY[305]), .clk(clk), .en_d2(en_d2), .Q(CARRY[36]) );
  smffa  dla447 (.D(SUMMAND[374]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[374]) );
  smffa  dla448 (.D(SUMMAND[375]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[375]) );
  smffa  dla449 (.D(SUMMAND[376]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[376]) );
  smfulladder dfa287 (.DATA_A (LATCHED_PP[374]), .DATA_B (LATCHED_PP[375]), .DATA_C (LATCHED_PP[376]), .SAVE (INT_SUM[395]), .CARRY (INT_CARRY[321]) );
  smffa  dla450 (.D(SUMMAND[377]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[377]) );
  smffa  dla451 (.D(SUMMAND[378]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[378]) );
  smffa  dla452 (.D(SUMMAND[379]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[379]) );
  smfulladder dfa288 (.DATA_A (LATCHED_PP[377]), .DATA_B (LATCHED_PP[378]), .DATA_C (LATCHED_PP[379]), .SAVE (INT_SUM[396]), .CARRY (INT_CARRY[322]) );
  smffa  dla453 (.D(SUMMAND[380]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[380]) );
  smffa  dla454 (.D(SUMMAND[381]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[381]) );
  smffa  dla455 (.D(SUMMAND[382]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[382]) );
  smfulladder dfa289 (.DATA_A (LATCHED_PP[380]), .DATA_B (LATCHED_PP[381]), .DATA_C (LATCHED_PP[382]), .SAVE (INT_SUM[397]), .CARRY (INT_CARRY[323]) );
  smffa  dla456 (.D(SUMMAND[383]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[383]) );
  smffa  dla457 (.D(SUMMAND[384]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[384]) );
  smffa  dla458 (.D(SUMMAND[385]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[385]) );
  smfulladder dfa290 (.DATA_A (LATCHED_PP[383]), .DATA_B (LATCHED_PP[384]), .DATA_C (LATCHED_PP[385]), .SAVE (INT_SUM[398]), .CARRY (INT_CARRY[324]) );
  smffa  dla459 (.D(SUMMAND[386]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[386]) );
  smffa  dla460 (.D(SUMMAND[387]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[387]) );
  smffa  dla461 (.D(SUMMAND[388]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[388]) );
  smfulladder dfa291 (.DATA_A (LATCHED_PP[386]), .DATA_B (LATCHED_PP[387]), .DATA_C (LATCHED_PP[388]), .SAVE (INT_SUM[399]), .CARRY (INT_CARRY[325]) );
  smffa  dla462 (.D(SUMMAND[389]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[389]) );
  assign INT_SUM[400] = LATCHED_PP[389];
  smfulladder dfa292 (.DATA_A (INT_SUM[395]), .DATA_B (INT_SUM[396]), .DATA_C (INT_SUM[397]), .SAVE (INT_SUM[401]), .CARRY (INT_CARRY[326]) );
  smfulladder dfa293 (.DATA_A (INT_SUM[398]), .DATA_B (INT_SUM[399]), .DATA_C (INT_SUM[400]), .SAVE (INT_SUM[402]), .CARRY (INT_CARRY[327]) );
  smfulladder dfa294 (.DATA_A (INT_CARRY[306]), .DATA_B (INT_CARRY[307]), .DATA_C (INT_CARRY[308]), .SAVE (INT_SUM[403]), .CARRY (INT_CARRY[328]) );
  assign INT_SUM[404] = INT_CARRY[309];
  assign INT_SUM[405] = INT_CARRY[310];
  smfulladder dfa295 (.DATA_A (INT_SUM[401]), .DATA_B (INT_SUM[402]), .DATA_C (INT_SUM[403]), .SAVE (INT_SUM[406]), .CARRY (INT_CARRY[329]) );
  smfulladder dfa296 (.DATA_A (INT_SUM[404]), .DATA_B (INT_SUM[405]), .DATA_C (INT_CARRY[311]), .SAVE (INT_SUM[407]), .CARRY (INT_CARRY[330]) );
  smfulladder dfa297 (.DATA_A (INT_CARRY[312]), .DATA_B (INT_CARRY[313]), .DATA_C (INT_CARRY[314]), .SAVE (INT_SUM[408]), .CARRY (INT_CARRY[331]) );
  smfulladder dfa298 (.DATA_A (INT_SUM[406]), .DATA_B (INT_SUM[407]), .DATA_C (INT_SUM[408]), .SAVE (INT_SUM[409]), .CARRY (INT_CARRY[332]) );
  smhalfadder dha33 (.DATA_A (INT_CARRY[315]), .DATA_B (INT_CARRY[316]), .SAVE (INT_SUM[410]), .CARRY (INT_CARRY[333]) );
  smfulladder dfa299 (.DATA_A (INT_SUM[409]), .DATA_B (INT_SUM[410]), .DATA_C (INT_CARRY[317]), .SAVE (INT_SUM[411]), .CARRY (INT_CARRY[334]) );
  assign INT_SUM[412] = INT_CARRY[318];
  smfulladder dfa300 (.DATA_A (INT_SUM[411]), .DATA_B (INT_SUM[412]), .DATA_C (INT_CARRY[319]), .SAVE (INT_SUM[413]), .CARRY (INT_CARRY[320]) );
  smffb  dla463 (.D(INT_SUM[413]), .clk(clk), .en_d2(en_d2), .Q(SUM[37]) );
  smffb  dla464 (.D(INT_CARRY[320]), .clk(clk), .en_d2(en_d2), .Q(CARRY[37]) );
  smffa  dla465 (.D(SUMMAND[390]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[390]) );
  smffa  dla466 (.D(SUMMAND[391]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[391]) );
  smffa  dla467 (.D(SUMMAND[392]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[392]) );
  smfulladder dfa301 (.DATA_A (LATCHED_PP[390]), .DATA_B (LATCHED_PP[391]), .DATA_C (LATCHED_PP[392]), .SAVE (INT_SUM[414]), .CARRY (INT_CARRY[336]) );
  smffa  dla468 (.D(SUMMAND[393]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[393]) );
  smffa  dla469 (.D(SUMMAND[394]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[394]) );
  smffa  dla470 (.D(SUMMAND[395]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[395]) );
  smfulladder dfa302 (.DATA_A (LATCHED_PP[393]), .DATA_B (LATCHED_PP[394]), .DATA_C (LATCHED_PP[395]), .SAVE (INT_SUM[415]), .CARRY (INT_CARRY[337]) );
  smffa  dla471 (.D(SUMMAND[396]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[396]) );
  smffa  dla472 (.D(SUMMAND[397]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[397]) );
  smffa  dla473 (.D(SUMMAND[398]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[398]) );
  smfulladder dfa303 (.DATA_A (LATCHED_PP[396]), .DATA_B (LATCHED_PP[397]), .DATA_C (LATCHED_PP[398]), .SAVE (INT_SUM[416]), .CARRY (INT_CARRY[338]) );
  smffa  dla474 (.D(SUMMAND[399]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[399]) );
  smffa  dla475 (.D(SUMMAND[400]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[400]) );
  smffa  dla476 (.D(SUMMAND[401]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[401]) );
  smfulladder dfa304 (.DATA_A (LATCHED_PP[399]), .DATA_B (LATCHED_PP[400]), .DATA_C (LATCHED_PP[401]), .SAVE (INT_SUM[417]), .CARRY (INT_CARRY[339]) );
  smffa  dla477 (.D(SUMMAND[402]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[402]) );
  smffa  dla478 (.D(SUMMAND[403]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[403]) );
  smffa  dla479 (.D(SUMMAND[404]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[404]) );
  smfulladder dfa305 (.DATA_A (LATCHED_PP[402]), .DATA_B (LATCHED_PP[403]), .DATA_C (LATCHED_PP[404]), .SAVE (INT_SUM[418]), .CARRY (INT_CARRY[340]) );
  smfulladder dfa306 (.DATA_A (INT_SUM[414]), .DATA_B (INT_SUM[415]), .DATA_C (INT_SUM[416]), .SAVE (INT_SUM[419]), .CARRY (INT_CARRY[341]) );
  smfulladder dfa307 (.DATA_A (INT_SUM[417]), .DATA_B (INT_SUM[418]), .DATA_C (INT_CARRY[321]), .SAVE (INT_SUM[420]), .CARRY (INT_CARRY[342]) );
  smfulladder dfa308 (.DATA_A (INT_CARRY[322]), .DATA_B (INT_CARRY[323]), .DATA_C (INT_CARRY[324]), .SAVE (INT_SUM[421]), .CARRY (INT_CARRY[343]) );
  assign INT_SUM[422] = INT_CARRY[325];
  smfulladder dfa309 (.DATA_A (INT_SUM[419]), .DATA_B (INT_SUM[420]), .DATA_C (INT_SUM[421]), .SAVE (INT_SUM[423]), .CARRY (INT_CARRY[344]) );
  smfulladder dfa310 (.DATA_A (INT_SUM[422]), .DATA_B (INT_CARRY[326]), .DATA_C (INT_CARRY[327]), .SAVE (INT_SUM[424]), .CARRY (INT_CARRY[345]) );
  assign INT_SUM[425] = INT_CARRY[328];
  smfulladder dfa311 (.DATA_A (INT_SUM[423]), .DATA_B (INT_SUM[424]), .DATA_C (INT_SUM[425]), .SAVE (INT_SUM[426]), .CARRY (INT_CARRY[346]) );
  smfulladder dfa312 (.DATA_A (INT_CARRY[329]), .DATA_B (INT_CARRY[330]), .DATA_C (INT_CARRY[331]), .SAVE (INT_SUM[427]), .CARRY (INT_CARRY[347]) );
  smfulladder dfa313 (.DATA_A (INT_SUM[426]), .DATA_B (INT_SUM[427]), .DATA_C (INT_CARRY[332]), .SAVE (INT_SUM[428]), .CARRY (INT_CARRY[348]) );
  assign INT_SUM[429] = INT_CARRY[333];
  smfulladder dfa314 (.DATA_A (INT_SUM[428]), .DATA_B (INT_SUM[429]), .DATA_C (INT_CARRY[334]), .SAVE (INT_SUM[430]), .CARRY (INT_CARRY[335]) );
  smffb  dla480 (.D(INT_SUM[430]), .clk(clk), .en_d2(en_d2), .Q(SUM[38]) );
  smffb  dla481 (.D(INT_CARRY[335]), .clk(clk), .en_d2(en_d2), .Q(CARRY[38]) );
  smffa  dla482 (.D(SUMMAND[405]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[405]) );
  smffa  dla483 (.D(SUMMAND[406]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[406]) );
  smffa  dla484 (.D(SUMMAND[407]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[407]) );
  smfulladder dfa315 (.DATA_A (LATCHED_PP[405]), .DATA_B (LATCHED_PP[406]), .DATA_C (LATCHED_PP[407]), .SAVE (INT_SUM[431]), .CARRY (INT_CARRY[350]) );
  smffa  dla485 (.D(SUMMAND[408]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[408]) );
  smffa  dla486 (.D(SUMMAND[409]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[409]) );
  smffa  dla487 (.D(SUMMAND[410]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[410]) );
  smfulladder dfa316 (.DATA_A (LATCHED_PP[408]), .DATA_B (LATCHED_PP[409]), .DATA_C (LATCHED_PP[410]), .SAVE (INT_SUM[432]), .CARRY (INT_CARRY[351]) );
  smffa  dla488 (.D(SUMMAND[411]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[411]) );
  smffa  dla489 (.D(SUMMAND[412]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[412]) );
  smffa  dla490 (.D(SUMMAND[413]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[413]) );
  smfulladder dfa317 (.DATA_A (LATCHED_PP[411]), .DATA_B (LATCHED_PP[412]), .DATA_C (LATCHED_PP[413]), .SAVE (INT_SUM[433]), .CARRY (INT_CARRY[352]) );
  smffa  dla491 (.D(SUMMAND[414]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[414]) );
  smffa  dla492 (.D(SUMMAND[415]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[415]) );
  smffa  dla493 (.D(SUMMAND[416]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[416]) );
  smfulladder dfa318 (.DATA_A (LATCHED_PP[414]), .DATA_B (LATCHED_PP[415]), .DATA_C (LATCHED_PP[416]), .SAVE (INT_SUM[434]), .CARRY (INT_CARRY[353]) );
  smffa  dla494 (.D(SUMMAND[417]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[417]) );
  smffa  dla495 (.D(SUMMAND[418]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[418]) );
  smffa  dla496 (.D(SUMMAND[419]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[419]) );
  smfulladder dfa319 (.DATA_A (LATCHED_PP[417]), .DATA_B (LATCHED_PP[418]), .DATA_C (LATCHED_PP[419]), .SAVE (INT_SUM[435]), .CARRY (INT_CARRY[354]) );
  smfulladder dfa320 (.DATA_A (INT_SUM[431]), .DATA_B (INT_SUM[432]), .DATA_C (INT_SUM[433]), .SAVE (INT_SUM[436]), .CARRY (INT_CARRY[355]) );
  smfulladder dfa321 (.DATA_A (INT_SUM[434]), .DATA_B (INT_SUM[435]), .DATA_C (INT_CARRY[336]), .SAVE (INT_SUM[437]), .CARRY (INT_CARRY[356]) );
  smfulladder dfa322 (.DATA_A (INT_CARRY[337]), .DATA_B (INT_CARRY[338]), .DATA_C (INT_CARRY[339]), .SAVE (INT_SUM[438]), .CARRY (INT_CARRY[357]) );
  assign INT_SUM[439] = INT_CARRY[340];
  smfulladder dfa323 (.DATA_A (INT_SUM[436]), .DATA_B (INT_SUM[437]), .DATA_C (INT_SUM[438]), .SAVE (INT_SUM[440]), .CARRY (INT_CARRY[358]) );
  smfulladder dfa324 (.DATA_A (INT_SUM[439]), .DATA_B (INT_CARRY[341]), .DATA_C (INT_CARRY[342]), .SAVE (INT_SUM[441]), .CARRY (INT_CARRY[359]) );
  assign INT_SUM[442] = INT_CARRY[343];
  smfulladder dfa325 (.DATA_A (INT_SUM[440]), .DATA_B (INT_SUM[441]), .DATA_C (INT_SUM[442]), .SAVE (INT_SUM[443]), .CARRY (INT_CARRY[360]) );
  smhalfadder dha34 (.DATA_A (INT_CARRY[344]), .DATA_B (INT_CARRY[345]), .SAVE (INT_SUM[444]), .CARRY (INT_CARRY[361]) );
  smfulladder dfa326 (.DATA_A (INT_SUM[443]), .DATA_B (INT_SUM[444]), .DATA_C (INT_CARRY[346]), .SAVE (INT_SUM[445]), .CARRY (INT_CARRY[362]) );
  assign INT_SUM[446] = INT_CARRY[347];
  smfulladder dfa327 (.DATA_A (INT_SUM[445]), .DATA_B (INT_SUM[446]), .DATA_C (INT_CARRY[348]), .SAVE (INT_SUM[447]), .CARRY (INT_CARRY[349]) );
  smffb  dla497 (.D(INT_SUM[447]), .clk(clk), .en_d2(en_d2), .Q(SUM[39]) );
  smffb  dla498 (.D(INT_CARRY[349]), .clk(clk), .en_d2(en_d2), .Q(CARRY[39]) );
  smffa  dla499 (.D(SUMMAND[420]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[420]) );
  smffa  dla500 (.D(SUMMAND[421]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[421]) );
  smffa  dla501 (.D(SUMMAND[422]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[422]) );
  smfulladder dfa328 (.DATA_A (LATCHED_PP[420]), .DATA_B (LATCHED_PP[421]), .DATA_C (LATCHED_PP[422]), .SAVE (INT_SUM[448]), .CARRY (INT_CARRY[364]) );
  smffa  dla502 (.D(SUMMAND[423]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[423]) );
  smffa  dla503 (.D(SUMMAND[424]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[424]) );
  smffa  dla504 (.D(SUMMAND[425]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[425]) );
  smfulladder dfa329 (.DATA_A (LATCHED_PP[423]), .DATA_B (LATCHED_PP[424]), .DATA_C (LATCHED_PP[425]), .SAVE (INT_SUM[449]), .CARRY (INT_CARRY[365]) );
  smffa  dla505 (.D(SUMMAND[426]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[426]) );
  smffa  dla506 (.D(SUMMAND[427]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[427]) );
  smffa  dla507 (.D(SUMMAND[428]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[428]) );
  smfulladder dfa330 (.DATA_A (LATCHED_PP[426]), .DATA_B (LATCHED_PP[427]), .DATA_C (LATCHED_PP[428]), .SAVE (INT_SUM[450]), .CARRY (INT_CARRY[366]) );
  smffa  dla508 (.D(SUMMAND[429]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[429]) );
  smffa  dla509 (.D(SUMMAND[430]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[430]) );
  smffa  dla510 (.D(SUMMAND[431]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[431]) );
  smfulladder dfa331 (.DATA_A (LATCHED_PP[429]), .DATA_B (LATCHED_PP[430]), .DATA_C (LATCHED_PP[431]), .SAVE (INT_SUM[451]), .CARRY (INT_CARRY[367]) );
  smffa  dla511 (.D(SUMMAND[432]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[432]) );
  smffa  dla512 (.D(SUMMAND[433]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[433]) );
  smhalfadder dha35 (.DATA_A (LATCHED_PP[432]), .DATA_B (LATCHED_PP[433]), .SAVE (INT_SUM[452]), .CARRY (INT_CARRY[368]) );
  smfulladder dfa332 (.DATA_A (INT_SUM[448]), .DATA_B (INT_SUM[449]), .DATA_C (INT_SUM[450]), .SAVE (INT_SUM[453]), .CARRY (INT_CARRY[369]) );
  smfulladder dfa333 (.DATA_A (INT_SUM[451]), .DATA_B (INT_SUM[452]), .DATA_C (INT_CARRY[350]), .SAVE (INT_SUM[454]), .CARRY (INT_CARRY[370]) );
  smfulladder dfa334 (.DATA_A (INT_CARRY[351]), .DATA_B (INT_CARRY[352]), .DATA_C (INT_CARRY[353]), .SAVE (INT_SUM[455]), .CARRY (INT_CARRY[371]) );
  assign INT_SUM[456] = INT_CARRY[354];
  smfulladder dfa335 (.DATA_A (INT_SUM[453]), .DATA_B (INT_SUM[454]), .DATA_C (INT_SUM[455]), .SAVE (INT_SUM[457]), .CARRY (INT_CARRY[372]) );
  smfulladder dfa336 (.DATA_A (INT_SUM[456]), .DATA_B (INT_CARRY[355]), .DATA_C (INT_CARRY[356]), .SAVE (INT_SUM[458]), .CARRY (INT_CARRY[373]) );
  assign INT_SUM[459] = INT_CARRY[357];
  smfulladder dfa337 (.DATA_A (INT_SUM[457]), .DATA_B (INT_SUM[458]), .DATA_C (INT_SUM[459]), .SAVE (INT_SUM[460]), .CARRY (INT_CARRY[374]) );
  smhalfadder dha36 (.DATA_A (INT_CARRY[358]), .DATA_B (INT_CARRY[359]), .SAVE (INT_SUM[461]), .CARRY (INT_CARRY[375]) );
  smfulladder dfa338 (.DATA_A (INT_SUM[460]), .DATA_B (INT_SUM[461]), .DATA_C (INT_CARRY[360]), .SAVE (INT_SUM[462]), .CARRY (INT_CARRY[376]) );
  assign INT_SUM[463] = INT_CARRY[361];
  smfulladder dfa339 (.DATA_A (INT_SUM[462]), .DATA_B (INT_SUM[463]), .DATA_C (INT_CARRY[362]), .SAVE (INT_SUM[464]), .CARRY (INT_CARRY[363]) );
  smffb  dla513 (.D(INT_SUM[464]), .clk(clk), .en_d2(en_d2), .Q(SUM[40]) );
  smffb  dla514 (.D(INT_CARRY[363]), .clk(clk), .en_d2(en_d2), .Q(CARRY[40]) );
  smffa  dla515 (.D(SUMMAND[434]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[434]) );
  smffa  dla516 (.D(SUMMAND[435]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[435]) );
  smffa  dla517 (.D(SUMMAND[436]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[436]) );
  smfulladder dfa340 (.DATA_A (LATCHED_PP[434]), .DATA_B (LATCHED_PP[435]), .DATA_C (LATCHED_PP[436]), .SAVE (INT_SUM[465]), .CARRY (INT_CARRY[378]) );
  smffa  dla518 (.D(SUMMAND[437]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[437]) );
  smffa  dla519 (.D(SUMMAND[438]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[438]) );
  smffa  dla520 (.D(SUMMAND[439]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[439]) );
  smfulladder dfa341 (.DATA_A (LATCHED_PP[437]), .DATA_B (LATCHED_PP[438]), .DATA_C (LATCHED_PP[439]), .SAVE (INT_SUM[466]), .CARRY (INT_CARRY[379]) );
  smffa  dla521 (.D(SUMMAND[440]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[440]) );
  smffa  dla522 (.D(SUMMAND[441]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[441]) );
  smffa  dla523 (.D(SUMMAND[442]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[442]) );
  smfulladder dfa342 (.DATA_A (LATCHED_PP[440]), .DATA_B (LATCHED_PP[441]), .DATA_C (LATCHED_PP[442]), .SAVE (INT_SUM[467]), .CARRY (INT_CARRY[380]) );
  smffa  dla524 (.D(SUMMAND[443]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[443]) );
  smffa  dla525 (.D(SUMMAND[444]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[444]) );
  smffa  dla526 (.D(SUMMAND[445]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[445]) );
  smfulladder dfa343 (.DATA_A (LATCHED_PP[443]), .DATA_B (LATCHED_PP[444]), .DATA_C (LATCHED_PP[445]), .SAVE (INT_SUM[468]), .CARRY (INT_CARRY[381]) );
  smffa  dla527 (.D(SUMMAND[446]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[446]) );
  smffa  dla528 (.D(SUMMAND[447]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[447]) );
  smhalfadder dha37 (.DATA_A (LATCHED_PP[446]), .DATA_B (LATCHED_PP[447]), .SAVE (INT_SUM[469]), .CARRY (INT_CARRY[382]) );
  smfulladder dfa344 (.DATA_A (INT_SUM[465]), .DATA_B (INT_SUM[466]), .DATA_C (INT_SUM[467]), .SAVE (INT_SUM[470]), .CARRY (INT_CARRY[383]) );
  smfulladder dfa345 (.DATA_A (INT_SUM[468]), .DATA_B (INT_SUM[469]), .DATA_C (INT_CARRY[364]), .SAVE (INT_SUM[471]), .CARRY (INT_CARRY[384]) );
  smfulladder dfa346 (.DATA_A (INT_CARRY[365]), .DATA_B (INT_CARRY[366]), .DATA_C (INT_CARRY[367]), .SAVE (INT_SUM[472]), .CARRY (INT_CARRY[385]) );
  assign INT_SUM[473] = INT_CARRY[368];
  smfulladder dfa347 (.DATA_A (INT_SUM[470]), .DATA_B (INT_SUM[471]), .DATA_C (INT_SUM[472]), .SAVE (INT_SUM[474]), .CARRY (INT_CARRY[386]) );
  smfulladder dfa348 (.DATA_A (INT_SUM[473]), .DATA_B (INT_CARRY[369]), .DATA_C (INT_CARRY[370]), .SAVE (INT_SUM[475]), .CARRY (INT_CARRY[387]) );
  assign INT_SUM[476] = INT_CARRY[371];
  smfulladder dfa349 (.DATA_A (INT_SUM[474]), .DATA_B (INT_SUM[475]), .DATA_C (INT_SUM[476]), .SAVE (INT_SUM[477]), .CARRY (INT_CARRY[388]) );
  smhalfadder dha38 (.DATA_A (INT_CARRY[372]), .DATA_B (INT_CARRY[373]), .SAVE (INT_SUM[478]), .CARRY (INT_CARRY[389]) );
  smfulladder dfa350 (.DATA_A (INT_SUM[477]), .DATA_B (INT_SUM[478]), .DATA_C (INT_CARRY[374]), .SAVE (INT_SUM[479]), .CARRY (INT_CARRY[390]) );
  assign INT_SUM[480] = INT_CARRY[375];
  smfulladder dfa351 (.DATA_A (INT_SUM[479]), .DATA_B (INT_SUM[480]), .DATA_C (INT_CARRY[376]), .SAVE (INT_SUM[481]), .CARRY (INT_CARRY[377]) );
  smffb  dla529 (.D(INT_SUM[481]), .clk(clk), .en_d2(en_d2), .Q(SUM[41]) );
  smffb  dla530 (.D(INT_CARRY[377]), .clk(clk), .en_d2(en_d2), .Q(CARRY[41]) );
  smffa  dla531 (.D(SUMMAND[448]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[448]) );
  smffa  dla532 (.D(SUMMAND[449]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[449]) );
  smffa  dla533 (.D(SUMMAND[450]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[450]) );
  smfulladder dfa352 (.DATA_A (LATCHED_PP[448]), .DATA_B (LATCHED_PP[449]), .DATA_C (LATCHED_PP[450]), .SAVE (INT_SUM[482]), .CARRY (INT_CARRY[392]) );
  smffa  dla534 (.D(SUMMAND[451]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[451]) );
  smffa  dla535 (.D(SUMMAND[452]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[452]) );
  smffa  dla536 (.D(SUMMAND[453]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[453]) );
  smfulladder dfa353 (.DATA_A (LATCHED_PP[451]), .DATA_B (LATCHED_PP[452]), .DATA_C (LATCHED_PP[453]), .SAVE (INT_SUM[483]), .CARRY (INT_CARRY[393]) );
  smffa  dla537 (.D(SUMMAND[454]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[454]) );
  smffa  dla538 (.D(SUMMAND[455]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[455]) );
  smffa  dla539 (.D(SUMMAND[456]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[456]) );
  smfulladder dfa354 (.DATA_A (LATCHED_PP[454]), .DATA_B (LATCHED_PP[455]), .DATA_C (LATCHED_PP[456]), .SAVE (INT_SUM[484]), .CARRY (INT_CARRY[394]) );
  smffa  dla540 (.D(SUMMAND[457]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[457]) );
  smffa  dla541 (.D(SUMMAND[458]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[458]) );
  smffa  dla542 (.D(SUMMAND[459]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[459]) );
  smfulladder dfa355 (.DATA_A (LATCHED_PP[457]), .DATA_B (LATCHED_PP[458]), .DATA_C (LATCHED_PP[459]), .SAVE (INT_SUM[485]), .CARRY (INT_CARRY[395]) );
  smffa  dla543 (.D(SUMMAND[460]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[460]) );
  assign INT_SUM[486] = LATCHED_PP[460];
  smfulladder dfa356 (.DATA_A (INT_SUM[482]), .DATA_B (INT_SUM[483]), .DATA_C (INT_SUM[484]), .SAVE (INT_SUM[487]), .CARRY (INT_CARRY[396]) );
  smfulladder dfa357 (.DATA_A (INT_SUM[485]), .DATA_B (INT_SUM[486]), .DATA_C (INT_CARRY[378]), .SAVE (INT_SUM[488]), .CARRY (INT_CARRY[397]) );
  smfulladder dfa358 (.DATA_A (INT_CARRY[379]), .DATA_B (INT_CARRY[380]), .DATA_C (INT_CARRY[381]), .SAVE (INT_SUM[489]), .CARRY (INT_CARRY[398]) );
  assign INT_SUM[490] = INT_CARRY[382];
  smfulladder dfa359 (.DATA_A (INT_SUM[487]), .DATA_B (INT_SUM[488]), .DATA_C (INT_SUM[489]), .SAVE (INT_SUM[491]), .CARRY (INT_CARRY[399]) );
  smfulladder dfa360 (.DATA_A (INT_SUM[490]), .DATA_B (INT_CARRY[383]), .DATA_C (INT_CARRY[384]), .SAVE (INT_SUM[492]), .CARRY (INT_CARRY[400]) );
  assign INT_SUM[493] = INT_CARRY[385];
  smfulladder dfa361 (.DATA_A (INT_SUM[491]), .DATA_B (INT_SUM[492]), .DATA_C (INT_SUM[493]), .SAVE (INT_SUM[494]), .CARRY (INT_CARRY[401]) );
  smhalfadder dha39 (.DATA_A (INT_CARRY[386]), .DATA_B (INT_CARRY[387]), .SAVE (INT_SUM[495]), .CARRY (INT_CARRY[402]) );
  smfulladder dfa362 (.DATA_A (INT_SUM[494]), .DATA_B (INT_SUM[495]), .DATA_C (INT_CARRY[388]), .SAVE (INT_SUM[496]), .CARRY (INT_CARRY[403]) );
  assign INT_SUM[497] = INT_CARRY[389];
  smfulladder dfa363 (.DATA_A (INT_SUM[496]), .DATA_B (INT_SUM[497]), .DATA_C (INT_CARRY[390]), .SAVE (INT_SUM[498]), .CARRY (INT_CARRY[391]) );
  smffb  dla544 (.D(INT_SUM[498]), .clk(clk), .en_d2(en_d2), .Q(SUM[42]) );
  smffb  dla545 (.D(INT_CARRY[391]), .clk(clk), .en_d2(en_d2), .Q(CARRY[42]) );
  smffa  dla546 (.D(SUMMAND[461]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[461]) );
  smffa  dla547 (.D(SUMMAND[462]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[462]) );
  smffa  dla548 (.D(SUMMAND[463]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[463]) );
  smfulladder dfa364 (.DATA_A (LATCHED_PP[461]), .DATA_B (LATCHED_PP[462]), .DATA_C (LATCHED_PP[463]), .SAVE (INT_SUM[499]), .CARRY (INT_CARRY[405]) );
  smffa  dla549 (.D(SUMMAND[464]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[464]) );
  smffa  dla550 (.D(SUMMAND[465]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[465]) );
  smffa  dla551 (.D(SUMMAND[466]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[466]) );
  smfulladder dfa365 (.DATA_A (LATCHED_PP[464]), .DATA_B (LATCHED_PP[465]), .DATA_C (LATCHED_PP[466]), .SAVE (INT_SUM[500]), .CARRY (INT_CARRY[406]) );
  smffa  dla552 (.D(SUMMAND[467]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[467]) );
  smffa  dla553 (.D(SUMMAND[468]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[468]) );
  smffa  dla554 (.D(SUMMAND[469]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[469]) );
  smfulladder dfa366 (.DATA_A (LATCHED_PP[467]), .DATA_B (LATCHED_PP[468]), .DATA_C (LATCHED_PP[469]), .SAVE (INT_SUM[501]), .CARRY (INT_CARRY[407]) );
  smffa  dla555 (.D(SUMMAND[470]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[470]) );
  smffa  dla556 (.D(SUMMAND[471]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[471]) );
  smffa  dla557 (.D(SUMMAND[472]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[472]) );
  smfulladder dfa367 (.DATA_A (LATCHED_PP[470]), .DATA_B (LATCHED_PP[471]), .DATA_C (LATCHED_PP[472]), .SAVE (INT_SUM[502]), .CARRY (INT_CARRY[408]) );
  smffa  dla558 (.D(SUMMAND[473]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[473]) );
  smfulladder dfa368 (.DATA_A (LATCHED_PP[473]), .DATA_B (INT_CARRY[392]), .DATA_C (INT_CARRY[393]), .SAVE (INT_SUM[503]), .CARRY (INT_CARRY[409]) );
  assign INT_SUM[504] = INT_CARRY[394];
  assign INT_SUM[505] = INT_CARRY[395];
  smfulladder dfa369 (.DATA_A (INT_SUM[499]), .DATA_B (INT_SUM[500]), .DATA_C (INT_SUM[501]), .SAVE (INT_SUM[506]), .CARRY (INT_CARRY[410]) );
  smfulladder dfa370 (.DATA_A (INT_SUM[502]), .DATA_B (INT_SUM[503]), .DATA_C (INT_SUM[504]), .SAVE (INT_SUM[507]), .CARRY (INT_CARRY[411]) );
  smfulladder dfa371 (.DATA_A (INT_SUM[505]), .DATA_B (INT_CARRY[396]), .DATA_C (INT_CARRY[397]), .SAVE (INT_SUM[508]), .CARRY (INT_CARRY[412]) );
  assign INT_SUM[509] = INT_CARRY[398];
  smfulladder dfa372 (.DATA_A (INT_SUM[506]), .DATA_B (INT_SUM[507]), .DATA_C (INT_SUM[508]), .SAVE (INT_SUM[510]), .CARRY (INT_CARRY[413]) );
  smfulladder dfa373 (.DATA_A (INT_SUM[509]), .DATA_B (INT_CARRY[399]), .DATA_C (INT_CARRY[400]), .SAVE (INT_SUM[511]), .CARRY (INT_CARRY[414]) );
  smfulladder dfa374 (.DATA_A (INT_SUM[510]), .DATA_B (INT_SUM[511]), .DATA_C (INT_CARRY[401]), .SAVE (INT_SUM[512]), .CARRY (INT_CARRY[415]) );
  assign INT_SUM[513] = INT_CARRY[402];
  smfulladder dfa375 (.DATA_A (INT_SUM[512]), .DATA_B (INT_SUM[513]), .DATA_C (INT_CARRY[403]), .SAVE (INT_SUM[514]), .CARRY (INT_CARRY[404]) );
  smffb  dla559 (.D(INT_SUM[514]), .clk(clk), .en_d2(en_d2), .Q(SUM[43]) );
  smffb  dla560 (.D(INT_CARRY[404]), .clk(clk), .en_d2(en_d2), .Q(CARRY[43]) );
  smffa  dla561 (.D(SUMMAND[474]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[474]) );
  smffa  dla562 (.D(SUMMAND[475]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[475]) );
  smffa  dla563 (.D(SUMMAND[476]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[476]) );
  smfulladder dfa376 (.DATA_A (LATCHED_PP[474]), .DATA_B (LATCHED_PP[475]), .DATA_C (LATCHED_PP[476]), .SAVE (INT_SUM[515]), .CARRY (INT_CARRY[417]) );
  smffa  dla564 (.D(SUMMAND[477]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[477]) );
  smffa  dla565 (.D(SUMMAND[478]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[478]) );
  smffa  dla566 (.D(SUMMAND[479]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[479]) );
  smfulladder dfa377 (.DATA_A (LATCHED_PP[477]), .DATA_B (LATCHED_PP[478]), .DATA_C (LATCHED_PP[479]), .SAVE (INT_SUM[516]), .CARRY (INT_CARRY[418]) );
  smffa  dla567 (.D(SUMMAND[480]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[480]) );
  smffa  dla568 (.D(SUMMAND[481]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[481]) );
  smffa  dla569 (.D(SUMMAND[482]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[482]) );
  smfulladder dfa378 (.DATA_A (LATCHED_PP[480]), .DATA_B (LATCHED_PP[481]), .DATA_C (LATCHED_PP[482]), .SAVE (INT_SUM[517]), .CARRY (INT_CARRY[419]) );
  smffa  dla570 (.D(SUMMAND[483]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[483]) );
  smffa  dla571 (.D(SUMMAND[484]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[484]) );
  smffa  dla572 (.D(SUMMAND[485]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[485]) );
  smfulladder dfa379 (.DATA_A (LATCHED_PP[483]), .DATA_B (LATCHED_PP[484]), .DATA_C (LATCHED_PP[485]), .SAVE (INT_SUM[518]), .CARRY (INT_CARRY[420]) );
  smfulladder dfa380 (.DATA_A (INT_SUM[515]), .DATA_B (INT_SUM[516]), .DATA_C (INT_SUM[517]), .SAVE (INT_SUM[519]), .CARRY (INT_CARRY[421]) );
  smfulladder dfa381 (.DATA_A (INT_SUM[518]), .DATA_B (INT_CARRY[405]), .DATA_C (INT_CARRY[406]), .SAVE (INT_SUM[520]), .CARRY (INT_CARRY[422]) );
  smfulladder dfa382 (.DATA_A (INT_CARRY[407]), .DATA_B (INT_CARRY[408]), .DATA_C (INT_CARRY[409]), .SAVE (INT_SUM[521]), .CARRY (INT_CARRY[423]) );
  smfulladder dfa383 (.DATA_A (INT_SUM[519]), .DATA_B (INT_SUM[520]), .DATA_C (INT_SUM[521]), .SAVE (INT_SUM[522]), .CARRY (INT_CARRY[424]) );
  smfulladder dfa384 (.DATA_A (INT_CARRY[410]), .DATA_B (INT_CARRY[411]), .DATA_C (INT_CARRY[412]), .SAVE (INT_SUM[523]), .CARRY (INT_CARRY[425]) );
  smfulladder dfa385 (.DATA_A (INT_SUM[522]), .DATA_B (INT_SUM[523]), .DATA_C (INT_CARRY[413]), .SAVE (INT_SUM[524]), .CARRY (INT_CARRY[426]) );
  assign INT_SUM[525] = INT_CARRY[414];
  smfulladder dfa386 (.DATA_A (INT_SUM[524]), .DATA_B (INT_SUM[525]), .DATA_C (INT_CARRY[415]), .SAVE (INT_SUM[526]), .CARRY (INT_CARRY[416]) );
  smffb  dla573 (.D(INT_SUM[526]), .clk(clk), .en_d2(en_d2), .Q(SUM[44]) );
  smffb  dla574 (.D(INT_CARRY[416]), .clk(clk), .en_d2(en_d2), .Q(CARRY[44]) );
  smffa  dla575 (.D(SUMMAND[486]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[486]) );
  smffa  dla576 (.D(SUMMAND[487]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[487]) );
  smffa  dla577 (.D(SUMMAND[488]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[488]) );
  smfulladder dfa387 (.DATA_A (LATCHED_PP[486]), .DATA_B (LATCHED_PP[487]), .DATA_C (LATCHED_PP[488]), .SAVE (INT_SUM[527]), .CARRY (INT_CARRY[428]) );
  smffa  dla578 (.D(SUMMAND[489]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[489]) );
  smffa  dla579 (.D(SUMMAND[490]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[490]) );
  smffa  dla580 (.D(SUMMAND[491]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[491]) );
  smfulladder dfa388 (.DATA_A (LATCHED_PP[489]), .DATA_B (LATCHED_PP[490]), .DATA_C (LATCHED_PP[491]), .SAVE (INT_SUM[528]), .CARRY (INT_CARRY[429]) );
  smffa  dla581 (.D(SUMMAND[492]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[492]) );
  smffa  dla582 (.D(SUMMAND[493]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[493]) );
  smffa  dla583 (.D(SUMMAND[494]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[494]) );
  smfulladder dfa389 (.DATA_A (LATCHED_PP[492]), .DATA_B (LATCHED_PP[493]), .DATA_C (LATCHED_PP[494]), .SAVE (INT_SUM[529]), .CARRY (INT_CARRY[430]) );
  smffa  dla584 (.D(SUMMAND[495]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[495]) );
  smffa  dla585 (.D(SUMMAND[496]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[496]) );
  smffa  dla586 (.D(SUMMAND[497]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[497]) );
  smfulladder dfa390 (.DATA_A (LATCHED_PP[495]), .DATA_B (LATCHED_PP[496]), .DATA_C (LATCHED_PP[497]), .SAVE (INT_SUM[530]), .CARRY (INT_CARRY[431]) );
  smfulladder dfa391 (.DATA_A (INT_SUM[527]), .DATA_B (INT_SUM[528]), .DATA_C (INT_SUM[529]), .SAVE (INT_SUM[531]), .CARRY (INT_CARRY[432]) );
  smfulladder dfa392 (.DATA_A (INT_SUM[530]), .DATA_B (INT_CARRY[417]), .DATA_C (INT_CARRY[418]), .SAVE (INT_SUM[532]), .CARRY (INT_CARRY[433]) );
  smhalfadder dha40 (.DATA_A (INT_CARRY[419]), .DATA_B (INT_CARRY[420]), .SAVE (INT_SUM[533]), .CARRY (INT_CARRY[434]) );
  smfulladder dfa393 (.DATA_A (INT_SUM[531]), .DATA_B (INT_SUM[532]), .DATA_C (INT_SUM[533]), .SAVE (INT_SUM[534]), .CARRY (INT_CARRY[435]) );
  smfulladder dfa394 (.DATA_A (INT_CARRY[421]), .DATA_B (INT_CARRY[422]), .DATA_C (INT_CARRY[423]), .SAVE (INT_SUM[535]), .CARRY (INT_CARRY[436]) );
  smfulladder dfa395 (.DATA_A (INT_SUM[534]), .DATA_B (INT_SUM[535]), .DATA_C (INT_CARRY[424]), .SAVE (INT_SUM[536]), .CARRY (INT_CARRY[437]) );
  assign INT_SUM[537] = INT_CARRY[425];
  smfulladder dfa396 (.DATA_A (INT_SUM[536]), .DATA_B (INT_SUM[537]), .DATA_C (INT_CARRY[426]), .SAVE (INT_SUM[538]), .CARRY (INT_CARRY[427]) );
  smffb  dla587 (.D(INT_SUM[538]), .clk(clk), .en_d2(en_d2), .Q(SUM[45]) );
  smffb  dla588 (.D(INT_CARRY[427]), .clk(clk), .en_d2(en_d2), .Q(CARRY[45]) );
  smffa  dla589 (.D(SUMMAND[498]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[498]) );
  smffa  dla590 (.D(SUMMAND[499]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[499]) );
  smffa  dla591 (.D(SUMMAND[500]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[500]) );
  smfulladder dfa397 (.DATA_A (LATCHED_PP[498]), .DATA_B (LATCHED_PP[499]), .DATA_C (LATCHED_PP[500]), .SAVE (INT_SUM[539]), .CARRY (INT_CARRY[439]) );
  smffa  dla592 (.D(SUMMAND[501]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[501]) );
  smffa  dla593 (.D(SUMMAND[502]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[502]) );
  smffa  dla594 (.D(SUMMAND[503]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[503]) );
  smfulladder dfa398 (.DATA_A (LATCHED_PP[501]), .DATA_B (LATCHED_PP[502]), .DATA_C (LATCHED_PP[503]), .SAVE (INT_SUM[540]), .CARRY (INT_CARRY[440]) );
  smffa  dla595 (.D(SUMMAND[504]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[504]) );
  smffa  dla596 (.D(SUMMAND[505]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[505]) );
  smffa  dla597 (.D(SUMMAND[506]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[506]) );
  smfulladder dfa399 (.DATA_A (LATCHED_PP[504]), .DATA_B (LATCHED_PP[505]), .DATA_C (LATCHED_PP[506]), .SAVE (INT_SUM[541]), .CARRY (INT_CARRY[441]) );
  smffa  dla598 (.D(SUMMAND[507]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[507]) );
  assign INT_SUM[542] = LATCHED_PP[507];
  smffa  dla599 (.D(SUMMAND[508]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[508]) );
  assign INT_SUM[543] = LATCHED_PP[508];
  smfulladder dfa400 (.DATA_A (INT_SUM[539]), .DATA_B (INT_SUM[540]), .DATA_C (INT_SUM[541]), .SAVE (INT_SUM[544]), .CARRY (INT_CARRY[442]) );
  smfulladder dfa401 (.DATA_A (INT_SUM[542]), .DATA_B (INT_SUM[543]), .DATA_C (INT_CARRY[428]), .SAVE (INT_SUM[545]), .CARRY (INT_CARRY[443]) );
  smfulladder dfa402 (.DATA_A (INT_CARRY[429]), .DATA_B (INT_CARRY[430]), .DATA_C (INT_CARRY[431]), .SAVE (INT_SUM[546]), .CARRY (INT_CARRY[444]) );
  smfulladder dfa403 (.DATA_A (INT_SUM[544]), .DATA_B (INT_SUM[545]), .DATA_C (INT_SUM[546]), .SAVE (INT_SUM[547]), .CARRY (INT_CARRY[445]) );
  smfulladder dfa404 (.DATA_A (INT_CARRY[432]), .DATA_B (INT_CARRY[433]), .DATA_C (INT_CARRY[434]), .SAVE (INT_SUM[548]), .CARRY (INT_CARRY[446]) );
  smfulladder dfa405 (.DATA_A (INT_SUM[547]), .DATA_B (INT_SUM[548]), .DATA_C (INT_CARRY[435]), .SAVE (INT_SUM[549]), .CARRY (INT_CARRY[447]) );
  assign INT_SUM[550] = INT_CARRY[436];
  smfulladder dfa406 (.DATA_A (INT_SUM[549]), .DATA_B (INT_SUM[550]), .DATA_C (INT_CARRY[437]), .SAVE (INT_SUM[551]), .CARRY (INT_CARRY[438]) );
  smffb  dla600 (.D(INT_SUM[551]), .clk(clk), .en_d2(en_d2), .Q(SUM[46]) );
  smffb  dla601 (.D(INT_CARRY[438]), .clk(clk), .en_d2(en_d2), .Q(CARRY[46]) );
  smffa  dla602 (.D(SUMMAND[509]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[509]) );
  smffa  dla603 (.D(SUMMAND[510]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[510]) );
  smffa  dla604 (.D(SUMMAND[511]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[511]) );
  smfulladder dfa407 (.DATA_A (LATCHED_PP[509]), .DATA_B (LATCHED_PP[510]), .DATA_C (LATCHED_PP[511]), .SAVE (INT_SUM[552]), .CARRY (INT_CARRY[449]) );
  smffa  dla605 (.D(SUMMAND[512]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[512]) );
  smffa  dla606 (.D(SUMMAND[513]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[513]) );
  smffa  dla607 (.D(SUMMAND[514]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[514]) );
  smfulladder dfa408 (.DATA_A (LATCHED_PP[512]), .DATA_B (LATCHED_PP[513]), .DATA_C (LATCHED_PP[514]), .SAVE (INT_SUM[553]), .CARRY (INT_CARRY[450]) );
  smffa  dla608 (.D(SUMMAND[515]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[515]) );
  smffa  dla609 (.D(SUMMAND[516]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[516]) );
  smffa  dla610 (.D(SUMMAND[517]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[517]) );
  smfulladder dfa409 (.DATA_A (LATCHED_PP[515]), .DATA_B (LATCHED_PP[516]), .DATA_C (LATCHED_PP[517]), .SAVE (INT_SUM[554]), .CARRY (INT_CARRY[451]) );
  smffa  dla611 (.D(SUMMAND[518]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[518]) );
  smffa  dla612 (.D(SUMMAND[519]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[519]) );
  smhalfadder dha41 (.DATA_A (LATCHED_PP[518]), .DATA_B (LATCHED_PP[519]), .SAVE (INT_SUM[555]), .CARRY (INT_CARRY[452]) );
  smfulladder dfa410 (.DATA_A (INT_SUM[552]), .DATA_B (INT_SUM[553]), .DATA_C (INT_SUM[554]), .SAVE (INT_SUM[556]), .CARRY (INT_CARRY[453]) );
  smfulladder dfa411 (.DATA_A (INT_SUM[555]), .DATA_B (INT_CARRY[439]), .DATA_C (INT_CARRY[440]), .SAVE (INT_SUM[557]), .CARRY (INT_CARRY[454]) );
  assign INT_SUM[558] = INT_CARRY[441];
  smfulladder dfa412 (.DATA_A (INT_SUM[556]), .DATA_B (INT_SUM[557]), .DATA_C (INT_SUM[558]), .SAVE (INT_SUM[559]), .CARRY (INT_CARRY[455]) );
  smfulladder dfa413 (.DATA_A (INT_CARRY[442]), .DATA_B (INT_CARRY[443]), .DATA_C (INT_CARRY[444]), .SAVE (INT_SUM[560]), .CARRY (INT_CARRY[456]) );
  smfulladder dfa414 (.DATA_A (INT_SUM[559]), .DATA_B (INT_SUM[560]), .DATA_C (INT_CARRY[445]), .SAVE (INT_SUM[561]), .CARRY (INT_CARRY[457]) );
  assign INT_SUM[562] = INT_CARRY[446];
  smfulladder dfa415 (.DATA_A (INT_SUM[561]), .DATA_B (INT_SUM[562]), .DATA_C (INT_CARRY[447]), .SAVE (INT_SUM[563]), .CARRY (INT_CARRY[448]) );
  smffb  dla613 (.D(INT_SUM[563]), .clk(clk), .en_d2(en_d2), .Q(SUM[47]) );
  smffb  dla614 (.D(INT_CARRY[448]), .clk(clk), .en_d2(en_d2), .Q(CARRY[47]) );
  smffa  dla615 (.D(SUMMAND[520]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[520]) );
  smffa  dla616 (.D(SUMMAND[521]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[521]) );
  smffa  dla617 (.D(SUMMAND[522]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[522]) );
  smfulladder dfa416 (.DATA_A (LATCHED_PP[520]), .DATA_B (LATCHED_PP[521]), .DATA_C (LATCHED_PP[522]), .SAVE (INT_SUM[564]), .CARRY (INT_CARRY[459]) );
  smffa  dla618 (.D(SUMMAND[523]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[523]) );
  smffa  dla619 (.D(SUMMAND[524]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[524]) );
  smffa  dla620 (.D(SUMMAND[525]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[525]) );
  smfulladder dfa417 (.DATA_A (LATCHED_PP[523]), .DATA_B (LATCHED_PP[524]), .DATA_C (LATCHED_PP[525]), .SAVE (INT_SUM[565]), .CARRY (INT_CARRY[460]) );
  smffa  dla621 (.D(SUMMAND[526]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[526]) );
  smffa  dla622 (.D(SUMMAND[527]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[527]) );
  smffa  dla623 (.D(SUMMAND[528]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[528]) );
  smfulladder dfa418 (.DATA_A (LATCHED_PP[526]), .DATA_B (LATCHED_PP[527]), .DATA_C (LATCHED_PP[528]), .SAVE (INT_SUM[566]), .CARRY (INT_CARRY[461]) );
  smffa  dla624 (.D(SUMMAND[529]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[529]) );
  assign INT_SUM[567] = LATCHED_PP[529];
  smfulladder dfa419 (.DATA_A (INT_SUM[564]), .DATA_B (INT_SUM[565]), .DATA_C (INT_SUM[566]), .SAVE (INT_SUM[568]), .CARRY (INT_CARRY[462]) );
  smfulladder dfa420 (.DATA_A (INT_SUM[567]), .DATA_B (INT_CARRY[449]), .DATA_C (INT_CARRY[450]), .SAVE (INT_SUM[569]), .CARRY (INT_CARRY[463]) );
  assign INT_SUM[570] = INT_CARRY[451];
  assign INT_SUM[571] = INT_CARRY[452];
  smfulladder dfa421 (.DATA_A (INT_SUM[568]), .DATA_B (INT_SUM[569]), .DATA_C (INT_SUM[570]), .SAVE (INT_SUM[572]), .CARRY (INT_CARRY[464]) );
  smfulladder dfa422 (.DATA_A (INT_SUM[571]), .DATA_B (INT_CARRY[453]), .DATA_C (INT_CARRY[454]), .SAVE (INT_SUM[573]), .CARRY (INT_CARRY[465]) );
  smfulladder dfa423 (.DATA_A (INT_SUM[572]), .DATA_B (INT_SUM[573]), .DATA_C (INT_CARRY[455]), .SAVE (INT_SUM[574]), .CARRY (INT_CARRY[466]) );
  assign INT_SUM[575] = INT_CARRY[456];
  smfulladder dfa424 (.DATA_A (INT_SUM[574]), .DATA_B (INT_SUM[575]), .DATA_C (INT_CARRY[457]), .SAVE (INT_SUM[576]), .CARRY (INT_CARRY[458]) );
  smffb  dla625 (.D(INT_SUM[576]), .clk(clk), .en_d2(en_d2), .Q(SUM[48]) );
  smffb  dla626 (.D(INT_CARRY[458]), .clk(clk), .en_d2(en_d2), .Q(CARRY[48]) );
  smffa  dla627 (.D(SUMMAND[530]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[530]) );
  smffa  dla628 (.D(SUMMAND[531]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[531]) );
  smffa  dla629 (.D(SUMMAND[532]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[532]) );
  smfulladder dfa425 (.DATA_A (LATCHED_PP[530]), .DATA_B (LATCHED_PP[531]), .DATA_C (LATCHED_PP[532]), .SAVE (INT_SUM[577]), .CARRY (INT_CARRY[468]) );
  smffa  dla630 (.D(SUMMAND[533]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[533]) );
  smffa  dla631 (.D(SUMMAND[534]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[534]) );
  smffa  dla632 (.D(SUMMAND[535]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[535]) );
  smfulladder dfa426 (.DATA_A (LATCHED_PP[533]), .DATA_B (LATCHED_PP[534]), .DATA_C (LATCHED_PP[535]), .SAVE (INT_SUM[578]), .CARRY (INT_CARRY[469]) );
  smffa  dla633 (.D(SUMMAND[536]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[536]) );
  smffa  dla634 (.D(SUMMAND[537]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[537]) );
  smffa  dla635 (.D(SUMMAND[538]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[538]) );
  smfulladder dfa427 (.DATA_A (LATCHED_PP[536]), .DATA_B (LATCHED_PP[537]), .DATA_C (LATCHED_PP[538]), .SAVE (INT_SUM[579]), .CARRY (INT_CARRY[470]) );
  smffa  dla636 (.D(SUMMAND[539]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[539]) );
  assign INT_SUM[580] = LATCHED_PP[539];
  smfulladder dfa428 (.DATA_A (INT_SUM[577]), .DATA_B (INT_SUM[578]), .DATA_C (INT_SUM[579]), .SAVE (INT_SUM[581]), .CARRY (INT_CARRY[471]) );
  smfulladder dfa429 (.DATA_A (INT_SUM[580]), .DATA_B (INT_CARRY[459]), .DATA_C (INT_CARRY[460]), .SAVE (INT_SUM[582]), .CARRY (INT_CARRY[472]) );
  assign INT_SUM[583] = INT_CARRY[461];
  smfulladder dfa430 (.DATA_A (INT_SUM[581]), .DATA_B (INT_SUM[582]), .DATA_C (INT_SUM[583]), .SAVE (INT_SUM[584]), .CARRY (INT_CARRY[473]) );
  smhalfadder dha42 (.DATA_A (INT_CARRY[462]), .DATA_B (INT_CARRY[463]), .SAVE (INT_SUM[585]), .CARRY (INT_CARRY[474]) );
  smfulladder dfa431 (.DATA_A (INT_SUM[584]), .DATA_B (INT_SUM[585]), .DATA_C (INT_CARRY[464]), .SAVE (INT_SUM[586]), .CARRY (INT_CARRY[475]) );
  assign INT_SUM[587] = INT_CARRY[465];
  smfulladder dfa432 (.DATA_A (INT_SUM[586]), .DATA_B (INT_SUM[587]), .DATA_C (INT_CARRY[466]), .SAVE (INT_SUM[588]), .CARRY (INT_CARRY[467]) );
  smffb  dla637 (.D(INT_SUM[588]), .clk(clk), .en_d2(en_d2), .Q(SUM[49]) );
  smffb  dla638 (.D(INT_CARRY[467]), .clk(clk), .en_d2(en_d2), .Q(CARRY[49]) );
  smffa  dla639 (.D(SUMMAND[540]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[540]) );
  smffa  dla640 (.D(SUMMAND[541]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[541]) );
  smffa  dla641 (.D(SUMMAND[542]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[542]) );
  smfulladder dfa433 (.DATA_A (LATCHED_PP[540]), .DATA_B (LATCHED_PP[541]), .DATA_C (LATCHED_PP[542]), .SAVE (INT_SUM[589]), .CARRY (INT_CARRY[477]) );
  smffa  dla642 (.D(SUMMAND[543]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[543]) );
  smffa  dla643 (.D(SUMMAND[544]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[544]) );
  smffa  dla644 (.D(SUMMAND[545]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[545]) );
  smfulladder dfa434 (.DATA_A (LATCHED_PP[543]), .DATA_B (LATCHED_PP[544]), .DATA_C (LATCHED_PP[545]), .SAVE (INT_SUM[590]), .CARRY (INT_CARRY[478]) );
  smffa  dla645 (.D(SUMMAND[546]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[546]) );
  smffa  dla646 (.D(SUMMAND[547]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[547]) );
  smffa  dla647 (.D(SUMMAND[548]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[548]) );
  smfulladder dfa435 (.DATA_A (LATCHED_PP[546]), .DATA_B (LATCHED_PP[547]), .DATA_C (LATCHED_PP[548]), .SAVE (INT_SUM[591]), .CARRY (INT_CARRY[479]) );
  smfulladder dfa436 (.DATA_A (INT_SUM[589]), .DATA_B (INT_SUM[590]), .DATA_C (INT_SUM[591]), .SAVE (INT_SUM[592]), .CARRY (INT_CARRY[480]) );
  smfulladder dfa437 (.DATA_A (INT_CARRY[468]), .DATA_B (INT_CARRY[469]), .DATA_C (INT_CARRY[470]), .SAVE (INT_SUM[593]), .CARRY (INT_CARRY[481]) );
  smfulladder dfa438 (.DATA_A (INT_SUM[592]), .DATA_B (INT_SUM[593]), .DATA_C (INT_CARRY[471]), .SAVE (INT_SUM[594]), .CARRY (INT_CARRY[482]) );
  assign INT_SUM[595] = INT_CARRY[472];
  smfulladder dfa439 (.DATA_A (INT_SUM[594]), .DATA_B (INT_SUM[595]), .DATA_C (INT_CARRY[473]), .SAVE (INT_SUM[596]), .CARRY (INT_CARRY[483]) );
  assign INT_SUM[597] = INT_CARRY[474];
  smfulladder dfa440 (.DATA_A (INT_SUM[596]), .DATA_B (INT_SUM[597]), .DATA_C (INT_CARRY[475]), .SAVE (INT_SUM[598]), .CARRY (INT_CARRY[476]) );
  smffb  dla648 (.D(INT_SUM[598]), .clk(clk), .en_d2(en_d2), .Q(SUM[50]) );
  smffb  dla649 (.D(INT_CARRY[476]), .clk(clk), .en_d2(en_d2), .Q(CARRY[50]) );
  smffa  dla650 (.D(SUMMAND[549]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[549]) );
  smffa  dla651 (.D(SUMMAND[550]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[550]) );
  smffa  dla652 (.D(SUMMAND[551]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[551]) );
  smfulladder dfa441 (.DATA_A (LATCHED_PP[549]), .DATA_B (LATCHED_PP[550]), .DATA_C (LATCHED_PP[551]), .SAVE (INT_SUM[599]), .CARRY (INT_CARRY[485]) );
  smffa  dla653 (.D(SUMMAND[552]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[552]) );
  smffa  dla654 (.D(SUMMAND[553]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[553]) );
  smffa  dla655 (.D(SUMMAND[554]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[554]) );
  smfulladder dfa442 (.DATA_A (LATCHED_PP[552]), .DATA_B (LATCHED_PP[553]), .DATA_C (LATCHED_PP[554]), .SAVE (INT_SUM[600]), .CARRY (INT_CARRY[486]) );
  smffa  dla656 (.D(SUMMAND[555]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[555]) );
  smffa  dla657 (.D(SUMMAND[556]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[556]) );
  smffa  dla658 (.D(SUMMAND[557]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[557]) );
  smfulladder dfa443 (.DATA_A (LATCHED_PP[555]), .DATA_B (LATCHED_PP[556]), .DATA_C (LATCHED_PP[557]), .SAVE (INT_SUM[601]), .CARRY (INT_CARRY[487]) );
  smfulladder dfa444 (.DATA_A (INT_SUM[599]), .DATA_B (INT_SUM[600]), .DATA_C (INT_SUM[601]), .SAVE (INT_SUM[602]), .CARRY (INT_CARRY[488]) );
  smfulladder dfa445 (.DATA_A (INT_CARRY[477]), .DATA_B (INT_CARRY[478]), .DATA_C (INT_CARRY[479]), .SAVE (INT_SUM[603]), .CARRY (INT_CARRY[489]) );
  smfulladder dfa446 (.DATA_A (INT_SUM[602]), .DATA_B (INT_SUM[603]), .DATA_C (INT_CARRY[480]), .SAVE (INT_SUM[604]), .CARRY (INT_CARRY[490]) );
  assign INT_SUM[605] = INT_CARRY[481];
  smfulladder dfa447 (.DATA_A (INT_SUM[604]), .DATA_B (INT_SUM[605]), .DATA_C (INT_CARRY[482]), .SAVE (INT_SUM[606]), .CARRY (INT_CARRY[491]) );
  smhalfadder dha43 (.DATA_A (INT_SUM[606]), .DATA_B (INT_CARRY[483]), .SAVE (INT_SUM[607]), .CARRY (INT_CARRY[484]) );
  smffb  dla659 (.D(INT_SUM[607]), .clk(clk), .en_d2(en_d2), .Q(SUM[51]) );
  smffb  dla660 (.D(INT_CARRY[484]), .clk(clk), .en_d2(en_d2), .Q(CARRY[51]) );
  smffa  dla661 (.D(SUMMAND[558]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[558]) );
  smffa  dla662 (.D(SUMMAND[559]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[559]) );
  smffa  dla663 (.D(SUMMAND[560]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[560]) );
  smfulladder dfa448 (.DATA_A (LATCHED_PP[558]), .DATA_B (LATCHED_PP[559]), .DATA_C (LATCHED_PP[560]), .SAVE (INT_SUM[608]), .CARRY (INT_CARRY[493]) );
  smffa  dla664 (.D(SUMMAND[561]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[561]) );
  smffa  dla665 (.D(SUMMAND[562]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[562]) );
  smffa  dla666 (.D(SUMMAND[563]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[563]) );
  smfulladder dfa449 (.DATA_A (LATCHED_PP[561]), .DATA_B (LATCHED_PP[562]), .DATA_C (LATCHED_PP[563]), .SAVE (INT_SUM[609]), .CARRY (INT_CARRY[494]) );
  smffa  dla667 (.D(SUMMAND[564]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[564]) );
  smffa  dla668 (.D(SUMMAND[565]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[565]) );
  smfulladder dfa450 (.DATA_A (LATCHED_PP[564]), .DATA_B (LATCHED_PP[565]), .DATA_C (INT_CARRY[485]), .SAVE (INT_SUM[610]), .CARRY (INT_CARRY[495]) );
  smhalfadder dha44 (.DATA_A (INT_CARRY[486]), .DATA_B (INT_CARRY[487]), .SAVE (INT_SUM[611]), .CARRY (INT_CARRY[496]) );
  smfulladder dfa451 (.DATA_A (INT_SUM[608]), .DATA_B (INT_SUM[609]), .DATA_C (INT_SUM[610]), .SAVE (INT_SUM[612]), .CARRY (INT_CARRY[497]) );
  smfulladder dfa452 (.DATA_A (INT_SUM[611]), .DATA_B (INT_CARRY[488]), .DATA_C (INT_CARRY[489]), .SAVE (INT_SUM[613]), .CARRY (INT_CARRY[498]) );
  smfulladder dfa453 (.DATA_A (INT_SUM[612]), .DATA_B (INT_SUM[613]), .DATA_C (INT_CARRY[490]), .SAVE (INT_SUM[614]), .CARRY (INT_CARRY[499]) );
  smhalfadder dha45 (.DATA_A (INT_SUM[614]), .DATA_B (INT_CARRY[491]), .SAVE (INT_SUM[615]), .CARRY (INT_CARRY[492]) );
  smffb  dla669 (.D(INT_SUM[615]), .clk(clk), .en_d2(en_d2), .Q(SUM[52]) );
  smffb  dla670 (.D(INT_CARRY[492]), .clk(clk), .en_d2(en_d2), .Q(CARRY[52]) );
  smffa  dla671 (.D(SUMMAND[566]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[566]) );
  smffa  dla672 (.D(SUMMAND[567]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[567]) );
  smffa  dla673 (.D(SUMMAND[568]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[568]) );
  smfulladder dfa454 (.DATA_A (LATCHED_PP[566]), .DATA_B (LATCHED_PP[567]), .DATA_C (LATCHED_PP[568]), .SAVE (INT_SUM[616]), .CARRY (INT_CARRY[501]) );
  smffa  dla674 (.D(SUMMAND[569]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[569]) );
  smffa  dla675 (.D(SUMMAND[570]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[570]) );
  smffa  dla676 (.D(SUMMAND[571]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[571]) );
  smfulladder dfa455 (.DATA_A (LATCHED_PP[569]), .DATA_B (LATCHED_PP[570]), .DATA_C (LATCHED_PP[571]), .SAVE (INT_SUM[617]), .CARRY (INT_CARRY[502]) );
  smffa  dla677 (.D(SUMMAND[572]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[572]) );
  assign INT_SUM[618] = LATCHED_PP[572];
  smffa  dla678 (.D(SUMMAND[573]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[573]) );
  assign INT_SUM[619] = LATCHED_PP[573];
  smfulladder dfa456 (.DATA_A (INT_SUM[616]), .DATA_B (INT_SUM[617]), .DATA_C (INT_SUM[618]), .SAVE (INT_SUM[620]), .CARRY (INT_CARRY[503]) );
  assign INT_SUM[621] = INT_SUM[619];
  smfulladder dfa457 (.DATA_A (INT_SUM[620]), .DATA_B (INT_SUM[621]), .DATA_C (INT_CARRY[493]), .SAVE (INT_SUM[622]), .CARRY (INT_CARRY[504]) );
  smfulladder dfa458 (.DATA_A (INT_CARRY[494]), .DATA_B (INT_CARRY[495]), .DATA_C (INT_CARRY[496]), .SAVE (INT_SUM[623]), .CARRY (INT_CARRY[505]) );
  smfulladder dfa459 (.DATA_A (INT_SUM[622]), .DATA_B (INT_SUM[623]), .DATA_C (INT_CARRY[497]), .SAVE (INT_SUM[624]), .CARRY (INT_CARRY[506]) );
  assign INT_SUM[625] = INT_CARRY[498];
  smfulladder dfa460 (.DATA_A (INT_SUM[624]), .DATA_B (INT_SUM[625]), .DATA_C (INT_CARRY[499]), .SAVE (INT_SUM[626]), .CARRY (INT_CARRY[500]) );
  smffb  dla679 (.D(INT_SUM[626]), .clk(clk), .en_d2(en_d2), .Q(SUM[53]) );
  smffb  dla680 (.D(INT_CARRY[500]), .clk(clk), .en_d2(en_d2), .Q(CARRY[53]) );
  smffa  dla681 (.D(SUMMAND[574]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[574]) );
  smffa  dla682 (.D(SUMMAND[575]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[575]) );
  smffa dla683 (.D(SUMMAND[576]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[576]) );
  smfulladder dfa461 (.DATA_A (LATCHED_PP[574]), .DATA_B (LATCHED_PP[575]), .DATA_C (LATCHED_PP[576]), .SAVE (INT_SUM[627]), .CARRY (INT_CARRY[508]) );
  smffa  dla684 (.D(SUMMAND[577]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[577]) );
  smffa  dla685 (.D(SUMMAND[578]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[578]) );
  smffa  dla686 (.D(SUMMAND[579]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[579]) );
  smfulladder dfa462 (.DATA_A (LATCHED_PP[577]), .DATA_B (LATCHED_PP[578]), .DATA_C (LATCHED_PP[579]), .SAVE (INT_SUM[628]), .CARRY (INT_CARRY[509]) );
  smffa  dla687 (.D(SUMMAND[580]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[580]) );
  smfulladder dfa463 (.DATA_A (LATCHED_PP[580]), .DATA_B (INT_CARRY[501]), .DATA_C (INT_CARRY[502]), .SAVE (INT_SUM[629]), .CARRY (INT_CARRY[510]) );
  smfulladder dfa464 (.DATA_A (INT_SUM[627]), .DATA_B (INT_SUM[628]), .DATA_C (INT_SUM[629]), .SAVE (INT_SUM[630]), .CARRY (INT_CARRY[511]) );
  assign INT_SUM[631] = INT_CARRY[503];
  smfulladder dfa465 (.DATA_A (INT_SUM[630]), .DATA_B (INT_SUM[631]), .DATA_C (INT_CARRY[504]), .SAVE (INT_SUM[632]), .CARRY (INT_CARRY[512]) );
  assign INT_SUM[633] = INT_CARRY[505];
  smfulladder dfa466 (.DATA_A (INT_SUM[632]), .DATA_B (INT_SUM[633]), .DATA_C (INT_CARRY[506]), .SAVE (INT_SUM[634]), .CARRY (INT_CARRY[507]) );
  smffb  dla688 (.D(INT_SUM[634]), .clk(clk), .en_d2(en_d2), .Q(SUM[54]) );
  smffb  dla689 (.D(INT_CARRY[507]), .clk(clk), .en_d2(en_d2), .Q(CARRY[54]) );
  smffa  dla690 (.D(SUMMAND[581]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[581]) );
  smffa  dla691 (.D(SUMMAND[582]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[582]) );
  smffa  dla692 (.D(SUMMAND[583]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[583]) );
  smfulladder dfa467 (.DATA_A (LATCHED_PP[581]), .DATA_B (LATCHED_PP[582]), .DATA_C (LATCHED_PP[583]), .SAVE (INT_SUM[635]), .CARRY (INT_CARRY[514]) );
  smffa  dla693 (.D(SUMMAND[584]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[584]) );
  smffa  dla694 (.D(SUMMAND[585]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[585]) );
  smffa  dla695 (.D(SUMMAND[586]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[586]) );
  smfulladder dfa468 (.DATA_A (LATCHED_PP[584]), .DATA_B (LATCHED_PP[585]), .DATA_C (LATCHED_PP[586]), .SAVE (INT_SUM[636]), .CARRY (INT_CARRY[515]) );
  smffa  dla696 (.D(SUMMAND[587]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[587]) );
  assign INT_SUM[637] = LATCHED_PP[587];
  smfulladder dfa469 (.DATA_A (INT_SUM[635]), .DATA_B (INT_SUM[636]), .DATA_C (INT_SUM[637]), .SAVE (INT_SUM[638]), .CARRY (INT_CARRY[516]) );
  smfulladder dfa470 (.DATA_A (INT_CARRY[508]), .DATA_B (INT_CARRY[509]), .DATA_C (INT_CARRY[510]), .SAVE (INT_SUM[639]), .CARRY (INT_CARRY[517]) );
  smfulladder dfa471 (.DATA_A (INT_SUM[638]), .DATA_B (INT_SUM[639]), .DATA_C (INT_CARRY[511]), .SAVE (INT_SUM[640]), .CARRY (INT_CARRY[518]) );
  smhalfadder dha46 (.DATA_A (INT_SUM[640]), .DATA_B (INT_CARRY[512]), .SAVE (INT_SUM[641]), .CARRY (INT_CARRY[513]) );
  smffb  dla697 (.D(INT_SUM[641]), .clk(clk), .en_d2(en_d2), .Q(SUM[55]) );
  smffb  dla698 (.D(INT_CARRY[513]), .clk(clk), .en_d2(en_d2), .Q(CARRY[55]) );
  smffa  dla699 (.D(SUMMAND[588]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[588]) );
  smffa  dla700 (.D(SUMMAND[589]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[589]) );
  smffa  dla701 (.D(SUMMAND[590]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[590]) );
  smfulladder dfa472 (.DATA_A (LATCHED_PP[588]), .DATA_B (LATCHED_PP[589]), .DATA_C (LATCHED_PP[590]), .SAVE (INT_SUM[642]), .CARRY (INT_CARRY[520]) );
  smffa  dla702 (.D(SUMMAND[591]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[591]) );
  smffa  dla703 (.D(SUMMAND[592]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[592]) );
  smffa  dla704 (.D(SUMMAND[593]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[593]) );
  smfulladder dfa473 (.DATA_A (LATCHED_PP[591]), .DATA_B (LATCHED_PP[592]), .DATA_C (LATCHED_PP[593]), .SAVE (INT_SUM[643]), .CARRY (INT_CARRY[521]) );
  smfulladder dfa474 (.DATA_A (INT_SUM[642]), .DATA_B (INT_SUM[643]), .DATA_C (INT_CARRY[514]), .SAVE (INT_SUM[644]), .CARRY (INT_CARRY[522]) );
  assign INT_SUM[645] = INT_CARRY[515];
  smfulladder dfa475 (.DATA_A (INT_SUM[644]), .DATA_B (INT_SUM[645]), .DATA_C (INT_CARRY[516]), .SAVE (INT_SUM[646]), .CARRY (INT_CARRY[523]) );
  assign INT_SUM[647] = INT_CARRY[517];
  smfulladder dfa476 (.DATA_A (INT_SUM[646]), .DATA_B (INT_SUM[647]), .DATA_C (INT_CARRY[518]), .SAVE (INT_SUM[648]), .CARRY (INT_CARRY[519]) );
  smffb  dla705 (.D(INT_SUM[648]), .clk(clk), .en_d2(en_d2), .Q(SUM[56]) );
  smffb  dla706 (.D(INT_CARRY[519]), .clk(clk), .en_d2(en_d2), .Q(CARRY[56]) );
  smffa  dla707 (.D(SUMMAND[594]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[594]) );
  smffa  dla708 (.D(SUMMAND[595]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[595]) );
  smffa  dla709 (.D(SUMMAND[596]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[596]) );
  smfulladder dfa477 (.DATA_A (LATCHED_PP[594]), .DATA_B (LATCHED_PP[595]), .DATA_C (LATCHED_PP[596]), .SAVE (INT_SUM[649]), .CARRY (INT_CARRY[525]) );
  smffa  dla710 (.D(SUMMAND[597]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[597]) );
  smffa  dla711 (.D(SUMMAND[598]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[598]) );
  smffa  dla712 (.D(SUMMAND[599]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[599]) );
  smfulladder dfa478 (.DATA_A (LATCHED_PP[597]), .DATA_B (LATCHED_PP[598]), .DATA_C (LATCHED_PP[599]), .SAVE (INT_SUM[650]), .CARRY (INT_CARRY[526]) );
  smfulladder dfa479 (.DATA_A (INT_SUM[649]), .DATA_B (INT_SUM[650]), .DATA_C (INT_CARRY[520]), .SAVE (INT_SUM[651]), .CARRY (INT_CARRY[527]) );
  assign INT_SUM[652] = INT_CARRY[521];
  smfulladder dfa480 (.DATA_A (INT_SUM[651]), .DATA_B (INT_SUM[652]), .DATA_C (INT_CARRY[522]), .SAVE (INT_SUM[653]), .CARRY (INT_CARRY[528]) );
  smhalfadder dha47 (.DATA_A (INT_SUM[653]), .DATA_B (INT_CARRY[523]), .SAVE (INT_SUM[654]), .CARRY (INT_CARRY[524]) );
  smffb  dla713 (.D(INT_SUM[654]), .clk(clk), .en_d2(en_d2), .Q(SUM[57]) );
  smffb  dla714 (.D(INT_CARRY[524]), .clk(clk), .en_d2(en_d2), .Q(CARRY[57]) );
  smffa  dla715 (.D(SUMMAND[600]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[600]) );
  smffa  dla716 (.D(SUMMAND[601]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[601]) );
  smffa  dla717 (.D(SUMMAND[602]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[602]) );
  smfulladder dfa481 (.DATA_A (LATCHED_PP[600]), .DATA_B (LATCHED_PP[601]), .DATA_C (LATCHED_PP[602]), .SAVE (INT_SUM[655]), .CARRY (INT_CARRY[530]) );
  smffa  dla718 (.D(SUMMAND[603]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[603]) );
  smffa  dla719 (.D(SUMMAND[604]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[604]) );
  smhalfadder dha48 (.DATA_A (LATCHED_PP[603]), .DATA_B (LATCHED_PP[604]), .SAVE (INT_SUM[656]), .CARRY (INT_CARRY[531]) );
  smfulladder dfa482 (.DATA_A (INT_SUM[655]), .DATA_B (INT_SUM[656]), .DATA_C (INT_CARRY[525]), .SAVE (INT_SUM[657]), .CARRY (INT_CARRY[532]) );
  assign INT_SUM[658] = INT_CARRY[526];
  smfulladder dfa483 (.DATA_A (INT_SUM[657]), .DATA_B (INT_SUM[658]), .DATA_C (INT_CARRY[527]), .SAVE (INT_SUM[659]), .CARRY (INT_CARRY[533]) );
  smhalfadder dha49 (.DATA_A (INT_SUM[659]), .DATA_B (INT_CARRY[528]), .SAVE (INT_SUM[660]), .CARRY (INT_CARRY[529]) );
  smffb  dla720 (.D(INT_SUM[660]), .clk(clk), .en_d2(en_d2), .Q(SUM[58]) );
  smffb  dla721 (.D(INT_CARRY[529]), .clk(clk), .en_d2(en_d2), .Q(CARRY[58]) );
  smffa  dla722 (.D(SUMMAND[605]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[605]) );
  smffa  dla723 (.D(SUMMAND[606]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[606]) );
  smffa  dla724 (.D(SUMMAND[607]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[607]) );
  smfulladder dfa484 (.DATA_A (LATCHED_PP[605]), .DATA_B (LATCHED_PP[606]), .DATA_C (LATCHED_PP[607]), .SAVE (INT_SUM[661]), .CARRY (INT_CARRY[535]) );
  smffa  dla725 (.D(SUMMAND[608]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[608]) );
  smffa  dla726 (.D(SUMMAND[609]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[609]) );
  smhalfadder dha50 (.DATA_A (LATCHED_PP[608]), .DATA_B (LATCHED_PP[609]), .SAVE (INT_SUM[662]), .CARRY (INT_CARRY[536]) );
  smfulladder dfa485 (.DATA_A (INT_SUM[661]), .DATA_B (INT_SUM[662]), .DATA_C (INT_CARRY[530]), .SAVE (INT_SUM[663]), .CARRY (INT_CARRY[537]) );
  assign INT_SUM[664] = INT_CARRY[531];
  smfulladder dfa486 (.DATA_A (INT_SUM[663]), .DATA_B (INT_SUM[664]), .DATA_C (INT_CARRY[532]), .SAVE (INT_SUM[665]), .CARRY (INT_CARRY[538]) );
  smhalfadder dha51 (.DATA_A (INT_SUM[665]), .DATA_B (INT_CARRY[533]), .SAVE (INT_SUM[666]), .CARRY (INT_CARRY[534]) );
  smffb  dla727 (.D(INT_SUM[666]), .clk(clk), .en_d2(en_d2), .Q(SUM[59]) );
  smffb  dla728 (.D(INT_CARRY[534]), .clk(clk), .en_d2(en_d2), .Q(CARRY[59]) );
  smffa  dla729 (.D(SUMMAND[610]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[610]) );
  smffa  dla730 (.D(SUMMAND[611]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[611]) );
  smffa  dla731 (.D(SUMMAND[612]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[612]) );
  smfulladder dfa487 (.DATA_A (LATCHED_PP[610]), .DATA_B (LATCHED_PP[611]), .DATA_C (LATCHED_PP[612]), .SAVE (INT_SUM[667]), .CARRY (INT_CARRY[540]) );
  smffa  dla732 (.D(SUMMAND[613]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[613]) );
  smfulladder dfa488 (.DATA_A (LATCHED_PP[613]), .DATA_B (INT_CARRY[535]), .DATA_C (INT_CARRY[536]), .SAVE (INT_SUM[668]), .CARRY (INT_CARRY[541]) );
  smfulladder dfa489 (.DATA_A (INT_SUM[667]), .DATA_B (INT_SUM[668]), .DATA_C (INT_CARRY[537]), .SAVE (INT_SUM[669]), .CARRY (INT_CARRY[542]) );
  smhalfadder dha52 (.DATA_A (INT_SUM[669]), .DATA_B (INT_CARRY[538]), .SAVE (INT_SUM[670]), .CARRY (INT_CARRY[539]) );
  smffb  dla733 (.D(INT_SUM[670]), .clk(clk), .en_d2(en_d2), .Q(SUM[60]) );
  smffb  dla734 (.D(INT_CARRY[539]), .clk(clk), .en_d2(en_d2), .Q(CARRY[60]) );
  smffa  dla735 (.D(SUMMAND[614]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[614]) );
  smffa  dla736 (.D(SUMMAND[615]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[615]) );
  smffa  dla737 (.D(SUMMAND[616]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[616]) );
  smfulladder dfa490 (.DATA_A (LATCHED_PP[614]), .DATA_B (LATCHED_PP[615]), .DATA_C (LATCHED_PP[616]), .SAVE (INT_SUM[671]), .CARRY (INT_CARRY[544]) );
  smffa  dla738 (.D(SUMMAND[617]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[617]) );
  assign INT_SUM[672] = LATCHED_PP[617];
  smfulladder dfa491 (.DATA_A (INT_SUM[671]), .DATA_B (INT_SUM[672]), .DATA_C (INT_CARRY[540]), .SAVE (INT_SUM[673]), .CARRY (INT_CARRY[545]) );
  assign INT_SUM[674] = INT_CARRY[541];
  smfulladder dfa492 (.DATA_A (INT_SUM[673]), .DATA_B (INT_SUM[674]), .DATA_C (INT_CARRY[542]), .SAVE (INT_SUM[675]), .CARRY (INT_CARRY[543]) );
  smffb  dla739 (.D(INT_SUM[675]), .clk(clk), .en_d2(en_d2), .Q(SUM[61]) );
  smffb  dla740 (.D(INT_CARRY[543]), .clk(clk), .en_d2(en_d2), .Q(CARRY[61]) );
  smffa  dla741 (.D(SUMMAND[618]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[618]) );
  smffa  dla742 (.D(SUMMAND[619]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[619]) );
  smffa  dla743 (.D(SUMMAND[620]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[620]) );
  smfulladder dfa493 (.DATA_A (LATCHED_PP[618]), .DATA_B (LATCHED_PP[619]), .DATA_C (LATCHED_PP[620]), .SAVE (INT_SUM[676]), .CARRY (INT_CARRY[547]) );
  assign INT_SUM[677] = INT_SUM[676];
  assign INT_SUM[678] = INT_CARRY[544];
  smfulladder dfa494 (.DATA_A (INT_SUM[677]), .DATA_B (INT_SUM[678]), .DATA_C (INT_CARRY[545]), .SAVE (INT_SUM[679]), .CARRY (INT_CARRY[546]) );
  smffb  dla744 (.D(INT_SUM[679]), .clk(clk), .en_d2(en_d2), .Q(SUM[62]) );
  smffb  dla745 (.D(INT_CARRY[546]), .clk(clk), .en_d2(en_d2), .Q(CARRY[62]) );
  smffa  dla746 (.D(SUMMAND[621]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[621]) );
  smffa  dla747 (.D(SUMMAND[622]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[622]) );
  smffa  dla748 (.D(SUMMAND[623]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[623]) );
  smfulladder dfa495 (.DATA_A (LATCHED_PP[621]), .DATA_B (LATCHED_PP[622]), .DATA_C (LATCHED_PP[623]), .SAVE (INT_SUM[680]), .CARRY (INT_CARRY[549]) );
  assign INT_SUM[681] = INT_CARRY[547];
  smhalfadder dha53 (.DATA_A (INT_SUM[680]), .DATA_B (INT_SUM[681]), .SAVE (INT_SUM[682]), .CARRY (INT_CARRY[548]) );
  smffb  dla749 (.D(INT_SUM[682]), .clk(clk), .en_d2(en_d2), .Q(SUM[63]) );
  smffb  dla750 (.D(INT_CARRY[548]), .clk(clk), .en_d2(en_d2), .Q(CARRY[63]) );
  smffa  dla751 (.D(SUMMAND[624]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[624]) );
  assign INT_SUM[683] = LATCHED_PP[624];
  smffa  dla752 (.D(SUMMAND[625]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[625]) );
  assign INT_SUM[684] = LATCHED_PP[625];
  smfulladder dfa496 (.DATA_A (INT_SUM[683]), .DATA_B (INT_SUM[684]), .DATA_C (INT_CARRY[549]), .SAVE (INT_SUM[685]), .CARRY (INT_CARRY[550]) );
  smffb  dla753 (.D(INT_SUM[685]), .clk(clk), .en_d2(en_d2), .Q(SUM[64]) );
  smffb  dla754 (.D(INT_CARRY[550]), .clk(clk), .en_d2(en_d2), .Q(CARRY[64]) );
  smffa  dla755 (.D(SUMMAND[626]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[626]) );
  smffa  dla756 (.D(SUMMAND[627]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[627]) );
  smhalfadder dha54 (.DATA_A (LATCHED_PP[626]), .DATA_B (LATCHED_PP[627]), .SAVE (INT_SUM[686]), .CARRY (INT_CARRY[551]) );
  smffb  dla757 (.D(INT_SUM[686]), .clk(clk), .en_d2(en_d2), .Q(SUM[65]) );
  smffb  dla758 (.D(INT_CARRY[551]), .clk(clk), .en_d2(en_d2), .Q(CARRY[65]) );
  smffa  dla759 (.D(SUMMAND[628]), .clk(clk), .en_d1(en_d1), .Q(LATCHED_PP[628]) );
  assign INT_SUM[687] = LATCHED_PP[628];
  smffb  dla760 (.D(INT_SUM[687]), .clk(clk), .en_d2(en_d2), .Q(SUM[66]) );
endmodule

module smprestage_128 (A, B, CIN, POUT, GOUT);
  input  [63:0] A;
  input  [63:0] B;
  input  CIN;
  output [63:0] POUT;
  output [63:0] GOUT;
  smblock0 d10 (A[0], B[0], POUT[0], GOUT[1] );
  smblock0 d11 (A[1], B[1], POUT[1], GOUT[2] );
  smblock0 d12 (A[2], B[2], POUT[2], GOUT[3] );
  smblock0 d13 (A[3], B[3], POUT[3], GOUT[4] );
  smblock0 d14 (A[4], B[4], POUT[4], GOUT[5] );
  smblock0 d15 (A[5], B[5], POUT[5], GOUT[6] );
  smblock0 d16 (A[6], B[6], POUT[6], GOUT[7] );
  smblock0 d17 (A[7], B[7], POUT[7], GOUT[8] );
  smblock0 d18 (A[8], B[8], POUT[8], GOUT[9] );
  smblock0 d19 (A[9], B[9], POUT[9], GOUT[10] );
  smblock0 d110 (A[10], B[10], POUT[10], GOUT[11] );
  smblock0 d111 (A[11], B[11], POUT[11], GOUT[12] );
  smblock0 d112 (A[12], B[12], POUT[12], GOUT[13] );
  smblock0 d113 (A[13], B[13], POUT[13], GOUT[14] );
  smblock0 d114 (A[14], B[14], POUT[14], GOUT[15] );
  smblock0 d115 (A[15], B[15], POUT[15], GOUT[16] );
  smblock0 d116 (A[16], B[16], POUT[16], GOUT[17] );
  smblock0 d117 (A[17], B[17], POUT[17], GOUT[18] );
  smblock0 d118 (A[18], B[18], POUT[18], GOUT[19] );
  smblock0 d119 (A[19], B[19], POUT[19], GOUT[20] );
  smblock0 d120 (A[20], B[20], POUT[20], GOUT[21] );
  smblock0 d121 (A[21], B[21], POUT[21], GOUT[22] );
  smblock0 d122 (A[22], B[22], POUT[22], GOUT[23] );
  smblock0 d123 (A[23], B[23], POUT[23], GOUT[24] );
  smblock0 d124 (A[24], B[24], POUT[24], GOUT[25] );
  smblock0 d125 (A[25], B[25], POUT[25], GOUT[26] );
  smblock0 d126 (A[26], B[26], POUT[26], GOUT[27] );
  smblock0 d127 (A[27], B[27], POUT[27], GOUT[28] );
  smblock0 d128 (A[28], B[28], POUT[28], GOUT[29] );
  smblock0 d129 (A[29], B[29], POUT[29], GOUT[30] );
  smblock0 d130 (A[30], B[30], POUT[30], GOUT[31] );
  smblock0 d131 (A[31], B[31], POUT[31], GOUT[32] );
  smblock0 d132 (A[32], B[32], POUT[32], GOUT[33] );
  smblock0 d133 (A[33], B[33], POUT[33], GOUT[34] );
  smblock0 d134 (A[34], B[34], POUT[34], GOUT[35] );
  smblock0 d135 (A[35], B[35], POUT[35], GOUT[36] );
  smblock0 d136 (A[36], B[36], POUT[36], GOUT[37] );
  smblock0 d137 (A[37], B[37], POUT[37], GOUT[38] );
  smblock0 d138 (A[38], B[38], POUT[38], GOUT[39] );
  smblock0 d139 (A[39], B[39], POUT[39], GOUT[40] );
  smblock0 d140 (A[40], B[40], POUT[40], GOUT[41] );
  smblock0 d141 (A[41], B[41], POUT[41], GOUT[42] );
  smblock0 d142 (A[42], B[42], POUT[42], GOUT[43] );
  smblock0 d143 (A[43], B[43], POUT[43], GOUT[44] );
  smblock0 d144 (A[44], B[44], POUT[44], GOUT[45] );
  smblock0 d145 (A[45], B[45], POUT[45], GOUT[46] );
  smblock0 d146 (A[46], B[46], POUT[46], GOUT[47] );
  smblock0 d147 (A[47], B[47], POUT[47], GOUT[48] );
  smblock0 d148 (A[48], B[48], POUT[48], GOUT[49] );
  smblock0 d149 (A[49], B[49], POUT[49], GOUT[50] );
  smblock0 d150 (A[50], B[50], POUT[50], GOUT[51] );
  smblock0 d151 (A[51], B[51], POUT[51], GOUT[52] );
  smblock0 d152 (A[52], B[52], POUT[52], GOUT[53] );
  smblock0 d153 (A[53], B[53], POUT[53], GOUT[54] );
  smblock0 d154 (A[54], B[54], POUT[54], GOUT[55] );
  smblock0 d155 (A[55], B[55], POUT[55], GOUT[56] );
  smblock0 d156 (A[56], B[56], POUT[56], GOUT[57] );
  smblock0 d157 (A[57], B[57], POUT[57], GOUT[58] );
  smblock0 d158 (A[58], B[58], POUT[58], GOUT[59] );
  smblock0 d159 (A[59], B[59], POUT[59], GOUT[60] );
  smblock0 d160 (A[60], B[60], POUT[60], GOUT[61] );
  smblock0 d161 (A[61], B[61], POUT[61], GOUT[62] );
  smblock0 d162 (A[62], B[62], POUT[62], GOUT[63] );
  sminvblock d2 (CIN, GOUT[0] );
endmodule

module smdblc_0_128 (PIN, GIN, POUT, GOUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [63:0] POUT;
  output [63:0] GOUT;
  sminvblock d10 (GIN[0], GOUT[0] );
  smblock1a d21 (PIN[0], GIN[0], GIN[1], GOUT[1] );
  smblock1 d32 (PIN[0], PIN[1], GIN[1], GIN[2], POUT[0], GOUT[2] );
  smblock1 d33 (PIN[1], PIN[2], GIN[2], GIN[3], POUT[1], GOUT[3] );
  smblock1 d34 (PIN[2], PIN[3], GIN[3], GIN[4], POUT[2], GOUT[4] );
  smblock1 d35 (PIN[3], PIN[4], GIN[4], GIN[5], POUT[3], GOUT[5] );
  smblock1 d36 (PIN[4], PIN[5], GIN[5], GIN[6], POUT[4], GOUT[6] );
  smblock1 d37 (PIN[5], PIN[6], GIN[6], GIN[7], POUT[5], GOUT[7] );
  smblock1 d38 (PIN[6], PIN[7], GIN[7], GIN[8], POUT[6], GOUT[8] );
  smblock1 d39 (PIN[7], PIN[8], GIN[8], GIN[9], POUT[7], GOUT[9] );
  smblock1 d310 (PIN[8], PIN[9], GIN[9], GIN[10], POUT[8], GOUT[10] );
  smblock1 d311 (PIN[9], PIN[10], GIN[10], GIN[11], POUT[9], GOUT[11] );
  smblock1 d312 (PIN[10], PIN[11], GIN[11], GIN[12], POUT[10], GOUT[12] );
  smblock1 d313 (PIN[11], PIN[12], GIN[12], GIN[13], POUT[11], GOUT[13] );
  smblock1 d314 (PIN[12], PIN[13], GIN[13], GIN[14], POUT[12], GOUT[14] );
  smblock1 d315 (PIN[13], PIN[14], GIN[14], GIN[15], POUT[13], GOUT[15] );
  smblock1 d316 (PIN[14], PIN[15], GIN[15], GIN[16], POUT[14], GOUT[16] );
  smblock1 d317 (PIN[15], PIN[16], GIN[16], GIN[17], POUT[15], GOUT[17] );
  smblock1 d318 (PIN[16], PIN[17], GIN[17], GIN[18], POUT[16], GOUT[18] );
  smblock1 d319 (PIN[17], PIN[18], GIN[18], GIN[19], POUT[17], GOUT[19] );
  smblock1 d320 (PIN[18], PIN[19], GIN[19], GIN[20], POUT[18], GOUT[20] );
  smblock1 d321 (PIN[19], PIN[20], GIN[20], GIN[21], POUT[19], GOUT[21] );
  smblock1 d322 (PIN[20], PIN[21], GIN[21], GIN[22], POUT[20], GOUT[22] );
  smblock1 d323 (PIN[21], PIN[22], GIN[22], GIN[23], POUT[21], GOUT[23] );
  smblock1 d324 (PIN[22], PIN[23], GIN[23], GIN[24], POUT[22], GOUT[24] );
  smblock1 d325 (PIN[23], PIN[24], GIN[24], GIN[25], POUT[23], GOUT[25] );
  smblock1 d326 (PIN[24], PIN[25], GIN[25], GIN[26], POUT[24], GOUT[26] );
  smblock1 d327 (PIN[25], PIN[26], GIN[26], GIN[27], POUT[25], GOUT[27] );
  smblock1 d328 (PIN[26], PIN[27], GIN[27], GIN[28], POUT[26], GOUT[28] );
  smblock1 d329 (PIN[27], PIN[28], GIN[28], GIN[29], POUT[27], GOUT[29] );
  smblock1 d330 (PIN[28], PIN[29], GIN[29], GIN[30], POUT[28], GOUT[30] );
  smblock1 d331 (PIN[29], PIN[30], GIN[30], GIN[31], POUT[29], GOUT[31] );
  smblock1 d332 (PIN[30], PIN[31], GIN[31], GIN[32], POUT[30], GOUT[32] );
  smblock1 d333 (PIN[31], PIN[32], GIN[32], GIN[33], POUT[31], GOUT[33] );
  smblock1 d334 (PIN[32], PIN[33], GIN[33], GIN[34], POUT[32], GOUT[34] );
  smblock1 d335 (PIN[33], PIN[34], GIN[34], GIN[35], POUT[33], GOUT[35] );
  smblock1 d336 (PIN[34], PIN[35], GIN[35], GIN[36], POUT[34], GOUT[36] );
  smblock1 d337 (PIN[35], PIN[36], GIN[36], GIN[37], POUT[35], GOUT[37] );
  smblock1 d338 (PIN[36], PIN[37], GIN[37], GIN[38], POUT[36], GOUT[38] );
  smblock1 d339 (PIN[37], PIN[38], GIN[38], GIN[39], POUT[37], GOUT[39] );
  smblock1 d340 (PIN[38], PIN[39], GIN[39], GIN[40], POUT[38], GOUT[40] );
  smblock1 d341 (PIN[39], PIN[40], GIN[40], GIN[41], POUT[39], GOUT[41] );
  smblock1 d342 (PIN[40], PIN[41], GIN[41], GIN[42], POUT[40], GOUT[42] );
  smblock1 d343 (PIN[41], PIN[42], GIN[42], GIN[43], POUT[41], GOUT[43] );
  smblock1 d344 (PIN[42], PIN[43], GIN[43], GIN[44], POUT[42], GOUT[44] );
  smblock1 d345 (PIN[43], PIN[44], GIN[44], GIN[45], POUT[43], GOUT[45] );
  smblock1 d346 (PIN[44], PIN[45], GIN[45], GIN[46], POUT[44], GOUT[46] );
  smblock1 d347 (PIN[45], PIN[46], GIN[46], GIN[47], POUT[45], GOUT[47] );
  smblock1 d348 (PIN[46], PIN[47], GIN[47], GIN[48], POUT[46], GOUT[48] );
  smblock1 d349 (PIN[47], PIN[48], GIN[48], GIN[49], POUT[47], GOUT[49] );
  smblock1 d350 (PIN[48], PIN[49], GIN[49], GIN[50], POUT[48], GOUT[50] );
  smblock1 d351 (PIN[49], PIN[50], GIN[50], GIN[51], POUT[49], GOUT[51] );
  smblock1 d352 (PIN[50], PIN[51], GIN[51], GIN[52], POUT[50], GOUT[52] );
  smblock1 d353 (PIN[51], PIN[52], GIN[52], GIN[53], POUT[51], GOUT[53] );
  smblock1 d354 (PIN[52], PIN[53], GIN[53], GIN[54], POUT[52], GOUT[54] );
  smblock1 d355 (PIN[53], PIN[54], GIN[54], GIN[55], POUT[53], GOUT[55] );
  smblock1 d356 (PIN[54], PIN[55], GIN[55], GIN[56], POUT[54], GOUT[56] );
  smblock1 d357 (PIN[55], PIN[56], GIN[56], GIN[57], POUT[55], GOUT[57] );
  smblock1 d358 (PIN[56], PIN[57], GIN[57], GIN[58], POUT[56], GOUT[58] );
  smblock1 d359 (PIN[57], PIN[58], GIN[58], GIN[59], POUT[57], GOUT[59] );
  smblock1 d360 (PIN[58], PIN[59], GIN[59], GIN[60], POUT[58], GOUT[60] );
  smblock1 d361 (PIN[59], PIN[60], GIN[60], GIN[61], POUT[59], GOUT[61] );
  smblock1 d362 (PIN[60], PIN[61], GIN[61], GIN[62], POUT[60], GOUT[62] );
  smblock1 d363 (PIN[61], PIN[62], GIN[62], GIN[63], POUT[61], GOUT[63] );
endmodule

module smdblc_1_128 (PIN, GIN, POUT, GOUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [63:0] POUT;
  output [63:0] GOUT;
  sminvblock d10 (GIN[0], GOUT[0] );
  sminvblock d11 (GIN[1], GOUT[1] );
  smblock2a d22 (PIN[0], GIN[0], GIN[2], GOUT[2] );
  smblock2a d23 (PIN[1], GIN[1], GIN[3], GOUT[3] );
  smblock2 d34 (PIN[0], PIN[2], GIN[2], GIN[4], POUT[0], GOUT[4] );
  smblock2 d35 (PIN[1], PIN[3], GIN[3], GIN[5], POUT[1], GOUT[5] );
  smblock2 d36 (PIN[2], PIN[4], GIN[4], GIN[6], POUT[2], GOUT[6] );
  smblock2 d37 (PIN[3], PIN[5], GIN[5], GIN[7], POUT[3], GOUT[7] );
  smblock2 d38 (PIN[4], PIN[6], GIN[6], GIN[8], POUT[4], GOUT[8] );
  smblock2 d39 (PIN[5], PIN[7], GIN[7], GIN[9], POUT[5], GOUT[9] );
  smblock2 d310 (PIN[6], PIN[8], GIN[8], GIN[10], POUT[6], GOUT[10] );
  smblock2 d311 (PIN[7], PIN[9], GIN[9], GIN[11], POUT[7], GOUT[11] );
  smblock2 d312 (PIN[8], PIN[10], GIN[10], GIN[12], POUT[8], GOUT[12] );
  smblock2 d313 (PIN[9], PIN[11], GIN[11], GIN[13], POUT[9], GOUT[13] );
  smblock2 d314 (PIN[10], PIN[12], GIN[12], GIN[14], POUT[10], GOUT[14] );
  smblock2 d315 (PIN[11], PIN[13], GIN[13], GIN[15], POUT[11], GOUT[15] );
  smblock2 d316 (PIN[12], PIN[14], GIN[14], GIN[16], POUT[12], GOUT[16] );
  smblock2 d317 (PIN[13], PIN[15], GIN[15], GIN[17], POUT[13], GOUT[17] );
  smblock2 d318 (PIN[14], PIN[16], GIN[16], GIN[18], POUT[14], GOUT[18] );
  smblock2 d319 (PIN[15], PIN[17], GIN[17], GIN[19], POUT[15], GOUT[19] );
  smblock2 d320 (PIN[16], PIN[18], GIN[18], GIN[20], POUT[16], GOUT[20] );
  smblock2 d321 (PIN[17], PIN[19], GIN[19], GIN[21], POUT[17], GOUT[21] );
  smblock2 d322 (PIN[18], PIN[20], GIN[20], GIN[22], POUT[18], GOUT[22] );
  smblock2 d323 (PIN[19], PIN[21], GIN[21], GIN[23], POUT[19], GOUT[23] );
  smblock2 d324 (PIN[20], PIN[22], GIN[22], GIN[24], POUT[20], GOUT[24] );
  smblock2 d325 (PIN[21], PIN[23], GIN[23], GIN[25], POUT[21], GOUT[25] );
  smblock2 d326 (PIN[22], PIN[24], GIN[24], GIN[26], POUT[22], GOUT[26] );
  smblock2 d327 (PIN[23], PIN[25], GIN[25], GIN[27], POUT[23], GOUT[27] );
  smblock2 d328 (PIN[24], PIN[26], GIN[26], GIN[28], POUT[24], GOUT[28] );
  smblock2 d329 (PIN[25], PIN[27], GIN[27], GIN[29], POUT[25], GOUT[29] );
  smblock2 d330 (PIN[26], PIN[28], GIN[28], GIN[30], POUT[26], GOUT[30] );
  smblock2 d331 (PIN[27], PIN[29], GIN[29], GIN[31], POUT[27], GOUT[31] );
  smblock2 d332 (PIN[28], PIN[30], GIN[30], GIN[32], POUT[28], GOUT[32] );
  smblock2 d333 (PIN[29], PIN[31], GIN[31], GIN[33], POUT[29], GOUT[33] );
  smblock2 d334 (PIN[30], PIN[32], GIN[32], GIN[34], POUT[30], GOUT[34] );
  smblock2 d335 (PIN[31], PIN[33], GIN[33], GIN[35], POUT[31], GOUT[35] );
  smblock2 d336 (PIN[32], PIN[34], GIN[34], GIN[36], POUT[32], GOUT[36] );
  smblock2 d337 (PIN[33], PIN[35], GIN[35], GIN[37], POUT[33], GOUT[37] );
  smblock2 d338 (PIN[34], PIN[36], GIN[36], GIN[38], POUT[34], GOUT[38] );
  smblock2 d339 (PIN[35], PIN[37], GIN[37], GIN[39], POUT[35], GOUT[39] );
  smblock2 d340 (PIN[36], PIN[38], GIN[38], GIN[40], POUT[36], GOUT[40] );
  smblock2 d341 (PIN[37], PIN[39], GIN[39], GIN[41], POUT[37], GOUT[41] );
  smblock2 d342 (PIN[38], PIN[40], GIN[40], GIN[42], POUT[38], GOUT[42] );
  smblock2 d343 (PIN[39], PIN[41], GIN[41], GIN[43], POUT[39], GOUT[43] );
  smblock2 d344 (PIN[40], PIN[42], GIN[42], GIN[44], POUT[40], GOUT[44] );
  smblock2 d345 (PIN[41], PIN[43], GIN[43], GIN[45], POUT[41], GOUT[45] );
  smblock2 d346 (PIN[42], PIN[44], GIN[44], GIN[46], POUT[42], GOUT[46] );
  smblock2 d347 (PIN[43], PIN[45], GIN[45], GIN[47], POUT[43], GOUT[47] );
  smblock2 d348 (PIN[44], PIN[46], GIN[46], GIN[48], POUT[44], GOUT[48] );
  smblock2 d349 (PIN[45], PIN[47], GIN[47], GIN[49], POUT[45], GOUT[49] );
  smblock2 d350 (PIN[46], PIN[48], GIN[48], GIN[50], POUT[46], GOUT[50] );
  smblock2 d351 (PIN[47], PIN[49], GIN[49], GIN[51], POUT[47], GOUT[51] );
  smblock2 d352 (PIN[48], PIN[50], GIN[50], GIN[52], POUT[48], GOUT[52] );
  smblock2 d353 (PIN[49], PIN[51], GIN[51], GIN[53], POUT[49], GOUT[53] );
  smblock2 d354 (PIN[50], PIN[52], GIN[52], GIN[54], POUT[50], GOUT[54] );
  smblock2 d355 (PIN[51], PIN[53], GIN[53], GIN[55], POUT[51], GOUT[55] );
  smblock2 d356 (PIN[52], PIN[54], GIN[54], GIN[56], POUT[52], GOUT[56] );
  smblock2 d357 (PIN[53], PIN[55], GIN[55], GIN[57], POUT[53], GOUT[57] );
  smblock2 d358 (PIN[54], PIN[56], GIN[56], GIN[58], POUT[54], GOUT[58] );
  smblock2 d359 (PIN[55], PIN[57], GIN[57], GIN[59], POUT[55], GOUT[59] );
  smblock2 d360 (PIN[56], PIN[58], GIN[58], GIN[60], POUT[56], GOUT[60] );
  smblock2 d361 (PIN[57], PIN[59], GIN[59], GIN[61], POUT[57], GOUT[61] );
  smblock2 d362 (PIN[58], PIN[60], GIN[60], GIN[62], POUT[58], GOUT[62] );
  smblock2 d363 (PIN[59], PIN[61], GIN[61], GIN[63], POUT[59], GOUT[63] );
endmodule

module smdblc_2_128 (PIN, GIN, POUT, GOUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [63:0] POUT;
  output [63:0] GOUT;
  sminvblock d10 (GIN[0], GOUT[0] );
  sminvblock d11 (GIN[1], GOUT[1] );
  sminvblock d12 (GIN[2], GOUT[2] );
  sminvblock d13 (GIN[3], GOUT[3] );
  smblock1a d24 (PIN[0], GIN[0], GIN[4], GOUT[4] );
  smblock1a d25 (PIN[1], GIN[1], GIN[5], GOUT[5] );
  smblock1a d26 (PIN[2], GIN[2], GIN[6], GOUT[6] );
  smblock1a d27 (PIN[3], GIN[3], GIN[7], GOUT[7] );
  smblock1 d38 (PIN[0], PIN[4], GIN[4], GIN[8], POUT[0], GOUT[8] );
  smblock1 d39 (PIN[1], PIN[5], GIN[5], GIN[9], POUT[1], GOUT[9] );
  smblock1 d310 (PIN[2], PIN[6], GIN[6], GIN[10], POUT[2], GOUT[10] );
  smblock1 d311 (PIN[3], PIN[7], GIN[7], GIN[11], POUT[3], GOUT[11] );
  smblock1 d312 (PIN[4], PIN[8], GIN[8], GIN[12], POUT[4], GOUT[12] );
  smblock1 d313 (PIN[5], PIN[9], GIN[9], GIN[13], POUT[5], GOUT[13] );
  smblock1 d314 (PIN[6], PIN[10], GIN[10], GIN[14], POUT[6], GOUT[14] );
  smblock1 d315 (PIN[7], PIN[11], GIN[11], GIN[15], POUT[7], GOUT[15] );
  smblock1 d316 (PIN[8], PIN[12], GIN[12], GIN[16], POUT[8], GOUT[16] );
  smblock1 d317 (PIN[9], PIN[13], GIN[13], GIN[17], POUT[9], GOUT[17] );
  smblock1 d318 (PIN[10], PIN[14], GIN[14], GIN[18], POUT[10], GOUT[18] );
  smblock1 d319 (PIN[11], PIN[15], GIN[15], GIN[19], POUT[11], GOUT[19] );
  smblock1 d320 (PIN[12], PIN[16], GIN[16], GIN[20], POUT[12], GOUT[20] );
  smblock1 d321 (PIN[13], PIN[17], GIN[17], GIN[21], POUT[13], GOUT[21] );
  smblock1 d322 (PIN[14], PIN[18], GIN[18], GIN[22], POUT[14], GOUT[22] );
  smblock1 d323 (PIN[15], PIN[19], GIN[19], GIN[23], POUT[15], GOUT[23] );
  smblock1 d324 (PIN[16], PIN[20], GIN[20], GIN[24], POUT[16], GOUT[24] );
  smblock1 d325 (PIN[17], PIN[21], GIN[21], GIN[25], POUT[17], GOUT[25] );
  smblock1 d326 (PIN[18], PIN[22], GIN[22], GIN[26], POUT[18], GOUT[26] );
  smblock1 d327 (PIN[19], PIN[23], GIN[23], GIN[27], POUT[19], GOUT[27] );
  smblock1 d328 (PIN[20], PIN[24], GIN[24], GIN[28], POUT[20], GOUT[28] );
  smblock1 d329 (PIN[21], PIN[25], GIN[25], GIN[29], POUT[21], GOUT[29] );
  smblock1 d330 (PIN[22], PIN[26], GIN[26], GIN[30], POUT[22], GOUT[30] );
  smblock1 d331 (PIN[23], PIN[27], GIN[27], GIN[31], POUT[23], GOUT[31] );
  smblock1 d332 (PIN[24], PIN[28], GIN[28], GIN[32], POUT[24], GOUT[32] );
  smblock1 d333 (PIN[25], PIN[29], GIN[29], GIN[33], POUT[25], GOUT[33] );
  smblock1 d334 (PIN[26], PIN[30], GIN[30], GIN[34], POUT[26], GOUT[34] );
  smblock1 d335 (PIN[27], PIN[31], GIN[31], GIN[35], POUT[27], GOUT[35] );
  smblock1 d336 (PIN[28], PIN[32], GIN[32], GIN[36], POUT[28], GOUT[36] );
  smblock1 d337 (PIN[29], PIN[33], GIN[33], GIN[37], POUT[29], GOUT[37] );
  smblock1 d338 (PIN[30], PIN[34], GIN[34], GIN[38], POUT[30], GOUT[38] );
  smblock1 d339 (PIN[31], PIN[35], GIN[35], GIN[39], POUT[31], GOUT[39] );
  smblock1 d340 (PIN[32], PIN[36], GIN[36], GIN[40], POUT[32], GOUT[40] );
  smblock1 d341 (PIN[33], PIN[37], GIN[37], GIN[41], POUT[33], GOUT[41] );
  smblock1 d342 (PIN[34], PIN[38], GIN[38], GIN[42], POUT[34], GOUT[42] );
  smblock1 d343 (PIN[35], PIN[39], GIN[39], GIN[43], POUT[35], GOUT[43] );
  smblock1 d344 (PIN[36], PIN[40], GIN[40], GIN[44], POUT[36], GOUT[44] );
  smblock1 d345 (PIN[37], PIN[41], GIN[41], GIN[45], POUT[37], GOUT[45] );
  smblock1 d346 (PIN[38], PIN[42], GIN[42], GIN[46], POUT[38], GOUT[46] );
  smblock1 d347 (PIN[39], PIN[43], GIN[43], GIN[47], POUT[39], GOUT[47] );
  smblock1 d348 (PIN[40], PIN[44], GIN[44], GIN[48], POUT[40], GOUT[48] );
  smblock1 d349 (PIN[41], PIN[45], GIN[45], GIN[49], POUT[41], GOUT[49] );
  smblock1 d350 (PIN[42], PIN[46], GIN[46], GIN[50], POUT[42], GOUT[50] );
  smblock1 d351 (PIN[43], PIN[47], GIN[47], GIN[51], POUT[43], GOUT[51] );
  smblock1 d352 (PIN[44], PIN[48], GIN[48], GIN[52], POUT[44], GOUT[52] );
  smblock1 d353 (PIN[45], PIN[49], GIN[49], GIN[53], POUT[45], GOUT[53] );
  smblock1 d354 (PIN[46], PIN[50], GIN[50], GIN[54], POUT[46], GOUT[54] );
  smblock1 d355 (PIN[47], PIN[51], GIN[51], GIN[55], POUT[47], GOUT[55] );
  smblock1 d356 (PIN[48], PIN[52], GIN[52], GIN[56], POUT[48], GOUT[56] );
  smblock1 d357 (PIN[49], PIN[53], GIN[53], GIN[57], POUT[49], GOUT[57] );
  smblock1 d358 (PIN[50], PIN[54], GIN[54], GIN[58], POUT[50], GOUT[58] );
  smblock1 d359 (PIN[51], PIN[55], GIN[55], GIN[59], POUT[51], GOUT[59] );
  smblock1 d360 (PIN[52], PIN[56], GIN[56], GIN[60], POUT[52], GOUT[60] );
  smblock1 d361 (PIN[53], PIN[57], GIN[57], GIN[61], POUT[53], GOUT[61] );
  smblock1 d362 (PIN[54], PIN[58], GIN[58], GIN[62], POUT[54], GOUT[62] );
  smblock1 d363 (PIN[55], PIN[59], GIN[59], GIN[63], POUT[55], GOUT[63] );
endmodule

module smdblc_3_128 (PIN, GIN, POUT, GOUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [63:0] POUT;
  output [63:0] GOUT;
  sminvblock d10 (GIN[0], GOUT[0] );
  sminvblock d11 (GIN[1], GOUT[1] );
  sminvblock d12 (GIN[2], GOUT[2] );
  sminvblock d13 (GIN[3], GOUT[3] );
  sminvblock d14 (GIN[4], GOUT[4] );
  sminvblock d15 (GIN[5], GOUT[5] );
  sminvblock d16 (GIN[6], GOUT[6] );
  sminvblock d17 (GIN[7], GOUT[7] );
  smblock2a d28 (PIN[0], GIN[0], GIN[8], GOUT[8] );
  smblock2a d29 (PIN[1], GIN[1], GIN[9], GOUT[9] );
  smblock2a d210 (PIN[2], GIN[2], GIN[10], GOUT[10] );
  smblock2a d211 (PIN[3], GIN[3], GIN[11], GOUT[11] );
  smblock2a d212 (PIN[4], GIN[4], GIN[12], GOUT[12] );
  smblock2a d213 (PIN[5], GIN[5], GIN[13], GOUT[13] );
  smblock2a d214 (PIN[6], GIN[6], GIN[14], GOUT[14] );
  smblock2a d215 (PIN[7], GIN[7], GIN[15], GOUT[15] );
  smblock2 d316 (PIN[0], PIN[8], GIN[8], GIN[16], POUT[0], GOUT[16] );
  smblock2 d317 (PIN[1], PIN[9], GIN[9], GIN[17], POUT[1], GOUT[17] );
  smblock2 d318 (PIN[2], PIN[10], GIN[10], GIN[18], POUT[2], GOUT[18] );
  smblock2 d319 (PIN[3], PIN[11], GIN[11], GIN[19], POUT[3], GOUT[19] );
  smblock2 d320 (PIN[4], PIN[12], GIN[12], GIN[20], POUT[4], GOUT[20] );
  smblock2 d321 (PIN[5], PIN[13], GIN[13], GIN[21], POUT[5], GOUT[21] );
  smblock2 d322 (PIN[6], PIN[14], GIN[14], GIN[22], POUT[6], GOUT[22] );
  smblock2 d323 (PIN[7], PIN[15], GIN[15], GIN[23], POUT[7], GOUT[23] );
  smblock2 d324 (PIN[8], PIN[16], GIN[16], GIN[24], POUT[8], GOUT[24] );
  smblock2 d325 (PIN[9], PIN[17], GIN[17], GIN[25], POUT[9], GOUT[25] );
  smblock2 d326 (PIN[10], PIN[18], GIN[18], GIN[26], POUT[10], GOUT[26] );
  smblock2 d327 (PIN[11], PIN[19], GIN[19], GIN[27], POUT[11], GOUT[27] );
  smblock2 d328 (PIN[12], PIN[20], GIN[20], GIN[28], POUT[12], GOUT[28] );
  smblock2 d329 (PIN[13], PIN[21], GIN[21], GIN[29], POUT[13], GOUT[29] );
  smblock2 d330 (PIN[14], PIN[22], GIN[22], GIN[30], POUT[14], GOUT[30] );
  smblock2 d331 (PIN[15], PIN[23], GIN[23], GIN[31], POUT[15], GOUT[31] );
  smblock2 d332 (PIN[16], PIN[24], GIN[24], GIN[32], POUT[16], GOUT[32] );
  smblock2 d333 (PIN[17], PIN[25], GIN[25], GIN[33], POUT[17], GOUT[33] );
  smblock2 d334 (PIN[18], PIN[26], GIN[26], GIN[34], POUT[18], GOUT[34] );
  smblock2 d335 (PIN[19], PIN[27], GIN[27], GIN[35], POUT[19], GOUT[35] );
  smblock2 d336 (PIN[20], PIN[28], GIN[28], GIN[36], POUT[20], GOUT[36] );
  smblock2 d337 (PIN[21], PIN[29], GIN[29], GIN[37], POUT[21], GOUT[37] );
  smblock2 d338 (PIN[22], PIN[30], GIN[30], GIN[38], POUT[22], GOUT[38] );
  smblock2 d339 (PIN[23], PIN[31], GIN[31], GIN[39], POUT[23], GOUT[39] );
  smblock2 d340 (PIN[24], PIN[32], GIN[32], GIN[40], POUT[24], GOUT[40] );
  smblock2 d341 (PIN[25], PIN[33], GIN[33], GIN[41], POUT[25], GOUT[41] );
  smblock2 d342 (PIN[26], PIN[34], GIN[34], GIN[42], POUT[26], GOUT[42] );
  smblock2 d343 (PIN[27], PIN[35], GIN[35], GIN[43], POUT[27], GOUT[43] );
  smblock2 d344 (PIN[28], PIN[36], GIN[36], GIN[44], POUT[28], GOUT[44] );
  smblock2 d345 (PIN[29], PIN[37], GIN[37], GIN[45], POUT[29], GOUT[45] );
  smblock2 d346 (PIN[30], PIN[38], GIN[38], GIN[46], POUT[30], GOUT[46] );
  smblock2 d347 (PIN[31], PIN[39], GIN[39], GIN[47], POUT[31], GOUT[47] );
  smblock2 d348 (PIN[32], PIN[40], GIN[40], GIN[48], POUT[32], GOUT[48] );
  smblock2 d349 (PIN[33], PIN[41], GIN[41], GIN[49], POUT[33], GOUT[49] );
  smblock2 d350 (PIN[34], PIN[42], GIN[42], GIN[50], POUT[34], GOUT[50] );
  smblock2 d351 (PIN[35], PIN[43], GIN[43], GIN[51], POUT[35], GOUT[51] );
  smblock2 d352 (PIN[36], PIN[44], GIN[44], GIN[52], POUT[36], GOUT[52] );
  smblock2 d353 (PIN[37], PIN[45], GIN[45], GIN[53], POUT[37], GOUT[53] );
  smblock2 d354 (PIN[38], PIN[46], GIN[46], GIN[54], POUT[38], GOUT[54] );
  smblock2 d355 (PIN[39], PIN[47], GIN[47], GIN[55], POUT[39], GOUT[55] );
  smblock2 d356 (PIN[40], PIN[48], GIN[48], GIN[56], POUT[40], GOUT[56] );
  smblock2 d357 (PIN[41], PIN[49], GIN[49], GIN[57], POUT[41], GOUT[57] );
  smblock2 d358 (PIN[42], PIN[50], GIN[50], GIN[58], POUT[42], GOUT[58] );
  smblock2 d359 (PIN[43], PIN[51], GIN[51], GIN[59], POUT[43], GOUT[59] );
  smblock2 d360 (PIN[44], PIN[52], GIN[52], GIN[60], POUT[44], GOUT[60] );
  smblock2 d361 (PIN[45], PIN[53], GIN[53], GIN[61], POUT[45], GOUT[61] );
  smblock2 d362 (PIN[46], PIN[54], GIN[54], GIN[62], POUT[46], GOUT[62] );
  smblock2 d363 (PIN[47], PIN[55], GIN[55], GIN[63], POUT[47], GOUT[63] );
endmodule

module smdblc_4_128 (PIN, GIN, POUT, GOUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [63:0] POUT;
  output [63:0] GOUT;
  sminvblock d10 (GIN[0], GOUT[0] );
  sminvblock d11 (GIN[1], GOUT[1] );
  sminvblock d12 (GIN[2], GOUT[2] );
  sminvblock d13 (GIN[3], GOUT[3] );
  sminvblock d14 (GIN[4], GOUT[4] );
  sminvblock d15 (GIN[5], GOUT[5] );
  sminvblock d16 (GIN[6], GOUT[6] );
  sminvblock d17 (GIN[7], GOUT[7] );
  sminvblock d18 (GIN[8], GOUT[8] );
  sminvblock d19 (GIN[9], GOUT[9] );
  sminvblock d110 (GIN[10], GOUT[10] );
  sminvblock d111 (GIN[11], GOUT[11] );
  sminvblock d112 (GIN[12], GOUT[12] );
  sminvblock d113 (GIN[13], GOUT[13] );
  sminvblock d114 (GIN[14], GOUT[14] );
  sminvblock d115 (GIN[15], GOUT[15] );
  smblock1a d216 (PIN[0], GIN[0], GIN[16], GOUT[16] );
  smblock1a d217 (PIN[1], GIN[1], GIN[17], GOUT[17] );
  smblock1a d218 (PIN[2], GIN[2], GIN[18], GOUT[18] );
  smblock1a d219 (PIN[3], GIN[3], GIN[19], GOUT[19] );
  smblock1a d220 (PIN[4], GIN[4], GIN[20], GOUT[20] );
  smblock1a d221 (PIN[5], GIN[5], GIN[21], GOUT[21] );
  smblock1a d222 (PIN[6], GIN[6], GIN[22], GOUT[22] );
  smblock1a d223 (PIN[7], GIN[7], GIN[23], GOUT[23] );
  smblock1a d224 (PIN[8], GIN[8], GIN[24], GOUT[24] );
  smblock1a d225 (PIN[9], GIN[9], GIN[25], GOUT[25] );
  smblock1a d226 (PIN[10], GIN[10], GIN[26], GOUT[26] );
  smblock1a d227 (PIN[11], GIN[11], GIN[27], GOUT[27] );
  smblock1a d228 (PIN[12], GIN[12], GIN[28], GOUT[28] );
  smblock1a d229 (PIN[13], GIN[13], GIN[29], GOUT[29] );
  smblock1a d230 (PIN[14], GIN[14], GIN[30], GOUT[30] );
  smblock1a d231 (PIN[15], GIN[15], GIN[31], GOUT[31] );
  smblock1 d332 (PIN[0], PIN[16], GIN[16], GIN[32], POUT[0], GOUT[32] );
  smblock1 d333 (PIN[1], PIN[17], GIN[17], GIN[33], POUT[1], GOUT[33] );
  smblock1 d334 (PIN[2], PIN[18], GIN[18], GIN[34], POUT[2], GOUT[34] );
  smblock1 d335 (PIN[3], PIN[19], GIN[19], GIN[35], POUT[3], GOUT[35] );
  smblock1 d336 (PIN[4], PIN[20], GIN[20], GIN[36], POUT[4], GOUT[36] );
  smblock1 d337 (PIN[5], PIN[21], GIN[21], GIN[37], POUT[5], GOUT[37] );
  smblock1 d338 (PIN[6], PIN[22], GIN[22], GIN[38], POUT[6], GOUT[38] );
  smblock1 d339 (PIN[7], PIN[23], GIN[23], GIN[39], POUT[7], GOUT[39] );
  smblock1 d340 (PIN[8], PIN[24], GIN[24], GIN[40], POUT[8], GOUT[40] );
  smblock1 d341 (PIN[9], PIN[25], GIN[25], GIN[41], POUT[9], GOUT[41] );
  smblock1 d342 (PIN[10], PIN[26], GIN[26], GIN[42], POUT[10], GOUT[42] );
  smblock1 d343 (PIN[11], PIN[27], GIN[27], GIN[43], POUT[11], GOUT[43] );
  smblock1 d344 (PIN[12], PIN[28], GIN[28], GIN[44], POUT[12], GOUT[44] );
  smblock1 d345 (PIN[13], PIN[29], GIN[29], GIN[45], POUT[13], GOUT[45] );
  smblock1 d346 (PIN[14], PIN[30], GIN[30], GIN[46], POUT[14], GOUT[46] );
  smblock1 d347 (PIN[15], PIN[31], GIN[31], GIN[47], POUT[15], GOUT[47] );
  smblock1 d348 (PIN[16], PIN[32], GIN[32], GIN[48], POUT[16], GOUT[48] );
  smblock1 d349 (PIN[17], PIN[33], GIN[33], GIN[49], POUT[17], GOUT[49] );
  smblock1 d350 (PIN[18], PIN[34], GIN[34], GIN[50], POUT[18], GOUT[50] );
  smblock1 d351 (PIN[19], PIN[35], GIN[35], GIN[51], POUT[19], GOUT[51] );
  smblock1 d352 (PIN[20], PIN[36], GIN[36], GIN[52], POUT[20], GOUT[52] );
  smblock1 d353 (PIN[21], PIN[37], GIN[37], GIN[53], POUT[21], GOUT[53] );
  smblock1 d354 (PIN[22], PIN[38], GIN[38], GIN[54], POUT[22], GOUT[54] );
  smblock1 d355 (PIN[23], PIN[39], GIN[39], GIN[55], POUT[23], GOUT[55] );
  smblock1 d356 (PIN[24], PIN[40], GIN[40], GIN[56], POUT[24], GOUT[56] );
  smblock1 d357 (PIN[25], PIN[41], GIN[41], GIN[57], POUT[25], GOUT[57] );
  smblock1 d358 (PIN[26], PIN[42], GIN[42], GIN[58], POUT[26], GOUT[58] );
  smblock1 d359 (PIN[27], PIN[43], GIN[43], GIN[59], POUT[27], GOUT[59] );
  smblock1 d360 (PIN[28], PIN[44], GIN[44], GIN[60], POUT[28], GOUT[60] );
  smblock1 d361 (PIN[29], PIN[45], GIN[45], GIN[61], POUT[29], GOUT[61] );
  smblock1 d362 (PIN[30], PIN[46], GIN[46], GIN[62], POUT[30], GOUT[62] );
  smblock1 d363 (PIN[31], PIN[47], GIN[47], GIN[63], POUT[31], GOUT[63] );
endmodule

module smxorstage_128 (A, B, PBIT, CARRY, SUM);
  input  [63:0] A;
  input  [63:0] B;
  input  PBIT;
  input  [63:0] CARRY;
  output [63:0] SUM;
  smxxor1 d20 (A[0], B[0], CARRY[0], SUM[0] );
  smxxor1 d21 (A[1], B[1], CARRY[1], SUM[1] );
  smxxor1 d22 (A[2], B[2], CARRY[2], SUM[2] );
  smxxor1 d23 (A[3], B[3], CARRY[3], SUM[3] );
  smxxor1 d24 (A[4], B[4], CARRY[4], SUM[4] );
  smxxor1 d25 (A[5], B[5], CARRY[5], SUM[5] );
  smxxor1 d26 (A[6], B[6], CARRY[6], SUM[6] );
  smxxor1 d27 (A[7], B[7], CARRY[7], SUM[7] );
  smxxor1 d28 (A[8], B[8], CARRY[8], SUM[8] );
  smxxor1 d29 (A[9], B[9], CARRY[9], SUM[9] );
  smxxor1 d210 (A[10], B[10], CARRY[10], SUM[10] );
  smxxor1 d211 (A[11], B[11], CARRY[11], SUM[11] );
  smxxor1 d212 (A[12], B[12], CARRY[12], SUM[12] );
  smxxor1 d213 (A[13], B[13], CARRY[13], SUM[13] );
  smxxor1 d214 (A[14], B[14], CARRY[14], SUM[14] );
  smxxor1 d215 (A[15], B[15], CARRY[15], SUM[15] );
  smxxor1 d216 (A[16], B[16], CARRY[16], SUM[16] );
  smxxor1 d217 (A[17], B[17], CARRY[17], SUM[17] );
  smxxor1 d218 (A[18], B[18], CARRY[18], SUM[18] );
  smxxor1 d219 (A[19], B[19], CARRY[19], SUM[19] );
  smxxor1 d220 (A[20], B[20], CARRY[20], SUM[20] );
  smxxor1 d221 (A[21], B[21], CARRY[21], SUM[21] );
  smxxor1 d222 (A[22], B[22], CARRY[22], SUM[22] );
  smxxor1 d223 (A[23], B[23], CARRY[23], SUM[23] );
  smxxor1 d224 (A[24], B[24], CARRY[24], SUM[24] );
  smxxor1 d225 (A[25], B[25], CARRY[25], SUM[25] );
  smxxor1 d226 (A[26], B[26], CARRY[26], SUM[26] );
  smxxor1 d227 (A[27], B[27], CARRY[27], SUM[27] );
  smxxor1 d228 (A[28], B[28], CARRY[28], SUM[28] );
  smxxor1 d229 (A[29], B[29], CARRY[29], SUM[29] );
  smxxor1 d230 (A[30], B[30], CARRY[30], SUM[30] );
  smxxor1 d231 (A[31], B[31], CARRY[31], SUM[31] );
  smxxor1 d232 (A[32], B[32], CARRY[32], SUM[32] );
  smxxor1 d233 (A[33], B[33], CARRY[33], SUM[33] );
  smxxor1 d234 (A[34], B[34], CARRY[34], SUM[34] );
  smxxor1 d235 (A[35], B[35], CARRY[35], SUM[35] );
  smxxor1 d236 (A[36], B[36], CARRY[36], SUM[36] );
  smxxor1 d237 (A[37], B[37], CARRY[37], SUM[37] );
  smxxor1 d238 (A[38], B[38], CARRY[38], SUM[38] );
  smxxor1 d239 (A[39], B[39], CARRY[39], SUM[39] );
  smxxor1 d240 (A[40], B[40], CARRY[40], SUM[40] );
  smxxor1 d241 (A[41], B[41], CARRY[41], SUM[41] );
  smxxor1 d242 (A[42], B[42], CARRY[42], SUM[42] );
  smxxor1 d243 (A[43], B[43], CARRY[43], SUM[43] );
  smxxor1 d244 (A[44], B[44], CARRY[44], SUM[44] );
  smxxor1 d245 (A[45], B[45], CARRY[45], SUM[45] );
  smxxor1 d246 (A[46], B[46], CARRY[46], SUM[46] );
  smxxor1 d247 (A[47], B[47], CARRY[47], SUM[47] );
  smxxor1 d248 (A[48], B[48], CARRY[48], SUM[48] );
  smxxor1 d249 (A[49], B[49], CARRY[49], SUM[49] );
  smxxor1 d250 (A[50], B[50], CARRY[50], SUM[50] );
  smxxor1 d251 (A[51], B[51], CARRY[51], SUM[51] );
  smxxor1 d252 (A[52], B[52], CARRY[52], SUM[52] );
  smxxor1 d253 (A[53], B[53], CARRY[53], SUM[53] );
  smxxor1 d254 (A[54], B[54], CARRY[54], SUM[54] );
  smxxor1 d255 (A[55], B[55], CARRY[55], SUM[55] );
  smxxor1 d256 (A[56], B[56], CARRY[56], SUM[56] );
  smxxor1 d257 (A[57], B[57], CARRY[57], SUM[57] );
  smxxor1 d258 (A[58], B[58], CARRY[58], SUM[58] );
  smxxor1 d259 (A[59], B[59], CARRY[59], SUM[59] );
  smxxor1 d260 (A[60], B[60], CARRY[60], SUM[60] );
  smxxor1 d261 (A[61], B[61], CARRY[61], SUM[61] );
  smxxor1 d262 (A[62], B[62], CARRY[62], SUM[62] );
  smxxor1 d263 (A[63], B[63], CARRY[63], SUM[63] );
endmodule

module smdblc_5_128 (PIN, GIN, POUT, GOUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [63:0] POUT;
  output [63:0] GOUT;
  sminvblock d10 (GIN[0], GOUT[0] );
  sminvblock d11 (GIN[1], GOUT[1] );
  sminvblock d12 (GIN[2], GOUT[2] );
  sminvblock d13 (GIN[3], GOUT[3] );
  sminvblock d14 (GIN[4], GOUT[4] );
  sminvblock d15 (GIN[5], GOUT[5] );
  sminvblock d16 (GIN[6], GOUT[6] );
  sminvblock d17 (GIN[7], GOUT[7] );
  sminvblock d18 (GIN[8], GOUT[8] );
  sminvblock d19 (GIN[9], GOUT[9] );
  sminvblock d110 (GIN[10], GOUT[10] );
  sminvblock d111 (GIN[11], GOUT[11] );
  sminvblock d112 (GIN[12], GOUT[12] );
  sminvblock d113 (GIN[13], GOUT[13] );
  sminvblock d114 (GIN[14], GOUT[14] );
  sminvblock d115 (GIN[15], GOUT[15] );
  sminvblock d116 (GIN[16], GOUT[16] );
  sminvblock d117 (GIN[17], GOUT[17] );
  sminvblock d118 (GIN[18], GOUT[18] );
  sminvblock d119 (GIN[19], GOUT[19] );
  sminvblock d120 (GIN[20], GOUT[20] );
  sminvblock d121 (GIN[21], GOUT[21] );
  sminvblock d122 (GIN[22], GOUT[22] );
  sminvblock d123 (GIN[23], GOUT[23] );
  sminvblock d124 (GIN[24], GOUT[24] );
  sminvblock d125 (GIN[25], GOUT[25] );
  sminvblock d126 (GIN[26], GOUT[26] );
  sminvblock d127 (GIN[27], GOUT[27] );
  sminvblock d128 (GIN[28], GOUT[28] );
  sminvblock d129 (GIN[29], GOUT[29] );
  sminvblock d130 (GIN[30], GOUT[30] );
  sminvblock d131 (GIN[31], GOUT[31] );
  smblock2a d232 (PIN[0], GIN[0], GIN[32], GOUT[32] );
  smblock2a d233 (PIN[1], GIN[1], GIN[33], GOUT[33] );
  smblock2a d234 (PIN[2], GIN[2], GIN[34], GOUT[34] );
  smblock2a d235 (PIN[3], GIN[3], GIN[35], GOUT[35] );
  smblock2a d236 (PIN[4], GIN[4], GIN[36], GOUT[36] );
  smblock2a d237 (PIN[5], GIN[5], GIN[37], GOUT[37] );
  smblock2a d238 (PIN[6], GIN[6], GIN[38], GOUT[38] );
  smblock2a d239 (PIN[7], GIN[7], GIN[39], GOUT[39] );
  smblock2a d240 (PIN[8], GIN[8], GIN[40], GOUT[40] );
  smblock2a d241 (PIN[9], GIN[9], GIN[41], GOUT[41] );
  smblock2a d242 (PIN[10], GIN[10], GIN[42], GOUT[42] );
  smblock2a d243 (PIN[11], GIN[11], GIN[43], GOUT[43] );
  smblock2a d244 (PIN[12], GIN[12], GIN[44], GOUT[44] );
  smblock2a d245 (PIN[13], GIN[13], GIN[45], GOUT[45] );
  smblock2a d246 (PIN[14], GIN[14], GIN[46], GOUT[46] );
  smblock2a d247 (PIN[15], GIN[15], GIN[47], GOUT[47] );
  smblock2a d248 (PIN[16], GIN[16], GIN[48], GOUT[48] );
  smblock2a d249 (PIN[17], GIN[17], GIN[49], GOUT[49] );
  smblock2a d250 (PIN[18], GIN[18], GIN[50], GOUT[50] );
  smblock2a d251 (PIN[19], GIN[19], GIN[51], GOUT[51] );
  smblock2a d252 (PIN[20], GIN[20], GIN[52], GOUT[52] );
  smblock2a d253 (PIN[21], GIN[21], GIN[53], GOUT[53] );
  smblock2a d254 (PIN[22], GIN[22], GIN[54], GOUT[54] );
  smblock2a d255 (PIN[23], GIN[23], GIN[55], GOUT[55] );
  smblock2a d256 (PIN[24], GIN[24], GIN[56], GOUT[56] );
  smblock2a d257 (PIN[25], GIN[25], GIN[57], GOUT[57] );
  smblock2a d258 (PIN[26], GIN[26], GIN[58], GOUT[58] );
  smblock2a d259 (PIN[27], GIN[27], GIN[59], GOUT[59] );
  smblock2a d260 (PIN[28], GIN[28], GIN[60], GOUT[60] );
  smblock2a d261 (PIN[29], GIN[29], GIN[61], GOUT[61] );
  smblock2a d262 (PIN[30], GIN[30], GIN[62], GOUT[62] );
  smblock2a d263 (PIN[31], GIN[31], GIN[63], GOUT[63] );
endmodule

module smdblc_6_128 (PIN, GIN, POUT, GOUT);
  input  [63:0] PIN;
  input  [63:0] GIN;
  output [0:0] POUT;
  output [63:0] GOUT;
  assign GOUT[63:0] = GIN[63:0];
endmodule

module smboothcoder_34_34 (OPA, OPB, SUMMAND);
  input  [33:0] OPA;
  input  [33:0] OPB;
  output [628:0] SUMMAND;
  wire [33:0] OPA_;
  wire [67:0] INT_MULTIPLIER;
  wire LOGIC_ONE, LOGIC_ZERO;
  assign LOGIC_ONE = 1'b1;
  assign LOGIC_ZERO = 1'b0;
  smdecoder dDEC0 (.INA (LOGIC_ZERO), .INB (OPB[0]), .INC (OPB[1]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]) );
  assign OPA_ = ~ OPA;
  smpp_low dPPL0 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[0]) );
  smr_gate dRGATE0 (.INA (LOGIC_ZERO), .INB (OPB[0]), .INC (OPB[1]), .PPBIT (SUMMAND[1]) );
  smpp_middle dPPM0 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[2]) );
  smpp_middle dPPM1 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[3]) );
  smpp_middle dPPM2 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[6]) );
  smpp_middle dPPM3 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[8]) );
  smpp_middle dPPM4 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[12]) );
  smpp_middle dPPM5 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[15]) );
  smpp_middle dPPM6 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[20]) );
  smpp_middle dPPM7 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[24]) );
  smpp_middle dPPM8 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[30]) );
  smpp_middle dPPM9 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[35]) );
  smpp_middle dPPM10 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[42]) );
  smpp_middle dPPM11 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[48]) );
  smpp_middle dPPM12 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[56]) );
  smpp_middle dPPM13 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[63]) );
  smpp_middle dPPM14 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[72]) );
  smpp_middle dPPM15 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[80]) );
  smpp_middle dPPM16 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[90]) );
  smpp_middle dPPM17 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[99]) );
  smpp_middle dPPM18 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[110]) );
  smpp_middle dPPM19 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[120]) );
  smpp_middle dPPM20 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[132]) );
  smpp_middle dPPM21 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[143]) );
  smpp_middle dPPM22 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[156]) );
  smpp_middle dPPM23 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[168]) );
  smpp_middle dPPM24 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[182]) );
  smpp_middle dPPM25 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[195]) );
  smpp_middle dPPM26 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[210]) );
  smpp_middle dPPM27 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[224]) );
  smpp_middle dPPM28 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[240]) );
  smpp_middle dPPM29 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[255]) );
  smpp_middle dPPM30 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[272]) );
  smpp_middle dPPM31 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[288]) );
  smpp_middle dPPM32 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[306]) );
  smpp_high dPPH0 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[0]), .TWONEG (INT_MULTIPLIER[1]), .ONEPOS (INT_MULTIPLIER[2]), .ONENEG (INT_MULTIPLIER[3]), .PPBIT (SUMMAND[323]) );
  assign SUMMAND[324] = 1'b1;
  smdecoder dDEC1 (.INA (OPB[1]), .INB (OPB[2]), .INC (OPB[3]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]) );
  smpp_low dPPL1 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[4]) );
  smr_gate dRGATE1 (.INA (OPB[1]), .INB (OPB[2]), .INC (OPB[3]), .PPBIT (SUMMAND[5]) );
  smpp_middle dPPM33 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[7]) );
  smpp_middle dPPM34 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[9]) );
  smpp_middle dPPM35 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[13]) );
  smpp_middle dPPM36 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[16]) );
  smpp_middle dPPM37 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[21]) );
  smpp_middle dPPM38 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[25]) );
  smpp_middle dPPM39 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[31]) );
  smpp_middle dPPM40 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[36]) );
  smpp_middle dPPM41 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[43]) );
  smpp_middle dPPM42 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[49]) );
  smpp_middle dPPM43 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[57]) );
  smpp_middle dPPM44 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[64]) );
  smpp_middle dPPM45 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[73]) );
  smpp_middle dPPM46 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[81]) );
  smpp_middle dPPM47 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[91]) );
  smpp_middle dPPM48 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[100]) );
  smpp_middle dPPM49 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[111]) );
  smpp_middle dPPM50 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[121]) );
  smpp_middle dPPM51 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[133]) );
  smpp_middle dPPM52 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[144]) );
  smpp_middle dPPM53 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[157]) );
  smpp_middle dPPM54 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[169]) );
  smpp_middle dPPM55 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[183]) );
  smpp_middle dPPM56 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[196]) );
  smpp_middle dPPM57 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[211]) );
  smpp_middle dPPM58 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[225]) );
  smpp_middle dPPM59 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[241]) );
  smpp_middle dPPM60 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[256]) );
  smpp_middle dPPM61 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[273]) );
  smpp_middle dPPM62 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[289]) );
  smpp_middle dPPM63 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[307]) );
  smpp_middle dPPM64 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[325]) );
  smpp_middle dPPM65 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[341]) );
  assign SUMMAND[342] = LOGIC_ONE;
  smpp_high dPPH1 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[4]), .TWONEG (INT_MULTIPLIER[5]), .ONEPOS (INT_MULTIPLIER[6]), .ONENEG (INT_MULTIPLIER[7]), .PPBIT (SUMMAND[358]) );
  smdecoder dDEC2 (.INA (OPB[3]), .INB (OPB[4]), .INC (OPB[5]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]) );
  smpp_low dPPL2 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[10]) );
  smr_gate dRGATE2 (.INA (OPB[3]), .INB (OPB[4]), .INC (OPB[5]), .PPBIT (SUMMAND[11]) );
  smpp_middle dPPM66 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[14]) );
  smpp_middle dPPM67 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[17]) );
  smpp_middle dPPM68 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[22]) );
  smpp_middle dPPM69 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[26]) );
  smpp_middle dPPM70 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[32]) );
  smpp_middle dPPM71 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[37]) );
  smpp_middle dPPM72 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[44]) );
  smpp_middle dPPM73 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[50]) );
  smpp_middle dPPM74 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[58]) );
  smpp_middle dPPM75 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[65]) );
  smpp_middle dPPM76 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[74]) );
  smpp_middle dPPM77 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[82]) );
  smpp_middle dPPM78 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[92]) );
  smpp_middle dPPM79 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[101]) );
  smpp_middle dPPM80 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[112]) );
  smpp_middle dPPM81 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[122]) );
  smpp_middle dPPM82 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[134]) );
  smpp_middle dPPM83 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[145]) );
  smpp_middle dPPM84 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[158]) );
  smpp_middle dPPM85 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[170]) );
  smpp_middle dPPM86 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[184]) );
  smpp_middle dPPM87 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[197]) );
  smpp_middle dPPM88 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[212]) );
  smpp_middle dPPM89 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[226]) );
  smpp_middle dPPM90 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[242]) );
  smpp_middle dPPM91 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[257]) );
  smpp_middle dPPM92 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[274]) );
  smpp_middle dPPM93 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[290]) );
  smpp_middle dPPM94 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[308]) );
  smpp_middle dPPM95 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[326]) );
  smpp_middle dPPM96 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[343]) );
  smpp_middle dPPM97 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[359]) );
  smpp_middle dPPM98 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[374]) );
  assign SUMMAND[375] = LOGIC_ONE;
  smpp_high dPPH2 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[8]), .TWONEG (INT_MULTIPLIER[9]), .ONEPOS (INT_MULTIPLIER[10]), .ONENEG (INT_MULTIPLIER[11]), .PPBIT (SUMMAND[390]) );
  smdecoder dDEC3 (.INA (OPB[5]), .INB (OPB[6]), .INC (OPB[7]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]) );
  smpp_low dPPL3 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[18]) );
  smr_gate dRGATE3 (.INA (OPB[5]), .INB (OPB[6]), .INC (OPB[7]), .PPBIT (SUMMAND[19]) );
  smpp_middle dPPM99 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[23]) );
  smpp_middle dPPM100 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[27]) );
  smpp_middle dPPM101 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[33]) );
  smpp_middle dPPM102 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[38]) );
  smpp_middle dPPM103 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[45]) );
  smpp_middle dPPM104 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[51]) );
  smpp_middle dPPM105 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[59]) );
  smpp_middle dPPM106 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[66]) );
  smpp_middle dPPM107 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[75]) );
  smpp_middle dPPM108 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[83]) );
  smpp_middle dPPM109 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[93]) );
  smpp_middle dPPM110 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[102]) );
  smpp_middle dPPM111 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[113]) );
  smpp_middle dPPM112 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[123]) );
  smpp_middle dPPM113 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[135]) );
  smpp_middle dPPM114 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[146]) );
  smpp_middle dPPM115 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[159]) );
  smpp_middle dPPM116 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[171]) );
  smpp_middle dPPM117 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[185]) );
  smpp_middle dPPM118 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[198]) );
  smpp_middle dPPM119 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[213]) );
  smpp_middle dPPM120 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[227]) );
  smpp_middle dPPM121 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[243]) );
  smpp_middle dPPM122 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[258]) );
  smpp_middle dPPM123 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[275]) );
  smpp_middle dPPM124 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[291]) );
  smpp_middle dPPM125 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[309]) );
  smpp_middle dPPM126 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[327]) );
  smpp_middle dPPM127 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[344]) );
  smpp_middle dPPM128 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[360]) );
  smpp_middle dPPM129 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[376]) );
  smpp_middle dPPM130 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[391]) );
  smpp_middle dPPM131 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[405]) );
  assign SUMMAND[406] = LOGIC_ONE;
  smpp_high dPPH3 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[12]), .TWONEG (INT_MULTIPLIER[13]), .ONEPOS (INT_MULTIPLIER[14]), .ONENEG (INT_MULTIPLIER[15]), .PPBIT (SUMMAND[420]) );
  smdecoder dDEC4 (.INA (OPB[7]), .INB (OPB[8]), .INC (OPB[9]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]) );
  smpp_low dPPL4 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[28]) );
  smr_gate dRGATE4 (.INA (OPB[7]), .INB (OPB[8]), .INC (OPB[9]), .PPBIT (SUMMAND[29]) );
  smpp_middle dPPM132 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[34]) );
  smpp_middle dPPM133 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[39]) );
  smpp_middle dPPM134 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[46]) );
  smpp_middle dPPM135 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[52]) );
  smpp_middle dPPM136 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[60]) );
  smpp_middle dPPM137 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[67]) );
  smpp_middle dPPM138 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[76]) );
  smpp_middle dPPM139 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[84]) );
  smpp_middle dPPM140 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[94]) );
  smpp_middle dPPM141 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[103]) );
  smpp_middle dPPM142 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[114]) );
  smpp_middle dPPM143 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[124]) );
  smpp_middle dPPM144 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[136]) );
  smpp_middle dPPM145 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[147]) );
  smpp_middle dPPM146 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[160]) );
  smpp_middle dPPM147 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[172]) );
  smpp_middle dPPM148 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[186]) );
  smpp_middle dPPM149 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[199]) );
  smpp_middle dPPM150 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[214]) );
  smpp_middle dPPM151 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[228]) );
  smpp_middle dPPM152 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[244]) );
  smpp_middle dPPM153 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[259]) );
  smpp_middle dPPM154 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[276]) );
  smpp_middle dPPM155 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[292]) );
  smpp_middle dPPM156 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[310]) );
  smpp_middle dPPM157 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[328]) );
  smpp_middle dPPM158 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[345]) );
  smpp_middle dPPM159 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[361]) );
  smpp_middle dPPM160 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[377]) );
  smpp_middle dPPM161 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[392]) );
  smpp_middle dPPM162 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[407]) );
  smpp_middle dPPM163 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[421]) );
  smpp_middle dPPM164 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[434]) );
  assign SUMMAND[435] = LOGIC_ONE;
  smpp_high dPPH4 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[16]), .TWONEG (INT_MULTIPLIER[17]), .ONEPOS (INT_MULTIPLIER[18]), .ONENEG (INT_MULTIPLIER[19]), .PPBIT (SUMMAND[448]) );
  smdecoder dDEC5 (.INA (OPB[9]), .INB (OPB[10]), .INC (OPB[11]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]) );
  smpp_low dPPL5 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[40]) );
  smr_gate dRGATE5 (.INA (OPB[9]), .INB (OPB[10]), .INC (OPB[11]), .PPBIT (SUMMAND[41]) );
  smpp_middle dPPM165 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[47]) );
  smpp_middle dPPM166 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[53]) );
  smpp_middle dPPM167 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[61]) );
  smpp_middle dPPM168 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[68]) );
  smpp_middle dPPM169 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[77]) );
  smpp_middle dPPM170 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[85]) );
  smpp_middle dPPM171 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[95]) );
  smpp_middle dPPM172 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[104]) );
  smpp_middle dPPM173 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[115]) );
  smpp_middle dPPM174 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[125]) );
  smpp_middle dPPM175 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[137]) );
  smpp_middle dPPM176 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[148]) );
  smpp_middle dPPM177 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[161]) );
  smpp_middle dPPM178 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[173]) );
  smpp_middle dPPM179 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[187]) );
  smpp_middle dPPM180 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[200]) );
  smpp_middle dPPM181 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[215]) );
  smpp_middle dPPM182 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[229]) );
  smpp_middle dPPM183 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[245]) );
  smpp_middle dPPM184 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[260]) );
  smpp_middle dPPM185 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[277]) );
  smpp_middle dPPM186 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[293]) );
  smpp_middle dPPM187 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[311]) );
  smpp_middle dPPM188 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[329]) );
  smpp_middle dPPM189 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[346]) );
  smpp_middle dPPM190 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[362]) );
  smpp_middle dPPM191 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[378]) );
  smpp_middle dPPM192 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[393]) );
  smpp_middle dPPM193 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[408]) );
  smpp_middle dPPM194 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[422]) );
  smpp_middle dPPM195 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[436]) );
  smpp_middle dPPM196 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[449]) );
  smpp_middle dPPM197 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[461]) );
  assign SUMMAND[462] = LOGIC_ONE;
  smpp_high dPPH5 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[20]), .TWONEG (INT_MULTIPLIER[21]), .ONEPOS (INT_MULTIPLIER[22]), .ONENEG (INT_MULTIPLIER[23]), .PPBIT (SUMMAND[474]) );
  smdecoder dDEC6 (.INA (OPB[11]), .INB (OPB[12]), .INC (OPB[13]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]) );
  smpp_low dPPL6 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[54]) );
  smr_gate dRGATE6 (.INA (OPB[11]), .INB (OPB[12]), .INC (OPB[13]), .PPBIT (SUMMAND[55]) );
  smpp_middle dPPM198 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[62]) );
  smpp_middle dPPM199 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[69]) );
  smpp_middle dPPM200 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[78]) );
  smpp_middle dPPM201 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[86]) );
  smpp_middle dPPM202 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[96]) );
  smpp_middle dPPM203 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[105]) );
  smpp_middle dPPM204 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[116]) );
  smpp_middle dPPM205 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[126]) );
  smpp_middle dPPM206 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[138]) );
  smpp_middle dPPM207 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[149]) );
  smpp_middle dPPM208 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[162]) );
  smpp_middle dPPM209 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[174]) );
  smpp_middle dPPM210 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[188]) );
  smpp_middle dPPM211 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[201]) );
  smpp_middle dPPM212 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[216]) );
  smpp_middle dPPM213 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[230]) );
  smpp_middle dPPM214 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[246]) );
  smpp_middle dPPM215 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[261]) );
  smpp_middle dPPM216 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[278]) );
  smpp_middle dPPM217 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[294]) );
  smpp_middle dPPM218 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[312]) );
  smpp_middle dPPM219 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[330]) );
  smpp_middle dPPM220 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[347]) );
  smpp_middle dPPM221 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[363]) );
  smpp_middle dPPM222 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[379]) );
  smpp_middle dPPM223 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[394]) );
  smpp_middle dPPM224 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[409]) );
  smpp_middle dPPM225 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[423]) );
  smpp_middle dPPM226 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[437]) );
  smpp_middle dPPM227 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[450]) );
  smpp_middle dPPM228 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[463]) );
  smpp_middle dPPM229 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[475]) );
  smpp_middle dPPM230 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[486]) );
  assign SUMMAND[487] = LOGIC_ONE;
  smpp_high dPPH6 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[24]), .TWONEG (INT_MULTIPLIER[25]), .ONEPOS (INT_MULTIPLIER[26]), .ONENEG (INT_MULTIPLIER[27]), .PPBIT (SUMMAND[498]) );
  smdecoder dDEC7 (.INA (OPB[13]), .INB (OPB[14]), .INC (OPB[15]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]) );
  smpp_low dPPL7 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[70]) );
  smr_gate dRGATE7 (.INA (OPB[13]), .INB (OPB[14]), .INC (OPB[15]), .PPBIT (SUMMAND[71]) );
  smpp_middle dPPM231 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[79]) );
  smpp_middle dPPM232 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[87]) );
  smpp_middle dPPM233 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[97]) );
  smpp_middle dPPM234 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[106]) );
  smpp_middle dPPM235 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[117]) );
  smpp_middle dPPM236 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[127]) );
  smpp_middle dPPM237 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[139]) );
  smpp_middle dPPM238 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[150]) );
  smpp_middle dPPM239 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[163]) );
  smpp_middle dPPM240 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[175]) );
  smpp_middle dPPM241 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[189]) );
  smpp_middle dPPM242 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[202]) );
  smpp_middle dPPM243 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[217]) );
  smpp_middle dPPM244 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[231]) );
  smpp_middle dPPM245 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[247]) );
  smpp_middle dPPM246 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[262]) );
  smpp_middle dPPM247 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[279]) );
  smpp_middle dPPM248 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[295]) );
  smpp_middle dPPM249 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[313]) );
  smpp_middle dPPM250 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[331]) );
  smpp_middle dPPM251 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[348]) );
  smpp_middle dPPM252 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[364]) );
  smpp_middle dPPM253 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[380]) );
  smpp_middle dPPM254 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[395]) );
  smpp_middle dPPM255 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[410]) );
  smpp_middle dPPM256 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[424]) );
  smpp_middle dPPM257 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[438]) );
  smpp_middle dPPM258 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[451]) );
  smpp_middle dPPM259 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[464]) );
  smpp_middle dPPM260 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[476]) );
  smpp_middle dPPM261 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[488]) );
  smpp_middle dPPM262 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[499]) );
  smpp_middle dPPM263 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[509]) );
  assign SUMMAND[510] = LOGIC_ONE;
  smpp_high dPPH7 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[28]), .TWONEG (INT_MULTIPLIER[29]), .ONEPOS (INT_MULTIPLIER[30]), .ONENEG (INT_MULTIPLIER[31]), .PPBIT (SUMMAND[520]) );
  smdecoder dDEC8 (.INA (OPB[15]), .INB (OPB[16]), .INC (OPB[17]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]) );
  smpp_low dPPL8 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[88]) );
  smr_gate dRGATE8 (.INA (OPB[15]), .INB (OPB[16]), .INC (OPB[17]), .PPBIT (SUMMAND[89]) );
  smpp_middle dPPM264 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[98]) );
  smpp_middle dPPM265 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[107]) );
  smpp_middle dPPM266 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[118]) );
  smpp_middle dPPM267 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[128]) );
  smpp_middle dPPM268 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[140]) );
  smpp_middle dPPM269 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[151]) );
  smpp_middle dPPM270 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[164]) );
  smpp_middle dPPM271 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[176]) );
  smpp_middle dPPM272 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[190]) );
  smpp_middle dPPM273 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[203]) );
  smpp_middle dPPM274 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[218]) );
  smpp_middle dPPM275 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[232]) );
  smpp_middle dPPM276 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[248]) );
  smpp_middle dPPM277 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[263]) );
  smpp_middle dPPM278 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[280]) );
  smpp_middle dPPM279 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[296]) );
  smpp_middle dPPM280 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[314]) );
  smpp_middle dPPM281 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[332]) );
  smpp_middle dPPM282 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[349]) );
  smpp_middle dPPM283 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[365]) );
  smpp_middle dPPM284 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[381]) );
  smpp_middle dPPM285 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[396]) );
  smpp_middle dPPM286 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[411]) );
  smpp_middle dPPM287 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[425]) );
  smpp_middle dPPM288 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[439]) );
  smpp_middle dPPM289 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[452]) );
  smpp_middle dPPM290 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[465]) );
  smpp_middle dPPM291 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[477]) );
  smpp_middle dPPM292 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[489]) );
  smpp_middle dPPM293 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[500]) );
  smpp_middle dPPM294 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[511]) );
  smpp_middle dPPM295 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[521]) );
  smpp_middle dPPM296 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[530]) );
  assign SUMMAND[531] = LOGIC_ONE;
  smpp_high dPPH8 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[32]), .TWONEG (INT_MULTIPLIER[33]), .ONEPOS (INT_MULTIPLIER[34]), .ONENEG (INT_MULTIPLIER[35]), .PPBIT (SUMMAND[540]) );
  smdecoder dDEC9 (.INA (OPB[17]), .INB (OPB[18]), .INC (OPB[19]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]) );
  smpp_low dPPL9 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[108]) );
  smr_gate dRGATE9 (.INA (OPB[17]), .INB (OPB[18]), .INC (OPB[19]), .PPBIT (SUMMAND[109]) );
  smpp_middle dPPM297 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[119]) );
  smpp_middle dPPM298 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[129]) );
  smpp_middle dPPM299 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[141]) );
  smpp_middle dPPM300 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[152]) );
  smpp_middle dPPM301 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[165]) );
  smpp_middle dPPM302 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[177]) );
  smpp_middle dPPM303 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[191]) );
  smpp_middle dPPM304 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[204]) );
  smpp_middle dPPM305 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[219]) );
  smpp_middle dPPM306 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[233]) );
  smpp_middle dPPM307 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[249]) );
  smpp_middle dPPM308 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[264]) );
  smpp_middle dPPM309 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[281]) );
  smpp_middle dPPM310 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[297]) );
  smpp_middle dPPM311 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[315]) );
  smpp_middle dPPM312 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[333]) );
  smpp_middle dPPM313 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[350]) );
  smpp_middle dPPM314 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[366]) );
  smpp_middle dPPM315 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[382]) );
  smpp_middle dPPM316 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[397]) );
  smpp_middle dPPM317 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[412]) );
  smpp_middle dPPM318 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[426]) );
  smpp_middle dPPM319 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[440]) );
  smpp_middle dPPM320 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[453]) );
  smpp_middle dPPM321 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[466]) );
  smpp_middle dPPM322 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[478]) );
  smpp_middle dPPM323 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[490]) );
  smpp_middle dPPM324 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[501]) );
  smpp_middle dPPM325 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[512]) );
  smpp_middle dPPM326 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[522]) );
  smpp_middle dPPM327 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[532]) );
  smpp_middle dPPM328 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[541]) );
  smpp_middle dPPM329 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[549]) );
  assign SUMMAND[550] = LOGIC_ONE;
  smpp_high dPPH9 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[36]), .TWONEG (INT_MULTIPLIER[37]), .ONEPOS (INT_MULTIPLIER[38]), .ONENEG (INT_MULTIPLIER[39]), .PPBIT (SUMMAND[558]) );
  smdecoder dDEC10 (.INA (OPB[19]), .INB (OPB[20]), .INC (OPB[21]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]) );
  smpp_low dPPL10 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[130]) );
  smr_gate dRGATE10 (.INA (OPB[19]), .INB (OPB[20]), .INC (OPB[21]), .PPBIT (SUMMAND[131]) );
  smpp_middle dPPM330 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[142]) );
  smpp_middle dPPM331 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[153]) );
  smpp_middle dPPM332 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[166]) );
  smpp_middle dPPM333 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[178]) );
  smpp_middle dPPM334 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[192]) );
  smpp_middle dPPM335 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[205]) );
  smpp_middle dPPM336 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[220]) );
  smpp_middle dPPM337 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[234]) );
  smpp_middle dPPM338 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[250]) );
  smpp_middle dPPM339 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[265]) );
  smpp_middle dPPM340 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[282]) );
  smpp_middle dPPM341 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[298]) );
  smpp_middle dPPM342 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[316]) );
  smpp_middle dPPM343 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[334]) );
  smpp_middle dPPM344 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[351]) );
  smpp_middle dPPM345 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[367]) );
  smpp_middle dPPM346 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[383]) );
  smpp_middle dPPM347 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[398]) );
  smpp_middle dPPM348 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[413]) );
  smpp_middle dPPM349 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[427]) );
  smpp_middle dPPM350 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[441]) );
  smpp_middle dPPM351 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[454]) );
  smpp_middle dPPM352 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[467]) );
  smpp_middle dPPM353 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[479]) );
  smpp_middle dPPM354 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[491]) );
  smpp_middle dPPM355 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[502]) );
  smpp_middle dPPM356 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[513]) );
  smpp_middle dPPM357 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[523]) );
  smpp_middle dPPM358 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[533]) );
  smpp_middle dPPM359 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[542]) );
  smpp_middle dPPM360 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[551]) );
  smpp_middle dPPM361 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[559]) );
  smpp_middle dPPM362 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[566]) );
  assign SUMMAND[567] = LOGIC_ONE;
  smpp_high dPPH10 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[40]), .TWONEG (INT_MULTIPLIER[41]), .ONEPOS (INT_MULTIPLIER[42]), .ONENEG (INT_MULTIPLIER[43]), .PPBIT (SUMMAND[574]) );
  smdecoder dDEC11 (.INA (OPB[21]), .INB (OPB[22]), .INC (OPB[23]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]) );
  smpp_low dPPL11 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[154]) );
  smr_gate dRGATE11 (.INA (OPB[21]), .INB (OPB[22]), .INC (OPB[23]), .PPBIT (SUMMAND[155]) );
  smpp_middle dPPM363 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[167]) );
  smpp_middle dPPM364 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[179]) );
  smpp_middle dPPM365 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[193]) );
  smpp_middle dPPM366 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[206]) );
  smpp_middle dPPM367 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[221]) );
  smpp_middle dPPM368 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[235]) );
  smpp_middle dPPM369 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[251]) );
  smpp_middle dPPM370 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[266]) );
  smpp_middle dPPM371 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[283]) );
  smpp_middle dPPM372 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[299]) );
  smpp_middle dPPM373 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[317]) );
  smpp_middle dPPM374 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[335]) );
  smpp_middle dPPM375 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[352]) );
  smpp_middle dPPM376 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[368]) );
  smpp_middle dPPM377 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[384]) );
  smpp_middle dPPM378 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[399]) );
  smpp_middle dPPM379 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[414]) );
  smpp_middle dPPM380 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[428]) );
  smpp_middle dPPM381 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[442]) );
  smpp_middle dPPM382 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[455]) );
  smpp_middle dPPM383 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[468]) );
  smpp_middle dPPM384 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[480]) );
  smpp_middle dPPM385 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[492]) );
  smpp_middle dPPM386 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[503]) );
  smpp_middle dPPM387 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[514]) );
  smpp_middle dPPM388 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[524]) );
  smpp_middle dPPM389 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[534]) );
  smpp_middle dPPM390 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[543]) );
  smpp_middle dPPM391 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[552]) );
  smpp_middle dPPM392 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[560]) );
  smpp_middle dPPM393 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[568]) );
  smpp_middle dPPM394 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[575]) );
  smpp_middle dPPM395 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[581]) );
  assign SUMMAND[582] = LOGIC_ONE;
  smpp_high dPPH11 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[44]), .TWONEG (INT_MULTIPLIER[45]), .ONEPOS (INT_MULTIPLIER[46]), .ONENEG (INT_MULTIPLIER[47]), .PPBIT (SUMMAND[588]) );
  smdecoder dDEC12 (.INA (OPB[23]), .INB (OPB[24]), .INC (OPB[25]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]) );
  smpp_low dPPL12 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[180]) );
  smr_gate dRGATE12 (.INA (OPB[23]), .INB (OPB[24]), .INC (OPB[25]), .PPBIT (SUMMAND[181]) );
  smpp_middle dPPM396 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[194]) );
  smpp_middle dPPM397 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[207]) );
  smpp_middle dPPM398 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[222]) );
  smpp_middle dPPM399 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[236]) );
  smpp_middle dPPM400 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[252]) );
  smpp_middle dPPM401 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[267]) );
  smpp_middle dPPM402 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[284]) );
  smpp_middle dPPM403 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[300]) );
  smpp_middle dPPM404 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[318]) );
  smpp_middle dPPM405 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[336]) );
  smpp_middle dPPM406 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[353]) );
  smpp_middle dPPM407 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[369]) );
  smpp_middle dPPM408 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[385]) );
  smpp_middle dPPM409 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[400]) );
  smpp_middle dPPM410 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[415]) );
  smpp_middle dPPM411 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[429]) );
  smpp_middle dPPM412 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[443]) );
  smpp_middle dPPM413 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[456]) );
  smpp_middle dPPM414 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[469]) );
  smpp_middle dPPM415 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[481]) );
  smpp_middle dPPM416 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[493]) );
  smpp_middle dPPM417 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[504]) );
  smpp_middle dPPM418 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[515]) );
  smpp_middle dPPM419 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[525]) );
  smpp_middle dPPM420 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[535]) );
  smpp_middle dPPM421 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[544]) );
  smpp_middle dPPM422 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[553]) );
  smpp_middle dPPM423 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[561]) );
  smpp_middle dPPM424 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[569]) );
  smpp_middle dPPM425 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[576]) );
  smpp_middle dPPM426 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[583]) );
  smpp_middle dPPM427 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[589]) );
  smpp_middle dPPM428 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[594]) );
  assign SUMMAND[595] = LOGIC_ONE;
  smpp_high dPPH12 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[48]), .TWONEG (INT_MULTIPLIER[49]), .ONEPOS (INT_MULTIPLIER[50]), .ONENEG (INT_MULTIPLIER[51]), .PPBIT (SUMMAND[600]) );
  smdecoder dDEC13 (.INA (OPB[25]), .INB (OPB[26]), .INC (OPB[27]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]) );
  smpp_low dPPL13 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[208]) );
  smr_gate dRGATE13 (.INA (OPB[25]), .INB (OPB[26]), .INC (OPB[27]), .PPBIT (SUMMAND[209]) );
  smpp_middle dPPM429 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[223]) );
  smpp_middle dPPM430 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[237]) );
  smpp_middle dPPM431 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[253]) );
  smpp_middle dPPM432 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[268]) );
  smpp_middle dPPM433 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[285]) );
  smpp_middle dPPM434 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[301]) );
  smpp_middle dPPM435 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[319]) );
  smpp_middle dPPM436 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[337]) );
  smpp_middle dPPM437 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[354]) );
  smpp_middle dPPM438 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[370]) );
  smpp_middle dPPM439 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[386]) );
  smpp_middle dPPM440 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[401]) );
  smpp_middle dPPM441 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[416]) );
  smpp_middle dPPM442 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[430]) );
  smpp_middle dPPM443 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[444]) );
  smpp_middle dPPM444 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[457]) );
  smpp_middle dPPM445 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[470]) );
  smpp_middle dPPM446 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[482]) );
  smpp_middle dPPM447 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[494]) );
  smpp_middle dPPM448 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[505]) );
  smpp_middle dPPM449 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[516]) );
  smpp_middle dPPM450 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[526]) );
  smpp_middle dPPM451 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[536]) );
  smpp_middle dPPM452 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[545]) );
  smpp_middle dPPM453 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[554]) );
  smpp_middle dPPM454 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[562]) );
  smpp_middle dPPM455 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[570]) );
  smpp_middle dPPM456 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[577]) );
  smpp_middle dPPM457 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[584]) );
  smpp_middle dPPM458 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[590]) );
  smpp_middle dPPM459 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[596]) );
  smpp_middle dPPM460 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[601]) );
  smpp_middle dPPM461 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[605]) );
  assign SUMMAND[606] = LOGIC_ONE;
  smpp_high dPPH13 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[52]), .TWONEG (INT_MULTIPLIER[53]), .ONEPOS (INT_MULTIPLIER[54]), .ONENEG (INT_MULTIPLIER[55]), .PPBIT (SUMMAND[610]) );
  smdecoder dDEC14 (.INA (OPB[27]), .INB (OPB[28]), .INC (OPB[29]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]) );
  smpp_low dPPL14 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[238]) );
  smr_gate dRGATE14 (.INA (OPB[27]), .INB (OPB[28]), .INC (OPB[29]), .PPBIT (SUMMAND[239]) );
  smpp_middle dPPM462 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[254]) );
  smpp_middle dPPM463 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[269]) );
  smpp_middle dPPM464 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[286]) );
  smpp_middle dPPM465 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[302]) );
  smpp_middle dPPM466 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[320]) );
  smpp_middle dPPM467 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[338]) );
  smpp_middle dPPM468 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[355]) );
  smpp_middle dPPM469 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[371]) );
  smpp_middle dPPM470 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[387]) );
  smpp_middle dPPM471 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[402]) );
  smpp_middle dPPM472 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[417]) );
  smpp_middle dPPM473 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[431]) );
  smpp_middle dPPM474 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[445]) );
  smpp_middle dPPM475 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[458]) );
  smpp_middle dPPM476 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[471]) );
  smpp_middle dPPM477 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[483]) );
  smpp_middle dPPM478 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[495]) );
  smpp_middle dPPM479 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[506]) );
  smpp_middle dPPM480 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[517]) );
  smpp_middle dPPM481 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[527]) );
  smpp_middle dPPM482 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[537]) );
  smpp_middle dPPM483 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[546]) );
  smpp_middle dPPM484 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[555]) );
  smpp_middle dPPM485 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[563]) );
  smpp_middle dPPM486 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[571]) );
  smpp_middle dPPM487 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[578]) );
  smpp_middle dPPM488 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[585]) );
  smpp_middle dPPM489 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[591]) );
  smpp_middle dPPM490 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[597]) );
  smpp_middle dPPM491 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[602]) );
  smpp_middle dPPM492 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[607]) );
  smpp_middle dPPM493 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[611]) );
  smpp_middle dPPM494 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[614]) );
  assign SUMMAND[615] = LOGIC_ONE;
  smpp_high dPPH14 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[56]), .TWONEG (INT_MULTIPLIER[57]), .ONEPOS (INT_MULTIPLIER[58]), .ONENEG (INT_MULTIPLIER[59]), .PPBIT (SUMMAND[618]) );
  smdecoder dDEC15 (.INA (OPB[29]), .INB (OPB[30]), .INC (OPB[31]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]) );
  smpp_low dPPL15 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[270]) );
  smr_gate dRGATE15 (.INA (OPB[29]), .INB (OPB[30]), .INC (OPB[31]), .PPBIT (SUMMAND[271]) );
  smpp_middle dPPM495 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[287]) );
  smpp_middle dPPM496 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[303]) );
  smpp_middle dPPM497 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[321]) );
  smpp_middle dPPM498 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[339]) );
  smpp_middle dPPM499 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[356]) );
  smpp_middle dPPM500 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[372]) );
  smpp_middle dPPM501 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[388]) );
  smpp_middle dPPM502 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[403]) );
  smpp_middle dPPM503 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[418]) );
  smpp_middle dPPM504 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[432]) );
  smpp_middle dPPM505 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[446]) );
  smpp_middle dPPM506 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[459]) );
  smpp_middle dPPM507 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[472]) );
  smpp_middle dPPM508 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[484]) );
  smpp_middle dPPM509 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[496]) );
  smpp_middle dPPM510 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[507]) );
  smpp_middle dPPM511 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[518]) );
  smpp_middle dPPM512 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[528]) );
  smpp_middle dPPM513 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[538]) );
  smpp_middle dPPM514 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[547]) );
  smpp_middle dPPM515 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[556]) );
  smpp_middle dPPM516 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[564]) );
  smpp_middle dPPM517 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[572]) );
  smpp_middle dPPM518 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[579]) );
  smpp_middle dPPM519 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[586]) );
  smpp_middle dPPM520 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[592]) );
  smpp_middle dPPM521 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[598]) );
  smpp_middle dPPM522 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[603]) );
  smpp_middle dPPM523 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[608]) );
  smpp_middle dPPM524 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[612]) );
  smpp_middle dPPM525 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[616]) );
  smpp_middle dPPM526 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[619]) );
  smpp_middle dPPM527 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[621]) );
  assign SUMMAND[622] = LOGIC_ONE;
  smpp_high dPPH15 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[60]), .TWONEG (INT_MULTIPLIER[61]), .ONEPOS (INT_MULTIPLIER[62]), .ONENEG (INT_MULTIPLIER[63]), .PPBIT (SUMMAND[624]) );
  smdecoder dDEC16 (.INA (OPB[31]), .INB (OPB[32]), .INC (OPB[33]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]) );
  smpp_low dPPL16 (.INA (OPA[0]), .INB (OPA_[0]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[304]) );
  smr_gate dRGATE16 (.INA (OPB[31]), .INB (OPB[32]), .INC (OPB[33]), .PPBIT (SUMMAND[305]) );
  smpp_middle dPPM528 (.INA (OPA[0]), .INB (OPA_[0]), .INC (OPA[1]), .IND (OPA_[1]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[322]) );
  smpp_middle dPPM529 (.INA (OPA[1]), .INB (OPA_[1]), .INC (OPA[2]), .IND (OPA_[2]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[340]) );
  smpp_middle dPPM530 (.INA (OPA[2]), .INB (OPA_[2]), .INC (OPA[3]), .IND (OPA_[3]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[357]) );
  smpp_middle dPPM531 (.INA (OPA[3]), .INB (OPA_[3]), .INC (OPA[4]), .IND (OPA_[4]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[373]) );
  smpp_middle dPPM532 (.INA (OPA[4]), .INB (OPA_[4]), .INC (OPA[5]), .IND (OPA_[5]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[389]) );
  smpp_middle dPPM533 (.INA (OPA[5]), .INB (OPA_[5]), .INC (OPA[6]), .IND (OPA_[6]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[404]) );
  smpp_middle dPPM534 (.INA (OPA[6]), .INB (OPA_[6]), .INC (OPA[7]), .IND (OPA_[7]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[419]) );
  smpp_middle dPPM535 (.INA (OPA[7]), .INB (OPA_[7]), .INC (OPA[8]), .IND (OPA_[8]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[433]) );
  smpp_middle dPPM536 (.INA (OPA[8]), .INB (OPA_[8]), .INC (OPA[9]), .IND (OPA_[9]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[447]) );
  smpp_middle dPPM537 (.INA (OPA[9]), .INB (OPA_[9]), .INC (OPA[10]), .IND (OPA_[10]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[460]) );
  smpp_middle dPPM538 (.INA (OPA[10]), .INB (OPA_[10]), .INC (OPA[11]), .IND (OPA_[11]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[473]) );
  smpp_middle dPPM539 (.INA (OPA[11]), .INB (OPA_[11]), .INC (OPA[12]), .IND (OPA_[12]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[485]) );
  smpp_middle dPPM540 (.INA (OPA[12]), .INB (OPA_[12]), .INC (OPA[13]), .IND (OPA_[13]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[497]) );
  smpp_middle dPPM541 (.INA (OPA[13]), .INB (OPA_[13]), .INC (OPA[14]), .IND (OPA_[14]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[508]) );
  smpp_middle dPPM542 (.INA (OPA[14]), .INB (OPA_[14]), .INC (OPA[15]), .IND (OPA_[15]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[519]) );
  smpp_middle dPPM543 (.INA (OPA[15]), .INB (OPA_[15]), .INC (OPA[16]), .IND (OPA_[16]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[529]) );
  smpp_middle dPPM544 (.INA (OPA[16]), .INB (OPA_[16]), .INC (OPA[17]), .IND (OPA_[17]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[539]) );
  smpp_middle dPPM545 (.INA (OPA[17]), .INB (OPA_[17]), .INC (OPA[18]), .IND (OPA_[18]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[548]) );
  smpp_middle dPPM546 (.INA (OPA[18]), .INB (OPA_[18]), .INC (OPA[19]), .IND (OPA_[19]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[557]) );
  smpp_middle dPPM547 (.INA (OPA[19]), .INB (OPA_[19]), .INC (OPA[20]), .IND (OPA_[20]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[565]) );
  smpp_middle dPPM548 (.INA (OPA[20]), .INB (OPA_[20]), .INC (OPA[21]), .IND (OPA_[21]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[573]) );
  smpp_middle dPPM549 (.INA (OPA[21]), .INB (OPA_[21]), .INC (OPA[22]), .IND (OPA_[22]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[580]) );
  smpp_middle dPPM550 (.INA (OPA[22]), .INB (OPA_[22]), .INC (OPA[23]), .IND (OPA_[23]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[587]) );
  smpp_middle dPPM551 (.INA (OPA[23]), .INB (OPA_[23]), .INC (OPA[24]), .IND (OPA_[24]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[593]) );
  smpp_middle dPPM552 (.INA (OPA[24]), .INB (OPA_[24]), .INC (OPA[25]), .IND (OPA_[25]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[599]) );
  smpp_middle dPPM553 (.INA (OPA[25]), .INB (OPA_[25]), .INC (OPA[26]), .IND (OPA_[26]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[604]) );
  smpp_middle dPPM554 (.INA (OPA[26]), .INB (OPA_[26]), .INC (OPA[27]), .IND (OPA_[27]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[609]) );
  smpp_middle dPPM555 (.INA (OPA[27]), .INB (OPA_[27]), .INC (OPA[28]), .IND (OPA_[28]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[613]) );
  smpp_middle dPPM556 (.INA (OPA[28]), .INB (OPA_[28]), .INC (OPA[29]), .IND (OPA_[29]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[617]) );
  smpp_middle dPPM557 (.INA (OPA[29]), .INB (OPA_[29]), .INC (OPA[30]), .IND (OPA_[30]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[620]) );
  smpp_middle dPPM558 (.INA (OPA[30]), .INB (OPA_[30]), .INC (OPA[31]), .IND (OPA_[31]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[623]) );
  smpp_middle dPPM559 (.INA (OPA[31]), .INB (OPA_[31]), .INC (OPA[32]), .IND (OPA_[32]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[625]) );
  smpp_middle dPPM560 (.INA (OPA[32]), .INB (OPA_[32]), .INC (OPA[33]), .IND (OPA_[33]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[626]) );
  assign SUMMAND[627] = LOGIC_ONE;
  smpp_high dPPH16 (.INA (OPA[33]), .INB (OPA_[33]), .TWOPOS (INT_MULTIPLIER[64]), .TWONEG (INT_MULTIPLIER[65]), .ONEPOS (INT_MULTIPLIER[66]), .ONENEG (INT_MULTIPLIER[67]), .PPBIT (SUMMAND[628]) );
endmodule

// Simple cells

module smpp_low (ONEPOS, ONENEG, TWONEG, INA, INB, PPBIT);
  input ONEPOS;
  input ONENEG;
  input TWONEG;
  input INA;
  input INB;
  output PPBIT;
  assign PPBIT = (ONEPOS & INA) | (ONENEG & INB) | TWONEG;
endmodule

module smpp_middle (ONEPOS, ONENEG, TWOPOS, TWONEG, INA, INB, INC, IND, PPBIT);
  input ONEPOS;
  input ONENEG;
  input TWOPOS;
  input TWONEG;
  input INA;
  input INB;
  input INC;
  input IND;
  output PPBIT;
  assign PPBIT = ~ ((~ (INA & TWOPOS)) & (~ (INB & TWONEG)) & (~ (INC & ONEPOS)) & (~ (IND & ONENEG)));
endmodule

module smpp_high (ONEPOS, ONENEG, TWOPOS, TWONEG, INA, INB, PPBIT);
  input ONEPOS;
  input ONENEG;
  input TWOPOS;
  input TWONEG;
  input INA;
  input INB;
  output PPBIT;
  assign PPBIT = ~ ((INA & ONEPOS) | (INB & ONENEG) | (INA & TWOPOS) | (INB & TWONEG));
endmodule

module smr_gate (INA, INB, INC, PPBIT);
  input INA;
  input INB;
  input INC;
  output PPBIT;
  assign PPBIT = (~ (INA & INB)) & INC;
endmodule

module smdecoder (INA, INB, INC, TWOPOS, TWONEG, ONEPOS, ONENEG);
  input INA;
  input INB;
  input INC;
  output TWOPOS;
  output TWONEG;
  output ONEPOS;
  output ONENEG;
  assign TWOPOS = ~ (~ (INA & INB & (~ INC)));
  assign TWONEG = ~ (~ ((~ INA) & (~ INB) & INC));
  assign ONEPOS = ((~ INA) & INB & (~ INC)) | ((~ INC) & (~ INB) & INA);
  assign ONENEG = (INA & (~ INB) & INC) | (INC & INB & (~ INA));
endmodule

module smfulladder (DATA_A, DATA_B, DATA_C, SAVE, CARRY);
  input DATA_A;
  input DATA_B;
  input DATA_C;
  output SAVE;
  output CARRY;
  wire TMP;
  assign TMP = DATA_A ^ DATA_B;
  assign SAVE = TMP ^ DATA_C;
  assign CARRY = ~ ((~ (TMP & DATA_C)) & (~ (DATA_A & DATA_B)));
endmodule

module smhalfadder (DATA_A, DATA_B, SAVE, CARRY);
  input DATA_A;
  input DATA_B;
  output SAVE;
  output CARRY;
  assign SAVE = DATA_A ^ DATA_B;
  assign CARRY = DATA_A & DATA_B;
endmodule

module smffa
  (
  input clk,
  input en_d1,
  input D,
  output reg Q
  );
  always @ (posedge clk) begin
      Q <= D;
  end
endmodule

module smffb
  (
  input clk,
  input en_d2,
  input D,
  output reg Q
  );
  always @ (posedge clk) begin
      Q <= D;
  end
endmodule

module sminvblock (GIN, GOUT);
  input GIN;
  output GOUT;
  assign GOUT = ~ GIN;
endmodule

module smxxor1 (A, B, GIN, SUM);
  input A;
  input B;
  input GIN;
  output SUM;
  assign SUM = (~ (A ^ B)) ^ GIN;
endmodule

module smblock0 (A, B, POUT, GOUT);
  input A;
  input B;
  output POUT;
  output GOUT;
  assign POUT = ~ (A | B);
  assign GOUT = ~ (A & B);
endmodule

module smblock1 (PIN1, PIN2, GIN1, GIN2, POUT, GOUT);
  input PIN1;
  input PIN2;
  input GIN1;
  input GIN2;
  output POUT;
  output GOUT;
  assign POUT = ~ (PIN1 | PIN2);
  assign GOUT = ~ (GIN2 & (PIN2 | GIN1));
endmodule

module smblock2 (PIN1, PIN2, GIN1, GIN2, POUT, GOUT);
  input PIN1;
  input PIN2;
  input GIN1;
  input GIN2;
  output POUT;
  output GOUT;
  assign POUT = ~ (PIN1 & PIN2);
  assign GOUT = ~ (GIN2 | (PIN2 & GIN1));
endmodule

module smblock1a (PIN2, GIN1, GIN2, GOUT);
  input PIN2;
  input GIN1;
  input GIN2;
  output GOUT;
  assign GOUT = ~ (GIN2 & (PIN2 | GIN1));
endmodule

module smblock2a (PIN2, GIN1, GIN2, GOUT);
  input PIN2;
  input GIN1;
  input GIN2;
  output GOUT;
  assign GOUT = ~ (GIN2 | (PIN2 & GIN1));
endmodule
// verilog_format: on

// Local Variables:
// compile-command: "vlint --brief --nowarn=MULTMF,MODLNM t_math_wallace_mul.v"
// End:
