C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE PRRFVN
C                       *****************
C
C      ---------------------------------------------------------
     * (NDIM,NPOINR,NELRAY,NODRAY,SUFRAY, 
     *  VFACER,VNODER,TRAV)
C      ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            Interpolation des faces de rayonnement aux noeuds de      *
C            rayonnement de type shading de gouraud                    *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  VFACER   !  R ! D  ! Valeur stockee sur une face de rayonnement   !
C !  VNODER   !  R ! M  ! Valeur stockee sur les noeuds de rayonnement !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NDIM,NELRAY,NPOINR
      INTEGER NODRAY(NELRAY,NDIM)
      DOUBLE PRECISION VFACER(NELRAY),VNODER(NPOINR),TRAV(NPOINR)
      DOUBLE PRECISION SUFRAY(NELRAY)
C
C..Variables internes
      INTEGER I,N,N1,N2,N3
C
C***********************************************************************
C
C     0- INITIALISATION
C     =================
      DO 10 I=1,NPOINR
         TRAV(I) = 0.
         VNODER(I)= 0.
   10 CONTINUE
C
      IF (NBLBLR .GT. 3) WRITE(NFECRA,1000)
C
C     1- DIMENSION 2
C     ==============
      IF (NDIM.EQ.2) THEN
         DO 100 I=1,NELRAY
C
            N1 = NODRAY(I,1)
            N2 = NODRAY(I,2)
C
            TRAV(N1) = TRAV(N1) + SUFRAY(I)
            TRAV(N2) = TRAV(N2) + SUFRAY(I)
C
            VNODER(N1) = VNODER(N1) + VFACER(I)*SUFRAY(I)
            VNODER(N2) = VNODER(N2) + VFACER(I)*SUFRAY(I)
C
  100    CONTINUE
C
         DO 110 N=1,NPOINR
             VNODER(N) = VNODER(N) / TRAV(N)
  110    CONTINUE
C
      ENDIF
C
C     2- DIMENSION 3
C     ==============
      IF (NDIM.EQ.3) THEN
         DO 200 I=1,NELRAY
C
            N1 = NODRAY(I,1)
            N2 = NODRAY(I,2)
            N3 = NODRAY(I,3)
C
            TRAV(N1) = TRAV(N1) + SUFRAY(I)
            TRAV(N2) = TRAV(N2) + SUFRAY(I)
            TRAV(N3) = TRAV(N3) + SUFRAY(I)
C
            VNODER(N1) = VNODER(N1) + VFACER(I)*SUFRAY(I)
            VNODER(N2) = VNODER(N2) + VFACER(I)*SUFRAY(I)
            VNODER(N3) = VNODER(N3) + VFACER(I)*SUFRAY(I)
C
  200    CONTINUE
C
         DO 210 N=1,NPOINR
             VNODER(N) = VNODER(N) / TRAV(N)
  210    CONTINUE
C
      ENDIF
C
C
C-------
C FORMAT
C-------
C
 1000 FORMAT(/,' *** PRRFVN : PROJECTION SUR LES NOEUDS DU MAILLAGE DE',
     &         ' RAYONNEMENT',/)

C----
C FIN
C----
      END
          
