# Release Notes

## v6.15.0

### Removal of support for Python v3.9

Python v3.9 is no longer supported.  As a consequence PEP 604 is now supported
and type hints no longer use `Optional` and `Union`.

The current ABI versions are now v12.18.0 and v13.11.0.

Resolves [#93](https://github.com/Python-SIP/sip/issues/93)

### Optimisations to improve the speed of code generation

A number of optimisations have been made to significantly reduce the time taken
to generate the bindings code. For example the generation of the QGIS Python
bindings (excluding the compilation of the generated code) is around 5x faster.

### Test framework

The test framework has been rewritten to use `pytest` instead of `unittest`.
Many tests have been added and the test suite can be run for each supported ABI
version.  See the `README.md` file in the `test` subdirectory for more details.

### `SIP_ABI` pseudo-timeline

The `SIP_ABI` pseudo-timeline was added to allow the ABI version to be tested
in `%If` directives.

### Support for `_Bool`

`_Bool` can now be used as a synonym for `bool`.

### `sip` Module Configuration

The `%SipModuleConfiguration` directive is used by ABI v14 to specify how the
`sip` module is expected to behave.  For example it can be configured to behave
like v12 or v13.

The `--option` option has been added to the `sip-module` command line tool
in order to configure a generated sdist to behave accordingly.

### Support for Multiple Interpreters and Free Threading

In anticipation of the support for multiple interpreters and free threading (to
be implemented in ABI v14), and `multi_interpreter_support` and `gil_use` have
been added as arguments to the `%Module` directive.

### Documentation

The documentation for `SIP_PYOBJECT` and similar types has been clarified to
state that callables returning objects of those types **must** return a **new**
reference.

Resolves [#96](https://github.com/Python-SIP/sip/issues/96)

### Bug fixes

- Global or static string pointers (of any encoding) and Python objects with
  `NULL` values are now interpreted as `None` rather than causing a crash.
- Global or static `void *` variables caused invalid code to be generated.
- Global or static explicitly signed or unsigned string pointers caused invalid
  code to be generated.
- Global or static `Py_hash_t` and `Py_ssize_t` variables were being completely
  ignored.
- The fully qualified names of `simplewrapper`, `wrapper` and `wrappertype` in
  an embedded `sip` module are now correct.
- Attempting to delete a wrapped class instance attribute will now raise an
  exception rather than crash.
- A regression that meant that generated wheels were not compressed has been
  fixed.


## v6.14.0

### Specification of target ABI version

`sip-sdist` now has a `--abi-version` command line option to be used if a value
is not specified in `pyproject.toml`.

### Bug fixes

- Bugs in the handling of the default target ABI have been fixed.
- Fixed a regression in v6.13.1 in the handling of composite modules.  Resolves
  [#95](https://github.com/Python-SIP/sip/issues/95)


## v6.13.1

### Bug fixes

Fixed a regression in v6.13.0 in the handling of mapped types for C++
templates with `typedef`ed arguments.


## v6.13.0

### `/ExportDerivedLocally/` class annotation

The new `/ExportDerivedLocally/` class annotation is similar to the
`/ExportDerived/` class annotation except that it only makes the derived
class declaration available to handwritten code in the module in which the
class was defined.

### `%TypeDerivedCode` directive

The new `%TypeDerivedCode` directive allows handwritten code to be specified
that is included at the start of the declaration of a derived class.

### Support for SBOMs

The `tools.sip.project.sbom-files` key in `pyproject.toml` is used to
specify a list of files (and glob-style patterns) that will be copied to
the `.dist-info/sboms` directory as described in PEP 770.

Resolves [#83](https://github.com/Python-SIP/sip/issues/83)

### Improved error reporting

When a build fails the last 100 lines of the build output will be
displayed.  As with previous versions the `--verbose` option must be
specified to see the full build output.

Resolves [#84](https://github.com/Python-SIP/sip/issues/84)

### Support for bool-based enums

Enums can now have `bool` as a base type.

Resolves [#88](https://github.com/Python-SIP/sip/issues/88)

### Non-public super-classes not supported

An attempt to use non-public super-classes will now result in a deprecation
message rather than being silently ignored.  The super-class should simply
be removed.

### Bug fixes

- Fixed the code generated for operator casts.
- Fixed the handling of mapped types for C++ templates with `typedef`ed
  arguments.
- Fixed the test for the `/Movable/` annotation so that it works with
  Python v3.14.  Resolves [#82](https://github.com/Python-SIP/sip/issues/82)
- A mis-named enum member was corrected.  Resolves [#86](https://github.com/Python-SIP/sip/issues/86)
- Specifying `%Docstring` as a sub-directive of the `%Module` directive
  generated invalid code.  Resolves [#81](https://github.com/Python-SIP/sip/issues/81)


## v6.12.0

### Support for C++11 enum base types

Support was added for C++11 enum base types.  At the moment this is limited
to base types no larger than `int`s.  Prior to this support, all enums were
assumed to be `int` which breaks on big-endian systems.

Resolves [#75](https://github.com/Python-SIP/sip/issues/75)

### Bug fixes

- Fixed a regression in v6.11.0 affecting class names as template
  arguments.  Resolves [#77](https://github.com/Python-SIP/sip/issues/77)


## v6.11.1

### Bug fixes

- The PEP 517 `build_wheel()` hook has been fixed after it regressed in
  v6.11.0.  Resolves [#73](https://github.com/Python-SIP/sip/issues/73)
- The handling of calls where `self` is passed as an argument in ABI v13 was
  fixed.  Resolves [#74](https://github.com/Python-SIP/sip/issues/74)


## v6.11.0

### Added the `/Movable/` mapped type annotation

When the `/Movable/` annotation is specified for a mapped type, values of that
type are wrapped in calls to `std::move()` when passing them as arguments to a
C++ callable.  In addition the `/Transfer/` argument annotation is
automatically applied.

Resolves [#60](https://github.com/Python-SIP/sip/issues/60)

### Support for template arguments in super-classes

It is now possible to invoke a class template as a super-class in a class
template.

Resolves [#12](https://github.com/Python-SIP/sip/issues/12)

### Determining the version of the limited API to use

The version of the limited API to use is now taken from the `requires-python`
field of the metadata in a project's `pyproject.toml` file.  If this is not
specified then (as with previous versions of SIP) the version of the oldest
supported version of Python is used.

Resolves [#58](https://github.com/Python-SIP/sip/issues/58)

### `%Docstring` support for namespaces

The `%Docstring` directive can now be specified for C++ namespaces.

Resolves [#11](https://github.com/Python-SIP/sip/issues/11)

### Support for `operator~()` in the global scope

`operator~()` can now be specified in the global scope.

Resolves [#9](https://github.com/Python-SIP/sip/issues/9)

### Use consistent timestamps when creating wheel files

The value of the environment variable `SOURCE_DATE_EPOCH`, if defined, will be
used as the timestamp for all files included in a wheel.  This ensures wheel
building is repeatable.

Pull request [#70](https://github.com/Python-SIP/sip/pull/70)

### Bindings support for PEP 639

- The `project` section of `pyproject.toml` files may now use `license` to
  specify a valid SPDX license expression.  `license-files`, if specified, is a
  list of glob patterns describing the files containing licensing information.
  The old style of `license` is deprecated.
- The metadata format of the generated `PKG-INFO` file of an sdist will
  normally be v2.4.  If the deprecated form of `license` is used in
  `pyproject.toml` then it will be v2.2.
- License files will be installed in the `licenses` sub-directory of the
  generated `.dist-info` directory of a wheel.
- `packaging` v24.2 is now required.

Resolves [#69](https://github.com/Python-SIP/sip/issues/69)

### Normalised wheel names

The names of wheel files (both those generated by `sip-wheel` and indirectly
from the sdists created by `sip-module`) now conform to current PyPA standards.

Resolves [#68](https://github.com/Python-SIP/sip/issues/68)

### `pyproject.toml` now conforms to PEP 639

The licensing information in SIP's `pyproject.toml` now conforms to PEP 639.
This means that the minimum `setuptools` version is v77.

### Bug fixes

- The handling of unknown `%Timeline` tags in `%If` directives has been fixed.
  An unknown tag is assumed to refer to a later version than all the known
  tags.  Therefore `(unknown -)` will always be false, and `(- unknown)` will
  always be true.
- Generated code will not contain digraphs.  This usually affects C++
  extensions being built with the default `setuptools` builder.
- Long deprecation messages are now handled correctly.  Pull request
  [#67](https://github.com/Python-SIP/sip/pull/67)

### Documentation fixes

- Fixed the documentation for `SIP_ABI_MAJOR_VERSION` and
  `SIP_ABI_MINOR_VERSION` for both v12 and v13 of the ABI.

### Improved unit tests

The support for writing unit tests for SIP has been improved and documented.
In particular, test cases that require multiple test modules to be built are
now supported.


## v6.10.0

### Introspection of the `sip` module ABI version

`SIP_ABI_VERSION` has been added as a module attribute of the `sip` module.
This is an integer that represents the ABI version that the module implements
as a 3 part hexadecimal number.

This has been implemented in ABIs v12.17 and v13.10.

Resolves [#62](https://github.com/Python-SIP/sip/issues/62)

### `sip-module` support for older ABI versions

The ability of `sip-module` to generate sdists for older ABI versions has been
restored.  The oldest that can be generated are v12.9 and v13.1 which are the
oldest non-deprecated versions.

The documentation now contains brief histories of these versions.

Resolves [#61](https://github.com/Python-SIP/sip/issues/61)

### Default ABI version

The default minor ABI version to use is now the latest minor version for a
particular major version (rather than `0` as it was previously).

Resolves [#63](https://github.com/Python-SIP/sip/issues/63)

### Specify the ABI version on the command line

The `--abi-version` command line option has been added to `sip-build`,
`sip-install` and `sip-wheel` to specify the ABI version of the `sip` module to
generate code for.

Resolves [#64](https://github.com/Python-SIP/sip/issues/64)

### Added the `%MinimumABIVersion` directive

The `%MinimumABIVersion` directive is used to specify the minimum `sip` module
ABI to target in order to ensure that all calls to the public API from
handwritten code are available.

A consequence of this change is that passing string values to the
`/Deprecated/` annotation no longer requires an ABI version that supports them
to be targeted.  If the targeted ABI version does not support them they are
simply ignored.

Resolves [#65](https://github.com/Python-SIP/sip/issues/65)

### Escaping special characters in string annotations

The value of a string annotation uses the `;` and `:` characters to allow
platform- and feature-specific values to be defined.  These special characters
can now be escaped using a leading `\\`.  This capability has now been
documented.

Resolves [#59](https://github.com/Python-SIP/sip/issues/59)

### Bug fixes

- The license designator in `setup.py` for the latest versions of the `sip`
  module are now correctly specified as `BSD-2-Clause`.
- The code generation has been fixed for classes created by instantiating
  mapped type templates using a `typedef` with the `/NoTypeName/` annotation.
  Resolves [#66](https://github.com/Python-SIP/sip/issues/66)


## v6.9.1

### `sip-sdist` creates PEP 625 compatible file names

The sdists created by `sip-sdist` are now compatible with PEP 625 in that
they have lower case names.  This ensures that they will still be able to
be uploaded to PyPI.

Resolves [#23](https://github.com/Python-SIP/sip/issues/23)

### Update the minimum version of `setuptools`

The minimum version of `setuptools` used by SIP and by the generated `sip`
module sdists has been set to v69.5.  This is the oldest version that
supports PEP 625.

Resolves [#55](https://github.com/Python-SIP/sip/issues/55)

### `sip` module sdist `Requires-Python` is incorrect

The minimum Python version in the generated `sip` module metadata is now
set to v3.9.

Resolves [#56](https://github.com/Python-SIP/sip/issues/56)


## v6.9.0

### Removal of support for Python v3.8

- Generated bindings now require Python v3.9 or later.
- Type hints now conform to PEP 585.
- The latest `sip` module ABI versions are v12.16 and v13.9.

Resolves [#37](https://github.com/Python-SIP/sip/issues/37)

### Added support for the `deprecated()` decorator in `.pyi` files

- `.pyi` files now use the `deprecated()` decorator when the `/Deprecated/`
  annotation is specified.
- The `/Deprecated/` annotation may now specify an optional string which will
  be appended to the default deprecation warning.

Resolves [#8](https://github.com/Python-SIP/sip/issues/8)

### PyQt-specific support for registering `QFlags` types

Calls to `qMetaTypeId()` for all `QFlags` mapped types are now automatically
generated for PyQt using ABI v13.

Resolves [#43](https://github.com/Python-SIP/sip/issues/43)

### Bug fixes

- The handling of the SIP versions timeline was fixed.  (Resolves
  [#47](https://github.com/Python-SIP/sip/issues/47))
- Annotations are now only validated if they are known to be needed.
- The buffer protocol support for byte objects was fixed. (Resolves
  [#36](https://github.com/Python-SIP/sip/issues/36))
- All outstanding compiler warnings were eliminated when building the `sip`
  module.  (Resolves [#32](https://github.com/Python-SIP/sip/issues/32))
- Redundant `%` in trace output of `this` pointer in were removed.  (Pull
  request [#33](https://github.com/Python-SIP/sip/pull/33))


## v6.8.6

### Handle single number macOS deployment targets

If the macOS deployment target (as returned by `sysconfig.get_platform()`)
was just a major version number then SIP would crash.

Resolves [#31](https://github.com/Python-SIP/sip/issues/31)

### Support for architectures where `char` is unsigned

Conversions to and from `char` and Python integer objects on architectures
where `char` was unsigned (eg. Linux on ARM) have been fixed.

The latest `sip` module ABI versions are v12.15 and v13.8.

Resolves [#29](https://github.com/Python-SIP/sip/issues/29)

### Support for building from git archives

`.git_archival.txt` and `.gitattributes` were added so that git archives
contain the necessary metadata for [setuptools-scm](https://setuptools-scm.readthedocs.io/en/stable/usage#git-archives).

Pull request [#30](https://github.com/Python-SIP/sip/pull/30)

### Run the tests using the current Python version

The tests are run using the current Python version instead of the default
one to make it easier to test using multiple Python versions.

Pull request [#27](https://github.com/Python-SIP/sip/pull/27)


## v6.8.5

### Missing dependency in `pyproject.toml`

Added `setuptools` as a project dependency.

Resolves [#26](https://github.com/Python-SIP/sip/issues/26)

### V6.8.4 release notes are incorrect

The incorrect entries in the v6.8.4 release notes regarding the latest ABI
version numbers were removed.

Resolves [#24](https://github.com/Python-SIP/sip/issues/24)


## v6.8.4

### Added support for Python v3.13

Python v3.13 raises the minimum macOS version to 10.13.  Ensure that this
minimum is used for wheel names for projects where all modules use the limited
ABI, no matter what the minimum requirement of the version of Python being used
to build the wheel is.

Eliminated all compiler warnings on all platforms when building the `sip`
module.

Removed calls to all deprecated parts of the Python API.

Resolves [#22](https://github.com/Python-SIP/sip/issues/22)

### Make all tools accessable using `python -m`

`sip-distinfo` can now also be run using `python -m sipbuild.tools.distinfo`.

`sip-module` can now also be run using `python -m sipbuild.tools.module`.

Resolves [#21](https://github.com/Python-SIP/sip/issues/21)

### Assume C99 support

`_Bool` and `stdbool.h` are assumed to be available on all supported platforms.

`va_copy` is assumed to be available on all supported platforms.

Resolves [#13](https://github.com/Python-SIP/sip/issues/13)

### Object map incorrect size assumptions for Windows 64

`uintptr_t` is now used as the hash key in the object map rather than
`unsigned long`.

Resolves [#14](https://github.com/Python-SIP/sip/issues/14)

### `%MappedType` documentation error

The documentation for the `MappedType` directive incorrectly stated that the
type was `type` rather than `base-type`.

Resolves [#10](https://github.com/Python-SIP/sip/issues/10)

### Missing import affecting XML generation

The generation of XML (used by PyQt documentation) failed because of a missing
import.

Resolves [#18](https://github.com/Python-SIP/sip/issues/18)

### Fixed the generation of module-level attributes

This is a regression in SIP v6.8 and only affects attributes defined in hidden
namespaces.

Resolves [#19](https://github.com/Python-SIP/sip/issues/19)

### Documentation updates

The documentation is now hosted at
[Read the Docs](https://python-sip.readthedocs.io).

Resolves [#2](https://github.com/Python-SIP/sip/issues/2)

### Completion of the migration from Mercurial

SIP is now licensed under the BSD-2-Clause license.

`README.md` now reflects the state of the migration.

The project has now been migrated from `setup.py` to `setuptools_scm` and
`pyproject.toml`.

Resolves [#1](https://github.com/Python-SIP/sip/issues/1)
