#define XERR
#include "loop.ih"

    // data filled by writerounds.cc

    // by iterate.cc

CSVTable Loop::headerRounds(size_t iteration) const
{
   CSVTable tab{ outStream(
        d_nRounds == 0 ? "" : d_options.roundsFile(), iteration),
                 "  " };

// --------------------------------------------------------------------------- -> continues
//                      Mammo                              MRI                
//        --------------------------------  --------------------------------  
//           Positive         Negative         Positive         Negative      
//        ---------------  ---------------  ---------------  ---------------  
// round    true    false    true    false    true    false    true    false  
// ---------------------------------------------------------------------------
// 
//                      --------------------------------------------------------------
//                                                                                    
//                                                                                    
//                              number of                  costs           number of  
//                      -------------------------  ---------------------  ------------
//                      tumors  interval  trueInt  screening        biop    MRI  Mammo
//                      --------------------------------------------------------------

    if (not tab.stream() or d_nRounds == 0)
        return tab;

    labels(tab.stream());

    roundsNcols(tab);                       // # columns of the rounds table

    tab << hline();                         // topline

    roundsColHdrs(tab);                     // column headers

    tab.sep(", ");

    return tab;
}






/*****************************
    tab.fmt() << "round" <<                             // 1: round
                "pos." << "neg." <<                     // 2-3
                "-pos.-" << "-neg.-" <<                 // 4-5          2-3
                "tumors" << "interval" <<               // 6-7          4-5
                "trueInt" << "screening" << "biop567yyy";  // 8-10      6-8

        //  E.g., "Mammo" << "Tomo" << "MRI"; // 9-11 (generally: 9..)

    size_t nFields = d_modalities.roundFmt(tab); 

    tab << hline();
    tab.row(1) << join(2, FMT::CENTER) << "false"       <<  //  2-3
                  join(2, FMT::CENTER) << "true"        <<  //  4-5     2-3
                  join(3, FMT::CENTER) << "number of"   <<  //  6-7     4-6 
                  join(2, FMT::CENTER) << "costs"       <<  //  
                  join(nFields, FMT::CENTER) << "number of";

    tab.row(1) << hline(2) << hline(2) << hline(3) << hline(2) << 
                                                        hline(nFields);  

    tab.more() << "round" << "pos." << "neg." <<        // 1-3
                             "pos." << "neg." <<        // 4-5      1-3
                "tumors" << "interval" << "trueInt" <<  // 6-7      4-6
                "screening" << "biop";                  // 8-9      7-8

********************/

