//  main.cpp
//  forautocompl
//
//  Created by Martin Steinegger on 26.11.12.
//  Copyright (c) 2012 -. All rights reserved.
//

#include <iostream>
#include "Parameters.h"
#include "StripedSmithWaterman.h"
#include "MsaFilter.h"
#include "PSSMCalculator.h"
#include "Sequence.h"
#include "SubstitutionMatrix.h"
#include "MultipleAlignment.h"

const char* binary_name = "test_pssm";

int main (int, const char**) {
    Parameters& par = Parameters::getInstance();
    SubstitutionMatrix subMat(par.scoringMatrixFile.c_str(), 2.0, 0.0);
    std::cout << "Subustitution matrix:";
    SubstitutionMatrix::print(subMat.subMatrix,subMat.int2aa,subMat.alphabetSize);
    //   BaseMatrix::print(subMat.subMatrix, subMat.alphabetSize);
    const char *seqs[1001];
    int counter = 0;
//    seqs[counter++]  = "QDELTAGPCATVHVITVQMAKSGELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRKQGRHVYYQLQDHHIVALYQNALDHLQECR";
//    seqs[counter++]  = "---------------------ASELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRKQGRHVYYQLQDHHIVALYQNALDHLQECR";
//    seqs[counter++]  = "---------------------ASELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRKQGRHVYYQLQDHHIVALYQNALDHLQECR";
//    seqs[counter++]  = "---------------------ASELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRK-----------------------------";
//    seqs[counter++]  = "---------------------ASELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRK-----------------------------";
//    seqs[counter++]  = "---------------------ASELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRK-----------------------------";
//    seqs[counter++]  = "---------------------ASELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRK-----------------------------";
//    seqs[counter++]  = "---------------------ASELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYR------------------------------";
//    seqs[counter++]  = "------------------------------EKAQRMAEFLGFLADPNRLRLLSILAQQEMCVGDLAVSLGMNESAVSHQLRTLRAIRLVSSRKQGRHVFYRLQDHHVLDFYQAVLEHLDE--";
//    seqs[counter++]  = "--------CDQHHAVDLKDIQNVRTQTLSVEKAQQMAEFFSLLGDANRLRLLSILARQEQCVCDLAEILEMSESAVSHQLRSLRALRLVSYRKQGRKVYYRLLDHHVLDLYQAVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSLLGDPNRLRILSLLAAQELCVCDLAAALDMSESAVSHQLRTLRTMRLVSYRKQGRNVFYNLQDSHVLNLYQSVTEHLDE--";
//    seqs[counter++]  = "----TVPTCETVHAL-----ESNRINQLDQEKAQRMAEFFRLLGDANRLRILSVLAKQKLCVCDLAAILEMSESAVSHQLRTLRSLRLVSYQKQGRKVYYDLQDHHVLDLYNSVVEHLDE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKRELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKRELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLELEKAQKMAEFFSLLGDANRLRILSLLAKRELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QEAKFQHLQGLEIEKAQKMAEFFSLLGDANRLRILSLLAKRELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QGAKFQHLQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-----------------QGAKFQHLQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-------PSCDAHLVHLEQVRQVQPEIMPVDKAQQMAEFFNALADPNRLRLMSALANRELCVCDLAAAVKVSESAVSHQLRILRSQHLVKYRREGRNVYYSLADQHIISLYQEVSEHLQE--";
//    seqs[counter++]  = "---------------------------VALKQAQQMADFFAVLSDPHRLRLISALAQQELCVCDLAIAMKMSDSAVSHQLRILRSARLVTYRKEGRNVYYSLADEHIVNLYREVADHLQE--";
//    seqs[counter++]  = "-------------------------QTLSVEKAQQMAEFFSLLGDANRLRLLSILARQEQCVCDLAEILEMSESAVSHQLRSLRALRLVSYRKQGRKVYYRLLDRHVLDLYQAVAEHLDE--";
//    seqs[counter++]  = "-----------------QEGKFQNLQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "------------------------LQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
//    seqs[counter++]  = "-------------------------QVITSEKAQRMAEFFSFLGDPNRLRILSFLANKELCVGDLAALLNMSESAVSHQLRNLRVMRLVGYRKQGRNVFYHLHDNHIFHLYQAVAEHLDE--";
//    seqs[counter++]  = "-------------------------QTLSSNKAQRMAEFFSLLGDANRLRILSVLAVQELCVCDIAAAVEMSESAVSHQLRTLRAMRLVSYRKQGRNVFYNLQDSHVLSLYQSVAEHLDE--";
//    seqs[counter++]  = "EDNLPLSPCETHPVHLIDRVSSSKTQILPTTKAQQMAEFFAVLADPNRLRLLSALASQELCVCDLAALTKMSQSAVSHQLRLLKVMRLVSYRREGRNVYYSLADRHIIDLYRCAAEHLDE--";
//    seqs[counter++]  = "-------PC-TPHIIEKELIDTCKTQILSNDKAQRMAEFFSLLGDSNRLRILSILAQQELCVCDLAASLDMSESAVSHQLRTLKVMRLVAYQKIGRKVYYRLLDHHVLELYRSVAEHLDE--";
//    seqs[counter++]  = "-------PC-TPHSLDSEFIDTFKGQILSSEKAQKMAEFFSLLGDPNRLRILSVLAKQELCVCDLAATLDMTESAVSHQLRTLKAMRLVSYQKRGRKVFYRLLDHHVLELYSSVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSFLGDANRLRILSLLAQQELCVSDLAAALNMSESAVSHQLRNLRAMRLVSYRKQGRNVFYRLHDSHVLHLYQAVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSLLGDANRLRILSLLAQKELCVCDLAATLDMTESAVSHQLRTLRAMRLVSYRKQGRNVFYNLQDSHVLNLYQSVAEHLDE--";
//    seqs[counter++]  = "-----------------------QVRQVQPEVAQQMAEFFSALADPSRLRLMSALARQELCVCDLAAAMKVSESAVSHQLRILRSQRLVKYRRVGRNVYYSLADNHVMNLYREVADHLQE--";
//    seqs[counter++]  = "-DEL---ECTSEHAIDLENINSIQNQLLNENKAQRMAEFFSFLGDANRLRIISALALKELCVHELAEIVQMTESAVSHQLRNLKAIRLVSYRKEGRRVYYRLQDNHVVSLYEAVTEHLDE--";
//    seqs[counter++]  = "-------------------------EVITTEKAQRMADFFSFLGDANRLRILSFLAKKELCVGDLATLLDMSESAVSHQLRNLRAMRLVSYRKQGRNVFYRLHDNHIFHLYQAVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSLLGDANRLRILSLLAQKELCVCDLAATLDMTESAVSHQLRTLRAMRLVSYRKQGRNVFYNLQDSHVLNLYQSVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSLLGDPNRLRILSLLAKQELCVCDLAATLDMSESAVSHQLRTLRTMRLVRYHKAGRKVFYQLSDHHVLDLYHSVAEHLDE--";
//    seqs[counter++]  = "------------------------IQVLSSQKAQRMAEFFSFLGDANRLRILSLLAEKELCVSDLAATLEMTESAVSHQLRNLRVMRLVNYRKQGRRVFYSLHDHHVLHLYQAVAEHLDE--";
//    seqs[counter++]  = "-DQENALNCTIQHPVDLSHVRQLHKAILSEEKSQRMAEFFSLLGDPNRLRILSALAVNELCVCDLAAAVKMSESAVSHQLRTLRSMRLVGYRRQGRNVFYYLKDSHVLNLYREVAEHLDE--";
//    seqs[counter++]  = "-------------------------EVLSTEKSQRMAEFFSFLGDANRLRILSFLATKELCVSDIATLLEMSESAVSHQLRNLRAMRLVSYRKQGRHVFYRLHDNHILELYQAVAEHLDE--";
//    seqs[counter++]  = "-------------------------QVLNTEKAQRMAEFFGFLGDANRLRILSLLAQQELCVSDLAGVLNMSESAVSHQLRNLRAMRLVSYRKQGRNVFYRLHDSHVLHLYQAVAEHLDE--";
//    seqs[counter++]  = "------------HSINNSQLQQPSLDLITTDKAQRMAEFFSFLGDANRLRILSLLATEELCVRDLAHVLEMSESAVSHQLRNLRAMRLVSYRKQGRNVFYSLHDSHVLHLYQAVAEHLDE--";
//    seqs[counter++]  = "--------CDSPHLVDSDRVQGIQTQVLNSQKAQRMAEFFSLLGDANRLRLLSVLAAQELCVCDLAATLEMSESAVSHQLRALRALRLVSYRKQGRQVFYSLLDRHVLELYRAVAEHLDE--";
//    seqs[counter++]  = "--------------------------ALSSNKAQKMAEFFSFLGDANRLRILSLLAEKELCVGDLAAALEMSESAVSHQLRNLRVMRLVGYRKQGRRVFYRLHDSHVLYIYQAVAEHLDE--";
//    seqs[counter++]  = "--------------------------------AQQMAEFFSALADPSRLRLMSALARQELCVCDLAAAMKVSESAVSHQLRILRSQRLVKYRRVGRNVYYSLADNHVMNLYREVADHLQE--";
//    seqs[counter++]  = "------------------------IQVLSSEKAQRMAEFFSFLGDANRLRILSLLAEKEFCVSDLAARLDMSESAVSHQLRNLRAMRLVNYRKQGRRVFYRLHDNHVLHLYQAVAEHLDE--";
//    seqs[counter++]  = "-------------------------EVLSTEKSQRMADFFSFLGDANRLRILSFLAAKELCVSDIATLLEMSESAVSHQLRNLRAMRLVSYRKQGRHVFYRLHDNHILELYQAVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSLMGDTNRLRILSLLAHQELCVCDLAAILNMSESAVSHQLRTLKAIRLVSYEKRGRKVFYSLQDHHVLELYESVAEHLDE--";
//    seqs[counter++]  = "--ENTHPPKCETHLVHLDNVRSIQAQILAPDKAQQMAEVFGVLADPNRLRLISALFAQELCVCDLAALTKMTESAVSHQLRLLKAMRLVSYRREGKNVYYSLADNHIVNLYCSLSQHLDE--";
//    seqs[counter++]  = "------------HQIEPELIETCKTQILASDKAQKMAEFFSLLGDSNRLRILSVLAQQELCVCDLAATLDMSESAVSHQLRTLKVMRLVGYQKRGRKVFYHLLDHHVLELYRSVAEHLDE--";
//    seqs[counter++]  = "--------CDPSHLVDCWRAGDIQTQVLNTAKAQRMAEFFSLLGDANRLRLLSVLAKQELCVCDLAAALSMSESAVSHQLRALRAMRLVSYRKVGRQVFYSLLDRHVFELYQAVAEHLDE--";
//    seqs[counter++]  = "-----------VHINTV---RQVQLEIIPTEKAQQMADFFGTLADPHRLRLLSALAKQELCVCDLAASVKMSESAVSHQLRILRTMRLVKYRREGRNVYYSLADSHVTNVYREVASHIDE--";
//    seqs[counter++]  = "--------CDVQHPVNLEQVRQLHREILSQEKAQRMAEFFGLLGDANRLRIVSALAMQELCVCDLAAIVKMSESAVSHQLRALRSIRLVGYRKQGRNVFYRLKDSHVLNLYREVAEHLDE--";
//    seqs[counter++]  = "--------------------------------AQRMAEFFSLLGDANRLRLLSVLAKQELCVCDLAAALSMSESAVSHQLRALRAMRLVSYRKVGRQVFYSLLDRHVFELYQAVAEHLDE--";
//    seqs[counter++]  = "-----------VHLDRVSASRS---QILPTTKAQQMAEFFAVLADPNRLRLISALASQELCVCDLAALMKMTESAVSHQLRLLKAMRLVSYRREGRNIYYSLADNHVISLYREVAVHLDE--";
//    seqs[counter++]  = "--------------------------------AQRMAEFFSFLGDANRLRILSVLAKEELCVSDLAALLEMSESAVSHQLRNLRAMRLVSYRKQGRNVFYQLHDSHVFHLYQAVAEHLDE--";
//    seqs[counter++]  = "--------------------------------AQRMAEFFSLLGDPNRLRILSVLANQELCVCDLAATLDMGESAVSHQLRTLKSMRLVSYEKRGRKVFYRLLDHHVLELYQSVAEHLDE--";
//    seqs[counter++]  = "-------------LIHLESVRQVQPEVLATEKAQRMAEFFTVLSDPHRLKLLSALAQQELCVCDLAATVKMGESAVSHQLRVLKSHRLVKYRRQGRNVFYSLADGHVAALYQEVADHLDE--";
//    seqs[counter++]  = "-------------------------QILSQEKAQRMAEFLGGLGDANRLKIISLLANHELCVHDIAAAVGMSESAVSHQLRILRTLRLVSYRKHKRKVYYQLLDHHILELYRVVCEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSFLGDANRLRVLSLLANKEFCVSDLAALLEMSESAVSHQLRNLRVMRLVSYRKQGRNVFYRLHDSHVFHLYQSVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAQFFGLLADTNRLRIVDLLAQGEFCVRDIAVALEMSESAVSHQLRMLKALRLVRFRRQGRHIFYQLLDHHVLTLYKAAAEHLDE--";
//    seqs[counter++]  = "--------CDRAHLVDCSRVGDIQTQVLNTAKAQRMAEFFSLLGDANRLRLVSVLAKQELCVCDLAATLGMSESAVSHQLRAMRAMRLVSYRKVGRQVFYSLLDRHVLELYRAVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRLSEFLGFLADPNRLRILSILAAKEMCVGDLAAILEMNESAVSHQLRTLRAIRLVNFRKQGRHVFYSLQDRQILDFYRSAIEHI----";
//    seqs[counter++]  = "--------CHPPHPIDLDECKPLKQQILSVEKSQRMAEFFSLLGDPNRLRIVSVLALKELCVCDLAAMLEMSESAVSHQMRCLKAMRLVGYRKQGRKVFYRLQDDHVFQLYMSVAEHIDE--";
//    seqs[counter++]  = "-----------VHLEQVRQVQS---EIVTTEKAQQMAQFFGAMADPHRLKLLSALVKAELCVCDLAAVVKMSESAVSHQLRLLRNLRLVKHRREGRNVYYSLADAHIANLYREVAEHLDE--";
//    seqs[counter++]  = "-----------VHLDNVRQVQS---EVLATEKAQRMAEFFSALSDPHRLKLLSALAQQELCVCDLAAAVKMGESAVSHQLRVLKSQRLVKYRRQGRNVFYSLADGHVTAIYRAVAEHLDE--";
//    seqs[counter++]  = "-----------VHLDNVRQVQS---EVLATEKAQRMAEFFSALSDPHRLKLLSALAQQELCVCDLAAAVKMGESAVSHQLRVLKSQRLVKYRRQGRNVFYSLADGHVTAIYRAVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAELFSSLGDTNRLRIISLLAIAELCVCDIATALDMSESAVSHQLRTLRAMRLVRYHKRGRKVYYHLQDQHVLDLYQSVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSLLGDTNRLRIISVLAIQELCVCDLAAILDMSESAVSHQLRALRALRLVRYHKRGRKVFYHLQDNHVLNLYKSVAEHLEE--";
//    seqs[counter++]  = "-----------VHLDNVWQVQS---KVLATEKAQQMAEFFSVLSDPHRLKLLSALAQQELCVCDLAAIVKMGESAVSHQLRVLRSQKLVKYRRQGRNVYYSLADEHIVTFYREVAQHL----";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFGVLGDPNRWRILSALALQELRVGELAAAVDMSESAVSHQLRVLRSMRLVSYRKQGRSVLYCLKDDHIFNLYQAASEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFGVLGDPNRWRILSALALQELRVGELAAAVDMSESAVSHQLRVLRSMRLVSYRKQGRSVLYCLKDDHIFNLYQAASEHLDE--";
//    seqs[counter++]  = "-------PTCDTHLVHLDSVRSSQAQILPTDKAQQMAEIFGVLADTNRIRLLSALASSELCVCDLAALTKMSESAVCHQLRLLKAMRLVSYRREGRNVYYTLADSHVINLYRSLVENL----";
//    seqs[counter++]  = "-----------------------------PEVAQRMAEFFSVLSDPHRLKLLSALAQQELCVCDLAAAVKMGESAVSHQLRVLKSHRLVKYRRQGRNVFYSLADGHVASIYRDVADHLDE--";
//    seqs[counter++]  = "-----------VHLEQVRQVQS---EIVTTEKAQQMAQFFGAMADPHRLKLLSALSKAELCVCDLAIVVKMSDSAVSHQLRLLRNLRLVKHRREGRNVYYSLADAHIANLYREVAEHLDE--";
//    seqs[counter++]  = "---------------------------IPTEKAQQMADFFGTLADPHRLRLLSALAKQELCVCDLAASVKMSESAVSHQLRILRTMRLVKYRREGRNVYYSLKDSHVTNIYREVAKHIDE--";
//    seqs[counter++]  = "--------------------------------AQRMAEFFGVLGDANRWRILSALATGEMRVGELAAAVEMSESAVSHQLRTLRTARLVSYRKEGRNVIYRLKDHHILNLYRDASEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAQFFGLLADTNRVRIVALLAQGEFCVRDIAVALDMSESAVSHQLRMLKALRLVRFRRQGRHIFYRLLDHHVLTLYEVVAEHLDE--";
//    seqs[counter++]  = "-------PTCDTHLVHLENVRSSQAQILPTQKAQQMAEVFGVLADTNRLRLLSALASQELCVCDLAALTKMSESAVCHQLRLLKVMRLVSYRREGRNVYYSLADSYIINLYHSLVEHYSE--";
//    seqs[counter++]  = "-------PQCDTHLVHLDNVRSIQTQILSIDKAKQMAEVFGILGDPNRLRLISALASQELCVCDLAALMKMTESAVSHQLRLLKAMRLVSYRREGKNVYYSLADNHIINLYCSLAEHLDE--";
//    seqs[counter++]  = "------------------------------EKSQRMADFFGLLGDSNRLRILSVLAQEEMCVCDLATMLKMSESAVSHQLRTLKSMRLVAYHKRGRRVYYRLLDHHVLELYRSVAEHLDE--";
//    seqs[counter++]  = "-------PTCDTHLVHLDNVRSSQAQILPTDKAQQMAEIFGVLADTNRIRLLSALASSELCVCDLAALTKMSESAVCHQLRLLKAMRLVSYRREGRNVYYSLADSHVINLYRSLVE------";
//    seqs[counter++]  = "--------------------------------AQQMAEFFGTLADPTRLRLLSVLATQELCVCDLATALKMSESAVSHQLRVLRSQRLVKYRKEGRNVHYSLADLHVVNLYREVAAHLNE--";
//    seqs[counter++]  = "--------------------------------AQQMAELFGVLADPNRLRLLSLVVAGEMCVCDLAAGLKMSESAVSHQLRLLRTMRLVSYRKEGRNVYYGLADSHIVNLYHSVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKSQRMAEFFSLLGDSNRLRILSMLAHEEFCVCDIAATLEMSESAVSHQLRTLKAMRLVKYEKRGRKVFYRLLDHHVLELYQSVTEHLDE--";
//    seqs[counter++]  = "-------------------------EVIATEQAQHMAEFFSALSDPHRLKLLSALAQQELCVCDLAAAVKMGESAVSHQLRVLRSHRLVKYRKLGRNVCYSLADEHIMTIYRVVAEHLNE--";
//    seqs[counter++]  = "--------------------------------AQRMAEFFSGVGDPNRLRILSVLAIQELCVCDLAITLEMSESAVSHQLRVLRAMRLVSYQRRGRKVFYRLQDNHVLEFYQSVAEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAVFFGVLGDSNRWRILSALASQELPVGELAEAVEMSESAVSHQLRVLRTMRLVSYRKRGRNVYYCLKDKHIFNLYREASEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAVFFGVLGDSNRWRILSALASQELPVGELAEAVEMSESAVSHQLRVLRTMRLVSYRKRGRNVYYCLKDKHIFNLYREASEHLDE--";
//    seqs[counter++]  = "-------PNCDAHVVHLDNVRSTQAEILATSKAKQIAEVFGILADPNRLRLLSALASQELCVCDLAALTKMTESAVCHQLRLFKAMRLVNYRREGKNVYYSLVDSYIINLYRSVEEHLEE--";
//    seqs[counter++]  = "-------------------------QILSREKAQRMAEFFSTLGDPNRWRILSALALKEMRVRDLAAAVDMTESAVSHQLRILRTMRFVSYQKRGRNVVYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "-------PICDAHVVHLDRVCSSKVQILPTDKAQQMSEIFGVLADTNRLRLLSALASQELCVCDLAALTKMTESAVCHQLRLLKAMHLVNYRREGRNVYYSLADSHLLNLYRFLVEHL----";
//    seqs[counter++]  = "--------CDCIHEDTVRKVRS---EMITEEVSHALAEVFRALGDPTRVKLLYALSRRELCVCDLAAVIGASESAVSHQLRLLRTQKLVRFRREGKVVYYSLADKHVEKLFQQGLEHVTE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSTLGDPNRWRILSALALKEMRVRDLAAAVDMTESAVSHQLRILRTMRFVSYQKRGRNVVYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSTLGDPNRWRILSALALKEMRVRDLAAAVDMTESAVSHQLRILRTMRFVSYQKRGRNVVYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSTLGDPNRWRILSALALKEMRVRDLAAAVDMTESAVSHQLRILRTMRFVSYQKRGRNVVYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFFSTLGDPNRWRILSALALKEMRVRDLAAAVDMTESAVSHQLRILRTMRFVSYQKRGRNVVYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "-------------------------QVLSQEQAQRMAEFFGVLGDSNRWRILSALALQSMRVRDLAAKVAMSESAVSHQLRILRTMRLVRYEKQGRNVLYSLKDSHIFNLYREALEHINE--";
//    seqs[counter++]  = "-----------------------QLEILPMEQAQRRAELFNVLADPNRLRLLSALAKQELCVCDLAAGLKMGESAVSHQLRVLKSMRMVNYRKEGRNVYYSLADSQAIDLY-----------";
//    seqs[counter++]  = "----------------------------------SLAETFKVLGDPTRVQIIHALAQKELCVCDLAALLGMSQSAISHQLRILRNLRLVKYRKEGKIVYYSIDDQHIINLFTEGLEHI----";
//    seqs[counter++]  = "-------------------------------VLRDLADLFKVLSDHTRVRILHALLKSELCVCDLVDALDMNQSAVSHQLRVLRSAKVVKYRKEGRHVFYSLDDDHVVSLLQDGLDHVME--";
//    seqs[counter++]  = "-----------VHYVNEKSVKAVQKTMIGDDVADALAETFKVLSDSTRVKILFALSKAELCVCDLSALLGMNESAVSHHLRLLKALKLVKYRREGRMAYYSLDDEHIERLFRQGLEHVQE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFLGVLSDPNRWRILSALAIEEMRVGELAAAVEMSESAVSHQLRVLRNTRMVRRRKCGRTVIYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "--------------------------------------FLKLLGDPTRLNLLSALSRTELCVCDLAAVVGLSESAVSHQLRLLRTGRLVAFRKEGRVVYYRLADEHVTTLIRSALDHARE--";
//    seqs[counter++]  = "------------------------------ERATKLAYLFKTLGDPTRIRIMDALARSEFCVCDLAELLDLSQSATSHQLRILRNSNLVKYRKDGKMVYYSLQDNHVQELYRQGLEHIDE--";
//    seqs[counter++]  = "------------------------------EQAEDLAELFKTLADPTRVRIIDALAKTELCVCDLAELLNLSQSATSHQLRVLRSNKLVKFRREGKMVYYSLDDDHVLGLYSQGLEHINE--";
//    seqs[counter++]  = "--------------------------------ATQLAELFKTLGDPTRIRIMDALAKSEFCVCDLAELLDLSQSATSHQLRVLRNSNLVKYRRDGKMVYYSLQDNHVQELYRQGLEHIDE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFLGVLSNPNRWRILSALAIEEMRVGELAAAVEMSESAVSHQLRVLRNTRMVRRRKCGRTVIYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "-------------------------------------------SDPSRLRILAALAATELCVCDLAALIGISESAVSHQLRLLREERLVTFRKEGRMAYYRLMDHHVTELIRSALNHAQE--";
//    seqs[counter++]  = "---------------------------------------FAALGDPTRFRIIAALQVQELCVGDLAAAIGLSQSAVSHQLRALRDLGLVRSRREGRLVYYALDDEHVVTLVAQALDHV----";
//    seqs[counter++]  = "-EETSDSPVCEVLCIHKELIKEVEKTLIPGEQVNKLAELFKTLGDPTRIRIMDALAKGEFCVCDLAELLELSQSATSHQLRVLRSNHLVKYRREGKMVFYSLDDDHVLALYREGIEHILEGR";
//    seqs[counter++]  = "--------CNVVHVETVALVREASL----PEQVTELAAVFAVLGDPTRIRILRALSVSEMCVCDLAAALQMTQSAVSHQLRLLRNLRIIKRRKSGRMNYYSLDDDHILNLFETGLHHV----";
//    seqs[counter++]  = "-----------------------ESEELSKNVVKNLAATFKVLSDPTRIRIINVLANKELCVCDICELLDMSQSAISHQLRKLRDMNLVKYRKEGRVVHYSLDDEHILQLFCQGLEHVREDR";
//    seqs[counter++]  = "------------------------------------------LSDPTRIKILSALRETELCVCDLAAALGMSESAVSHQLRLLRTTRLVAYRKEGRQVYYRLADQHVEAILDCALEHARE--";
//    seqs[counter++]  = "------------------------------EKAQRMAEFLGVLSDPNCWRILSALAIEEMRVGELAAAVEMSESAVSHQLRVLRNTRMVRRRKCGRTVIYGLKDHHIFNLYRDVSEHLDE--";
//    seqs[counter++]  = "--------------------------------ATKLADLFKTLGDPTRVRLMDALAKTEICVCDLAELLGLSQSATSHQLRVLRSSNLVKYRREGKMVYYSLHDSHVQELYRQGLEHIDE--";
//    seqs[counter++]  = "--------------------------------ATKLADLFKTLGDPTRVRLMDALAKTEICVCDLAELLGLSQSATSHQLRVLRSSNLVKYRREGKMVYYSLHDSHVQELYRQGLEHIDE--";
//    seqs[counter++]  = "--------------------------------ATKLADLFKTLGDPTRVRLMDALAKTEICVCDLAELLGLSQSATSHQLRVLRSSNLVKYRREGKMVYYSLHDSHVQELYRQGLEHIDE--";
//    seqs[counter++]  = "--------------------------------ATKLADLFKTLGDPTRVRLMDALAKTEICVCDLAELLGLSQSATSHQLRVLRSSNLVKYRREGKMVYYSLHDSHVQELYRQGLEHIDE--";
//    seqs[counter++]  = "--------------------------------ATELAELFKTLGDPTRIRIMDALAKSEFCVCDLAELLDLSQSATSHQLRVLRNSNLVKYRRDGKMVYYSLSDNHVQELYGQGLEHIDE--";
//    seqs[counter++]  = "--------------------------------AQRRAELFNVLADPNRLRLLSALADRELCVCDLAAGLKMGESAVSHQLRVLKSMRMVNYRKEGRNVYYSLAD------------------";
//    seqs[counter++]  = "--------------------------------ATKLADLFKTLGDPTRVRIMDALAKAEVCVCDLAELLGLSQSATSHQLRVLRSSNLVKYRREGKMVYYSLHDNHVQELYRQGLEHIDE--";
//    seqs[counter++]  = "--------------------------AMAPEEELSLAELFKVLGDRTRARILEALAVSELCVCDLAAILCLSQSAVSHQLRLLRATKLVRYRKEGKNVFYSLDDEHVRQLFRQALEHVQEER";
//    seqs[counter++]  = "-----------------------------------LAETFKVLGDPTRIKIINALSNVELCVCDISEHLEMSSSAVSHQLRVLRNLNLVKYRKEGRTVYYSLDDDHILQLFSQCLEHVLE--";
//    seqs[counter++]  = "--------------------------------------FLKLLGDTTRLKILSALQTTELCVCDLASVVGISESAVSHQLRLLRTGRLVAFRKEGRVVYYRLADEHVTTLIRSALEHARE--";
//    seqs[counter++]  = "------------------------------ELLYELAEFFKIFGDSSRIRILSLLQQEKLCVGEISELLNLSPSAVSHQLRILRQARLVRYKKIGKEVFYELDDDHIEKIFEQGLEHIQE--";
//    seqs[counter++]  = "------------------------------QVVYDLAELFKTMGDPTRIKILYALKERELCVCDLSELLDMSSSAISHQLRVLRNNKLVKYRKEGRSVYYSLDDDHIMCLFGQGLEHVLEDR";
//    seqs[counter++]  = "---------------------------------QALSELFKVLGDMTRVRILEALSLAELCVCDLAEILALSQSAVSHQLRLLRAAKLVKYRREGKNAYYSLDDEHVAHLFAEALDHIKEDR";
//    seqs[counter++]  = "------------------------------EAATSL---LKMVADPTRLRILSALNIEELCVCDLAAVAGISESAVSHQLRLLRAHRLVSFRKEGRVVYYRLLDQHITSLIGNAIDHANE--";
//    seqs[counter++]  = "----------------------------APATLLALAETFKALGDPTRLRIVAALAQEELCVCDLATLVDVSESAVSHSLRTLRQLRLVQYRKVGKIAYYSLDDAHVARLVAEGLGHIDE--";
//    seqs[counter++]  = "--------------------------------------------DPTRLRLLSALATTELCVCDLAAVLGLSESAVSHQLRVLRVSRLVSYRKAGRVAYYRLADHHVQNLLEDVLAH-----";
//    seqs[counter++]  = "-----------------------------------LQELFKVLGDGTRIKILHAISRTELCVCDIASIINMSQSAVSHQLRILRNSRLVKHRKEGKVVYYSLQDNHVVQLFNQGLEHI----";
//    seqs[counter++]  = "-----------------------------------------VVADPTRLRMLSVLAAEELCVHDLSLVVSISESATSHQLRLLRAHRLVASRKVGRTVYYRLADHHVTLLIGNALQHAQE--";
//    seqs[counter++]  = "---------------------------------QALSELFKILGDMTRVRILEALSLAELCVCDLAEILALSQSAVSHQLRLLRAAKLVKYRREGKNAYYSLDDEHVAHLFAEALDHIKEDR";
//    seqs[counter++]  = "-------------------------------------------ADPTRLRILSALSREELCVCDLAAVVGISESATSHQLRLLRAHRLVRFRKVGRVAYYTLLDHHVTQLIGSALEHAQE--";
//    seqs[counter++]  = "---------------------------IADEDAQRVADLFKILGDTTRVKILQILSKRELCVCDIAAVVGMGQSAVSHQLRLLRNARLVKFRKEGKMAWYSLNDEHIATLLAQGIEHVQ---";
//    seqs[counter++]  = "-------------------------------VTRQMAEFFKSLSDPTRLRIVQALLEEELCVCDISAIVDISISAISHQLRLLRSMHIVKFRKQGKMVYYSLEDEHISRMLEIALEHLNE--";
//    seqs[counter++]  = "--------------------------------ANDLADLFKTLGDPTRVRIMDALAKGEFCVCDLAEVLGLSQSATSHQLRVLRNSKLVKYHREGKMVYYSLDDNHVLGLYRQGLEHISE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDATRVKILYSLSQAELCVCDLSRVLGMSVSAVSHQLRVLRAARLVAYRKEGKMAFYRLNDDHVRTLFQQALDHVRE--";
//    seqs[counter++]  = "-----------------------------------LAELFKTLGDPTRVRIMDVLAKNEFCVCDLAELLELSQSATSHQLRVLRSNHLVKYRREGKMVYYSLDDDHVMGLYREGLEHISE--";
//    seqs[counter++]  = "---------------------------------QELADLFKVLGDPTRIRIVQQLLNKEMCVTDIAEAMGMGQSAISHQLRVLRQARLVAFRKEGKTVYYSLNDEHVVMLLSQGIEHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKTLGDPTRVRIMDVLAKNEFCVCDLAELLELSQSATSHQLRVLRSNHLVKYRREGKMVYYSLDDDHVMGLYREGLEHISE--";
//    seqs[counter++]  = "------------------------------DLALDLAEVFGVLADSTRLKIITLLIGGESCVCEIAGKLGLKQSTVSHQLRLLRAMRLVKYRKTGRTVYYQLCDDHVVNLIQQTLNHLLE--";
//    seqs[counter++]  = "------------------------------DVVYDLAELFKTMGDPTRIKILYALKERELCVCDLSELLDMSASAISHQLRVLRNNKLVKYRKEGRSVYYSLDDDHVMCLFGQGLEHVLEDR";
//    seqs[counter++]  = "-------------------------------VVFDLAELFKTIGDPTRIKILYALKERELCVCDLSELLDMSSSAISHQLRVLRNNKLVKYRKEGRSVYYSLDDSHVLSLFRQGLEHVLE--";
//    seqs[counter++]  = "------------------------------ELLYELAELFKIFGDSSRIRILSLLQQEKLCVNEISFALNLSQSAVSHQLRILRHARLVRYQKQGKEVFYELDDDHIQKIFEQGLEHISE--";
//    seqs[counter++]  = "QDDVCDVPC--VHPEAVARVRSALPDASCVEAASTL---LKVVADPTRLRMLSALNIEELCVCDLANIAGISESAASHQLRLLRAHRLVTSRKEGRVVYYRLLDGHITSLIGSAIEH-----";
//    seqs[counter++]  = "------------------------------DITNRLAETFKVLGDPTRLKILLAVSLDELCVCDIASLLGTTKSAVSHQLRLLRSLRVVKYRKDGRIVYYSLDDSHVGNLLSEGLDHI----";
//    seqs[counter++]  = "------------------------------EIINRLAELFKTMSDPTRVKIIYALRERELCVCDISELLNMSPSAVSHQLRVLRNMNLVKYRKEGRSVFYSLDDDHVLTLFSQGLEHVLE--";
//    seqs[counter++]  = "----------------------------------ALADIFKTLGDATRLRILSALMQQELCVCDLAAVIDMSDSAVSHQLRVLRSQKLVKFRREGKVVYYSLADDHVRTLFAQGLEHVNE--";
//    seqs[counter++]  = "--------------------------------------FLKLVGDPTRLKILSALNARELCVCDLAAVVGLSESAVSHQLRLLRAGRVVTFRKAGRVAYYRLLDHHVTLLIESALDHARE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKVFADSTRIKILYALSNKELCVCDLWQGLGLTQSAVSHQLRILKQMRLVKYRKEGKTIYYSLDDDHIQSILNGGLEHVME--";
//    seqs[counter++]  = "--------------------------------ASDVADLFKALGDPTRVRIIHALLQSELCVHDLTVVLGMGQSAVSHQLRILRNMRIVKRRKEGKTVYYSLDDEHVAQIFKLTLDHL----";
//    seqs[counter++]  = "--------------------------------AGRLADLFKALADPTRVRIIAALLHTELCVDDLANLLDMSQSAISHQLRLLRNLHLVQFRRSGKHAFYRLVDDHVRDLFQRSREHL----";
//    seqs[counter++]  = "-----------------------------------LADLFKTLGDPTRVRIMDALAQKEFCVCDLAVLLDLSQSATSHQLRILRSNHLVKYRREGKMVYYSLDDDHVMALYKEGLEHISEGR";
//    seqs[counter++]  = "-------------------------------------EFLKLVGDPTRLRILSALNAQELCVCDLAAAVGSSESAVSHQLRLLRAGRVVAFRKVGRVAYYRLLDAHVTTLIDNALAHARE--";
//    seqs[counter++]  = "-------PKCDTHLVHLDNVRTSMTQLLPMDKAQHMAEVFGVLSDANRLRLVSALASQELCVCDLAALTKMSESAVCHQLRLLKVIRLVKYRREGRKIFYSLADGTILNLY-----------";
//    seqs[counter++]  = "---------------------------------KELAEFFKVFGDNTRIKILYALSSSEMCVCDLAALLDVTQSAVSHQLRILKQARLVKYRREGKVIYYSLDDNHIKEIFKSGLEHINE--";
//    seqs[counter++]  = "-------PCEGTLTNSIELLKS---EMIPDSTASGLADIFKALGDPTRVKIIYALAQKELCVHDLTQVLDMGQSAISHQLRYLRNLRIVKRRKEGKTVFYSLDDEHVEQIFHQMLQHV----";
//    seqs[counter++]  = "--------------------------------AIGLAEIFKALGDVTRVKILYLLANAELCVCDIADALNMTQSAISHQLRVLRDLRLVKFRKDGKSVFYSLDDEHILQLFSQGLEHVE---";
//    seqs[counter++]  = "-----------------------------------LAEFFKVFADSTRIKILYALSEGELCVCDIWQSLGLTQSAVSHQLRILKQMRLVKYRKEGKTIYYSLDDGHIQSILNQGLEHVME--";
//    seqs[counter++]  = "---------------------------------QPMADIFKVLSDPTRIRILSLLAHQEMCVTCIADALGMTHSAISHQLRLLRATNLVKFTKDGKEVIYSLDDSHVLSLFDQALDHV----";
//    seqs[counter++]  = "-------------------------ESISDSEAQQVAEIFKLLGDPTRVKILQVLTKRELCVCDIAAVIEMGQSAVSHQLRLLRNARLVRYRREGKMAWYSLDDEHVRSLLSQGIDHI----";
//    seqs[counter++]  = "-------------------------ESISDHEAQQVAEIFKLLGDPTRVKILQALTKRELCVCDLAAVIEMGQSAVSHQLRLLRNARLVRYRREGKMAWYSLDDEHVRSLLSQGIDHI----";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDHTRTRILSALALAELCVCDLAELLGMSHSAVSHQLRALRAARLVRFRREGKNAYYALDDDHVLGLIRQGLEHV----";
//    seqs[counter++]  = "---------------------------------QELAQLFKALGDPSRSRLLHALSFGELCVCDLASLLDMSQSAVSHQLRLLRGLRLVRYRKEGKMVYYALDDEHVKGLLAQGLEHV----";
//    seqs[counter++]  = "-------------------------------VVERLSETFKVLADPTRIRILYNLSKRELCVCDLAEILGMTQSAVSHQLRYLKALRLVKSRREGNTVYYRHDDAHTMGLLQMAIDH-----";
//    seqs[counter++]  = "-----------------------------------LSDIFKALSDPTRLKIINALLNSELCVCDIAAVLSMSQSAISHQLRILRNLRLVKYRKEGKSAIYSLDDDHILQLFSQGLEHV----";
//    seqs[counter++]  = "-----------------------------------MAETFKILADPTRVKILHALAHKELCVCDIAVTLDMKVSAVSHQLRLLKSARLVKQRREGKNVYYQLDDHHVEQLFEKTLEHI----";
//    seqs[counter++]  = "---------------------------------ETMAVLFKAMGDPNRLRILWALGAGEMCVCDLAALLTSSESAVSHQLRLLRQMALVSNRRQGQVLYYRLNDDHVHTLIHQALDHVRE--";
//    seqs[counter++]  = "------------HPQAISLAKS---ELIPEEQAQQVADLFKILGDTTRLKILQVLSKREMCVCDIANVIDMGQSAVSHQLRLLRTAQLVKYRKEGQNAWYSLSDDHIATLLYQGIEHVQ---";
//    seqs[counter++]  = "EDEKIAPHCEFIHVHDKVVKRVMDVMPEGEEL-QNLAEFFRVFGDSTRIRILYALSQSELCVCDIASLLGMGQSAISHQLRILKQMRLVKFRREGKSVLYSLADGHIQTILAQGMEHIGE--";
//    seqs[counter++]  = "EDEKIAPHCEFIHVHDKVVKRVMDVMPEGEEL-QNLAEFFRVFGDSTRIRILYALSQSELCVCDIASLLGMGQSAISHQLRILKQMRLVKFRREGKSVLYSLADGHIQTILAQGMEHIGE--";
//    seqs[counter++]  = "-----------------------------------LSELFKAIADPTRIKIINILINTEACVCDIASLLNMTQSAISHQLRVLKSARLVKYRKEGKVVYYSLDDYHVNDIFEKGLNHVRE--";
//    seqs[counter++]  = "-----------------------------PRVIEEVAQIFKALADPTRIKILYLLSQEECHVGHMAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAVDHAQ---";
//    seqs[counter++]  = "-----------------------------PEELQDLADFFKVCGDSTRIKILCVLWQSEMCVCDIAQSLGMTQSAISHQLRVLKQMKLVTNRREGKTVFYSLADSHIKTIMNQGLEHIRE--";
//    seqs[counter++]  = "------------------------------EALLKLAELFKILGDPTRLKIVELLLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMDHV----";
//    seqs[counter++]  = "-----------------------------PEAATDLADLFKALGDPTRVRIIHTLLQSELCVHDLCEVLGMGQSAISHQLRSLRNMRIVKRRKVGKTVFYSLDDEHVEQIFVQTLQHL----";
//    seqs[counter++]  = "-------------------------QMIGDDEAQFLADTFKTLSDPTRVKMLFALLNRELCVCDLAVVIGVSDSAVSHQLRMLRTNKLVKFRRDGKIMYYSLTDSHISALFKQAIEYI----";
//    seqs[counter++]  = "----------------------------APELSQQLADVFKVLGDPTRLRILRVLMNQEVCVRDIADELGMGQSAVSHQLRILRDARLVQFRRDGKTVYYSLADAHVFTLLDVGLEHVAE--";
//    seqs[counter++]  = "----------------------------APELSQQLADVFKVLGDPTRLRILRVLMNQEVCVRDIADELGMGQSAVSHQLRILRDARLVQFRRDGKTVYYSLADAHVFTLLDVGLEHVAE--";
//    seqs[counter++]  = "-------------------------RAIDEETVQRLSDIFKVMGDPTRLRIINALSAGEMCVCDIACALGMENSAISHQLRILKAMRLVKFRKEGKSAIYSLDDEHMLTLFNEGLKHAQ---";
//    seqs[counter++]  = "------------------------------EALQLLAELFKILGDPTRLRIVHLLLQHEMCVSDIAEHMNMGQSAISHQLRVLRQARLVTFRKDGKTAWYSLNDDHVVTLVHQGLEHV----";
//    seqs[counter++]  = "--------------------------------ATRLAAAFQALSDPTRVRLISALLEQELCVHDLAAVLGMSQSATSHQLRVLRALGLVRTRKEGRIVYYALDDEHIRELFQRGLEHI----";
//    seqs[counter++]  = "--------------MTEETSRAIEEQMPPEEIVYDLADLFKVFSDMTRIRILYALAHTELCVYDIAAVVGMSQSAISHQLRVLKQAKLVKYRREGKTVFYSLADGHIHTILNQGLEHVQE--";
//    seqs[counter++]  = "---------------------------------QPMADIFKVLSDPTRIRILSLLAHEEMCVTCIADSLGMTHSAISHQLRLLRATNLVKFTKDGKEVIYSLDDSHVLSLFDQALDHV----";
//    seqs[counter++]  = "------------------------------ELLYELAELFKIFGDSSRIRILSLLQKERLCVSEISTLLNLSQSAISHQLRILRQARLVRYKKIGKEVFYELDDDHIEKIFEQGLEHIQE--";
//    seqs[counter++]  = "------------------------------EYTQPLANLFKILGDPTRLRILQALMKSELCVYDIADTIQMGQSAVSHQLRILRDSHLVQFRRDGKTVYYSLADDHVYTMLQVGLEHVAE--";
//    seqs[counter++]  = "---------------------------------QPLADIYKVLGDPTRLRILHVLLHNEVCVYDISRKIDMGQSAVSHQLRILRNARLVQFRRAGKEVYYSLADRHVYTLLEVGLEHVSE--";
//    seqs[counter++]  = "------------------------------ETLYDLAEFFKVFGDSTRIRILYALFEAELCVGDMAKLLGLSQTACSHQLRVLKNNKLVRFRREGKVVYYSLSDDHVRSIIEKGMEHVEE--";
//    seqs[counter++]  = "---------------------------------EEMASFFRMMGDPTRIRILSLLFDEELCVHTLAERLEMTHSAVSHQLALLKHARLVRSRREGRHVYYRLADEHVQKVYELAREHLEE--";
//    seqs[counter++]  = "----------------------------AEEVLYDLAELFKVFGDSTRIRILYALVESELCVGDLAQILGMGQSAVSHQLKILKDAKLVRYRREGKSVIYALDDEHVRNILNMGMEHVEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDTTRVKIISALFEAELCVCDIAELLGMSQSAISHQLRVLRQARLVKHRKEGKVVFYSLDDDHIKSIFNQGLEHILEPR";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "------------------------------EVLKDLADFFKVFADTTRIRILCVLFQSEMCVCDLAEVLGMTQSAISHQLRMLKQMKLVKNRREGKTVFYSLADDHIQTIMNQGMEHILE--";
//    seqs[counter++]  = "------------------------------EVLKDLADFFKVFADTTRIRILCVLFQSEMCVCDLAEVLGMTQSAISHQLRMLKQMKLVKNRREGKTVFYSLADDHIQTIMNQGMEHILE--";
//    seqs[counter++]  = "---------------------------------QPLADIYKVLGDPTRLRILHVLLHNEVAVSDISRQINMGQSAVSHQLRILRNARLVQFRRAGKEVYYSLSDNHVYTLLEVGLEHVSE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELYKVFGDTTRIRILYALFESELCVNDMAQLLGLSQTAVSHQLRVLKNNKLVTFRKEGKIVFYSLSDDHVRSIIETGMEHIEE--";
//    seqs[counter++]  = "-----------------------------------LSDIFKVMGDPTRLRIIHALSSGEMCVCDIAAALGMEHSAISHQLRILRNMRVVKFRKQGKEAIYSLDDEHVLQLFNGGLEH-----";
//    seqs[counter++]  = "-----------------------------PEVLQNLADLFKVFGDPTRIRILYALSAQELCVCDIASILEMSQSAISHQLRVLKQSQLVNFRRDGKTVYYSLADSHVATILNQGLEHVLE--";
//    seqs[counter++]  = "-----------------------------PEVLQNLADLFKVFGDPTRIRILYALSAQELCVCDIASILEMSQSAISHQLRVLKQSQLVNFRRDGKTVYYSLADSHVATILNQGLEHVLE--";
//    seqs[counter++]  = "------------------------------EVLYDLGDFFKILGDSTRIKILSALFQSEMCVCDIAALLGMTQSAISHQLRVLKQGRLVKHRKEGKVVYYSLDDDHIKHIVDQGLTHISEKR";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "---------------------------------QDLAELFAAFGDPTRLRILTALSEGDLCVCDLSAALGMTASAVSHQLRLLRSLRLVRSRREGRVVYYRLDDEHVLNL------------";
//    seqs[counter++]  = "-----------------------------------LAELFRVLGDHTRVRVLAALSRTELCVCDLAELLGMSHSAVSHQLRALRASRLVRGRRDGKNVFYSLDDDHVRGLMEQGLDHV----";
//    seqs[counter++]  = "---------------------------------QELADLFKVLGDPTRIRIVQQLLNKEMCVTDIAESMGMGQSAISHQLRVLRQARLVTFRKEGKTVMYSLNDEHVVMLLSQGIEHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVEILLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMDHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVEILLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMDHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVEILLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMDHV----";
//    seqs[counter++]  = "---------------------------LADKYVQPMAEIFKVLGDPTRIKILELLSHEDMCVSNIAEMLDMTHSAISHQLRQLRHAQLVKFSKSGKEVIYSLDDEHVLTLFAQALDHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVEILLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMDHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVEILLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMDHV----";
//    seqs[counter++]  = "------------------------------EALLKLAELFKILGDPTRLKIVELLLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMEHV----";
//    seqs[counter++]  = "---------------------------IAEKFVQPMADTFKVLGDPTRIRILALLAENESCVTNIAETLEMTQSAISHQLRLLRHAGLVKFTKTGKEVIYSLDDNHVLTLFAQALDHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKDGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "-----------------------------------LAEFFKVFGDTTRIKIIYVLFQSELCVCDIAALLGMTQSAISHQLRVLKQARLVKYRKDGKVVYYSLDDEHVQTIFNMGYAHILE--";
//    seqs[counter++]  = "---------------------------------EDLCRIFKALADPSRLRLLYALAQEEMCVCDLSALLEITESAVSHQLRLLRTLQIVTNRREGTVLYYRLKDRHVTELIALALEHLRE--";
//    seqs[counter++]  = "------------------------------ETIENVSQIFKVLSDPTRIKILYLLSQEECNVNHIAEILGMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "------------------------------ELIFNLADFFKTFGDSTRIKIICALMETELCVCDLANVINTSQSAVSHQLRVLRQSRLVKYRKDGKTVYYSLDDDHIKLLISQGLDHL----";
//    seqs[counter++]  = "------------------------------ETIENVSQIFKVLSDPTRIKILYLLSQEECNVNHIAEILGMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "-----------------------------------LSEIFKIMGDPTRLKIIHALSSGEMCVCDIAAALGMEHSAISHQLRLLRNTRLAKYRKQGKEAVYSLDDEHVLKLFSEGLEH-----";
//    seqs[counter++]  = "----------------------------AEELLNELADFYKVFGDATRIKILCVLLRSEMCVCDLAEMLGMTQSAISHQLRVLKQMKLVKNRREGKTVYYSLADGHIQNIISQGMEHIME--";
//    seqs[counter++]  = "--------------------------AIQGEEAETLSQFFKVFSDPGRLRILSALRHQEMCVCDLAAFLQGSESAVSHQLRLLRTMNLVKNRREGTVLYYRLTDKHVDEIIVTGLTHIKE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDTTRVKIISALFEAELCVCDIAVLLGMSQSAISHQLRVLRQARLVKHRKEGKVVFYSLDDEHIKSIFNQGLEHILEPR";
//    seqs[counter++]  = "--------CNEVHSECVECVKSTMLE---EKKFINLSELFKMFADPTRLKIIYALLKKELCVCDIAEVIEMSQSSVSHQLRVLKALKLVKYRKEGKVVYYSLDDEHVNNIFNFGLSHIE---";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDLHVENVFKQGLEHI----";
//    seqs[counter++]  = "--------------------------------AQDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDLHVENVFKQGLEHI----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTAYYSLNDDHVEGLVRMGMEHV----";
//    seqs[counter++]  = "-----------------------------------MAEVFKALNDPTRLKIINILIVSELCVNDIANLLEISQPAISHHLKELRQLKLIKYHKKGRSVFYSLDDEHIHPLFQQCLEHVNE--";
//    seqs[counter++]  = "-----------------------------------LADFFKMFSDSTRVRILSALSIHELCVYDIANLLGISQSAVSHQLRLLRGARLVRSRREGKVIFYELDDDHVKHIFREGLDHIKE--";
//    seqs[counter++]  = "-----------------------------------MAEVFKALNDPTRLKIINILIVSELCVNDIANLLEISQPAISHHLKELRQLKLIKYHKKGRSVFYSLDDEHIHPLFQQCLEHVNE--";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLTIVELLLDNEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKEGKTVYYSLDDDHVEGLVRMGMEHV----";
//    seqs[counter++]  = "----------------------------ADEYLYDLAELFKVFGDSTRIRILYALFESELCVGDMAQLLGISQSAVSHQLKILKDSKLVKFRREGKIIFYMLDDDHVRTMLSMGMEHVEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDNHVECLVRMGMEHV----";
//    seqs[counter++]  = "------------------------------EVLGDLSELFKAFGDITRIRILYVLFQKEMCVCDIAETLGMSQSAISHQLRVLKSTRLVKFRKEGKVVYYSLDDDHVKYIFDQALLHVKE--";
//    seqs[counter++]  = "-----------------------ELQPLNSSVVSKLSSFFKVIGDETRVRIIYALSQGEMCVGDISEILGISQSAVSHQLKQLRMEGQVKTRREGKNIYYSLDDEHVVDILNQALKHI----";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLGMTHSAISHQLRVLKQARLVKFRKEGKVVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "---------------------------------QQLAEFFRVFGDSTRIRILYALSQSELCVCDIASLLNMGQSAISHQLRILKQMRLVKFRRDGRSVLYSLADSHIETILAQGMEHIGE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLGMTHSAISHQLRVLKQARLVKFRKEGKVVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLGMTHSAISHQLRVLKQARLVKFRKEGKVVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "---------------------------------QDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "---------------------------------QDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "---------------------------------QDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "---------------------------------QDLGDFFKVLSEPTRIKILYALSSSEMCVCDISNLLNMTQSAVSHQLKVLRTARLIKFRKEGKVVYYSLDDSHVENVFKQGLEHI----";
//    seqs[counter++]  = "---------------------------------EDLALLFKMFADPTRLKVLKALFEREMCVGDLAVLLKMTHSAVSHQLASLKKTRLVRSRKDGKVVYYSLDDDHIEEIFQKALDHVRE--";
//    seqs[counter++]  = "-----------------------------------MADFFKVFGDGTRLKILYYLSRHELCVADLALLVQMQQSAISHQLKLLRLHRLVKYRKEGTTTYYSLDDEHINSIFKVALEHLQE--";
//    seqs[counter++]  = "----------------------------AAEQLQALADFYKVFGDFTRIRILCILLRGEMCVCDLAQTLDMTQSAISHQLRVLKQVKLVTSRREGKTVFYSLADRHIRTIINQGMEHIQE--";
//    seqs[counter++]  = "---------------------------------QDLAEFFKVFGDATRLKILSVLLCSEMCVYDIATLLGMSQSAISHQLRVLKQMDLVKNRRDGKTIFYALADDHIITILNQGLNHIEE--";
//    seqs[counter++]  = "---------------------------------QDLAEFFKVFGDATRLKILSVLLCSEMCVYDIATLLGMSQSAISHQLRVLKQMDLVKNRRDGKTIFYALADDHIITILNQGLNHIEE--";
//    seqs[counter++]  = "------------------------------EILYKLADLYKVFGDATRIRILYTLSRGELCVCDIAELLGMTQSAISHQLRVLKQSALVKFRREGKAVYYSLADSHVATILAQGLDHVQE--";
//    seqs[counter++]  = "----------------------------ADESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIGIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------------ADESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIGIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------------ADESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIGIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------MEAPADETLYRLADLYKVFGDPTRIRILYALSGGELCVCDIAELLGMTQSAISHQLRVLKQSALVKFRRDGKTVYYSLADTHVATILAQGLDHVQE--";
//    seqs[counter++]  = "------------------------------EILYDLAELFRVFGDTTRIKILYALFESELCVNDIAQVVGLSQSAVSHQLRLLKTSKLVKFRREGKAIYYSLDDDHVRSMIALGMEHVEE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMGDGTRIQLLWALEESEMCVGDLAVLLNMTKSAVSHQLKVLRTAKLVRAEKKGKNVYYALNDHHVKSILEKALEHVCE--";
//    seqs[counter++]  = "----------TLQAIDAEAVEASRVEALPEAHLQMIVETFQALSDPTRARILYALIQRPMCVRDLAILVGVSPSGVSHQLRFLRDRRLVKSQRDGNTIYYQVDDHHVAALFKEADYHIDHVR";
//    seqs[counter++]  = "EEEITSYETKTIHKEIVE-----KVEKLMPEVIYDLADFFKILGDTTRMRILSALFHEEMCVYDIANLLKMTQSAISHQLRVLKQGRFVKHRKEGKVVYYSLEDEHIKHIVEQGMTHILEKR";
//    seqs[counter++]  = "--------CDIVHENVIEMVKKKMPQ---EEKLYDLAELFKVFGDTTRVKIISALFEAELCVCDIAELLHMTQSAISHQLRVLRQARLVKHRKEGKVVFYSLDDEHIKNIFNQGLEHILEPR";
//    seqs[counter++]  = "------------------------------------------LADPTRMRLLALKAAGELCVCDLALLAGVSVSAVSHQLRLLRQARLVAFRREGKQVYYRLADHHVERLLEGALEH-----";
//    seqs[counter++]  = "------------------------------ELLNSLADFYKAFADGTRVKILYVLQKSEMCVCDLAEILGVTQSAVSHQLRMLKQMKLVKNRRDGKTVYYSLADGHIQSIISQGMEHITE--";
//    seqs[counter++]  = "------------------------------EVA-GLSELFQVLADETRTKILYLLAVAELCVCDLAAALDLSLPAVSHHLRLLKTMRLVKYRREGKNVYYSLADEHVLRLIQVAQEHYAEQR";
//    seqs[counter++]  = "------------------------------ELLNSLADFYKAFADGTRVKILYVLQKSEMCVCDLAEILGVTQSAVSHQLRMLKQMKLVKNRRDGKTVYYSLADGHIQSIISQGMEHITE--";
//    seqs[counter++]  = "------------------------------ELLNSLADFYKAFADGTRVKILYVLQKSEMCVCDLAEILGVTQSAVSHQLRMLKQMKLVKNRRDGKTVYYSLADGHIQSIISQGMEHITE--";
//    seqs[counter++]  = "-------------------------------------------ADQTRLRILCLLRDREVCVHDIVEALDMSQSAISHQLRVLRDARLVSHRREGRHVYYRLADDHVREMLENALSH-----";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDTTRIKILYALFESEMCVCDIAALLGMSQSAVSHQLRILRQNKLVKFRKEGKVVYYSLADDHVKKIFEQGFDHINE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDTTRIKILYALFESEMCVCDIAALLGMSQSAVSHQLRILRQNKLVKFRKEGKVVYYSLADDHVKKIFEQGFDHINE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDTTRIKILYALFESEMCVCDIAALLGMSQSAVSHQLRILRQNKLVKFRKEGKVVYYSLADDHVKKIFEQGFDHINE--";
//    seqs[counter++]  = "-----------------------------------LSMLFKMFADPTRLRIFTILSHQTVCVDDLAEILGMTQSAVSHQLASLRKMNLVRSSKVGKNAYYQLADSHVMQIFSQALDHVKE--";
//    seqs[counter++]  = "-----------------------------------LSMLFKMFADPTRLRIFTILSHQTVCVDDLAEILGMTQSAVSHQLASLRKMNLVRSSKVGKNAYYQLADSHVMQIFSQALDHVKE--";
//    seqs[counter++]  = "----------------------------ADETFYDLAEFFKVFGDTTRIKILYALSSAEMCVCDMAALLGMSHSAISHQLRILKQTRLVKYRKEGKVVYYSLDDDHIKSIFDCGIAHVNE--";
//    seqs[counter++]  = "------------------------------------ADIFRALGDPSRLRMLSLLIHDELCVTEIAEALGDNLSAVSQRLKLLKSERIVGARREGKHIFYRLSDHHVKDLVTNALAHVTE--";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRREGKIVYYSLDDDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRREGKIVYYSLDDDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRREGKIVYYSLDDDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRREGKIVYYSLDDDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRREGKIVYYSLDDDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRREGKIVYYSLDDDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRREGKIVYYSLDDDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------ETIENVSQIFKVLADPTRIKILYLLSQEECNVNHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDTTRIKILYALFESEMCVCDIAVLLGMSQSAVSHQLRILRQNKLVKFRKEGKVVYYSLADDHVKKIFEQGFDHINE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDTTRIKILYALFESEMCVCDIAVLLGMSQSAVSHQLRILRQNKLVKFRKEGKVVYYSLADDHVKKIFEQGFDHINE--";
//    seqs[counter++]  = "------------------------------EILLRLAETFKVLGDPTRVRILHALSQEELCVCDIASLLSTTKSAISHQLRLLRSLRVVKFRKDGRIVYYSLDDSHVGNLLCEGLSHI----";
//    seqs[counter++]  = "------------------------------ETVIELSKIFKALGDPTRLKIIYSLSKRELCVCDIALLLEMNQSAISHQLRVLRNLRLVKYRKEGKSAVYSLDDDHVLGLFSQGLEHI----";
//    seqs[counter++]  = "------------------------------EITDKMAEMFKALGDPTRVRLIYALSQQELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "--------------------------------AEELAKLFKVLGDNTRIRILDALYRSELCVCDITALLGMNQSAVSHQLRVLRDARIVKSRKQGKNVLYSLDDEHISGLVRMGSEHVRELK";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIGIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIGIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------------ADESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------------ADESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------------ADESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------------ADESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ETSSEMADWFKAFSDPTRLRIIDALLQKELCVHDLTVLLDMGQSAISHQLRSLRNMRIVKRRKEGKTVYYSLDDAHIEQIFLQTLQHI----";
//    seqs[counter++]  = "------------------------------ETSSEMADWFKAFSDPTRLRIIDALLQKELCVHDLTVLLDMGQSAISHQLRSLRNMRIVKRRKEGKTVYYSLDDAHIEQIFLQTLQHI----";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDQTRIKIIFILFKEEMCVCDIAELVGMTQSAISHQLRVLKQARLVKFRKEGKTVFYSLDDDHITKIFDYGLHHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDQTRIKIIFILFKEEMCVCDIAELVGMTQSAISHQLRVLKQARLVKFRKEGKTVFYSLDDDHITKIFDYGLHHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDQTRIKIIFILFKEEMCVCDIAELVGMTQSAISHQLRVLKQARLVKFRKEGKTVFYSLDDDHITKIFDYGLHHIEE--";
//    seqs[counter++]  = "-----------------------------------MADFFKVFGDPTRVRILTALRRRELCVCDIAYVLGMSSSAVSHQLRGLKAARLVKNRREGKIVYYSLSDEHVEQILDLGFTHMEE--";
//    seqs[counter++]  = "------------------------------ELLYDLAELFKIFGDSSRIRILSLLQVDKLCVNEISQLLNLTPSAVSHQLRILRQARLVRYQKIGKEVFYSLDDDHIEKIFNQGLEHIQE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDTTRVKILSALFESELCVCDIADLLGMTQSAISHQLRVLRQARLVKPRKEGKVVFYSLDDEHIKNIFDQGMEHILE--";
//    seqs[counter++]  = "--------CDIVHENVIEMVRAKMPQ---EEKLYDLAELFKVFGDTTRVKIISALFEAEMCVCDIAELLHMTQSAISHQLRVLRQARLVKHRKEGKVVFYSLDDEHIKTIFNQGLEHILEPR";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDSTRIKIICALFESELCVCDMAALLGMTQSAISHQLRTLKSARLVKFRRQGKVIYYSLDDEHIKHIFDEGFKHITE--";
//    seqs[counter++]  = "--------CNTIHSDVINKVKKGMPE---DEVLYDLAELFKVFGDTTRTKILYALFEAEMCVCDLASLLGMSQSAVSHQLKVLKQTRLVKPRRDGKVVYYSLDDDHIKRIFNCGLEHINE--";
//    seqs[counter++]  = "--------CNTIHSDVINKVKKGMPE---DEVLYDLAELFKVFGDTTRTKILYALFEAEMCVCDLASLLGMSQSAVSHQLKVLKQTRLVKPRRDGKVVYYSLDDDHIKRIFNCGLEHINE--";
//    seqs[counter++]  = "------------------------------ETIENVSQIFKVLADPTRIKILYLLSQEECNVDHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "------------------------------EDAHSIAETFKILGDPTRVKILHTLSKRELCVCDISAVIAIGQSAVSHQLRLLRGARLVKHRKEGKMVWYSLDDEHISLLLAQGIEHV----";
//    seqs[counter++]  = "------------------------------ETVDEVSRLFKALADPTRIKMLYLLSQEECHVGHIAEMLGMTQSAVSHQLALLRNLRLVKYRREGKTLVYSCDDDHVISLLRQAIDHAQ---";
//    seqs[counter++]  = "------------------------------ETIENISRIFKVLADPTRIKILYLLSQEECNVNHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "-----------------------------------MADVFKVLGDPTRLRILRVLMNQEVCVRDIADELGMGQSAVSHQLRILRDARLVQFRRDGKTVYYSLADAHVFTLLDVGLEHVAE--";
//    seqs[counter++]  = "------------------------------QAASQVADWFKAFSDPTRVKLIDALLQRELCVHDLTVLLGMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLDDTHIEQIFVQTLQHTQ---";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "--------------------------------ADELAQLFKVLGDNTRIRILDALFRSELCVCDLTALLGMNQSAVSHQLRVLRDARIVKSKKQGKNVLYSLDDDHISELVRMGSEHVRELR";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "-------------------------------IAYKMSELFKALGDPTRIKLIYALAQKELCVHDLTQVLNMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDNHV---------------";
//    seqs[counter++]  = "---------------------------------QSMADLFKVFGDPTRVRILFALFQQEACVQEIANRLGMTQSAISHQLRILKQARLVSSRREGKSIFYALADDHIYTIFRQALEHIAE--";
//    seqs[counter++]  = "---------------------------------ERLSYLFKILGDPTRIKILSILDKKELCVNDIADKLNISVSAVSHQLNNLKVAKLVKSRRDGKNIYYTLDDDHVEKLFENALEHI----";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKIICALYESELCVCDIANLLNMTQSAVSHQLRTLKAARLVKFRRAGKVVYYSLDDEHIMRIFNEGLNHVNE--";
//    seqs[counter++]  = "---------------------------------RNLTEFFKIMGDGTRIQILCALIQNEMCVCDLAVLINVTKSAISHQLRSLKEAHLVKSRRSGKNVFYSLDDEHVKDILEKALDHIIE--";
//    seqs[counter++]  = "--------CNVIHENVVEMVKNALPQ---DEVLYDLAELFKAFGDSTRVKILCALFESEMCVCDLSAILGISQSAVSHQLRTLKASRLVKFKRVGKVVYYSLEDEHIKHIFNEGFKHIIE--";
//    seqs[counter++]  = "--------CNVIHEDVVEMVKNALPQ---DEVLYDLAELFKAFGDSTRVKILCALFESEMCVCDLSAILGISQSAVSHQLRTLKASRLVKFKRVGKVVYYSLEDEHIKHIFNEGFKHIIE--";
//    seqs[counter++]  = "--------CNVIHEDVVEMVKNALPQ---DEVLYDLAELFKAFGDSTRVKILCALFESEMCVCDLSAILGISQSAVSHQLRTLKASRLVKFKRVGKVVYYSLEDEHIKHIFNEGFKHIIE--";
//    seqs[counter++]  = "--------CNVIHENVVEMVKNALPQ---DEVLYDLAELFKAFGDSTRVKILCALFESEMCVCDLSAILGISQSAVSHQLRTLKASRLVKFKRVGKVVYYSLEDEHIKHIFNEGFKHIIE--";
//    seqs[counter++]  = "--------CSVIHEDVVNMVKKNMPK---EEHLYDLAELFKVFGDTTRIKILYALFASEMCVCDIAALINMSQSAVSHQLRVLKQARLVKYRKEGKVVYYSLDDEHIKQIFDQGYMHITE--";
//    seqs[counter++]  = "-----ASPCSNQHQPT-------EREVLAAPLAWRVADIFKALGDPTRVKIIALLDAGEMCVGEMCLTLGMSQPAISSQLRLLRTLGIVSVRREGKHAYYRLADEHVRHLFHQGLAH-----";
//    seqs[counter++]  = "--------CTVIHQDVVQAAYKAMLPA---DTTSSLAELFKIFGDATRIKILNALKCSEMCVCDLAACLNMTHSAISHQLRVLKAYNLVKPRKEGKVVYYSLADSHVTAILNTGLEHINE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKVFGDVTRLKLLSVLFHSEMCVCDLAKTLNMTQSAISHQLRILKQMKLVKNRREGKTVFYSLADGHIKTIINQGMEHIQE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKVFGDVTRLKLLSVLFHSEMCVCDLAKTLNMTQSAISHQLRILKQMKLVKNRREGKTVFYSLADGHIKTIINQGMEHIQE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKVFGDVTRLKLLSVLFHSEMCVCDLAKTLNMTQSAISHQLRILKQMKLVKNRREGKTVFYSLADGHIKTIINQGMEHIQE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKVFGDVTRLKLLSVLFHSEMCVCDLAKTLNMTQSAISHQLRILKQMKLVKNRREGKTVFYSLADGHIKTIINQGMEHIQE--";
//    seqs[counter++]  = "-------------------------------VVEEVSKIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRALRLVKYRREGKSLVYSCDDDHVISLLRQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VVEEVSKIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRALRLVKYRREGKSLVYSCDDDHVISLLRQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VVEEVSKIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRALRLVKYRREGKSLVYSCDDDHVISLLRQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VIEEVSRIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VIEEVSRIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VIEEVSRIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VIEEVSRIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VIEEVSRIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VIEEVSRIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "-------------------------------VIEEVSRIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKMLVYSCDDEHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "------------------------------ETIENVSRIFKVLADPTRIKILYLLSQEECNVNHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "------------------------------ETIENVSRIFKVLADPTRIKILYLLSQEECNVNHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "------------------------------ETIENVSRIFKVLADPTRIKILYLLSQEECNVNHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "------------------------------ETIENVSRIFKVLADPTRIKILYLLSQEECNVNHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "------------------------------ETIENVSRIFKVLADPTRIKILYLLSQEECNVNHIAEVLEMSQSAVSHQLSMLRNLRLVKYRREGKTLFYSCDDEHVISLLKQAIDH-----";
//    seqs[counter++]  = "-----------------------------------LSEVYKSLGDGTRLKILLALKEKESCVCDLAAALSMSQSAISHQLRVLRNVRLVKYRREGKMVYYSLDDEHILKILQEGLNHI----";
//    seqs[counter++]  = "-----------------------------------MAELFKAMGEPARVRILEALSISELCVCDLAELLSMSSSAVSHQLRVLRAARIVKYRKDGKNVIYSLDDAHIVGLLKQAEEHVAE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADHHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------GEYRHLDEETLFVVSQTFKALSDPTRIRILNLLCSEEHSVNDIAETLNLSQSSVSHQLRFLKNLRLVKFRREGTTLYYSEDDHHVMNLLKQAIDH-----";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRLIYALSRKELCVHDLSTILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------LSEFLEAFGDSSRIKILLTLSKRELCTCDISAITGLSVSAVSHQLRILRDKKLVKYRREGRNVYYSLDDEHVAAILDTALEHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "--------CNTIHSDVINKVKEGMPE---DEILYDLAELFKVFGDTTRTKILYALFEAEMCVCDLAALLGMSQSAVSHQLKVLKQTRLVKPRRDGKVVYYSLDDDHIKRIFNCGLEHINE--";
//    seqs[counter++]  = "-----------------------------------LADLFKVLGDSTRVRIICALFQAEMCVCDIAALLSMNQSAISHQLRVLKQARLVKYRKDGKVVYYSLEDEHVKRIFDQGLIHIDE--";
//    seqs[counter++]  = "------------------------------------------LSDPTRMRLLALRAAGELCVCDLALLAGVSVSAVSHQLRLLRQARLVAFRREGKQVYYRLADQHVEALLEGALAHAEE--";
//    seqs[counter++]  = "-------------------------------VVKEVSKIFKALADPTRMKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRALRLVKYRREGKSLVYSCDDDHVISLLRQAIDHAQ---";
//    seqs[counter++]  = "-----------------------------------LAATFRLLGDRTRVRILEALAGDELCVCDLAAVVGHSQSAVSHQLRLLRAAKLVRVRRDGKNAFYSLDDDHVRHLFRQALDHVQESR";
//    seqs[counter++]  = "------------------------------EVLYELAEIFKVFGDSTRIKILCALFEGEMCVCDMAELLGVSQSAVSHQLRVLKQARLVKFRRDGKIVYYSLADDHVKHIFNEGLNHVLE--";
//    seqs[counter++]  = "------------------------------ETVDEVSRLFKALADPTRIKMLYLLSQEECHVGHIAEVLGMSQSAVSHQLALLRTLRLVKYRREGKTLVYSCDDDHVISLLKQAIDHAQ---";
//    seqs[counter++]  = "------------------------------EVVYDLADFFKILGDTTRMRILSALFQEEMCVYDIANLLKMTQSAISHQLRVLKQGRFVKYRKEGKIVYYSLEDDHIKHIVEQGMTHILE--";
//    seqs[counter++]  = "------------------------------------------LADPTRMRILLAMKQGELCVCDLSHLLGMSQSAISHQLRVLRDNRLVSWRREGRQVFYRLADRHVEEILEDALEH-----";
//    seqs[counter++]  = "-----------------------------------LADLFKVFGDPTRIRILSVLSKQELCVQDIADALSMTQSAISHQLRILKQSALVKFRREGKTIYYSLADDHVATIMAQGLEHVCE--";
//    seqs[counter++]  = "------------------------------EVLFDLAEFFKVFGDSTRIKIMYALFEHEMCVCDIAALLNMTQSAVSHQLRVLKQARLVKYRKEGKVVYYSLNDEHIKDIVKEGLEHINEGR";
//    seqs[counter++]  = "----------------------------------ALSDFFKVMGDSTRIRLLWALEEAELCVNDLAVLLNMTKSAVSHQLKILRTAKLVKAEKQGKNVYYSLIDEHVKVILEMALDHVKE--";
//    seqs[counter++]  = "-----------------------------------LADLFKVFGDPTRIRILSVLSKQELCVQDIADALSMTQSAISHQLRILKQSALVKFRREGKTIYYSLADDHVATIMAQGLEHVCE--";
//    seqs[counter++]  = "------------------------------EEMNDLADFFRIFGDATRLKILYALKFSEMCVLDIAQLLGMSQSAISHQLRVLKQMDLVKNRRDGKTIFYSLADAHIVTILSQGLDHIEE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKTFADSTRIKIISALSNAEMCVCDLAHLLNTSQSAISHQLRVLRQNRLVKYRKVGKIVYYSLDDDHVLEVMRQGMEHI----";
//    seqs[counter++]  = "------------------------------ETTDKMAEMFKALGDPTRVRLIYALSQQELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-------------------------------------ELLKAVGDPTRMRILCALADRELCVCDLQAVLGLSQSAVSHQLRTLRNARLVTYRREGKMAYYTLADDHVRRLLDLSLEHV----";
//    seqs[counter++]  = "------------------------------EILYELAELFKVFGDSTRIRILYVLFEDELCVGDIAELLNMSQSSVSHQLRILKDAKLVKFRREGKSIFYALDDEHVYHILEMGMEHVEE--";
//    seqs[counter++]  = "------------------------------EVMFDLSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLNTSQSAISHQLRLLKAFRLVKSRKAGKVVYYSLSDDHVKSIIELGLAHLSE--";
//    seqs[counter++]  = "------------------------------EVMFDLSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLNTSQSAISHQLRLLKAFRLVKSRKVGKVVYYSLSDDHVKSIIELGLTHLSE--";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDTTRIKILCALFESEMCVCDIAATLGMNQSAVSHQLRILKQSKLVKYRKEGKVVYYSLADDHVIKIFDQGFSHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDTTRIKILCALFESEMCVCDIAATLGMNQSAVSHQLRILKQSKLVKYRKEGKVVYYSLADDHVIKIFDQGFSHIEE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDSTRIKIICALFESELCVCDMAALLGMTQSAISHQLRTLKSARLVKFRRQGKVIYYSLDDEHIKHIFDEGFKHITE--";
//    seqs[counter++]  = "---------------------------------EKLSMFFKAISDETRIKILYSLSRSKMCVCDLAALLGMTASAISHQLRVLRQAELVRSEKQGKVVYYMLSDNHVNTVFSNALEHIME--";
//    seqs[counter++]  = "---------------------------------EKLSMFFKAISDETRIKILYSLSRSKMCVCDLAALLGMTASAISHQLRVLRQAELVRSEKQGKVVYYMLSDNHVNTVFSNALEHIME--";
//    seqs[counter++]  = "---------------------------------EKLSMFFKAISDETRIKILYSLSRSKMCVCDLAALLGMTASAISHQLRVLRQAELVRSEKQGKVVYYMLSDNHVNTVFSNALEHIME--";
//    seqs[counter++]  = "---------------------------------EKLSMFFKAISDETRIKILYSLSRSKMCVCDLAALLGMTASAISHQLRVLRQAELVRSEKQGKVVYYMLSDNHVNTVFSNALEHIME--";
//    seqs[counter++]  = "------------------------------ELIQNVADFFKAFSDSTRLKIVSMLLEEEMCVCDIANVLNMTHSSVSHQLRVLRQLRVVKNRKDGKTVYYSLDDDHVRTILAQGINHL----";
//    seqs[counter++]  = "--------CCTIHEDCVECVKRNMLD---EETFMKLSGLFKVLGDYTRIRIIYALFNKELCVCDIAEVLNMSQSSISHQLRTLKAARLVKFRREGKTVFYSLDDKHISELFKSGLEHV----";
//    seqs[counter++]  = "-----------------------------------LAATFRLLGDRTRVRILEALACDELCVCDLAAVVGHSQSAVSHQLRLLRAAKLVRVRRDGKNAFYTLDDDHVRHLFRQALDHVQESR";
//    seqs[counter++]  = "---------------------------------QLLAELFKVLGDPTRLRIVRHLLQKEMCVTEIADSMDMGQSAISHQLRVLRQARLVTFRKEGKTAWYRLNDDHVIVLIRQGLEHV----";
//    seqs[counter++]  = "-------------------------------------------ADQTRLRILCLLRDREVCVHNIVEALDMSQSAISHQLRVLRDARLVSHRREGRHVYYRLADDHVREMLENALSH-----";
//    seqs[counter++]  = "------------------------------EMLYDLADFYKVFADSTRIKILYALLQSELCVCDLAEVLGASQSAVSHQLRMLKQMKLVKFRREGKAIVYSLSDDHIQNILSQGFEHITE--";
//    seqs[counter++]  = "----------------------------AEETIFDLAEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLGTSQSAISHQLRLLKVFRLVKSRKAGKVVYYSLLDDHVKSIIELGLAHLSE--";
//    seqs[counter++]  = "------------------------------------AEFFKVFGDGTRIKLLRLLLNQELCVGDIAEHLNMNQSAVSHQLRVLRQNDLVKYRKEGKTVFYSLDDEHIKIVLEQGMSHI----";
//    seqs[counter++]  = "-----------------------------------LSEFFKVFADMTRIKILHALSCSEMCVCDIAALLGATHSAVSHQLRILKQARLVKFRKDGKVVYYSLDDEHIKSIFDCGLSHISE--";
//    seqs[counter++]  = "-----------------------------------LADLYKVFGDPTRIRILYALSGGELCVCDIAELLGMTQSAISHQLRVLKQSALVKFRRDGKTVYYSLADAHVATILAQGLDHVQE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMGDSTRIRLLWALEEAEMCVNDLAVLLDMTKSAVSHQLKILRTAKLVKSEKRGKNVYYALNDHHVKVILEMALEHVKE--";
//    seqs[counter++]  = "-----------------------------------MAQLFKILGDPTRVRILQALSISEMCVCDIAALLEMTQSAISHQLRLLKQGRLVKYRRDGKVVYYSLNDNHVRLIFDQALSHITE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKVLGDSTRIRVLCALFEDEMCVCDIAALLGMTQSAISHQLRVLKQARLVKYKREGKVVYYSLEDEHVKRIFDQGLAHISE--";
//    seqs[counter++]  = "------------------------------EVLYDLADLFKIFGDTTRIKILCALFQAEMCVCDIAALLGMTQSAISHQLRVLKQSRLVRYRKEGKVVYYSLDDEHVKGIFNLGLTHIEE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLKMTHSAISHQLRVLKQARLVKFRKEGKTVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLKMTHSAISHQLRVLKQARLVKFRKEGKTVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLKMTHSAISHQLRVLKQARLVKFRKEGKTVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "KDELMSCKNNYVHEDKVQIA---EHNMPSEENLISVTELFKVLGDPTRTKILSVLYNDELCVCDISKILNMTKSAISHQLKTLRMARLIKSRRSGKEIYYSLADDHVGKIYHMAIEHVME--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLKMTHSAISHQLRVLKQARLVKFRKEGKTVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "------------------------------EQFQNLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIFDAGLSHIME--";
//    seqs[counter++]  = "------------------------------EQFQNLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIFDAGLSHIME--";
//    seqs[counter++]  = "------------------------------EQFQNLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIFDAGLSHIME--";
//    seqs[counter++]  = "------------------------------EQFQNLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIFDAGLSHIME--";
//    seqs[counter++]  = "------------------------------EQFQNLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIFDAGLSHIME--";
//    seqs[counter++]  = "------------------------------EQFQNLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIFDAGLSHIME--";
//    seqs[counter++]  = "------------------------------EQFQNLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIFDAGLSHIME--";
//    seqs[counter++]  = "--------CNTIHDDVITKVKEGMPE---DEILYDLAELFKVFGDTTRTKILYALFEAEMCVCDLATLLGMSQSAVSHQLKVLKHTRLVKPRRDGKVVYYSLDDDHIKRIFNCGLEHINE--";
//    seqs[counter++]  = "--------CNTIHDDVITKVKEGMPE---DEILYDLAELFKVFGDTTRTKILYALFEAEMCVCDLATLLGMSQSAVSHQLKVLKHTRLVKPRRDGKVVYYSLDDDHIKRIFNCGLEHINE--";
//    seqs[counter++]  = "--------CNTIHDDVITKVKEGMPE---DEILYDLAELFKVFGDTTRTKILYALFEAEMCVCDLATLLGMSQSAVSHQLKVLKHTRLVKPRRDGKVVYYSLDDDHIKRIFNCGLEHINE--";
//    seqs[counter++]  = "---------------------------------QELAQLFKVLGDHTRVRILNALYRSELCVCDLTSILAMNQSAVSHQLRVLRDARIVRSKKQGKNVLYALDDSHIAELIKIGFEHVQE--";
//    seqs[counter++]  = "------------------------------EVLYELADLFRVFGDSTRIKILYALHDSELCVQDIANAVQLSQSAVSHQLRVLKDCKLVRFRREGKTVYYALDDDHVRSILSMGMDHIEE--";
//    seqs[counter++]  = "------------------------------ETMDAIAELFKGFADSTRVHILALLSRQELCVTDIAETVDVSQSAISHQLRILKQMHLIKFRREGKNILYSLADDHVKTILQMGLEHVLE--";
//    seqs[counter++]  = "------------------------------EVA-GLSELFQALADETRTKILYLLASEELCVCDLAAILDLSLPAVSHHLRLLKTMRLVKYRREGKNVYYSLADEHVLRLIQVAQEHYEEER";
//    seqs[counter++]  = "-----------------------------------MAELFKALGDPTRVRLIYALSRQELCVHDLSTILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "--------------------------------AVDLAELFKALGDPTRVKMIYALLDRELCVHDLCQVLDMAQSAVSHQLRYLRNVRIVKRRKAGKTVYYSLDDDHVKEIFTQTLQHVQ---";
//    seqs[counter++]  = "------------------------------------AELFKVFGDPTRLKLLAALLAQEMCVCDLSDLLGISQSAVSHQLRLLRTSRLVKNRREGKSVYYSLDDDHVATILAQGMEHV----";
//    seqs[counter++]  = "------------------------------EVLYELGDFFKLLGDSTRIKILSALFHSEMCVCDIASLFDMTQSAISHQLRVLKQGRLVKYRKSGKVVYYSLDDEHVKEIVEQGLNHITE--";
//    seqs[counter++]  = "------------------------------EQFQTLGTLFKMFSDPTRLKILSALFQEELCVCDLSELLEMTHSAVSHQLSVLRQNRLIKYRRSGKNIYYSLDDEHIQLIYDAGLSHIME--";
//    seqs[counter++]  = "------------------------------EILYDLAELFKIFGDSTRIKILYALFESEMCVCDIAQLLNMTQSAISHQLRSLKQSKLVKYRREGKTVFYSLADAHVRTIINQGLEHVEE--";
//    seqs[counter++]  = "------------------------------------AEVFKVFGDTTRMKIISALLEAELCVGDIAEITNSTQSAISHQLRVLKQAKLVKFRKEGKIVYYSLDDEHVSEMYEMAKRHIEE--";
//    seqs[counter++]  = "------------------------------EILYDLAELFKIFGDSTRIKILYALFESEMCVCDIAQLLNMTQSAISHQLRSLKQSKLVKYRREGKTVFYSLADAHVRTIINQGLEHVEE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLKMTHSAISHQLRVLKQARLVKFRKEGKIVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLKMTHSAISHQLRVLKQARLVKFRKEGKIVYYSLDDNHISQIFNCGLSHIQE--";
//    seqs[counter++]  = "-----------------------------------LADFYKVFGDATRVKILCVLLESEMCVCDLAELLGMTQSAISHQLRVLKQMKLVKNRREGKTVYYSLADGHIQTIISQGMEHIQE--";
//    seqs[counter++]  = "-----------------------------------LADFFKVFADSTRIKMLYVLMCGEMCVCDLAQTLNMTQSAISHQLRTLKQMDLVRNRREGKTVFYSLADGHIKTILRQGLDHIEE--";
//    seqs[counter++]  = "--------------------------------AASLADVFKALGDPTRVKIIYALLQQELCVHDITQVLDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDEHIEQIFVQMLKHV----";
//    seqs[counter++]  = "--------------------------------AASLADVFKALGDPTRVKIIYALLQQELCVHDITQVLDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDEHIEQIFVQMLKHV----";
//    seqs[counter++]  = "------------------------------EKLQELADFFKVFGDSTRIRILCILLCGEMCVCDLAQTLDMTQSAISHQLRVLKQMKLVTNRREGKTVFYALADGHIRTIINQGMEHIQE--";
//    seqs[counter++]  = "--------------------------------AASLADVFKALGDPTRVKIIYALLQQELCVHDITQVLDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLDDEHIEQIFVQMLKHV----";
//    seqs[counter++]  = "---------------------------------KELADFYKVFADATRIKILWILLESEMCVCDLAEILGMTQSAISHQLRVLKQMKLVKNRREGKTVYYSLADGHIQTIISQGMEHIAE--";
//    seqs[counter++]  = "--------------------------------AASMSELFKALGDPTRIKIIHALLQHELNVHDLTVVLGMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLDDNHIEQLFVLTLQHLE---";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIRILHALFESELCVGDIAQILNLSQSAVSHQLKLLKDAKLVRFRREGKIIFYSLDDDHVRTILSMGMEHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIRILHALFESELCVGDIAQILNLSQSAVSHQLKLLKDAKLVRFRREGKIIFYSLDDDHVRTILSMGMEHIEE--";
//    seqs[counter++]  = "-----------------------------PKETMATARIFKALGDPNRLRLIMALLKGEMCVCDLSAFLGISESAASHQLRRLKDLALVKSRREGQVLYYSLDDDHVAQLLDVCLEHV----";
//    seqs[counter++]  = "-----------------------------------LAEFLEAFADSTRIKILLALTIGELCTCDLSSITGLSVSAISHQLRTLRDKKIVKYRRAGRNVYYSLDDEHVEAILKVAMEHIKERR";
//    seqs[counter++]  = "--------CDVIHAEVVE-----EVKKKMPEVLYDLADFFKVLGDSTRVKIMWALDEREMCVCDLAVLLNMTKSAISHQLRSLKQANLVKFRKEGKIVFYSLSDDHVKEIFEKGLEHIKE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKILYALFSSEMCVCDIADLLKMTHSAISHQLRVLKQARLVKFRKEGKTVYYSLDDNHISQIFNCGLAHIQE--";
//    seqs[counter++]  = "------------------------------EKLNDLAEFFKVFGDSTRIKIICALFSSEMCVCDIAILLNMTQSAISHQLRVLKQARLVKYRKEGKVVYYSLDDDHIKRIFDQGLLHINE--";
//    seqs[counter++]  = "------------------------------ELLYDLAEFFKIFGDSSRIRILSILREDKLCVNEISYLLQLSASAVSHQLRILRQARLVRYQKIGKEVFYSLDDDHIEKILDQGLEHIKE--";
//    seqs[counter++]  = "--------CDIVHENVIEMVRKKMPQ---EEKLYDLAELFKVFGDTTRVKIISALFEAEMCVCDIAELLHMTPSSISHQLRVLRQARLVKHRKEGKVVFYSLDDEHIKTIFNQSLEHILEPR";
//    seqs[counter++]  = "------------------------------KTAKELSELFKVVSDPTRIKILWAIGGGEVCVCCISELLGMSVSAVSHQLKTLRQAHLVKARREGRNIYYSLDDHHVKILLDVLLEHMEE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKTFGDSTRIKIICALFQSEMCVCDIAALLGMNQSAISHQLRVLKQARLVKYRKEGKVVYYCLDDDHVKGIFDQGLAHLNE--";
//    seqs[counter++]  = "-----------------------------------LAELFRVFGDTTRIKILCALAESEMCVCDIAALLNMTQSSISHQLRILKQARLVRYRREGKVVYYALDDEHVKQIFDLGLIHLNE--";
//    seqs[counter++]  = "---------------------------------RGLADFFKVFADATRIRILCVLSCSEMCVCDLAQTLDMTQSAISHQLRLLKQMKLVVNRREGKTVFYSLADSHIKTIMNQGMEHIRE--";
//    seqs[counter++]  = "---------------------------------RGLADFFKVFADATRIRILCVLSCSEMCVCDLAQTLDMTQSAISHQLRLLKQMKLVVNRREGKTVFYSLADSHIKTIMNQGMEHIRE--";
//    seqs[counter++]  = "---------------------------------RGLADFFKVFADATRIRILCVLSCSEMCVCDLAQTLDMTQSAISHQLRLLKQMKLVVNRREGKTVFYSLADSHIKTIMNQGMEHIRE--";
//    seqs[counter++]  = "---------------------------------RGLADFFKVFADATRIRILCVLSCSEMCVCDLAQTLDMTQSAISHQLRLLKQMKLVVNRREGKTVFYSLADSHIKTIMNQGMEHIRE--";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKAFGDSTRVKLLCALFEADMCVCDLAAVLGVSQSAVSHQLRTLKAARLVKFKRVGKVVYYSLDDEHIKGIFNQGFEHIME--";
//    seqs[counter++]  = "------------------------------------AALLKAVSDPTRLRLLTALGTGELCVCDLALIAGTSESAVSHQLRLLREQNLVLPRKEGRVVYYRLADAHVTDLLRNVLEHVGE--";
//    seqs[counter++]  = "-----------------------------------LSELFRVLADETRTKILYLLAAEELCVHDLARILDLTLPTISHHLRLMRLMRLVKSRREGKHVYYSLSDDHVLQLIQTAQEHYQE--";
//    seqs[counter++]  = "-----------------------------------LAEIFKVLSEPTRVRILQALSEEELCVCDIAAVVETTPSAISHQLRILRTNRLVKSRKDGKMVYYSLDDEHVRNLFEEGIRHLKE--";
//    seqs[counter++]  = "---------------------SGHLEHLKDKVVAGLSEFFKVLGDETRTKILYLLAHQELCVCDLAALLDTSLPAVSHHLRLLKALRLVKYRRDGKMVYYSLDDEHILNLIREAQAHFAEGR";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRVRILYALYRSELCVCDLSDALDMTQSAISHQLQILRTNKLVKSRREGKQIYYSLADEHVVTIMAQGLDHILE--";
//    seqs[counter++]  = "--------------------------------AQQVAESFKLLGDTTRVKMLHALSKRELCVCDLAAVVEMGQSAVSHQLRLLRSARLVKYRKEGKMAWYSLDDGHIGLLLSQCIEHIQ---";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKIFGDSTRVKILYALLESELCVCDIAKLMDVSQSAVSHQLRVLKASKLVKFRREGKTIYYSLADSHVVSILNQGMEHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKALGDYTRVRMLYALSINELCVCALAEVLDMSPSAISHQLRLLRAARLVRYRKDGKNVYYTLDDDHVRALIVQGLDHVRE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRNADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRNADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRNADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRNADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMEMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDDHVECLVRMGMEHV----";
//    seqs[counter++]  = "-----------------------------------MASFFRMMGDPTRIRILSLLFDEELCVHTLADRLEMTQSAVSHQLALLKHAWLVRSRREGKHVYYSLADEHVKQVYELAREHLEE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKVLGDSTRIKVLWALAEAEMCVCDIAALLGMTQSAISHQLRVLKQARLVKYKRNGKVVYYSLDDDHVKSIFNQGLIHISE--";
//    seqs[counter++]  = "------------------------------ETMFDLSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLATSQSAISHQLRLLKAFRLVKSRKAGKVVYYSLSDDHVKSIIELGLAHLSE--";
//    seqs[counter++]  = "-----------------------------------LADMYKALGDPSRLRIVMALSQGEMCVCDLAAYLEISESAVSHQLRRLRSLALVKNRRDGKILYYSLDDDHVSSLVALGLEHVRE--";
//    seqs[counter++]  = "------------------------------ETMFDLSEFFKVFSDSTRIKILSSLLISEMCVCDLAAVLNTSQSAISHQLRLLKAFRLVKSRKAGKVVYYSLSDDHVKSIIELGLAHLSE--";
//    seqs[counter++]  = "------------------------------ETMFDLSEFFKVFSDSTRIKILSSLLLSEMCVCDLAAVLNTSQSAISHQLRLLKAFRLVKSRKVGKVVYYSLSDDHVKSIIELGLAHLSE--";
//    seqs[counter++]  = "----------------------------ADQIASPLANFFKTLSDPTRLRIILAIGTTSLSVNEISTIINMSQSSVSHQLRILRDNHLVISQRFGQHIHYQLTDQHVLTILENSLDHISE--";
//    seqs[counter++]  = "-----------------------------------LADLFKIFSDSTRIKILCILFESEMCVYDLSGILGMSQSAVSHQLRLLKQSKLVKHRREGKIIFYSLSDDHIRKIIDNGLEHIQE--";
//    seqs[counter++]  = "------------------------------ELLYDLAEFFKIFGDSSRIRILSILREEKLCVNEISFLLQISPSAVSHQLRILRQARLVRYQKIGKEVFYSLDDDHIEKILDQGLEHINE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVLGDYTRIKIIYALLKKELCVCDIAELLDMSQSSISHQLRTLKAARLVKFRKEGKVVYYSLDDEHIEHILNASLEHVE---";
//    seqs[counter++]  = "------------------------------------------MGDANRLKILSALTRGELCVCDLAAVIRLSESATSHQLRLLRIGRGVASRKEGRTVYYRLLDQHVTTLIANVLDHARE--";
//    seqs[counter++]  = "-----------------------------------LAQLFAAFGDPTRLRILTALRSGDLCVCDLTAVLGMTASAVSHQLRLLRNLRLVRSRKVGRVVYYHLDDEHVLNL------------";
//    seqs[counter++]  = "---------------------------------KELADFYKVFGDSTRIKILCVLLESEMCVCDLAEVLGMTQSAISHQLRVLKQMKLVKNRREGKTVYYSLSDGHIQTIISQGMEHITE--";
//    seqs[counter++]  = "-----------------------------PERATTMAELFKALGDPTRVRLIYALSRQELCVHDLSAILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------LSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLGTSQSAISHQLRLLKVFRLVKSRKAGKVVYYSLSDDHVKSIIELGLAHLSE--";
//    seqs[counter++]  = "------------------------------EITDKMAEMFKALGDPTRVRLIYALSQKELCVHDLSVILDMGQSAISHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHV----";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKIFGDSTRIKILYVLFESEMCVCDIAQLLGMTQSAISHQLRSLKQSRLVKARREGKTVFYSLADGHVRTILDQGMEHVAE--";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKIFGDSTRIKILYVLFESEMCVCDIAQLLGMTQSAISHQLRSLKQSRLVKARREGKTVFYSLADGHVRTILDQGMEHVAE--";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKIFGDSTRIKILYVLFESEMCVCDIAQLLGMTQSAISHQLRSLKQSRLVKARREGKTVFYSLADGHVRTILDQGMEHVAE--";
//    seqs[counter++]  = "------------------------------EVVYDLSDFFKILGDTTRMKILSALFQEEMCVCDIAYLLKMTQSAISHQLRVLKQGRFVKYRKEGKVVYYSLEDDHIKHIVEQGMTHILEKR";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKIFGDSTRIKILYVLFESEMCVCDIAQLLGMTQSAISHQLRSLKQSRLVKARREGKTVFYSLADGHVRTILDQGMEHVAE--";
//    seqs[counter++]  = "-----------------------------------LADLFKMFADSTRLKILCILCESEMCVNDIANLISMSQSAVSHQLRILKQSKLIRGRREGKIVFYSLADSHINTIINNGLEHIQE--";
//    seqs[counter++]  = "---------------------------------KELADFYKVFADATRIKILWILLESEMCVCDLAEILGMTQSAISHQLRVLKQMKLVKNRRDGKTVYYSLADGHIQTIISQGMEHIAE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------QTAVDLADLFRALGDPTRVKIIYALLQQELCVHDISTALGMGQSAVSHQLRYLRNLRILKRRKVGKTVFYSLDDDHMEQIFVQTLQHL----";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "-----------------------------------LSETFGALADSNRAKILHSLLNQELCVCDIACVVGISESAISQHLRILRTLRLVKQRKQGRMMYYSLNDNHIRQLLEICLEH-----";
//    seqs[counter++]  = "--------------------------------ASELADVFKALGDPTRVKIIHALLQNELCVHDLTQVLEMGQSAVSHQLRVLRNARIVKRRKVGKTVYYSLDDDHVEQIFVQTLQHL----";
//    seqs[counter++]  = "--------------------------------ASELADVFKALGDPTRVKIIHALLQNELCVHDLTQVLEMGQSAVSHQLRVLRNARIVKRRKVGKTVYYSLDDDHVEQIFVQTLQHL----";
//    seqs[counter++]  = "------------------------------ELILEIADFFDALGNPTRLKILFALLEDELCTCDLSNITGLSVSAVSHQLRILKDRKIITYRKDGKNVFYKLNDEHIREILKVALEHMKE--";
//    seqs[counter++]  = "---------------------------------EELAQLFKVLGDHTRIRILNALCLSELCVCDLTSILGMNQSAVSHQLRVLRDAKLVKSRKQGKNVLYTLDDTHVSTLIRTGSEHIRE--";
//    seqs[counter++]  = "-------------------------------VLNDMAEFFKVFGDVTRIKILSALFQKEMCVCDIAAVLDMNQSAISHQLRLLKSRRLVKFRREGKVIYYSLDDAHIKKIFNEGLHHIQ---";
//    seqs[counter++]  = "------------------------------KVIYELSEFFKILSDQTRLKILVLLFEKEQNVSELQRQIGVTQSNISHQLRILRQANLVRYRKIGRNVYYRLYDEHVEIIIKYAMEHLKE--";
//    seqs[counter++]  = "------------------------------EEVQKLSAIYKALGDPTRFKILFCLKQEEMCVCDISAILDMSQSAISHQLRVLRNLRIVKYRKEGKMVFYSLDDKHIFRILDEGINHI----";
//    seqs[counter++]  = "------------------------------ETLHDLADLFKVFGDSTRIKILCALFQAEMCVCDIAALLGMTQSAISHQLRVLKQARLVKYRKDGKVVYYSLDDDHVKGIFNQGLIHINE--";
//    seqs[counter++]  = "------------------------------EALYDLADLFKVLGDSTRIKVLCVLFQAEMCVCDIAALLSMTHSAISHQLRVLKQARLVKYRKEGKVVYYSLDDEHVKSIFDQGMIHIAE--";
//    seqs[counter++]  = "--------CCETHDPNQRAVEAVRLRCCSRETMSDLAAIFKLMGEPVRITILHALSIRDLCVCDLAELLGMSHSAVSHQLRLLRTARMVRFEKQGRKAIYSLNDRHVETIMQTALAHMQ---";
//    seqs[counter++]  = "-----------------------------------LADLFKIFSDSTRIKILCILFESEMCVYDLSGILGMSKSAVSHQLRLLKQSKLVKHRREGKIIFYSLSDDHIRKIIDNGLEHIQE--";
//    seqs[counter++]  = "------------------------------ELLYDLSDLYKVFGDTTRIKILHVLSISEMCVCDISALLGMKQSSVSHQLKTLRQAKLVKYRRSGKVVYYSLDDNHVVEIFNQGLAHITE--";
//    seqs[counter++]  = "---------------------------------QKLSNMFKLFSDETRLKIICSLLKEELCVCDLCELLGLNQSQVSHQLQLLRNSKLVKFRREGKQIFYSLDDEHVELIIQMALDHILE--";
//    seqs[counter++]  = "EDEPIACQLKVIHLDRLRQAKA---QGPSDDELERLSLIFKAMGDPNRLKILTALMGGEMCVCDLAAHAGLSDSAISHALRRLRDLALVKPRRDGQIIYYSLDDAHVAGQLQLGLDHL----";
//    seqs[counter++]  = "-----------------------------------MAQLFKAMGDANRLKVLWALEKEEMCVCDIAAFLKVSESAVSHQLRMLRQLHLVSNRREGQVLYYRLNDHHINELMLIALKHTRE--";
//    seqs[counter++]  = "---------------------------------QDLADFFKVFGDLTRVKMLYVLFQSEMCVCDLAQVLQMTQSAISHQLRVLKQMKLVTNRREGKTVFYSLADSHIKTIMNQGMEHIRE--";
//    seqs[counter++]  = "---------------------------------QDLADFFKVFGDLTRVKMLYVLFQSEMCVCDLAQVLQMTQSAISHQLRVLKQMKLVTNRREGKTVFYSLADSHIKTIMNQGMEHIRE--";
//    seqs[counter++]  = "--------------------------------AVNMAEMFKALGDPTRVKIIYALSQQELCVHDLSVVLEMGQSAVSHQLRYLRNVRIVKRRKSGKTVFYSLDDDHVKEIFRQTLQHL----";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRLIYALSQRELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "---------------------------------QVLANNFKILGDPTRLRILQVLMNHELCVRDIADLIHMEQSAVSHQLRTLRDAGLVIFRREGKVVYYSLADDHVFTLLSVGIEHVSE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVLGDSTRAKIMWALDESEMCVCDLAVLLGMTKSAVSHQLRSLREANLVKNRREGKNVFYSLADDHVKQIFEKGLEHIRE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVLGDSTRAKIMWALDESEMCVCDLAVLLGMTKSAVSHQLRSLREANLVKNRREGKNVFYSLADDHVKQIFEKGLEHIRE--";
//    seqs[counter++]  = "---------------------------LAEPTVQQLAEIFKILGDSTRIKILHLLTLREMCVCDIAKTLAMGQSAISHQLRVLRAARLVKFRKDGKVAWYSLDDEHVVGLMCQGLEHI----";
//    seqs[counter++]  = "------------------------------EVLYELADLFRVFGDSTRIKILYALHDNELCVQDIANAVQLSQSAVSHQLRVLKDSKLVRFRREGKTVYYALDDDHVRSILSMGMDHIEE--";
//    seqs[counter++]  = "------------------------------ESLSKIAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDATRIRILCALSEGEICVSDLAETLSMTQPAISHQLRILKNTRLVKARRDGKQIYYSLADAHVSSIIGTALEHVEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDATRIRILCALSEGEICVSDLAETLSMTQPAISHQLRILKNTRLVKARRDGKQIYYSLADAHVSSIIGTALEHVEE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLVHIQE--";
//    seqs[counter++]  = "------------------------------EQAMEASRLLKAISDPTRIRILHLLSQEECPVGHIAEVLGMSQSAVSHQLSYLRSLRLVKYRRDGNTYYYTYEDEHVIGILRQVLDHL----";
//    seqs[counter++]  = "------------------------------EIIYDLADFFKILGDTTRMRILSALFQEEMCVYDIANLLKMTQSAISHQLRVLKQGRFVKHRKEGKIVYYSLEDEHIKHIVEQGMIHILEKR";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLVHIQE--";
//    seqs[counter++]  = "-----------------------------------LADLFKMFADSTRLKILCILCESEMCVNDIANLISMSQSAVSHQLRILKQSKLIRGRREGKIIFYSLADSHINTIINNGLEHIQE--";
//    seqs[counter++]  = "-----------------------------------MADWFKAFSDPTRLRIIDALLQRELCVHDLTVLLEMGQSAISHQLRSLRNMRIVKRRKEGKTVYYSLDDGHIEQIFIQTLQHI----";
//    seqs[counter++]  = "-----------------------------------LGTLFKMFSDPTRLRILSLLFQSEMCVCDIVALLDMTQSAVSHQLSVLRANRLIKYRRVGKNIYYSLDDEHIQYIFNAGVEHIQE--";
//    seqs[counter++]  = "-----------------------------------LAELYRVFGDSTRIRILYALFESEMCVCDIAQVLGMSISAISHQLRVLKQARLVKYRREGKTVFYSLSDDHVRSIIDQGIGHVEE--";
//    seqs[counter++]  = "-----------------------------------LGTLFKMFSDPTRLRILSLLFQSEMCVCDIVALLDMTQSAVSHQLSVLRANRLIKYRRVGKNIYYSLDDEHIQYIFNAGVEHIQE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDSTRIKIICALFESELCVCDMAALLGMTQSAISHQLRTLKSARLVKFRREGKVIYYSLDDEHIKHIFDEGFKHITE--";
//    seqs[counter++]  = "------------------------------EYIQELSAFFKVFGEENRTRILYALSIREMCVNDLVTLLGMSQSSVSHQLQILRAHGQVKFRKEGRNVFYSLDDKHVVDVFQEALQHI----";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDSTRIKIICALFESELCVCDMAALLGMTQSAISHQLRTLKSARLVKFRREGKVIYYSLDDEHIKHIFDEGFKHITE--";
//    seqs[counter++]  = "----------------------------------SLAELFKMFGDTTRIRIMCALFENELCVCDIAEVLGMGQSAVSHQLRLLRTANLVKVRRDGKSSFYSLDDEHIQKIYELGLDHILEKR";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDSTRVKILYALLESELCVCDIAKLMEVTQSAVSHQLRVLKNSKLVKFRREGKTVYYSLADSHVIHILDQGMEHICE--";
//    seqs[counter++]  = "------------------------------EMLYDLADLFKILGDSTRIKILCALFQAEMCVCDIAALLGMTQSAISHQLRVLKQARLVKNRKEGKVVYYSLEDEHVKSIFDQGLIHIAE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIKILNALLVSEMCVCDIANILNMTQSAVSHQLKNLKNARLIKNRKDGKTVFYSLADEHVMTILNQGIDHIEE--";
//    seqs[counter++]  = "------------------------------EFIQELAEFFKIFGDATRIRILQTLLEGERNVGDLADVLEMSQSAVSHQLRVLRQNDLVKYRKEGKTVFYSLDDEHIRMVLEQGMTHLRHKR";
//    seqs[counter++]  = "------------------------------ETIRELSDFFKVFGDMTRIKILCVLFQAELCVCDLAEVVGMTQSAVSHQLRILKQMKLVKNRREGKTVFYSLADGHIQSILNQGMEHIIE--";
//    seqs[counter++]  = "------------------------------ETIRELSDFFKVFGDMTRIKILCVLFQAELCVCDLAEVVGMTQSAVSHQLRILKQMKLVKNRREGKTVFYSLADGHIQSILNQGMEHIIE--";
//    seqs[counter++]  = "------------------------------EVLYELADLFRVFGDSTRIKILYALHDSELCVQDIADAVQLSQSAVSHQLRVLKDSKLVRFRREGKTVFYALDDDHVRSILSMGMDHIEE--";
//    seqs[counter++]  = "-----------------------------------LADFFKIFGDTTRIKILYVLLCSEMCVCDLAQILNMTQSAISHQLRVLKQMDLVKSRREGKTIFYSLADGHITTILSQGLDHIQE--";
//    seqs[counter++]  = "------------------------------EVLYELADLFRVFGDSTRIKILYALHDSELCVQDIADAVQLSQSAVSHQLRVLKDSKLVRFRREGKTVFYALDDDHVRSILSMGMDHIEE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "-----------------------------------MAELFKALGDPTRVRMIYALSRQELCVHDLSAILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLSDAHVEQIVLQTFEHI----";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "-----------------------KVKEIMPEETKDLAELFKVFGDTTRIKILCALFESEMCVCDIASLLGMSQSAVSHQLRVLKQNKLVKFKKEGKVVYYSLADDHVKKIFEQGFNHINE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------EVLYELADLFRVFGDSTRIKILYALHDNELCVQDIANAVQLSQSAVSHQLRVLKDTKLVRFRRDGKTVYYALDDDHVRSILSMGMDHIEE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ESLSKVAELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKAVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLADNHVKEIFEQGLVHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLADNHVKEIFEQGLVHIQE--";
//    seqs[counter++]  = "-----------------------------------LTELFRIFGDSTRIRILYVLFESEMCVCDIAALLGMTQSAISHQLRALKNARLVSSRREGKTVFYALADDHVKTIIDQGLEHVSE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLADNHVKEIFEQGLVHIQE--";
//    seqs[counter++]  = "------------------------------EIIYDLADFFKILGDTTRMRILSALFHEEMCVYDIANLLKMTQSAISHQLRVLKQGRFVKHRKEGKVVYYSLEDEHIKHIVEQGMTHILE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIRILHALIETELCVGDMAQILNLTQSAVSHQLKILKDAKLVKFRREGKIIFYALDDEHVRTILSMGVEHVEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIRILHALLETELCVGDMAQILNLSQSAVSHQLKILKDAKLVRFRREGKIIFYALDDEHVRNILSMGVEHVEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDTTRIKILCVLLKSEMCVCDIAATLGMNQSAVSHQLRILKQSKLVKHRKEGKVAYYSLADDHVTKIFDQGFSHIEE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKIMGDGTRIQLLWALEESEMCVNDLASLLNMTKSAVSHQLKVLRVAKLVKAQKKGKNVYYSLSDNHVKTIFQMALEHICE--";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDTTRIKILCVLLKSEMCVCDIAATLGMNQSAVSHQLRILKQSKLVKHRKEGKVAYYSLADDHVTKIFDQGFSHIEE--";
//    seqs[counter++]  = "-----------------------------------LADFFKIFGDTTRIKMLYVLLCSEMCVCDLAQILNMTQSAISHQLRVLKQMDLVKSRRDGKTIFYSLSDGHIKTILSQGLDHIQE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKVLGDSTRIKVLCALFEAEMCVCDIAALLGMTQSAISHQLRVLKQARLVKYKRNGKVVYYSLDDEHVKSIFDQGLIHISE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKVLGDSTRIKVLCALFEAEMCVCDIAALLGMTQSAISHQLRVLKQARLVKYKRNGKVVYYSLDDEHVKSIFDQGLIHISE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDSTRIKILCALFESEMCVCDLSALLSISQSAISHQLRVLKSARLVKFRRDGKVIYYSLDDEHIKHIFDEGLKHITE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKVLGDSTRIKVLCALFEAEMCVCDIAALLGMTQSAISHQLRVLKQARLVKYKRNGKVVYYSLDDEHVKSIFDQGLIHISE--";
//    seqs[counter++]  = "------------------------------EVLYDLADFFKVFGDSTRIKILYALYSSEMCVQDLAEVLKMNQSAISHQLRILKQSGLVKYRKQGKYMFYSLDDEHVSQIIAQGVAHLSE--";
//    seqs[counter++]  = "-----------------------------------LTELFRIFGDSTRIRILYVLSASEMCVCDIAALLGMTQSAISHQLRALKNARLVKSRREGKTVFYSLADSHVRTILDQGVEHVSE--";
//    seqs[counter++]  = "------------------------------ECVMDLADFFSIFSDSTRIRILWVLYGRELCVRDISDTLGISMSACSHQLKTLRNSGAVEARRDGKMIYYKLADEHVEILLRTGLEHIQE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKILGDTTRAKILFALDQNEMCVCDIANVLGMSKSSISHQLGTLRRMSIVKCRKEGKEVYYMLDDEHVKGLFELGIEHIE---";
//    seqs[counter++]  = "-----------------------------------LADFFKVFGDATRIKILYVLSRSEMCVCDIANLLKMGQSAISHQLRVLKQMRLVKFRREGKTVFYSLADGHIETILAQGMEHISE--";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILNLLCKEEHSVNDTAETLNLSQSSVSHQLRFLKNLRLVKFRREGTTLYYSEDDHHVMNLLKQAIEH-----";
//    seqs[counter++]  = "---------------------------------------FKALGDPTRIRILNLLCTKEHSVNDIADTLKLSQSTVSHQLRFLKNLRLVKFRREGTTLYYSEDDHHIINLLMQAIDH-----";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRLIYALSQRELCVHDLSVILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRMIYALSQRELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVYYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMGDSTRLQLLLSLQQSEMCVSDLANVLDMTKSAVSHQLKALRLSKLIKSRKEGKTVYYSLDDEHIETILGMAFDHTKE--";
//    seqs[counter++]  = "-----------------------KVKEIMPEETKDLAELFKVFGDTTRIKILCALFESEMCVCDIAALLGMSQSAVSHQLRVLKQNKLVKFKKEGKVVYYSLADDHVKKIFEQGFNHINE--";
//    seqs[counter++]  = "-----------------------KVKEIMPEETKDLAELFKVFGDTTRIKILCALFESEMCVCDIAALLGMSQSAVSHQLRVLKQNKLVKFKKEGKVVYYSLADDHVKKIFEQGFNHINE--";
//    seqs[counter++]  = "-----------------------KVKEIMPEETKDLAELFKVFGDTTRIKILCALFESEMCVCDIAALLGMSQSAVSHQLRVLKQNKLVKFKKEGKVVYYSLADDHVKKIFEQGFNHINE--";
//    seqs[counter++]  = "-----------------------------------LAEFLEAFADSTRIKILIALSKHELCTCDLSAITGLSVSAVSHQLRVLRDKKLVKYRRGGRNVYYSLDDEHVADILRIAIEHVAE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------QAAVQLADWFKAFSDPTRVKIISALLKRELCVHDLTVLLEMGQSAVSHQLRYLRNLRIVKRRKVGKTVYYSLDDAHIEQIFLQTLQH-----";
//    seqs[counter++]  = "-----------------------------------LADLFKVFGDPTRIRILYVLSVEELCVQDIADRLSMTQSAISHQLRVLKQMSLVKFRRDGKTIYYSLADSHVATIMNQGLEHVTE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDQTRVKILFTLIKDEMCVCDIAELLEMSQSAISHQLRVLKQARLVKYRREGKTVYYSVSDEHVAVILNMGIEHISE--";
//    seqs[counter++]  = "----------------------------AEETLYDLAELFKVFGDTTRIKIICALFESEMCVCDLSCLLNMTQSAISHQLRVLKSARLVKFRREGKVVYYSLDDEHIKHIYDAGLNHISE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDQTRVKILFTLIKDEMCVCDIAELLEMSQSAISHQLRVLKQARLVKYRREGKTVYYSVSDEHVAVILNMGIEHISE--";
//    seqs[counter++]  = "----------------------------AEETLYDLAELFKVFGDTTRIKIICALFESEMCVCDLSCLLNMTQSAISHQLRVLKSARLVKFRREGKVVYYSLDDEHIKHIYDAGLNHISE--";
//    seqs[counter++]  = "-------------------------------------------SDPTRIRILHLLSQEECPVGHIAEVLGMSQSAVSHQLGYLRSLRLVKYRRDGNTYYYTYEDEHVIGILQQVLDHI----";
//    seqs[counter++]  = "------------------------------EVLADLSDLFRVFGDTTRVKIIFALFSNEMCVCDIAELLGMTQSAISHQLRVLKNARLVKFRKEGKTVFYSLDDEHISEILKCGLEHVNE--";
//    seqs[counter++]  = "------------------------------DVLYDLSDFFKVLGDSTRVKIMWALDEREMCVCDLAVLLNMTKSAISHQLRSLKQANLVKFRKEGKIVFYSLADEHVKEIFEKGLEHIRE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKVLGDSTRIKVLCALFQAEMCVCDIAALLGMTQSAISHQLRVLKQARLVKYKREGKVVYYSLDDDHVKRIFDQGLIHISE--";
//    seqs[counter++]  = "-----------------------ENEALDEETLFVVSQTFKALSDPTRIRILYLLCREEMSVNGIAEALDLRQSTVSHQLRFLKNLRLVTYRREGTTIYYSHDDQHVMDLLQQTIQH-----";
//    seqs[counter++]  = "-----------------------------------LADLFKIFSDSTRIKILCILFESEMCVYDLSSILNMSQSAVSHQLRLLKQSKLVKHRREGKIIFYSLSDDHIRKIIDNGLEHIQE--";
//    seqs[counter++]  = "-----------------------------------LADLFKIFSDSTRIKILCILFESEMCVYDLSSILNMSQSAVSHQLRLLKQSKLVKHRREGKIIFYSLSDDHIRKIIDNGLEHIQE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRLIYALSQQELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRLIYALSQQELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRLIYALSQQELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGRMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "----------------------------AEETLKELADFYKVFGDATRVKILFVLLQAEMCVCDLAETLGMTQSAISHQLRVLKQMKLVKNRRDGKTVYYSLADGHIQNIISQGMEHILE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGRMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGRMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGRMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGRMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDRTRTRILHALFEAEMCVCDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLADQHVIHIFEQAFEHVNE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGRMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "-----------------------------------LAELFKALGDYTRVRILFALSVGELCVCALAEVLDMSQSAISHQLRLLRAAKLVRYRKEGKNVFYSLDDDHVRNLVSQGLDHIKE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGRMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "-----------------------------------LSDFLKVMADSTRLQLLMSLQQSEMCVSDLANVLNMTKSAVSHQLKALRLSKLVKSRKDGKTVYYSLDDEHIEEILAMSINHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "---------------------------------ENLADLYRAMGDNTRMHLLWSLMSGEACVGALASDIDITESAVSHQLRSLRAARLVKSRKAGKHVYYSLSDDHVSWILQKTCEHIRE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "-----------------------------PDQIESLSNFYKIMGDPTRLMLLMALEAGELCASDLANVTNMSRSAVSHQLKTLKQACLVRSRRDGKTIFYELDDEHIYSVLKVAFEHIQE--";
//    seqs[counter++]  = "---------------------------------ENLADLYRAMGDNTRMHLLWSLMSGEACVGALASDIDITESAVSHQLRSLRAARLVKSRKAGKHVYYSLSDDHVSWILQKTCEHIRE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRRAGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILHLLYQEELSVNNISEALHLRQSTVSHQLRFLKNLRLVKYRREGTSIYYSIDDEHVMDVLKQTIDHAQ---";
//    seqs[counter++]  = "-----------------------------------LAEFYKVFGDSTRIKILYVLSQSEMCVCDIATLLQMGQSAISHQLRMLKQMRLVKFRRDGKTVFYSLADGHIETILAQGMEHIEE--";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKVFGDSTRIRILYVLFETEMCVYDLSKILNVTQSAISHQLRVLKQNKLVKFRREGKNIFYSLADEHVRTIINQGMEHIEE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVLGDSTRARIISALDINEMCVCDLAVLLNMTKSAISHQLRSLKEANLVKFRKEGKVVFYSLTDDHVKDIFEKGLEHIRE--";
//    seqs[counter++]  = "------------------------------------AELFKVFGDTTRIKIICALFESEMCVCDIANLLNMTQSAISHQLRVLKQARLVKYRREGKIVYYSLDDEHIRHIFNQALAHINE--";
//    seqs[counter++]  = "------------------------------ETLYDLADLFKVLGDSTRIKILCTLFEAEMCVCDIAAVLGMTQSAISHQLRVLKQARLVKYKRSGKVVYYSLDDEHVKHIFDQGLIHISE--";
//    seqs[counter++]  = "-------------------------------------------SDPTRIRILHLLSQEECPVGHIAEVLGMSQSAVSHQLGYLRSLRLVKYRRDGNIYYYTYEDEHVIGILQQVLDHI----";
//    seqs[counter++]  = "------------------------------EILYDLAELFKIFGDSTRIKILYVLFEAEMCVCDIAQLLNMTQSAISHQLRALKQSKLVKYRREGKTVFYSLADDHVRSILDQGMEHVAE--";
//    seqs[counter++]  = "-------------------------------------------SDPTRIRILHLLSQEECPVGHIAEVLGMSQSAVSHQLGYLRSLRLVKYRRDGNIYYYTYEDEHVIGILQQVLDHI----";
//    seqs[counter++]  = "---------------------------------QDLSQLFRVLGDHTRIRILDALSHAELCVCDLSALLEMNQSAISHQLRLLRAAKIVKSRKEGKNVYYSLDDMHIQALMMLGLEHVME--";
//    seqs[counter++]  = "------------------------------ETMTALSDFFKNFGDSTRIKIVSALMAGELCVADIAEVLEISASAISHQLRILRQAKMVRSRRVGKQIYYSIEDNHVGILYTVGMEHIQEGR";
//    seqs[counter++]  = "-----------------------------------LADFFKVFGDSTRVSIICALFKAEMCVCDIAALLGMTKSAISHQLRVLKQSKLVKYRREGKVVYYSLDDDHVKNIFDQGLSHIEE--";
//    seqs[counter++]  = "---------------------------------QRLADFFKVFGDPTRQRILFALMNKELNVGQIAEALNASQSGISHQLKILRQANLVTFRKEGKTAYYSISDSHVSCIINDGLEHINE--";
//    seqs[counter++]  = "-----------------------------------LADLFKVFGDSTRIKIICALFQAEMCVCDIAALLGMNQSAISHQLRVLKQTRLVKNRKEGKVVYYSLDDDHVKGIFDQGLEHLYE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "------------------------------EMLYDLAELFKVFGDTTRVKILYALFANEMCVCDIASLLNMTHSAISHQLRVLKQARLVKFRREGKTVYYSLDDSHISQIFDCGLNHIRE--";
//    seqs[counter++]  = "-----------------------------------LAEFFRVFGDSTRIRILYVLSQSEMCVCDIAGLLKMGQSAISHQLRVLKQMRLVKFRRDGKTVFYSLADGHIETILAQGMEHISE--";
//    seqs[counter++]  = "-----------------------------------LAEFFRVFGDSTRIRILYVLSQSEMCVCDIAGLLKMGQSAISHQLRVLKQMRLVKFRRDGKTVFYSLADGHIETILAQGMEHISE--";
//    seqs[counter++]  = "----------------------------------SLAEFFKVFGDTTRIRIICALFEDELCVCDIAEVVGMGQSAVSHQLRLLRAAKLVRVRREGKSSFYSLDDEHVRKIFEMGLCHVEE--";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKVFGDSTRIRILFVLFEAEVCVCDLAAALNMTQSAVSHQLRILKQNKLVRSRREGKSVFYSLADAHVRAIINQGLEHVEE--";
//    seqs[counter++]  = "------------------------------EVLYDLAELFKVFGDSTRIRILFVLFEAEVCVCDLAAALNMTQSAVSHQLRILKQNKLVRSRREGKSVFYSLADAHVRAIINQGLEHVEE--";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRLIYALSQQELCVHDLSAILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "-----------------------------------MAELFKALGDYTRVRILYALSINELCVCALAEVLDMSQSAISHQLRLLRAAKLVRYRKEGKNVFYSLDDDHVRNLVSQGLDHIRE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMGDSTRIQLLWALEESEMCVGDLAVLLNMTKSAVSHQLKVLRTAKLVRSQKKGKNVYYSLNDAHVKDILEKALEHVCE--";
//    seqs[counter++]  = "-------------------------------ITDKMAEMFKALGDPTRVRLIYALSQQELCVHDLSVILDMGQSAISHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHV----";
//    seqs[counter++]  = "-------------------------------ITDKMAEMFKALGDPTRVRLIYALSQKELCVHDLSVILDMGQSAISHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHV----";
//    seqs[counter++]  = "-------------------------------ITDKMAEMFKALGDPTRVRLIYALSQQELCVHDLSVILDMGQSAISHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHV----";
//    seqs[counter++]  = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRRAGKKVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "-----------------------------PDIIDDLSELFKILGDQTRSKILFVLEQGEFCVSDISEAVGMTKYAVSHQLRTLKQAKLVKCRREGKEVIYSLDDDHVSTLFSCALAHVTE--";
//    seqs[counter++]  = "-----------------------------------LSDFYKVFGDPTRLKILFALESRELCVCDLAQILQMTKSAVSHQLKILRQTELVNFKKLGRSVFYRLSDAHIQGILDQGADHINE--";
//    seqs[counter++]  = "------------------------------EVLYELADLFRVFGDSTRIKILYALHDDELCVQDIANAVQLSQSAVSHQLRVLKDSKLVRFRRDGKTIYYALDDDHVRSILSMGMDHIEE--";
//    seqs[counter++]  = "-----------------------------------LSDLYKAMGDLTRIRIISALVNSEMCVCDLASLLDMTHSAISHQLRVLRQAHLVSFRKEGKVVYYSLDDNHIKMLYEQGLVHV----";
//    seqs[counter++]  = "-----------------------KVRGIMPEETKDLAALFKVFGDTTRIKILCALFESEMCVCDIAALLGMSQSAVSHQLRVLKQNKLVKFRKEGKVVYYSLADDHVKKIFEQGFNHINE--";
//    seqs[counter++]  = "------------------------------EDVRQIAETFKILGDATRIKIMHALSKRELCVCDIAAIVDIGQSAVSHQLRLLRGARLVRYRKEGKMVWYSLDDEHISMLLAKGIEHV----";
//    seqs[counter++]  = "------------------------------ELILEISDFFDALGNPTRLKILFALLEDELCTCDLSNITGLSVSAISHQLRILKDRKIVTYRKDGKNVFYRLDDEHIREILKVALKHMEE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMGDGTRIRLLWALEEAEMCVNDLAVLLDMTKSAVSHQLKILRTAKLVRAEKRGKNVYYALNDNHVKVIFEMALEHVCE--";
//    seqs[counter++]  = "------------------------------------AELFKVIGDCTRTRILHALFESEMCVRDLAYLLGMTQSSISHQLRVLKQAKLVKNRKEGKVVYYSLVDTHVMQIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ELLYDLSDLYKVFGDTTRVKILHVLSISEMCVCDISSLLGIKQSSVSHQLKTLRQAKLVKYRRNGKVVYYSLDDNHVEQIFNQGLAHIKE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKIIGDVTRIKLLIALEAKEMCVGELAAALNMTKSAVSHQLKALRSAKLVRTEKRGKNVFYALSDEHVRTVLEMALEHVSE--";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDTTRIKIICALYESEMCVCDLAALLNMTQSAISHQLRTLKVNRLVKFKRVGKVVYYSLDDEHIMRIFNEGLNHVNE--";
//    seqs[counter++]  = "------------------------------------AELFKVFADSTRVKIINVLLENKLCVGDIAALVGGTQSAISHQLRILKSAKLVKYTKIGKTVYYELSDDHVKKLFSVGKEHINE--";
//    seqs[counter++]  = "------------------------------DVFNKLAEFFKILGDTTRVKILFALDQNEMCVCDIANVLGMSKSSISHQLGTLRRMNIVKCRKVGKEVYYMLDDEHVKDVFEIGIEHIE---";
//    seqs[counter++]  = "-----------------------------------LADFFKVFGDATRIKILYVLSQSEMCVCDIANLLKMGQSAISHQLRVLKQMRLVKFRREGKTVFYSLADGHIESILAQGMEHINE--";
//    seqs[counter++]  = "-----------------------------------LADFFKVFGDATRIKILYVLSQSEMCVCDIANLLKMGQSAISHQLRVLKQMRLVKFRREGKTVFYSLADGHIESILAQGMEHINE--";
//    seqs[counter++]  = "------------------------------ERMKELADFYKVFADATRIRILCVLLESEMCVCDLAEVLQMTQSAISHQLRVLKQAKLVKNRRDGKTVYYSLADGHIQTIISQGMEHITE--";
//    seqs[counter++]  = "-----------------------------------LADLFKVFGDPTRIRILYVLSVEELCVQDIADRLSMTQSAISHQLRVLKQMSLVKFRRDGKTIYYSLADSHVATIMNQGLEHVTE--";
//    seqs[counter++]  = "------------------------------------AELFKVLGDRTRTRILHALFEAEMCVCDLSYLLGMTQSSVSHQLRVLKQAKLVKNRKEGKVVYYSLADDHVIRIFEQAFEHVNE--";
//    seqs[counter++]  = "------------------------------ELLGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRRSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------ELLGDLSDFFKVIGDGTRIRILWALDVTEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------ELLGDLSDFFKVIGDGTRIRILWALDVTEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------ELLGDLSDFFKVIGDGTRIRILWALDVTEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------LRARVTEVA-GLAGLFQALADETRTRILYLLSLSELCVCDLAAVLDLSLPAVSHHLRLLKAMRLVTSRREGRNVYYSLADGHVLRLIQVAQEHYAEER";
//    seqs[counter++]  = "------------------------------ELLGDLSDFFKVIGDGTRIRILWALDVTEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------ELLGDLSDFFKVIGDGTRIRILWALDVTEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "------------------------------ELLGDLSDFFKVIGDGTRIRILWALDVTEMCVCDIANVLNMTKSAVSHQLRALREADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
//    seqs[counter++]  = "---------------------------------ENLGEFFKVLTDASRLKILYALGAGELCVFDLSVTIGASVSSVSHHLAALKRVRLVKGRRDGRIIYYSLDDDHVKSIIRYAREHLEE--";
//    seqs[counter++]  = "------------------------------EILYDLAELFKIFGDSTRIKILYVLFESEMCVCDIAQLLNMTQSAISHQLRALKQSKLVKYRREGKTVFYSLADGHVRTILGQGMEHVAE--";
//    seqs[counter++]  = "------------------------------EMVYDLAELFKVFGDVTRVKIIYALLEREMCVCDIANLLEMTQSAISHQLRVLKKARLVKFRKEGKTVFYSLDDYHIDKIFSFGLDHIKE--";
//    seqs[counter++]  = "------------------------------ELILDIADFFDALGNPTRLKILFALLEEELCTCDLSNITGLSVSAISHQLRILKDRKIVAYRKDGKNVFYRLDDKHIKDVLKIALKHVRE--";
//    seqs[counter++]  = "------------------------------EILYDLAELFKIFGDSTRIKILYVLSENELCVNDIAQVLNMTQSSVSHQLRILKDSKLVRFRREGKSIFYALDDEHVRNIINMGMEHVEE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMGDGTRIRLLWALEESEMCVNDLAVLLDMTKSAVSHQLKILRTAKLVKAEKRGKNVYYALNDNHVKVILEMAQEHVME--";
//    seqs[counter++]  = "----------------------------------ALSTVFKLMGDPTRLRILEALSMDELCVCDLAALLCLTQSAVSHQLRLLRASKLVRFRREGKNAFYSLDDDHVRTLFRQGLEHVRE--";
//    seqs[counter++]  = "----------------------------------ALSTVFKLMGDPTRLRILEALSMDELCVCDLAALLCLTQSAVSHQLRLLRASKLVRFRREGKNAFYSLDDDHVRTLFRQGLEHVRE--";
//    seqs[counter++]  = "------------------------------EVA-GLSELFRVLGDETRTKILYLLSHRELCVCDLAEILEMSLPAVSHHLRLLKAMRLVKYRREGKMVYYSLDDDHIVNLIREAQAHFAEER";
//    seqs[counter++]  = "-----------------------------------LSEFFKVFSDSTRVKILSALLISEMCVCDLAALLQVTQSAISHQLRLLKAFRLVKSRKEGKVVYYSLNDDHVKSILELGLLHLSE--";
//    seqs[counter++]  = "-----------------------------------LAELFKIFGDSTRVKILYVLFEAEMCVCDIAQLLGMTQSAISHQLQVLKKSKLVKYRREGKTVFYSLADDHVRAILGQGMDHVTE--";
//    seqs[counter++]  = "-----------------------------------MAELFKVLGDRTRIRILYALYQSEMCVCDLASLLEMTQSAISHQLRVLKQAKLVKNRKEGKVVYYSPADLHVMQIFMQAMDHVKE--";
//    seqs[counter++]  = "---------------------------------QELANNFKVLGDPTRLRILQALMHGERCVRELADGIQMEQSAVSHQLRTLRDAGLVNFRRDGKVVYYSLADAHVFTLLSVGIEHVAE--";
//    seqs[counter++]  = "-----------------------------------MAEMFKALGDPTRVRMIYALSQRELCVHDLSSILDMGQSAVSHQLRYLRNLRIVKRRKEGKTVFYSLNDAHVEQIFLQTHEHI----";
//    seqs[counter++]  = "---------------------------------------FKALGDPTRIRILNLLAEREYAVNDIAETLDLRQSTVSHQLRFLKNLRLVKYRREGTTLYYSQDDDHVMSLLKMTIDH-----";
//    seqs[counter++]  = "------------------------------ETGNELSALFKMFADPTRLKILGMLFKEELCVCDIAFLLDMTHSAVSHQLSVLRQNRLIKYRRSGKNVFYSLDDAHIQQIYDAGLAHILE--";
//    seqs[counter++]  = "------------------------------ETGNELSALFKMFADPTRLKILGMLFKEELCVCDIAFLLDMTHSAVSHQLSVLRQNRLIKYRRSGKNVFYSLDDAHIQQIYDAGLAHILE--";
//    seqs[counter++]  = "-----------------------------------LSELFKILGDYTRIKIIYSLSKKELCVCDISEVVQMSQSAISHQLRILKAARLVKFRREGKSVYYSLDDEHIDRLFNAGLEHVE---";
//    seqs[counter++]  = "-----------------------------------LTELFRIFGDSTRIRILYVLFEAEMCVCDIASLLGMTQSAISHQLRALKNARLVKSRREGKTVFYSLADDHVKTIIDQGLEHVSE--";
//    seqs[counter++]  = "-------------------------ESVTQETIQKTADTFKVLSDPTRIRILHYLCQKEASVSDIASGLDLKQSTVSHQLRTLKLYRLVTHRREGTSIYYTFKDDHVMQTLEQMIDHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDTTRIKILYALFASEMCVCDIAALINMTQSAVSHQLRVLKQARLVKYRKEGKVVYYSLDDDHIKQIFDQGYMHITE--";
//    seqs[counter++]  = "------------------------------------AELFKIFGDSTRVNILATLSKNELCVCDVAEVLNMTVSAVSHQLRILRHNKLVKARRSGKEVFYSLADNHVVKILELAIDHVKE--";
//    seqs[counter++]  = "-----------------------------------LSELFKILGDYTRIKIIYSLSKKELCVCDISEVVQMSQSAISHQLRILKAARLVKFRREGKSVYYSLDDEHIDRLFNAGLEHVE---";
//    seqs[counter++]  = "------------------------------ELLYDLADLFKVFSDTTRIKILYALMSDELSVNDLAEAIGTSQSAVSHQLRILKQSHLVKFRRDGRNIHYSLADDHVLTILDQGLTHICE--";
//    seqs[counter++]  = "------------------------------QTARLTSDFFKAFADKTRVRILSALAIHELCVCDIADLLGMTQSAISHQLSFLKQARLVVGRKEGKTVYYTLCDGHIRTILRQGIEHVQE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIKILWALDEAEMCVCDIAVLLNMTQSAISHQLRVLKQARLVKYRKDGKIVFYSLEDEHIKQIFNQGLTHINE--";
//    seqs[counter++]  = "-----------------------------------LAEFFKVYGDTTRIKIICALFKAEMCVCDIAALFSMTQSAISHQLRVLKQARLVKFRKEGKVVYYSLDDEHVKRIFDQGLLHINE--";
//    seqs[counter++]  = "------------------------------DVLYDLADFFKVFGDSTRVKILWALDESEMCVCDLAVLHNMTKSAISHQLRSLKQAGLVKSRKEGRVVFYSLKDDHVKDIFEKGLEHIRE--";
//    seqs[counter++]  = "------------------------------EVA-GLSEIFKVLGDETRTKILYLLSFRELCVCDIATILDMSLPAISHHLRLLKALRLVKYRRDGKMVYYSLDDEHIVHLIREAQEHFAEYR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "------------------------------QTMSDLGDFFKNFGDSTRIKIVSALISGELCVADLAEVLEMSASAVSHQLRILRQAKIVKSRRNGKQVYYTIDDNHVGILYSVGLEHIREGR";
//    seqs[counter++]  = "--------------------KKDEHSFLSPQIVEEASRILKAISDPTRMKILYLLFQEECSVGHMVEVLGVSQSAISHQLTHLRHLRLVKYRREGNTYFYTYDDEHVVGILHQVIQHV-EC-";
//    seqs[counter++]  = "----------------------------------ALSDFFKNFGDSTRIKIVSALMAGELCVADIAEVLEISASAISHQLRILRQAKMVRSRRVGKQIYYSIEDNHVGILYTVGMEHIQEGR";
//    seqs[counter++]  = "------------------------------EMVYDLAELFKIFGDVTRIKIIYALLEREMCVCDIATLLEMTQSAISHQLRVLKKARLVKFRKEGKTVFYSLDDYHIDKIFSFGLDHIKE--";
//    seqs[counter++]  = "-----------------------------------MAELFKVFGDSTRMKIISALLQDELCVGEIAEITNSTQSAISHQLRVLKQAKLVKFKKVGKTVYYSLDDDHIYQIYKLVKEHIEE--";
//    seqs[counter++]  = "------------------------------ETLTDLADFFKVFGDATRVKILYVLLQSEMCVCDLAEVLQMTQSAISHQLRVLKQVKLVKNRREGKTVFYSLADGHIQTILNQGMEHISE--";
//    seqs[counter++]  = "--------------------------------ASGLSELFRVLADETRTRILYVLAEQELCVCDLAWLLEMSMPAVSHHLRLLKLMRMIRGERRGKQVFYSLQDHHVLTLIRTAQEHFAE--";
//    seqs[counter++]  = "---------------------------LSPDTLEKVSTIFKALSDPTRIKLLHLLSEEECSVTHMSEVLNLSQSAVSHQLSLLRNLRLVKFRREANTVYYSCDDEHVISLLKQAIQH-----";
//    seqs[counter++]  = "-----------------------------------LAEFFRVFGDSTRIRILYVLSQSEMCVCDIAGLLKMGQSAISHQLRVLKQMRLVKFRRDGKTVFYSLADGHIETILAQGMEHICE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQKTICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGKMTYYELADDHVAAVLSLTLKHLKE--";
//    seqs[counter++]  = "------------------------------DVVASLSELFKALGDPTRVKILSCLQISDMNVGDIADKLGMTTSAVSHQLRVLRAIKLVKGTKEGKEVRYSLDDDHVTLIMQCGLTHVNEER";
//    seqs[counter++]  = "------------------------------------AELFKVFGDSTRMKIICCLFEHEMCVCDIAELINSTQSAVSHQLRVLKQAKLVKFRKDGKTVYYSLSDEHVEMIFNMALEHIKE--";
//    seqs[counter++]  = "------------------------------ELLYNLAELYKVFGDSTRIRILFVLFEAEVCVCDLARALNMTQSAISHQLRILKQNKLVKSRREGKSIFYSLADDHVRTIIAQGLDHIEE--";
//    seqs[counter++]  = "------------------------------EIINELSEFFKVFSDTTRLRILEVLLNEETSVGVIANKINVSNSAVSHQLSYLRSTNLVKTRKEGQVIYYSIADNHIKVIIEYGLEHIKE--";
//    seqs[counter++]  = "------------------------------EILYDLAELFKVFGDTTRIKILYALFECEMCVCDIAQLLGVTQTAVSHQLRVLKANKLVKFRKEGKNAFYSLSDEHVTKIIAQGMEHICE--";
//    seqs[counter++]  = "------------------------------ETILEVSDFFDALGNPTRLKILFALLEDELCTCDLSNITGLSVSAISHQLRILKDRKIVTYRKDGKNVFYSLDDEHIREILKVALKHMEE--";
//    seqs[counter++]  = "-----------------------------------LSEFFKILSDQTRLKILIALSKKECSVSELQEFLNTTQSTVSHQLRILRQTNLVKYSKVGRRVYYKLYDEHVKTIINFALEHLEEFR";
//    seqs[counter++]  = "-----------------------------------LSEFFKILSDQTRLKILIALSKKECSVSELQEFLNTTQSTVSHQLRILRQTNLVKYSKVGRRVYYKLYDEHVKTIINFALEHLEEFR";
//    seqs[counter++]  = "------------------------------EILYDLAELFKVFGDTTRIKILYALFECEMCVCDIAQLLGVTQTAVSHQLRVLKANKLVKFRKEGKNAFYSLSDEHVTKIIAQGMEHICE--";
//    seqs[counter++]  = "------------------------------EMIDDLSNLFKVLGDQTRIKIIYSLIENEMCVCDIAETISMTQSAVSHQLRVLKQARLVKFRKEGKTVFYSLDDEHVNKIFDFGLSHIKE--";
//    seqs[counter++]  = "----------------------------------SIADFFAVFGDRTRIKILLALDQSPMCVCDLAVLLDMTKSVISHQLSSLKKINLVSSHKEGKHSYYALADDHIKKIIEMAVEHLEE--";
//    seqs[counter++]  = "------------------------------EMIDDLSNLFKVLGDQTRIKIIYSLIENEMCVCDIAETISMTQSAVSHQLRVLKQARLVKFRKEGKTVFYSLDDEHVNKIFDFGLSHIKE--";
//    seqs[counter++]  = "------------------------------EMIDDLSNLFKVLGDQTRIKIIYSLIENEMCVCDIAETISMTQSAVSHQLRVLKQARLVKFRKEGKTVFYSLDDEHVNKIFDFGLSHIKE--";
//    seqs[counter++]  = "---------------------------------QSVSQLYKALGDPTRLKILTALTVSELNVGAISEKIGLEQSAVSHQLRVLRTNHLVKSRKEGKTVYYSLDDDHVMAILADTFEHV----";
//    seqs[counter++]  = "----------------------------------SLAELFKVFGDPTRIRILFVLFETEVCVCDLARALNMTQSAVSHQLRILKQSRLVKNRREGKSMFYSLADDHVRTMIAQGREHILE--";
//    seqs[counter++]  = "------------------------------ELLYDLADLFKVFGDTTRIKMLYALMGQELCVADLAELIGATQSAVSHQLRTLKQVRLVKFQRDGKNVIYSLSDDHVYTMLAQGMTHICE--";
//    seqs[counter++]  = "------------------------------ELLYDLADLFKVFGDTTRIKMLYALMGQELCVADLAELIGATQSAVSHQLRTLKQVRLVKFQRDGKNVIYSLSDDHVYTMLAQGMTHICE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQKTICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGKMTYYELADNHVASVLSLTLKHLKE--";
//    seqs[counter++]  = "-----------------------------------LADLFKVFGDPTRIRILYVLSVEELCVQDIADRLFMTQSAISHQLRVLKQMSLVKFRRDGKTIYYSLADSHVATIMNQGLEHVTE--";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQKTICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGKMTYYELADNHVASVLSLTLKHLKE--";
//    seqs[counter++]  = "-----------------------------------LSNLFKVLGDNTRMRIITALSQEELCVCDLAVVLNMTKSAVSHQLKKLKAERQVKSRKEGKNVYYSLDDEHIVDILSRALEHI----";
//    seqs[counter++]  = "-------------------------------------------SDPTRIRILHLLSQEECPVGHIAEVLGMSQSAVSHQLSYLRTLRLVKYRREGNTYFYTYEDEHVIGILKQVLDHI----";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQKTICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGKMTYYELADNHVASVLSLTLKHLKE--";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMSDSTRLQLLISLQHSEMCVSDLANVLNMTKSAISHQLKALRISKLVKSRKDGKTVYYSLDDEHVKEILAMAAHHLKE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDTTRVKILFALFTAEMCVCDLTALLGLTQSAVSHQLRVLKQARLVKYRKDGKMVYYSLDDDHVKQIFDQGLAHI----";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMSDSTRLQLLISLQHSEMCVSDLANVLNMTKSAISHQLKALRISKLVKSRKDGKTVYYSLDDEHVEEILAMAAHHLKE--";
//    seqs[counter++]  = "-----------------------------PETAAGLADVFKALGDPTRVKIIYTLLQKELCVHDLTLVLEMGQSAISHQLRYLRNLRIVKRRKVGKTVFYSLDDEHIEQIFVQMLQHV----";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILHLLFEEELSVNKIAETLDLNQSNVSHQLRFLKNLRLVKYRRDGKTIYYSQDDEHVMKILQQSIDH-----";
//    seqs[counter++]  = "-----------------------------------LSDFFKVMGDSTRIRLLWALEEAGMCVNDLAVLLDMTKSAVSHQLKILRTAKLVKAEKRGKNVYYSLTDEHVKIVLEMALDHVRE--";
//    seqs[counter++]  = "---------------------------------QRAAAIFRALGDPARLHLLALLAAGEQCVSQLATETGDSLPAISQRLKLLRSERLVSQRRDGKHIYYQLADQHVVQLIEAGIDH-----";
//    seqs[counter++]  = "--------------------------------AIQVADWFKAFSDPTRVKLIHALLQQELCVHDLTTLLSMGQSAISHQLRYLRNLRIVKRRKDGKTVYYSLDDTHIEQIFLQTLQH-----";
//    seqs[counter++]  = "-----------------------------------LAEFFRIFGDATRIRILYVLMCSEMCVCDIATLLGMTQSAISHQLRVLKQMDLVKNRREGKTVFYSLADGHIKTILSQGIEHINE--";
//    seqs[counter++]  = "------------------------------ETVFELAELFKIFGDSTRTKILSCLELSELCVCDICSCLNMNQSAISHQLRVLRQAKLVKARKKGKEVIYSLDDDHVSKIYECALMHIKE--";
//    seqs[counter++]  = "-----------------------------------LAELFRVFGDTTRVRILWCLAQSDMCVSHLAERLRMSQSAVSHQLRILKSARLVRVTRQGRNAIYGLDDQHVKAIFDQALQHV----";
//    seqs[counter++]  = "-----------------------------------LAELFKVFADSTRMKIIYALMEEELCVCDIANIVKTTQSAISHQLRILKQAKLVKFRKEGKVVYYSLDDEHISQIVKKGREHIEE--";
//    seqs[counter++]  = "---------------------------------KDLADTFKLLSDFTRVKILYVLSLSELCVQDISELTGVSQSAVSHQLRILRNSRLVSWKKTGKQVFYSLNSDAVRALIEKGMEH-----";
//    seqs[counter++]  = "------------------------------ELIVEMANFFDSFGDATRLKILLALMEEELCTCDLSNITGLSVSAISHQLRVLKDRRIVSYRREGKNVFYRLDDEHIREILKIALKHLGE--";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILHLLFECELSVSMIAEALHLNQSNVSHQLRFLKNLRLVKYRREGKTVFYSQDDEHVMRILQQSIDH-----";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILHLLSQKECAVSEIAEALGLLQSTVSHQLRFLKNLRLVKFRRAGTTLYYSHDDEHVVDLLEQAIHH-----";
//    seqs[counter++]  = "------------------------------ELLYDLADFFKTFGDTTRVKILYALMEQDLCVADLAEAIGATQSAVSHQLRTLKQSRLVRAKREGKNVVYSLSDDHVHSILDQGMTHICE--";
//    seqs[counter++]  = "------------------------------ETFNSLSDNFKVLSDPTRLKILYALMLKEICVCDLAAVLEMTDSAVSHQLRLLRNRNLVKFRKKGKMAYYSISDHKIV--------------";
//    seqs[counter++]  = "---------------------------LSPDTLEKVSTIFKALSDPTRIKILHLLSEEECSVTHMSEVLNLSQSAVSHQLSLLRNLRLVKFRREANTVYYSCDDEHVISLLKQAIQH-----";
//    seqs[counter++]  = "------------------------------ETLYDLAELFKVFGDSTRVKILCVLFEAEMCVCDIAELLSMSQSAISHQLRVLKQSKLVKNRREGKTIFYSLADEHVRAIFNQGMEHIME--";
//    seqs[counter++]  = "-----------------------------------LSELFKVFGDSTRIKILTALSHGELCVCDLSKLVGMTSSAVSHQLKILRSAKLVSCRRDGKTVFYALADDHVTTIIRQGLEHVNE--";
//    seqs[counter++]  = "----------------------------AEEYLYDLAELFKVFGDSTRIRILYALFESELCVNDIAQLLNLGQSAVSHQLKILKDAKLVRFRREGKIIFYALDDDHVRNMLSMGMEHVEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKLFGDETRIRIIYTIHKKELCVSDIANILGMTHSSVSHQLKNLKSARLVRSKKEGKEVFYALNDDHIEKIFSMAMEHIRE--";
//    seqs[counter++]  = "-------------------------------------ELFKVLGDETRTKILSVLVEDELCVCDIAKLLEMTKSAISHQLKVLRLARLIKSRKVGKEVFYSLDDDHVLKIYKMAIEHVTE--";
//    seqs[counter++]  = "-------------------------------VVQKLAELFKVFGDGTRLKIIYALLQKELCVCDICEIVEMSQSSVSHQLRLLKTTGLVKYRKEGKTVFYSLDDEHVNSIFSVGLSHI----";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILNLLFEKEYAVNEIAEALGLRQSTVSHQLRFLKNLRLVKYRREKTTLYYSYDDNHVMDLLKQAIEH-----";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILNLLFEKEYAVNEIAEALGLRQSTVSHQLRFLKNLRLVKYRREKTTLYYSYDDNHVMDLLKQAIEH-----";
//    seqs[counter++]  = "--------------------KKDEHSFLSPQTVEEASRILKAISDPTRMKILYLLFQEECSVGHMVEVLGVSQSAISHQLTHLRHLRLVKYRREGNTYFYTYDDEHVVGILHQVIQHV-EC-";
//    seqs[counter++]  = "--------------------KKDEHSFLSPQTVEEASRILKAISDPTRMKILYLLFQEECSVGHMVEVLGVSQSAISHQLTHLRHLRLVKYRREGNTYFYTYDDEHVVGILHQVIQHV-EC-";
//    seqs[counter++]  = "-----------------------------PEAVEQLGATFGLLADASRLRLLMVLLHGEMCVCDLAVACGQSESGVSHALRLLRAHRVVAVRRSGRRAFYRLADAHVRMLLDLALTH-----";
//    seqs[counter++]  = "-----------------------------------LADLYRMFADTTRVRLLYLLSQGELSVNELAHRLSMSQSAVSHQLRQLRIAKLVRTRREGRTIYYSLADSHVEALLHVGLEHVSE--";
//    seqs[counter++]  = "-----------------------------------LADLYRMFADTTRVRLLYLLSQGELSVNELAHRLSMSQSAVSHQLRQLRIAKLVRTRREGRTIYYSLADSHVEALLHVGLEHVSE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIRILFVLFEAEVCVCDLAEALGMTQSAISHQLRILKQNKLVKNRREGKSIFYSLADEHVRTIIAQGCEHIEE--";
//    seqs[counter++]  = "------------------------------ELLYDLADLFKVFGDTTRIKMLYALMGQELCVADLAELIGATQSAVSHQLRTLKQARLVKFQRDGKNVIYSLSDDHVYTMLAQGMTHICE--";
//    seqs[counter++]  = "------------------------------------AEVFKIFGDSTRMKIIYALKLSELCVSDLAFITNSSESAISHQLRILKQAKLVKSRKEGKVVYYSLKDEHVIKLFEIGREHVEE--";
//    seqs[counter++]  = "--------------------------------AVQVADWFKAFSDPTRVKLIGALLQKELCVHDLTVLLDMGQSAVSHQLRYLRNMRIVKRRKAGKTVYYSLDDTHIEQIFVQTLQH-----";
//    seqs[counter++]  = "------------------------------------AELFKMFGDPTRLKLLAALLGQEVCVCDLSDLLGISQSAVSHQLRLLRASHLVKNRREGKSVFYSLDDEHVATILAQGMEHV----";
//    seqs[counter++]  = "------------------------------EKLRRLAEFFKIFGDPTRMRILCALKASELCVCDLTGLTGVSQPAVSHQLGLLRAAHAVRARREGKTVYYSLDDEHVGVLLRVGLEHI----";
//    seqs[counter++]  = "------------------------------KIINELSEFFKVFSDTTRLRILEVLLEKETYVGDISNKIKVSPSAVSHQLSYLRSTNLVKTRKEGQIIYYSIADNHIKVIIKYGLEHIKE--";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILNLLCSDEHSVNDIAEILDLSQSTVSHQLRFLKNLRLVKFRREGTSLYYSKDDDHIMNLLKQAIEH-----";
//    seqs[counter++]  = "------------------------------------AELFKVFADSTRMKIIYALMEEELCVCDIANIVQTTQSAISHQLRILKQSKLVKYRKEGKVVYYSLDDEHISQIVKKGREHIEE--";
//    seqs[counter++]  = "------------------------------QAAVQFADWFKAFSDPTRVKIISALLKRELCVHDLTVLLEMGQSAVSHQLRYLRNLRIVKRRKVGKTVYYSLDDTHI---------------";
//    seqs[counter++]  = "------------------MTFSEEAQHLDEETLFVVSQTFKALSDPTRIRILNLLCTGEHSVNEIAETLNLSQSSVSHQLRFLKNLRLVKYRRAGTTLFYSEDDEHIMNLLKQAIEH-----";
//    seqs[counter++]  = "------------------------VEEIDEEILYDLADLFKVFSDTTRIKILFALMDKDLCVADIAETIGASQSAVSHQLRILKQARLVKFQREGKNVIYALSDDHVHTMLDQGMTHICE--";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILHFLCSDEHSVNDIAQHLNLSQSTVSHQLRFLKNLRLVKFRREGTTLYYSKDDDHIMNLLKQAIDH-----";
//    seqs[counter++]  = "-----------------------------------LADLFKVFGDPTRIRILYALSVEELCVQDIADRLSMTQSAISHQLRVLKQMSLVKFRRDGKTIFYSLADSHVATIMNQGLEHVTE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIRILFVLFEAEVCVCDLAQALNMTQSAISHQLRILKQNKLVKNRREGKSIFYSLADDHVRAIIAQGREHIEE--";
//    seqs[counter++]  = "-----------------------------------LSSLFKVLGDYTRIKIIYALFKTELCVCDIAEVLNMSQSAISHQLRILKSARLVKFRRAGKLVYYSLDDEHINQLFNAGLEHV----";
//    seqs[counter++]  = "-----------------------------------LAEIFKVFGDSTRIKILYVLFESEMCVCDIAQLLNMNQSAISHQLRILKQNRLVKSRREGKAVFYSLADGHVRTIINQGMEHIQE--";
//    seqs[counter++]  = "-----------------------------------LAELYKVFGDSTRVRILYALLESEMCVGDMAQLLGLTPTACSHQLRVLKNSKLVRFRREGKIMFYSLADEHVRSILALGMEHILE--";
//    seqs[counter++]  = "-----------------------------PEVLEHVSQTFKALGDPTRIRILSMLAKEECAVNQLAETLQLSQSAVSHQLKTLRAFRFVRYRREGQNILYICDDDYIIGLLNEAV-------";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILHLLSQKECAVSEIAEALGLLQSTVSHQLRFLKNLRLVKFRRAGTTLYYSHDDEHVMDLLEQAIHH-----";
//    seqs[counter++]  = "---------------------------LSPDTLEKVSTIFKALSDPTRIKILYLLSEEECSVTHMSEVLNLSQSAVSHQLSMLRNLRLVKYRREANTLYYSCDDGHVISLLTQAIQH-----";
//    seqs[counter++]  = "---------------------------------------FKALCDPTRIRILNFLCSEEHSVNEIAEKLNLSQSSVSHQLRFLKNLRLVKFRREGTTLYYSNDDDHIMNLLQQAIDH-----";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILNMLCCEEHSVNDIAEKLDLNQSAVSHQLRFLKNLRLVKFRREGTTLYYTSADEHVINLLHQAIDH-----";
//    seqs[counter++]  = "-----------------------------------MSNFFKAISDPTRLRILQAVRQNPICVGDLAIALQMTKSAISHQLHYLRDCQLVKGEKKGKMTYYELADNHVASVLSLTLKHLKE--";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILNLLCTDEHSVNDIAEILDLSQSTVSHQLRFLKNLRLVKFRREGTTLYYSKDDDHIMNLLKQAIEH-----";
//    seqs[counter++]  = "---------------------------------------FKALSDPTRIRILNMLCCEEHSVNDIAEKLDLNQSAVSHQLRFLKNLRLVKFRREGTTLYYTSADEHVINLLHQAIDH-----";
//    seqs[counter++]  = "-----------------------------PEVLEHVSQTFKALGDPTRIRILSMLAKEECAVNQLAETLQLSQSAVSHQLKTLRAYRFVRYRREGQNILYICDDDYIIGLLNEAV-------";
//    seqs[counter++]  = "----------------------------------SAAALFHALGDPARLHLAALLIHRELCVSQLAELVNDSLPAVSQRLKLLKQERIVRARREGKHVYYQLDDDHIAALVINALAHAEE--";
//    seqs[counter++]  = "---------------------------------QDLADLFKVFGDFTRIRILFVLFEAEVCVCDLAEALDMTQSAISHQLKILKQARLVKSRREGKSVFYSLADGHVRTIIAQGRDHIEE--";
//    seqs[counter++]  = "-----------------------------------LAELFKVFGDSTRIRILYVLFEAEVCVCDLAQALNMTQSAISHQLRILKQNKLVKNRREGKSIFYSLADDHVRSIIAQGREHIEE--";
//    seqs[counter++]  = "---------------------------------EQLAELHKAMGDYTRIRILWYLMQKEYCVSDLAQKMEITESAISHQLRALRIARLVQSHKAGKNVIYSLQDEHIRWILEKTYDHISE--";
//    seqs[counter++]  = "-----------------------------------MAEIFKALADPTRVKVAYMLDRGELCVCDVAEVLGSSTATASHHLRTLKNKNIAKSRKAGKNVYYSLKDDHIRTLLHMTLEHQKE--";
//    seqs[counter++]  = "---------------------------------EDVARTFKALADPTRVKILYLLSQEECSVGHIADVLNMTQSAVSHQLSFLKNLRLVKSRRQGKSLFYSYDDEHVIEVLKQVIDH-----";
//    seqs[counter++]  = "------------------------------EVLERVSQTFKALGDPTRIRILSLLAREECAVNQVADALQLSQSAVSHQLKTLRAYRFVRYRREGQNILYTCDDAYIIELLNEAV-------";
//    seqs[counter++]  = "------------------------------ELLYDLAELYKVFGDSTRIKILYVLFESEMCVCDIAQLLNLSTSAISHQLRVLKQSQLVKFRREGKTVFYSLADSHVSSILAQGMEHVCE--";
//    seqs[counter++]  = "---------------------------------QEISSFFKVLGDKTRLSLLFLLEEESRNVSELAQALGMEQSAVSHQLKVLKDAKIVKSNRQGKSNYYSLDDGHIFTLLKQVRDHIQE--";

    
    
    seqs[counter++] = "QDELTAGPCATVHVITVQMAKSGELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRKQGRHVYYQLQDHHIVALYQNALDHLQECR";
    seqs[counter++] = "-----------------EIAPLAELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRKQGRHVYYQLQDHHIVALYQNALDHLQECR";
    seqs[counter++] = "---------------------AAELQAIAPEVAQSLAEFFAVLADPNRLRLLSLLARSELCVGDLAQAIGVSESAVSHQLRSLRNLRLVSYRK-----------------------------";
    seqs[counter++] = "------------------------LQGLELEKAQKMAEFFSLLGDANRLRILSLLAKQELCVCDLADDLGMSESAVSHQLRTLRALRLVKYQKQGRRVFYRLADHHVLDLYYAVSEHLEE--";
    seqs[counter++] = "---------------------SQEIQVLSSEKAQRMAEFFSFLGDANRLRILSLLAEKEFCVSDLAARLDMSESAVSHQLRNLRAMRLVNYRKQGRRVFYRLHDNHVLHLYQAVAEHLDE--";
    seqs[counter++] = "-----------------------QVRQVQPEVAQQMAEFFSALADPSRLRLMSALARQELCVCDLAAAMKVSESAVSHQLRILRSQRLVKYRRVGRNVYYSLADNHVMNLYREVADHLQE--";
    seqs[counter++] = "--------------------------------AQQMAEFFSALADPSRLRLMSALARQELCVCDLAAAMKVSESAVSHQLRILRSQRLVKYRRVGRNVYYSLADNHVMNLYREVADHLQE--";
    seqs[counter++] = "-------------------------EVLSTEKSQRMAEFFSFLGDANRLRILSFLATKELCVSDIATLLEMSESAVSHQLRNLRAMRLVSYRKQGRHVFYRLHDNHILELYQAVAEHLDE--";
    seqs[counter++] = "------------------------------EKAQRMAQFFGLLADTNRLRIVDLLAQGEFCVRDIAVALEMSESAVSHQLRMLKALRLVRFRRQGRHIFYQLLDHHVLTLYKAAAEHLDE--";
    seqs[counter++] = "-----------------------QTQVLNSQKAQRMAEFFSLLGDANRLRLLSVLAAQELCVCDLAATLEMSESAVSHQLRALRALRLVSYRKQGRQVFYSLLDRHVLELYRAVAEHLDE--";
    seqs[counter++] = "--------------------------------AQQMAEFFAVLADPNRLRLISALASQELCVCDLAALMKMTESAVSHQLRLLKAMRLVSYRREGRNIYYSLADNHVISLYREVAVHLDE--";
    seqs[counter++] = "---------------------------------------FAALGDPTRFRIIAALQVQELCVGDLAAAIGLSQSAVSHQLRALRDLGLVRSRREGRLVYYALDDEHVVTLVAQALDHVREER";
    seqs[counter++] = "-------------------------------VTRQMAEFFKSLSDPTRLRIVQALLEEELCVCDISAIVDISISAISHQLRLLRSMHIVKFRKQGKMVYYSLEDEHISRMLEIALEHLNE--";
    seqs[counter++] = "------------------------------DITNRLAETFKVLGDPTRLKILLAVSLDELCVCDIASLLGTTKSAVSHQLRLLRSLRVVKYRKDGRIVYYSLDDSHVGNLLSEGLDHI----";
    seqs[counter++] = "-----------------------------------MAETFKILADPTRVKILHALAHKELCVCDIAVTLDMKVSAVSHQLRLLKSARLVKQRREGKNVYYQLDDHHVEQLFEKTLEHIKQ--";
    seqs[counter++] = "--------------------------------AGRLADLFKALADPTRVRIIAALLHTELCVDDLANLLDMSQSAISHQLRLLRNLHLVQFRRSGKHAFYRLVDDHVRDLFQRSREHL----";
    seqs[counter++] = "------------------------------ELLYELAELFKIFGDSSRIRILSLLQKERLCVSEISTLLNLSQSAISHQLRILRQARLVRYKKIGKEVFYELDDDHIEKIFEQGLEHIQE--";
    seqs[counter++] = "--------------------------------ATRLAAAFQALSDPTRVRLISALLEQELCVHDLAAVLGMSQSATSHQLRVLRALGLVRTRKEGRIVYYALDDEHIRELFQRGLEHI----";
    seqs[counter++] = "---------------------------------EEMASFFRMMGDPTRIRILSLLFDEELCVHTLAERLEMTHSAVSHQLALLKHARLVRSRREGRHVYYRLADEHVQKVYELAREHLEE--";
    seqs[counter++] = "-DEFKKGSDLNCHVMNIQDCKEVELKSVTEETIFDLSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLGTSQSAISHQLRLLKVFRLVKSRKAGKVVYYSLSDDHVKSIIELGLAHLSE--";
    seqs[counter++] = "------------------------------ELIFNLADFFKTFGDSTRIKIICALMETELCVCDLANVINTSQSAVSHQLRVLRQSRLVKYRKDGKTVYYSLDDDHIKLLISQGLDHL----";
    seqs[counter++] = "-----------------------------------MAEVFKALNDPTRLKIINILIVSELCVNDIANLLEISQPAISHHLKELRQLKLIKYHKKGRSVFYSLDDEHIHPLFQQCLEHVNE--";
    seqs[counter++] = "-----------------------------------LAELFKILGDPTRLKIVELLLENEMCVNHIAETMGMGQSAISHQLRVLRQARLVTYRKDGKTAYYSLNDNHVECLVRMGMEHV----";
    seqs[counter++] = "---------------------------------EDLALLFKMFADPTRLKVLKALFEREMCVGDLAVLLKMTHSAVSHQLASLKKTRLVRSRKDGKVVYYSLDDDHIEEIFQKALDHVRE--";
    seqs[counter++] = "-------------------------------------------ADQTRLRILCLLRDREVCVHDIVEALDMSQSAISHQLRVLRDARLVSHRREGRHVYYRLADDHVREMLENALSH-----";
    seqs[counter++] = "-----------------------------------LSMLFKMFADPTRLRIFTILSHQTVCVDDLAEILGMTQSAVSHQLASLRKMNLVRSSKVGKNAYYQLADSHVMQIFSQALDHVKE--";
    seqs[counter++] = "-------PCAEVTALHLRL--SPATRAVDKGALQRAAAIFRALGDPARLHLLALLAAGEQCVSQLATETGDSLPAISQRLKLLRSERLVSQRRDGKHIYYQLADQHVVQLIEAGIDHAVESR";
    seqs[counter++] = "-----------------------------------LSEVYKSLGDGTRLKILLALKEKESCVCDLAAALSMSQSAISHQLRVLRNVRLVKYRREGKMVYYSLDDEHILKILQEGLNHI----";
    seqs[counter++] = "------------------------------EEVQKLSAIYKALGDPTRFKILFCLKQEEMCVCDISAILDMSQSAISHQLRVLRNLRIVKYRKEGKMVFYSLDDKHIFRILDEGINHIRE--";
    seqs[counter++] = "------------------------------ETMDAIAELFKGFADSTRVHILALLSRQELCVTDIAETVDVSQSAISHQLRILKQMHLIKFRREGKNILYSLADDHVKTILQMGLEHVLE--";
    seqs[counter++] = "-------------------------------------ELLKAVGDPTRMRILCALADRELCVCDLQAVLGLSQSAVSHQLRTLRNARLVTYRREGKMAYYTLADDHVRRLLDLSLEHV----";
    seqs[counter++] = "-------------------------EAKADQIASPLANFFKTLSDPTRLRIILAIGTTSLSVNEISTIINMSQSSVSHQLRILRDNHLVISQRFGQHIHYQLTDQHVLTILENSLDHISE--";
    seqs[counter++] = "-----------------------------------LAATFRLLGDRTRVRILEALAGDELCVCDLAAVVGHSQSAVSHQLRLLRAAKLVRVRRDGKNAFYSLDDDHVRHLFRQALDHVQE--";
    seqs[counter++] = "-----------------------------------MAQLFKILGDPTRVRILQALSISEMCVCDIAALLEMTQSAISHQLRLLKQGRLVKYRRDGKVVYYSLNDNHVRLIFDQALSHITE--";
    seqs[counter++] = "--------------------------ALTEKTAKELSELFKVVSDPTRIKILWAIGGGEVCVCCISELLGMSVSAVSHQLKTLRQAHLVKARREGRNIYYSLDDHHVKILLDVLLEHMEE--";
    seqs[counter++] = "---------------------------------ENLGEFFKVLTDASRLKILYALGAGELCVFDLSVTIGASVSSVSHHLAALKRVRLVKGRRDGRIIYYSLDDDHVKSIIRYAREHLEE--";
    seqs[counter++] = "---------------------------------QKLSNMFKLFSDETRLKIICSLLKEELCVCDLCELLGLNQSQVSHQLQLLRNSKLVKFRREGKQIFYSLDDEHVELIIQMALDHILE--";
    seqs[counter++] = "-----------------------------------LSETFGALADSNRAKILHSLLNQELCVCDIACVVGISESAISQHLRILRTLRLVKQRKQGRMMYYSLNDNHIRQLLEICLEH-----";
    seqs[counter++] = "-----------------------------------LAQLFAAFGDPTRLRILTALRSGDLCVCDLTAVLGMTASAVSHQLRLLRNLRLVRSRKVGRVVYYHLDDEHVLNL------------";
    seqs[counter++] = "------------------------------EILGDLSDFFKVIGDGTRIRILWALDVSEMCVCDIANVLNMTKSAVSHQLRALRDADLVKFRKSGKEVLYSLSDNHVKEIFEQGLIHIQE--";
    seqs[counter++] = "-----------------------------------LADLFKMFADSTRLKILCILCESEMCVNDIANLISMSQSAVSHQLRILKQSKLIRGRREGKIVFYSLADSHINTIINNGLEHIQE--";
    seqs[counter++] = "--------------------QSQEREVLAAPLAWRVADIFKALGDPTRVKIIALLDAGEMCVGEMCLTLGMSQPAISSQLRLLRTLGIVSVRREGKHAYYRLADEHVRHLFHQGLAH-----";
    seqs[counter++] = "------------------------------EYIQELSAFFKVFGEENRTRILYALSIREMCVNDLVTLLGMSQSSVSHQLQILRAHGQVKFRKEGRNVFYSLDDKHVVDVFQEALQHI----";
    seqs[counter++] = "------------------------------KVIYELSEFFKILSDQTRLKILVLLFEKEQNVSELQRQIGVTQSNISHQLRILRQANLVRYRKIGRNVYYRLYDEHVEIIIKYAMEHLKE--";
    seqs[counter++] = "------------------------------EVMFDLSEFFKVFSDSTRIKILSSLLVSEMCVCDLAAVLNTSQSAISHQLRLLKAFRLVKSRKVGKVVYYSLSDDHVKSIIELGLTHLSE--";
    seqs[counter++] = "-----------------------------------LAELFKIFGDATRIRILCALSEGEICVSDLAETLSMTQPAISHQLRILKNTRLVKARRDGKQIYYSLADAHVSSIIGTALEHVEE--";
    seqs[counter++] = "------------------------------ETLYDLADLFKVLGDSTRIKILCTLFEAEMCVCDIAAVLGMTQSAISHQLRVLKQARLVKYKRSGKVVYYSLDDEHVKHIFDQGLIHISENR";
    seqs[counter++] = "-----------------------------------LSDFYKVFGDPTRLKILFALESRELCVCDLAQILQMTKSAVSHQLKILRQTELVNFKKLGRSVFYRLSDAHIQGILDQGADHINE--";
    seqs[counter++] = "------------------------------ECVMDLADFFSIFSDSTRIRILWVLYGRELCVRDISDTLGISMSACSHQLKTLRNSGAVEARRDGKMIYYKLADEHVEILLRTGLEHIQE--";
    seqs[counter++] = "-----------------------------------LADMYKALGDPSRLRIVMALSQGEMCVCDLAAYLEISESAVSHQLRRLRSLALVKNRRDGKILYYSLDDDHVSSLVALGLEHVRE--";
    seqs[counter++] = "-------------------------------------DLFKTLGDPSRLRIIEVLSQEELSVDDLANQVGLTQSAASHQLRRLKLDRVVKYRKEGKFIYYSLADQHLLYLFNIARDHVQE--";
    seqs[counter++] = "-----------------------------PDQIESLSNFYKIMGDPTRLMLLMALEAGELCASDLANVTNMSRSAVSHQLKTLKQACLVRSRRDGKTIFYELDDEHIYSVLKVAFEHIQE--";
    seqs[counter++] = "-----------------------------------LSDFFKVLGDSTRARIISALDINEMCVCDLAVLLNMTKSAISHQLRSLKEANLVKFRKEGKVVFYSLTDDHVKDIFEKGLEHIRE--";
    seqs[counter++] = "-----------------------------------LSEFFKVFSDSTRVKILSALLISEMCVCDLAALLQVTQSAISHQLRLLKAFRLVKSRKEGKVVYYSLNDDHVKSILELGLLHLSEAK";
    seqs[counter++] = "-----------------------------PDIIDDLSELFKILGDQTRSKILFVLEQGEFCVSDISEAVGMTKYAVSHQLRTLKQAKLVKCRREGKEVIYSLDDDHVSTLFSCALAHVTE--";
    seqs[counter++] = "------------------------------------AELFKVFADSTRVKIINVLLENKLCVGDIAALVGGTQSAISHQLRILKSAKLVKYTKIGKTVYYELSDDHVKKLFSVGKEHINE--";
    seqs[counter++] = "------------------------------ETMSDLAAIFKLMGEPVRITILHALSIRDLCVCDLAELLGMSHSAVSHQLRLLRTARMVRFEKQGRKAIYSLNDRHVETIMQTALAHMQ---";
    seqs[counter++] = "---------------------------------QELANNFKVLGDPTRLRILQALMHGERCVRELADGIQMEQSAVSHQLRTLRDAGLVNFRRDGKVVYYSLADAHVFTLLSVGIEHVAE--";
    seqs[counter++] = "-----------------------------------LSELFKILGDYTRIKIIYSLSKKELCVCDISEVVQMSQSAISHQLRILKAARLVKFRREGKSVYYSLDDEHIDRLFNAGLEHVE---";
    seqs[counter++] = "------------------------------EIINELSEFFKVFSDTTRLRILEVLLNEETSVGVIANKINVSNSAVSHQLSYLRSTNLVKTRKEGQVIYYSIADNHIKVIIEYGLEHIKELK";
    seqs[counter++] = "-----------------------------------MSNFFKAISDPTRLRILQAVRQKTICVGDLAIALQMTKSAISHQLRYLRDCQLVKGEKKGKMTYYELADDHVAAVLSLTLKHLKE--";
    seqs[counter++] = "------------------------------DVVASLSELFKALGDPTRVKILSCLQISDMNVGDIADKLGMTTSAVSHQLRVLRAIKLVKGTKEGKEVRYSLDDDHVTLIMQCGLTHVNE--";
    seqs[counter++] = "-----------------------------------LAELFKVLGDYTRIKIIYALLKKELCVCDIAELLDMSQSSISHQLRTLKAARLVKFRKEGKVVYYSLDDEHIEHILNASLEHVE---";
    seqs[counter++] = "----------------------------------SIADFFAVFGDRTRIKILLALDQSPMCVCDLAVLLDMTKSVISHQLSSLKKINLVSSHKEGKHSYYALADDHIKKIIEMAVEHLEE--";
    seqs[counter++] = "------------------------VKSIDADTAQHLADLFKTLGDPTRIKILSLLTKTEMRVYDIADSLTMGQSAISHQLRVLRSARLVKFRRDGKEVLYSIDDDHVMKLLGQGLEHVQ---";
    seqs[counter++] = "---------------------------------KDLADTFKLLSDFTRVKILYVLSLSELCVQDISELTGVSQSAVSHQLRILRNSRLVSWKKTGKQVFYSLNSDAVRALIEKGMEHV----";
    seqs[counter++] = "-----------------------------------LAELFKVFGDTTRVKILFALFTAEMCVCDLTALLGLTQSAVSHQLRVLKQARLVKYRKDGKMVYYSLDDDHVKQIFDQGLAHI----";
    seqs[counter++] = "--------------------KSNE-QMLAPDDVDVTAEFFKALADPTRINIVNALQIHELCVTDLAEILGMTKSAVSHQLCYLRLNNLVMVKREGQRVYYALCDEHVEKVFEMAISHIKE--";
    seqs[counter++] = "------------------------------------ADIFRALGDPSRLRMLSLLIHDELCVTEIAEALGDNLSAVSQRLKLLKSERIVGARREGKHIFYRLSDHHV---------------";
    seqs[counter++] = "------------------------------DIVAKLSDFIKVLGDGTRIKIIWILEENEMCVNDLAVALNMSQSAVSHQLKTLKTANVVKSKREGKNIFYSLSDDHVKDIFLKTLEHIQE--";
    seqs[counter++] = "------------------------------ETMSDLSDFFKNFGDSTRIKIVSALISGELCVADIAEVLEMSVSAISHQLRILRQAKIVRARRNGKQMYYSIDDEHVAILYSLGLEHIRE--";
    seqs[counter++] = "------------------------------ETFNSLSDNFKVLSDPTRLKILYALMLKEICVCDLAAVLEMTDSAVSHQLRLLRNRNLVKFRKKGKMAYYSISDHKIV--------------";
    seqs[counter++] = "------------------------------------AELFKMFGDPTRLKLLAALLGQEVCVCDLSDLLGISQSAVSHQLRLLRASHLVKNRREGKSVFYSLDDEHVATILAQGMEHV----";
    seqs[counter++] = "-----------------------------------LSETFKIFGNPTRLKILSLLSVEDLCVCDICEILNMSQSAVSHQLRTLRSKNLVKYTKEGKQARYSLADKHVVQILKIGIEHVLE--";
    seqs[counter++] = "-------------------------------------DIFKILGDPSRMRIVAALRIKELCVGDISALMEISLSGVSHQLRLLKKSRIIKSRREGKLIYYSLDDDHIESLIDIALDHVRD--";
    seqs[counter++] = "---------------------------LSPQIVEEASRILKAISDPTRMKILYLLFQEECSVGHMVEVLGVSQSAISHQLTHLRHLRLVKYRREGNTYFYTYDDEHVVGILHQVIQHVE---";
    seqs[counter++] = "-----------------------------------LAELYKVFGDSTRIRILYALLESEMCVGDMAQLLGLTPTACSHQLRVLKNSKLVRFRREGKIMFYSLADDHVRSILALGMEHILE--";
    seqs[counter++] = "------------------------LRPVAEEAAK-LAPIFKALSDETRVKIIYALAQAELCVCDIAELTGCTLPAVSHHLRILRNIGLAKSRKEGKFIYYNIDDHHVSQIINAAFAHLRE--";
    seqs[counter++] = "----------------------------------ALSELFKILADPSRLRILHALQSPERCVCDLAALLDMSQSALSHQLAILRRARLVRPVKIGKIVYYQLDDHHVDALIALAMEHVSE--";
    seqs[counter++] = "----------------------------APEGTRRVAEVFGVLSDPTRARIVCALSIEELCVCDVAAVAGLSVSAASHQLKRLRDRGVVDYRKEGRLAFYRLVDDHVRSLMEEGVE------";
    seqs[counter++] = "-----------------------------------LAELFKVFGDPTRIRILWTLNEAEMCVCDIAVLLNMTQSAISHQLRVLKQANLVKNRKEGKAVYYSLVDDHVREIFDQGLIHINE--";
    seqs[counter++] = "----------------------------------AVAELFKALGDGSRMSILNALLCSELCVCDLTMILKMTQSAVSHQLRVLRGAKIVKSRKEGKNVYYSLDDPHIAMLIETGFEHVRE--";
    seqs[counter++] = "-----------------------------------LEELFKVMGSQTRLRIIALMEANELCVEHLADTVNISVSAISHQLKGLRQLRLVKTRKQAQSVYYSLDDEHIALLFNTARTHLSE--";
    seqs[counter++] = "------------------------------QVIEELAQFFKAVADASRLKLLLYLMKQEANVNELAEATGLTLSGVSQQLKLLKLMKLVKSSKQGKYVYYSLDDHHVKHIINDSLIHLSE--";
    seqs[counter++] = "-----------------------------------LADLFNIFGDTTRIKILHVLSKSEMCVCDISSLINMNRSSVSHQLKTLRQAKLVKYRKEGTIVYYSLSNDHVKQVFNQGLIHLIE--";
    seqs[counter++] = "------------------------------EVVQTLSTYFKALADDNRLKIIHALSREELCVRDVADIIGTTMQVASHHLRVLRDIGLVKNRKEGKHVFYSLKDRKTAEFVQNVIEDLED--";
    seqs[counter++] = "---------------------------------ERLAGVFRTFGDGTRLRILFALLRKEMCVNDLAQNLGMTVSAVSHQLRILRQGELVRTRREGKTVYYAIADHHVSLIIRSGAEHVLE--";
    seqs[counter++] = "-------------------------------------KLFKIYSDFTRLRIIDLLIEKEHCVQDIADSLDASQSAISHQLKLLRDLHVVKTRKQGKQVFYSLQDNHIKEIFLIGYSHATEC-";
    seqs[counter++] = "---------------------------------QKLSKLFKVLSDETRIKILYTISKHEVCVNDIANVLNLSQSAISHQLKTLKDANLIKSRREKQTIYYTLVDDHVHLIYNQALSHIKE--";
    seqs[counter++] = "------------------------------EAIQEVSKIFKMISDPTRLSILFLLQKEELSVGAIAQSLSMEQSAISHQLKTLRTSRLVKSKRAGKNMIYSLDDLHVFSILEQVLTHIEE--";
    seqs[counter++] = "---------------------------------------FSMFADGTRLKIMSALFVSEMCVGDLAILLNMSTSAISHQLASLKKTKLVRMRKEGKNVFYSMDDEHIEKIFQVTYLHVKE--";
    seqs[counter++] = "------------------------------------AALLGVISDPTRLKIMDALRLGELCVCDLAAVLSMSVSAISHQLRLLRTARLVRGRRAGKVIFYTIHDGHVEKLIDMALDHCRQC-";
    seqs[counter++] = "------------HTVTLEILVQGELRESIPEERQNVADIFSLLGDPARLRILIALSVRRLRVCDLVKVVGASESSVSHALRILRAHRVVDVIRRGREAHYALADSHVRALLELAIDHV----";
    seqs[counter++] = "-------------------------------------DFFDALGNPTRLKILALMEAGELCTCDLSAITKLSVSAISHQLRILKDRKIVTYRKDGKNVFYRLDDEHIREILRTALNHLSEVR";
    seqs[counter++] = "------------------------------------AEFFKVLGDPTRIKIVSLFENGELCVNDIVDVVDVSRTAVSHQLRILKDKRIISFRKEGQMKFYHLDDAHVEVIVLLTITHLQ---";
    seqs[counter++] = "---------------------------------EQLAELHKAMGDYTRIRILWYLMQKEYCVSDLAQKMEITESAISHQLRALRIARLVQSHKAGKNVIYSLQDEHIRWILEKTYDHISE--";
    seqs[counter++] = "---------------------------ISKELIGSAAAFFKVLGDETRMKILCTIADSEVCVNDIAEAVDMTKSAVSHQLKLLKDDDLVKSRREGKNIFYSLDDQHVMDILDIAFVHI----";
    seqs[counter++] = "-----------------------------------LCDIFKVLSDPTRMRIILTLVDSEMCVCDIAGAVECSQSNVSHQLRLMRQSGIVKFRKDGKSVYYSLDDDHVKTIIVQAVNHI----";
    seqs[counter++] = "------------------------------QAAVQFADWFKAFSDPTRVKIISALLKRELCVHDLTVLLEMGQSAVSHQLRYLRNLRIVKRRKVGKTVYYSLDDTHI---------------";
    seqs[counter++] = "------------------------------EILFDLADLFKVFGDSTRIRIMNVLFSGPTSVGEIAEVLDMSQSAISHQLKSLKDNNLVSSKRSGRSMYYELADDHVKTIFMTGLEHIKE--";
    seqs[counter++] = "-------------------------QQIEKNIIDSTSEFFKILADNTRLHIINLLLDREMFVNDIANALNMTNSSISHQLKKMKDNDVVKSRKDGKEVYYSLNDDHVKSIFLTTIDHI----";
    seqs[counter++] = "----------------------------AEEILYDVAELFKVFGDSTRIRIICALFESEMCVYDLAACLDMTQSAISHQLRILKQANLVKFRRDGKLMYYSLDDEHVKQIFDAGYKHIE---";
    seqs[counter++] = "----------------------------------SITQIFKAMADPTRVQILYLLSDKEYSVGEIARSLGFNQTTVSHQLRFLKNLRLVKSRREGTSIYYTQDDKHVLELLKQTIRHVE---";
    seqs[counter++] = "-------------------------------------QIFKALSDPNRVKIAYYLQHQELCVCDIADLLDVSVATASHHLRQLKALHIAKSRKEGKNVYYSLSDHHIQTLVAMTLEHQKEMR";
    seqs[counter++] = "------------------------------ETLYDVAELFKAFADTTRIKIIAILKEETLCVGAISEILNISQSAISHQLKALKNAKIVKSKREGKWIYYSLDDEHIKRIFDMGFEHI----";
    seqs[counter++] = "---------------TVEQETSTEHKNLPPEKVMPLADFFKVFGDSTRLKIIGILRHTSLSVCCIADCLGMEQSAISHQLKVLRNNHIVKVEKKGKQSFYSLDDLHVELLYQMGLEHIME--";
    seqs[counter++] = "---------------------------VTPEEATQLADLFRLLGDPTRAQLLALLEAGELCVCDLTETVEVSDTAVSHALRLLRTAGIVASRRAGRMIYYRLADVHVRMLLDLSREHL----";
    seqs[counter++] = "-----------------------------PAAAGKVAETLQALASPNRLRILTRLRQSPCSVTELSAAVGMEQPAVSHQLRLLRNLGLVAGDRSGRNIVYRLYDSHVASLLDEAVYHIE---";
    seqs[counter++] = "---------------------------IQAETLSAAAEIFKALGDVTRLRILDVLERREMKVQEIAAALGMTQSAISHQLGTLRTLRIVKARREGRSTFYSIDDGHVKQLFDLCVEHV----";
    seqs[counter++] = "---------------------------IAKEVS-GLSDLFKVIADETRTKIVFLLSETELCTCDLAEILRLSLPTISHHLKQLKSYRLVKSRREGKSVFYSLEDFHVVELIKLAKEHFQE--";
    seqs[counter++] = "-----------------------------------LAEVFRLMADPGRIRILALLEAGEVCVHDLASVSGLSESSVSQALRLMRAQRVVAGRRAGRHVFYRLDDSHVRMLLDLAITHV----";
    seqs[counter++] = "------------------------------EVLYDLAELFKVFGDSTRIRILYVLFETEMCVYDLSKILNVTQSAISHQLRVLKQNKLVKFRREGKNIFYSLADEH----------------";
    seqs[counter++] = "------------------------------KVLNHLSGIFKVLADPTRLRIIYTLSMGELCVTDISETLEMTQSSISHQLAILKSRDLIKVRKVGRKSYYSLDDDHVLSLFEGGYEH-----";
    seqs[counter++] = "-------------------------------------QLFKLLGDNTRLNIITLLTRKELCVEDLMKCTGMEQSAISHQLKKLRAHHIVKAEKVGKHVWYSLEDHHVLQLYNLADEH-----";
    seqs[counter++] = "--------------------------------------FFKVLADDTRIRILYALKEQEMCAGDIAVFLDMTKSAVSHQLAVMRKMHQVRARREGKNVFYSLDDQHIVDIMEEALIHM----";
    seqs[counter++] = "-----------------------------------MSEFFHMFDDPTRLKIIGALIISEMCVCDIAAVTGMSQSVISHHLKILRQERVIQFRRQGKMAYYSLCDDHIGGIFYQGRIHVQEER";
    seqs[counter++] = "---------------------------------------FKALSDPTRIRILNLLCADEHSVNDIAEILDLGQSTVSHQLRFLKNLRLVKFRREGTTLFYSKDDDHIMNLLKQAIEH-----";
    seqs[counter++] = "------------------------MQVLSPEQVGDVAEVFRLLGEPNRLRIVLACLETERTVGEIGEALGLSQSLTSHHLRLLRTARILRAIRHGRHVAYAIDDDHVRDVLRNMVAHLTE--";
    seqs[counter++] = "------------------------------------ADVFGLLGDPRRLKLLVALLEGELCVCDLAAVTGMSESATSHALRLLRAHRVVSVRRDGRMAYYRLDDAHV---------------";
    seqs[counter++] = "------------------------------ETVYNMATLFSTFSDSTRLKILLCLSRAKLCSCDISAAVNISKSATSHQMRILKMTKLVKAERKGKQIFYSLSDEHVSILLQAALEHVKE--";
    seqs[counter++] = "---------------------------------------FQALGDSTRLQILYALMHHTLCVRDLAILVGVSESAVSHQLRLLRDRRLVRQRRSGNIIYYSLDDEHLAVLFREA--------";
    seqs[counter++] = "------------------------------DVFEEMSGFYKLFSDRTRLKILWALRNGPLCVCDLCAVVGMSQPAVSQQLQKLRNGRIVKSRREGKVVYYSLDDEHIEAALDMAMEHVEE--";
    seqs[counter++] = "-----------------------------PEALNQAAEMFRAMGDPERLRLLTMLQGGERCVGEL---VGENDSTVSARLQSLHRARLLHRRREARHIFYRLADEHVAELLNNALEHASE--";
    seqs[counter++] = "------------------------------------------LATPSRLYILARLQEGPCSVGDLAEAVGMEASACSHQLRLLRNLGLVTGERQGRSIVYALYDHHVAELLDQALFHVE---";
    seqs[counter++] = "------------------------------------AQTFKALSDPTRIRILHLLSQGEHAVNGIAEKLNLLQSTVSHQLRFLKNLRLVKSRREGTSIYYSPEDEHVLDVLQQMIHHTQD--";
    seqs[counter++] = "-----------------------------------LAVIFGLLSDPGRVRILIALLEGEMCVCDLAATTGLSESGVSHALRLLRGPRVVQVRRSGRMAYYSLADSHVRMLLDLGLTHV----";
    seqs[counter++] = "--------------------------------AAKLAPLFKALSDETRVKIIYALAQQELCVCDIAELTGCTLPAVSHHLRLLRTMGLARCRKEGKFIYYTIDDHHVWQIINAAFEHMKE--";
    seqs[counter++] = "----------------------------AEHLVSAAAALFKVIGHPTRVRILLALAAEELCVCDLAQVLDATVSATSHQLRNMRAMGLVYFRTEGKLAYYRASDPVMVSLLQQGVEH-----";
    seqs[counter++] = "-----------------------------------LASLFKLFGDGTRVQILHALEQSEMCVCDLAVLLGVTKSAISHQLKALRLANLVKFRKEAQIVYYSLADDHVKEIIDKGFEHL----";
    seqs[counter++] = "---------------------------------KQVSQLYKVLSDPTRLRILLLLKEGEHNVTAISEQLGMEQSAVSHQLKLLRDSRVVKARREGKTIFYTLDDHHVIDILNQTFEHIE---";
    seqs[counter++] = "-----------------------------------MADLFKIFGDSTRIRILWALHESEMCVRGISKSLDLSMSAVSHQLKALKDADLVQSRRDGKNIYYSLCDEHVEILLNTALTHLKE--";
    seqs[counter++] = "----------------------------AEPVTEGLSTFFKALADDTRLKVIHALSQDELCVCDVANILGSTVQAASHHLRVLRNIGLAKYRKEGKRVFYSIRDRKTAGFIQKVIEDLKK--";
    seqs[counter++] = "------------------------------EMIEHLSEFFSMFSNPTRLRILLLLSKKEMCVGKIAEILRMDQSAVSAQLKVLRHLNLVKAKRHGRYMRYKLNNKHV---------------";
    seqs[counter++] = "------------------------------------ADIFKALADETRLKIFALTQENELCVCDVANIIGTSNATASHHLRHLRNLRIAKSRKEGKLVFYSLDDPHVITLVTMAMAHGQE--";
    seqs[counter++] = "-----------------------------------LAELFKVFGDSTRIRILFVLFEAEVCVCDLAEALHMTQPAISHQLKILKQAKLVRSRREGKSVFYSLADGHVRTIIAQGREHIEE--";
    seqs[counter++] = "-----------------------------------LADVFSVLGDPGRLRLLYALRDGEVSVGALSTLTGQSDSAVSHALQLLRAHRIVRVRREGRRAYYRLDDPHVQMLLEVARSH-----";
    seqs[counter++] = "---------------------------------QQIAQIMRLFGDPARLRLLVLLEVDEMCVGDLAQLAQMNESATSHALRLLRAHHVVAVRREGRMAYYRIIDTHVKASLQLTLDHV----";
    seqs[counter++] = "-----------------------------------MAETFRALADSTRVKIVGCLLEQELCTADLAAILNYSESAVSQHLRVLRQLRLVKQRREGKLVFYSLDDDHVRVLVLVCLNHI----";
    seqs[counter++] = "---------------------------------------FKALGDPTRARIIYALAVSKLSVGELATGLALTQSNVSHQLTVLKQLKLVVGTRNGRNVHYQLADKHIISIFQQVAAHAEE--";
    seqs[counter++] = "-----------------------------------LADVFGLLGEPNRVRLLIALLNGPMCVRDLAATIEMSESAVSHALRLLRAHRVVDVHRKGRVASYELADLHVLTLLKLGLEHV----";
    seqs[counter++] = "---------------------------------QKVSNLFKVIADPTRIDILYTLKDSRLSVSEIKDKLNMSQSAISHQLRVLKDVNLVKDERVGKNIFYSLSDNHVYDIFNQAIDHVRE--";
    seqs[counter++] = "----------------------------------SIAQIFKTLSDPTRLKILYVLSKKDLCVSDISELLSMSQSSISHQLALLRHQQLIKVNRVGRMAIYSLDDDHVLSIFNQGKTH-----";
    seqs[counter++] = "---------------------------------------FKVLGNQSRIRILLEIADEEKCVHEISEETDQSFSNASHHLKTLRDNRLVDYRKEGRHKYYRIKDDHVLKILQECIDH-----";
    seqs[counter++] = "-----------------------------------LSELFKILGDKTRINIIWTLDNREMCVCDIANVLNMTKSSISHQLAILKNAGIVKYYKSGKEVYYTLDDEHINKLYEIGLLHIEK--";
    seqs[counter++] = "---------------------------------EELANFYKIFSDPTKIKILWALDISEMCGCDLAAITGVTKSAISHQLSSLKELNLVKARKQGKIVYYSLSD------------------";
    seqs[counter++] = "----------------------------------SLANLYKIFGDATRIKIVYILFEHECCVCDIAATLGTTQSNVSHQLQILKSNDLVSYRREGKQIIYSLKDSHVKDIFEKGYEHITE--";
    seqs[counter++] = "--------------------------------AEALAESMRAFATGSRLRLLWALLDGELTVEELAERTELSQSAVSHQLRLLRQGRLVSVRRSGRHAHYRLHDPHVVDL------------";
    seqs[counter++] = "-----------------------------------LADLFKVFSDATRIKILFTLLETARCVADIAEATGASQSAVSHQLRILKQAHLVTFKRCGRSIEYSLADDHVYTMLLQGMNHICE--";
    seqs[counter++] = "-----------------------------------LADFFTAFSDTTRLKILFELLESEKTVTEICDNTDFSQSAASHQLSKLRILKLVKVRKQGKFAYYSLDDEHIEHIIETALEHFEE--";
    seqs[counter++] = "-----------------------------PGVDERVAALMGALASPTRLRLFALLESGELSAGELSKAVGMRPSATSHQLRVLRDLGLVRRRREGRRCYYSLADAHLGVLLREAL-------";
    seqs[counter++] = "-----------------------------------LSELFKLLSDPTRMKLVLALSCGEMCVCDLGAALGMTKSAISHQLKTMKQCSVVKSRREGKNVFYSLHDQHM---------------";
    seqs[counter++] = "------------------------------------ADFFKVFGDPTRLKILFLLEQGEKGVNAISEELGMQQSTISQQLKLLRACRLVRFRKDGRNVLYRLNDEHIHEILALGTEHYQE--";
    seqs[counter++] = "-----------------------------------LAGFFSVFSDPTRLKIISALSEKELCVHELSSLLDMKQPSISQHLKMLWQARVVKKRKVGLHVFYRLDDEHIEKIYTWGYEHVKE--";
    seqs[counter++] = "------------------------------EAAASVATTLQALATPSRLLILTELRHGPLPVTKLAEAVGMEQSAVSHQLRLLRNLGLVTGTRSGRSIVYSLYDNHVAQLLDEAVYH-----";
    seqs[counter++] = "---------------------------------------FKVIADQTRMRILLALSETSLSVNEIADILTMSQSSISHQLRVLKDNRLVKGTRLGKQIHYQLTDDHIVQIFKQIIEHIEE--";
    seqs[counter++] = "-EHLSADPLQT-HLIT-----SGLFEPMAPQEFQTSAELFGLLSDESRLRIFWILCHYEECVINLSSLVGMSSPAVSHHLRQLKTRRLIVSHRSGKEVYYKPAD------------------";
    seqs[counter++] = "------------------------------------AKIFKALADDTRIKIAYILAEEELCVCDIAAIIDASTATTSHHLRLLRKMGLTKYRKEGKQVYYSLDDDHVKDLIKIAFEHQQE--";
    seqs[counter++] = "--------------------------------ASRLADFFALFSDCSRLRVISALAISRMCVTDLADVCRMNQTTVSHQLRSLKSMGIVESERQGKIVFYRLADNKI---------------";
    seqs[counter++] = "---------------------------------------FKALGDPTRLGIVLELMETEKCVSEISSSLSISDSSTSHHLRSLRQLKLVKRRREGQKLFYSLDDHHVYLILTIGLEH-----";
    seqs[counter++] = "-----------------------------------------------RMRMISLLASGELCVGNLAIALHMSDSAVSHQRKTVRALRLVGYRKQNRHVF-----------------------";
    seqs[counter++] = "---------------------------------------FKALGDEARLRTLEMLVNREACVSEIAEASKEQISTVSHRLKLLRAEGLVNRRREGRHIYYSLADEHVMELIHNAFEH-----";
    seqs[counter++] = "-----------------------------------MALLYKTFGDATRLRIMYLLLQKEMAVCDIAACLNMTHSAISHQLSVLKNLNLVKYRKFGKTVIYSLADYHVSILIATAYEHITE--";
    seqs[counter++] = "-------------------------------------KLFKVLSDATRLRIYALTVEEELCVCDVSASVDCSIATASHHLRTLLKQGLVKYRKEGKVVYYSLDDHHISSLVHLAMEHVNE--";
    seqs[counter++] = "--------------------------------ATELGEMFRLLGDPNRLRIVASCLSQPMSVGDIADTLDLSPSLTSHHLRLLRSARLLKGTRHGKQVFYDLPDCHVRQMLTNMIEHVTE--";
    seqs[counter++] = "------------------------------QAAAQVASTLQALATPSRLMILTQLRNGPLPVTDLAEAIGMEQSAVSHQLRVLRNLGLVVGDRAGRSIVYSLYDTHVAQLLDEAIYH-----";
    seqs[counter++] = "---------------------------VSEEVVIKISNFYKALSDPSRLKIMSLLNEKGLCVSCIVEKVGMTQTAVSNQLKSLRDVNLVKSERKGKNIIYKLNDDHVRDILNLTMTHMEE--";
    seqs[counter++] = "-----------------------------------LSRMFGAFGDANRLKIMLAVADQDLCVCELGELLGMSAPAVSHHLRRLKDLSLVKTRRQGKLVYYSLDDQHIRDLLVIGQAHLQ---";
    seqs[counter++] = "------------------------------EETQRSVQIFKAFGDYTRYKILYLLYERELSVSEITSKIGVSQSAISHQLKLLRQTGLVSGRRDGQRILYSLADKHIIMIFKQVKEHISE--";
    seqs[counter++] = "---------------------------------------FKTMSDPTRMRIILAIAQGPITVNDLAAMLDLGQSTVSHQLRLLKQARLVAGERSGKQIYYHLVDDHVLEIYALTKAHIEE--";
    seqs[counter++] = "---------------------------VTPAESSRIADAFALLSDPGRVRVLALLEAGETCVCDLAEMVDMSPSALSHGLRLLRTAGVVTNRRDGRMVRYRLADSHVRLLLDVTREHL----";
    seqs[counter++] = "---------------------------------QRAAALFRALGDVERLKLLESLAQREVCVTELAETSRARMPTVSQRLRVLRAEGLVVQRREGKHIFYALADQHVVELVHNALQHASE--";
    seqs[counter++] = "------------------------------------AKIFALLGDAGRLQLVLRCMEKPQTVGELAEASGMSQSLTSHHLRQLRDQRILASERNGRHIFYQIDDEHISCVVRDVFAHV----";
    seqs[counter++] = "-----------------------------------LAETFRLLGDQSRLKILLQCMRGSVAVGDIAGSLDLSQSLVSHHLRLLRGARLVRGERQAKHIFYGIADQHVSQVLQDMAVHISE--";
    seqs[counter++] = "-----------------------------------LAEMFRLMGDPSRLKIIAACLGAPMCVSDIAAKYGMSQPLVSHHLRLLRAARVLRSERRGKQIFYEAADHHVKRVIGNMVEHVCE--";
    seqs[counter++] = "-------------------AKMNEPSILDPETLTSVSKIFKILQNEARLSIIYLLKDQELSVGEITNLINMEQSAVSHKLNALKKAHLVKTRRDGKTIFYSLDDDHVFNLLEQVITHSKE--";
    seqs[counter++] = "--------------------------------SEKLAEFYKTLGDKTRLRILSLLKVDERCVCELVEILGISQPTVSQHMRRLKSVHLVKERRQGRWVYYSL--------------------";
    seqs[counter++] = "------------------------------KTADDLAQLFSILGDGTRMRILFLLRNEETTVQSLADSLDMTHSAVSHHLRLIRPYQLVKSRKKGRNVFYSLYDDCVWHLLEEGLIHLRK--";
    seqs[counter++] = "--------------------------------AERLAEIMQALASPARLRILSMLSARPSTVTELSEQLQIGQTTVSNHLRLLRHLSLVTGSRAGRHIHYSLFDDHVTELLDEAIGHLE---";
    seqs[counter++] = "-----------------------------------LSEFFKFFGDTTRIRVIHLLLSGEMSVSAIAEKLNLEQSVVSHQLRILRTANLVKPTRDGRKIYYSLDDEHIGEIFNTGLAHI----";
    seqs[counter++] = "------------------------------ELLENVSDFFKALGNGTRLQIIWCLSRGELKSSELAAILQMSPSAISHQLTLLKNLKIVSVRREGKNQIYALADKHISQVLDSVVEHYEE--";
    seqs[counter++] = "---------------------TGELKHVLPEFAIETASLFGLLSDSTRLRILYLLYHREVCVRNIAEAIEMSPPAVSHHLRSLKQLGVITSRRIGKEVHYTIAD------------------";
    seqs[counter++] = "------------------------------EEVQGMAQMFKALSDPTRMKMAWLLDEGELCVCDMSILTKQSIATASHHLRLMKSLGIATSRKEGKNVFYSLADHHIRTLIRMTLEHMRE--";
    seqs[counter++] = "---------------------------------------FSALANPIRARIVNRLTDGEASVGELSEIVGVKQPLVSHHLKVLRSAHLVSARKDGQKAMYSLIDDHVASIFLDAFNHMKE--";
    seqs[counter++] = "--------------------------------------FHALRSEP-RLTIMYLLLEKDMCVCELERALGMTQSAISHNLRTLRQLDLVRVRKDGRFAVYSVADEHVRALLELSRSHVMGCQ";
    seqs[counter++] = "-----------------------------------LTEFFKMLGNPARIRILLLLMEQDANVSDLAEQLGMTQSAVSHQLNLLKLNKLVRGCRVGKMVFYALVDEHVQMVIEKGTEHIGRC-";
    seqs[counter++] = "--------------------------------------YFAALSEPNRLKILYILKNGEYCPCELSEILGCTKSALSHQLRILKDKNLIKNRKDGKFIYYSIKD------------------";
    seqs[counter++] = "-----------------------------------LSDFFGLLSESTRLKIILELIKGEKNVSQISKNLDMSQSAVLHQLRILRQGRIVKFKKAGKNVFYSIDDEHVEGIINKAIEHL----";
    seqs[counter++] = "----------------------------------SVAQLFKALADENRAKIFALCQDDELCVCDVANIIGSSVATASHHLRTLHKQGIVKYRKEGKLAFYSLDDDHIKQLFTLALAH-----";
    seqs[counter++] = "------------------------------EVLSGLADFFSIFSDATRMKIISALTITEMCVTDISEILGINQTTVSHQLKIMRQAGVVGFRREGKILFY----------------------";
    seqs[counter++] = "------------------------------EALYSEARIFKALADPNRLKIVKLLKEGELCACELTIALSSSQSTVSHHLSVLKSAGLVKERKEGKWSYFRLSEGAVIEILNQALKH-----";
    seqs[counter++] = "---------------------------------------FHLLRNKTRFKILLLLMEKERNVSELEEIIGGTQSAISHQLAELRNMKLVKDRQEKRMRYYSIYDSHVTSIIEAAVSHINEC-";
    seqs[counter++] = "---------------------------ISNEVLTEIVHIHKILANPSRVKILLLLSEGQQNVSQISDAIGLEQSAVSHQLKMLKAHQLVTQARNGKAINYQIGDSHILQLLKLSIAHAQE--";
    seqs[counter++] = "-------------------------------------DIFKILSEPTRLKILMALSLDSLCVCELASLLDVTQSAVSHQLRILRNAGMVDYERDGKMARYYLRDNMVV--------------";
    seqs[counter++] = "-----------------------EMELINKKEITELAELFKIFSSETRLKILYLLIDTEMCVHDIAKLINMNQSAVSHQLAVLREAHLVRYERKGRVLFYSL--------------------";
    seqs[counter++] = "-----------------------------------------VLANSTRVQILYLLEQSELNVSELTDILKIEQSNVSHQLQRLRDYQLISQKRKGKSIYYSLDDPHIITTLNQLMNHVQ---";
    seqs[counter++] = "-----------------------------------LEKIFKLLGNKQRLIILELLRERSYSVSEIINSLGMEQSAVSHQLKLLREAQLVETEKRGREVLYGLSDSHILILLDNALKHV----";
    seqs[counter++] = "---------------------------------------FKLLSNPSRLQMLKVLEQRELNVGELGDLLGLEQSVVSHQLALLRKHQLVSSERVGKANYYRLDDPHILDVVNEMLEH-----";
    seqs[counter++] = "------------------------------EILQKMSGLLKIAGDPTRLKMLYVLVRGPKCVCDLQEEIQASQSLVSHQLKILRDNGLVKCEKIGNRALYTLSDDHVVALLSIVHEHVME--";
    seqs[counter++] = "------------------------------ENAETAAEALKLLAEPTRLSILALLKDNEMAVGAIAEELGRPTPAISQHLAKLRAAKLVTFRKEGTTTYYSQKDEHVDMLVTNAL-------";
    seqs[counter++] = "-------------------------------VTEGMADLFKVLADDTRLKIVYALCRDELCVCDVATILGITNANASHHLRLLSHMGLAASRREGKMVFYRLQSPHVRHLLQEVLSRGEEDR";
    seqs[counter++] = "-----------------------------PEYITRMSAVFQALQSDTRLKILFLLRQKEMCVCELEQALEVTQSAVSHGLRTLRQLDLVRVRREGKFTVYYIADEHV---------------";
    seqs[counter++] = "-----------------------------------LADCHKALGDKTRLRILALLREEDLCVGELVEILKITQPAVSQHVRKLRNARLVKERRQGQWVYYSL--------------------";
    seqs[counter++] = "--------------------------------AEKIAELFKLISDGTRLRVLVLLCISEKCVSEIADAFGMSLPAVSHHLRVLKQAEIISSHRDGKEVYYSL--------------------";
    seqs[counter++] = "-----------------------------------LEKIFKILGNKQRLTILELLRSRSYSVSEIVDILNMEQSAVSHQLRVLREAQLVQAEKRGREVLYYLSDSHILILLDNALKHV----";
    seqs[counter++] = "------------------------------ELLDDLTDLFSVFSDKTRLRIVCALAMSRTCVTDLSGVLGINQTTVSHQLRLLRNLGVVRSERDGKIIYYSIKN------------------";
    seqs[counter++] = "---------------------------------EQVTDIFKALSDGNRLRIMHLLIQGESSVGHIAHALDLSQSNVSHQLRILKQAHLVKGNRDGQSMIYTIDDTHVTTLLKQAIHH-----";
    seqs[counter++] = "-----------------------------PKIFEMSTDLFSILSDVSRVRILWLLCHTEDCVANIADAVDMSSPAVSHHLKLLKSANILKYTKKGKEVYYTLAD------------------";
    seqs[counter++] = "------------------------------------AAMFKLLGDPTRARLLALLEAGELCVCDLAAATGTQEATVSQSLRMLRASGVVTGRRQGRLVFYRLADAHV---------------";
    seqs[counter++] = "---------------------------------ERLAGRFKGLADANRIKIAYLLTREELCVHDIARLVGISIANASHHLRLMRSLGVTKTRKKGTTVFYSLADRHVHTIVLLGMEHMEE--";
    seqs[counter++] = "------------------------------QVIVNLSSLYKVFADKTRLEILYALHENEMCVCDLAVLLNMTKSAISHQLKTLRLANLVKNRRVGKVVYYSLADEKVYEIFNQSFKQLTE--";
    seqs[counter++] = "---------------------------------QKVSQLYKVLSDPTRLKILLYLKQGELNVTALSEKLNMEQSAVSHQLKLLRENHVVKTDRVGKTIFYILDDHHVLDILNQTIQHI----";
    seqs[counter++] = "----------------------------------ALSDFFRIFGDQTRLRILYALAKTELCVCDLAKLLGASQSAVSHQLQVLRSHRLV---------------------------------";
    seqs[counter++] = "------------------------------DVAEKLAGAFKLLSVEARIRIVQVLKRRALCVTELTSQLGISQSATSQHLRVLKDARIVKFQKRGFHVYYHL--------------------";
    seqs[counter++] = "--------------------------------------------DPTRLKILLSLKEGELCSCDISEISKISISATSHQLRLLRDRKLVKYRKEGKFVYYELYDEKI---------------";
    seqs[counter++] = "---------------------------ISDHTATHLADTFSLLGDPSRIRVLGTLLDGPKRVLDIAQACGHTQSATSHSLRLLKAHHVVAGERHGREIHYALADDHVRALLTLALAHI----";
    seqs[counter++] = "---------------------------------QKILEILKILSDETRLKIVSLLAENELCVCELMEALRMSQSRISNHLRILRNTRIIEAKREGKWIFYSL--------------------";
    seqs[counter++] = "-----------------------------------LADFFDIFGDTSRIKILLALHDKSLPVSSIAELTGLSASAVSHHLSLLRGRRVVKVERKGKYRVYELDDDHVSSVLKMAISHIQEVK";
    seqs[counter++] = "---------------------------------EGIAVIFKALADDTRLKIVYALSQAELCVCDVAALINSTKSTASYHLRLLNHMGLAKFRKDGKLVYYRLADQHI---------------";
    seqs[counter++] = "--------------------------AIDAEAVQGVSALFKALGDETRLKVLALYKGEELCVCDVANIVGSTVATASHHLRLLRNIGIANYRKEGKLAFYSLRDAHI---------------";
    seqs[counter++] = "------------------------------------------LGDPTRLKIIYTLSETSMCVSDIAKTLDLSQSLVSHQLALLREAELVKVKRVSRNAIYSLDDAHVLTIFKQAHEH-----";
    seqs[counter++] = "-----------------------------PQLAAA-ANTFAMLASPARLHLVTLMSGGRFDVGTLAEKVGLSLPTTSQHLSKLRLAGIVSARRAGRHSYYTVEDPHVLSLVEQIFEHI----";
    seqs[counter++] = "---------------------------------------FKVLGDPTRTKIVLALDNREVCVCTLADTLGMTKSAVSHQLAILKANNIVKSRRDGKQVYYSFDDEHITDIIEIAQAHIKD--";
    seqs[counter++] = "------------------------------------ARLFKGLGDETRFRIYALYLEAELCVCDVAGILGTSVATASHHLRLMKNLGLTRSRKEGKMVYYSLDDDHVRLLVKLAIDHAAE--";
    seqs[counter++] = "---------------------------------------FQALGDPERLRLMIRLSEQEICVSELAELAQEQLTTVSARLKSLYAARLVKRRRQAKHVFYSIADDHVLQMIRGAVAHAAE--";
    seqs[counter++] = "-------------------------------------DIFKIIGDPTRLMILHAIEFHELCVCDLGHLVGVTKSAISHQMKLLKKYGLVKGRKVGKMVYYSVIDDNVKNLIHAGYNHV----";
    seqs[counter++] = "-------------------------------------ETFRLLGDPTRLKILLACLSEPKCVNDVASEVGITGSLTSHHLRLLRGARLVRAERQGRQIFYVAADSHVNAMLAEMVAHIRQ--";
    seqs[counter++] = "-----------------------------------LAEVFKVFGDSTRIKILYDLFEGEKNVTEICQDLEMNQSAISHQLKILRTARLVSGKRMGKSILYSLADEHVKTIIAMGIEHIEE--";
    seqs[counter++] = "---------------------------------------FSALADRSRLKILYALSETELCVCDVASLLGMKIATASHHLRKLRDLQILKYRNDGKLAYYSLKDQRVAEILHHTLNQLVE--";
    seqs[counter++] = "-----------------------------------LADLFKVFSDSTRMKIMYKLFDGEVSVGQIATSLDMSQSAISHQLKYLKESNLVKSKRNGKSMLYYLADDHVKIIIKTGLEHIEE--";
    seqs[counter++] = "-----------------------------------LVEFFKTLGDFTRLRIV-LELKTKRCVGELAEELEMSHSAVSHQLNILKANGIVKSQRQGKYIYYIVQDEYV----QNAIE------";
    seqs[counter++] = "----------------------------------AVAEVFKLISDGSRLRILWLLCHREVSVGDIAEMMDMSNPAVSHHLKLLKQSGLVDSRREGKEVFYRLAD------------------";
    seqs[counter++] = "--------------------------------------FFKQLGYSTRVRILCYLIQEPRKVSDIAVHLNMTLSSVSHQLRVLREAGLVSGQRQGKTITYQKKDDHVATIIQNTLDHL----";
    seqs[counter++] = "---------------------------VSPDVLELIAERFRVLADPARLQILNVLQGGEQTVTELMRTTGFRQAKVSKHLQLLYNLGFVDRRKEGLHVYYRL--------------------";
    seqs[counter++] = "---------------------------------------FKMLSDKTRLSIMLLIKEQEMNVSEISRALNMEQSAISHQLSALRSERLVKSRREKRSVFYSPNDQHVYDILTQVIDHLETC-";
    seqs[counter++] = "------------------MARAGDV----PSDYEPVSALFKALANPVRAAIVHLLSDRERTVGQLVEALGLPQPLVSQHLRVLRGALMVATRRQGQEIWYSVCDQHVAHILGDAMKHTQE--";
    seqs[counter++] = "---------------------------------KDIAEFFKLFSNDGRLKIISSLATDNLTVNEIVERTKLSQSLVSQQLKLLKNARILTNEKIGKTVTYSIYDRHILHLLKDVAEHLDE--";
    seqs[counter++] = "----------------------------------SVAQMLKAIADENRAKIYALCQDEELCVCDIANIIGITVANASHHLRTLHKQGIVRYRKEGKLAFYSLDDEHIRQIMMIVLEHKKE--";
    seqs[counter++] = "-----------------------------PDVGE-MVQIFKALADETRLRIYSLTLESEMCVCDVAAVIQSSSATASHHLRYLREHSLAKSERRGKMVYYALADKHVADLYEHAIEHTME--";
    seqs[counter++] = "---------------------------VSQEVVQQVAEYFSLLSEPMRLRLLHLLRDEEKCVQELVDATQTSQANVSKHLKVMWQAGILSRRSEGTSAYYRVEDEMIFELCNRVCDRL----";
    seqs[counter++] = "---------------------------------EKVSQLFKMLSDPTRLKILLYLKDGEQNVTAITQAVEMEQSAVSHQLRLLRENHVVKSHREGKAILYSLDDSHVLDILNQTLKHVEQ--";
    seqs[counter++] = "-------------------------------IAEHAAEVLKAIAHPVRLQIVELLQAEEMCVGDIVNALGAKQAITSQQLNMMKAKGVLSCRRDGARVYYRIENRNVIKLLDCIYDHCEK--";
    seqs[counter++] = "---------------------------------ERIAETLKALSDPTRLRIVSLLRHGELCVCDLTEALQTPQSKVSRHLAFLKNAGWVRARRSGKWVYYQILD------------------";
    seqs[counter++] = "-----------------------------------LSELFWVLSDATRIRILYALSEKEMCVCELARLLNNKQSSISHKLRILRNSKLVGFKRNGK--------------------------";
    seqs[counter++] = "--------------------------------------------NPTRLRILLLLSKKDMCVGKIAEILRMDQSAVSAQLKVLRHLNLVKAKRHGRYMRYKLNNKHV---------------";
    seqs[counter++] = "------------------------------EHSQIAAETFRMLADATRVRILWALFHDELSVNALAEHVGAVPTAVSQHLAKLRLAGLVSSRREGTFVYYSASDAHVKALVAQAL-------";
    seqs[counter++] = "----------------------GEIMVILPDRLQAQSELFKPLSDPTRLKILYLLRNGELCVCEIIFALKKPQSTISHHLNILKKAGFIKGRKEGVWIHYRLADAEIVGVIDNLTSILNE--";
    seqs[counter++] = "---------------------------------------FKALADETRVKIIALLQEPNLCVCDLAQITELTISGASHHLRLLKNMGLARSHKEGKHVRYCIHDEHVKIILEEALNH-----";
    seqs[counter++] = "------------------------------EQLQSLADTFKLMGDKTRLTILALLRERELCVCDLVDVTGMSQPSISQHLRKMKDAGLVSETRKGQWIYYSL--------------------";
    seqs[counter++] = "-------------------------------------------------------------------ALGTSESAVSHQLRRLRDQNLVLPRKEGRVVYYRLADAHVTDLLRNVLEHVGE--";
    seqs[counter++] = "-------------------------------------DLLGALANANRLKILSLIIDGELCVSAINAHVDLSEAALSHRLAKLRKLRLIESRRQGTTIYY----------------------";
    seqs[counter++] = "------------------------------EQAEELAGMFHLLGDVNRLRLICACLEEAVCVQDLADRFSLTPSLVSHHLRLLKAARLMRAERRGKQVFYTVNDEHV---------------";
    seqs[counter++] = "------------------------------------AKIFALLGDAGRLQLVLRCMEKPQTVSELAEATNMSQSLCSHHLRHLRDQRILASERRGRHILYRIDDDHISRVVRDTFAHVHE--";
    seqs[counter++] = "-------------------------------------EVFRMLADSTRIQLLWALIDRELSVNELAGEVGKLPASVSQHLAKLRMSRLVHTRREGTQIYYRLENEHIARLVTDALD------";
    seqs[counter++] = "---------------------------------KKIAEFYKALGDEVRLKILQMLSEQEMCVCEIIERLDMSQPAVSHHLKILRQVGLVKDSREGKWIYYSLHD------------------";
    seqs[counter++] = "-----------------------ELPALDDQHIASLAHLFHLLGDEGRIRLVLACMAGPVPVSELSAVTGMSQSLTSHHLRHLREARILRSERQGKQILYRLDDHHI---------------";
    seqs[counter++] = "-------------------------------------DIFKLLSHPMRLQIIYMLEQQTMNVGEIVERLGLEQSAVSHQLTLLRKGHLISTCQIGKIVCYSLNDKHILDIVNEALEHTQ---";
    seqs[counter++] = "------------------------------------------LSDPTRLRLLALLVREELSVAELQEILGMGQSRVSSQLALLRQVDLVTDRRDGKKAFYSIRSNRTLALLKSAIDSVSE--";
    seqs[counter++] = "------------------------IQPLSRKNAQSAEKLFKCLASASRLKILFVLLESEKSVGDITVDCDMSQPLVSQHLRHLRDNNLVYTKRHGKQVYYSIADEHIKHVVADCIQHVQ---";
    seqs[counter++] = "---------------------------IASELAPAVA-LFRSLGDPARLAILDRLARGEARVVDLTDELGLAQSTVSKHLACLRDCRLVDFRVEGRQSFYALARPELPALFRSA--------";
    seqs[counter++] = "------------------------------EEAAQLTSVLSLMADPTRARVLALDMVKELCVGDLALALESNEDAVGYALRLLRTAGLVTNRKQGRVVFYRL--------------------";
    seqs[counter++] = "------------------------------------ADLLKALSNPGRLRILCALVPGEMSVGDLETALGASQSYVSGQLLRLRNEGLVSCTRDGRSIRYQLAD------------------";
    seqs[counter++] = "------------------------------------------LSTPSRLLILARLREGPLPATELAAEVGMEQSACSHQLRLLRNLGLVVGERRGRSVVYALHDDHVAGLLDQAVYHVE---";
    seqs[counter++] = "------------------------------------AEYFKAISDPARVRIIYALANGELCVCELMLIMGMQQTVVSHHLKILKYANIVSDRKSGKWVNYSLADRRVL--------------";
    seqs[counter++] = "------------------------------------ANIFKLLGDYNRIRIINALKIKELCVCELSILLDMSQSSISHQLRILRHHNIVKNRKENKRVFYSLNNDKIFKLIEESI-------";
    seqs[counter++] = "-------------------------------------ELFTQLSSSTRIRLLCILAIEEMCVCELADMLKMSQPSISHHLRLLRQSGVVKYKKSGKRVIYYITD------------------";
    seqs[counter++] = "----------------------------------TLAELFKALGDPTRLNVLQLLTERQLCVGAIARRLGVTQPAVSQHLKVLKHLGLVKASRDGYHIHYSI-NQDMLASYKTHIDEWQ---";
    seqs[counter++] = "-----------------------------------MADILKVLGDPNRLHILSLISRQELCVCEITSILNISQSNASQHLARLRSVDLVKERRNAQWIYYSL--------------------";
    seqs[counter++] = "---------------------------------------FQALSEPIRLQILDLLQEQELCVCEIREKIKISQSKLSFHLRILREAKLARSRQQGRWVYYSLNPEQLL-LLEQYLNQLRE--";
    seqs[counter++] = "-------------------------KALQREHLQSAADLAKSLSDENRLRILDCISRGKQSVGGIAKELSLSQPLVSHHLRELRRTLLVKIERNGAFVYYELSD------------------";
    seqs[counter++] = "-----------------------------------------ILGEPSRLKIVLALSEGDMCVYHIVKAVNSNQSAVSHQLRILRENKVIKSFRKGQNIVYSLDDEHIMQIINIVKTHVEE--";
    seqs[counter++] = "----------------------------------SLAKYGKAISDPKRIELMDLLVQAEKNVDVLSKETGMSIASTSHHLQILKEARLVSDRRKGRNIFYQIED------------------";
    seqs[counter++] = "------------------------------EHAEDLAQVMQALSSPGRLLILARLDDSPCSVSTLVEDCGMAQATISNHLRILRHLDLVTGQREGRQVIYSLYDAHVQEFFRQALGHI----";
    seqs[counter++] = "-----------------------DLSSLSRSQAEVASELFKSLSNPNRLQIVAALALGEHPVGDLETMLGIKQPTLSQQLAELRDAGFVESRREAKQVFYRLGDKRLLAL------------";
    seqs[counter++] = "-----------------------------------LADFYKLFSDSSRIKILFVLLSGAHCVKHIAEKAEMSQSAVSHQLAVLRRSNIIRQTRSGQNITYSLADDHVKLLLELAIAHIRE--";
    seqs[counter++] = "------------------------------------ANLFKALADETRLSIYALTIEEEMCVCDIAAVIGSSMATASHHLRYLRERSLAKSERKGKQIYYSLSDNHVRQLVKIAHEHTKE--";
    seqs[counter++] = "------------------------------QAATQTASLLKTLGNPDRLLLLCQLTQGEACVSDLEASLGIQQPTLSQQLTVLRNEELVATRREGKRIYYSIAD------------------";
    seqs[counter++] = "------------------------LQMNMTQAATQTASLLKTLGNPDRLLLLCQLTQGEACVSDLEASLGIVQPTLSQQLTVLRNEGLVATRREGKRIYYSIADEKLFTL------------";
    seqs[counter++] = "-----------------------EMQDIAAQLQELHARVCKAIADPKRLLIINELRDGELSVGDLCEALGFSQSNASQHLSVLRERGIVNARRSGNNVFYSLRSRKIV----QAVDLLRE--";
    seqs[counter++] = "------------------------------------AKFFHGLANPTRLKIVETLLAGEMSVSQIVDAVGVSQSQVSNQLACLKWCGYVTSRKEGKYILYRISDERVRAILQLA--------";
    seqs[counter++] = "------------------------------------AEGFRLLADPTRIKILWALLQGESSVACLAEMVGAAPTAVSQHLAKLRLAGLVKGRREGTYVHYSAADGHVRALLAEALFH-----";
    seqs[counter++] = "---------------------------------------FKALSDFNRVRIMEFLENGEASVGHISHSLNMTQSNVSHQLKLLKSTHLVKSKRQGQSMIYSIDDIHVSTLLKQAIHH-----";
    seqs[counter++] = "----------------------------APEVGVTLARALLALTDPSRVRLCRLIARQAMTTADLADRLTMTRPQVSRHLRALRELGLVRMERHGRHVLYEL--------------------";
    seqs[counter++] = "---------------------------------QMLDEFFKSLSEPVRLRVMYLLERGELCVCDIVSSLEVSQSVVSRHLAYLRNAGLVSSRRQGVWIYYQL--------------------";
    seqs[counter++] = "------------------------------DLAASVSEKLKVYAQPQRLMILSCLWRGERTVADIGQATGIVQPALSQQLAELRRADLVQTRKEAKQVWYRLAD------------------";
    seqs[counter++] = "---------------------------------KKLASFFDVLSDGTRLKILSALAITPMCVSDLSAVLEINQTTVSHQLARMRLAAMVDFRREGK--------------------------";
    seqs[counter++] = "-----------------------------------LAELYKLLGNVTRLKILLALAQGELCVCDVAHVLGLTVAATSHQLKLLRDQGWLAMRNDGKMVYYRL--------------------";
    seqs[counter++] = "-------------------------------------KILSLLKNPVRLQILYILSQQSLSVSEIVELLHLDQSLVSHHLSDLRKYQLVSTKRDGKSIFYELDDPHILDIVNETLEH-----";
    seqs[counter++] = "-----------------------------------LSETFRLLGDPSRLRILLHCEEGPKSVTDISETLELSQSLVSHHLRLLRGARLVTRVRHSKQMFYEISDQHVGDVLLDMLSHVRE--";
    seqs[counter++] = "-----------------------------------LAELFAALSDPTRLRLLNLMRDREVCVCDFVEILGQSQPKISRHLAYLRRAGIVCARREGKWMHYRIE-------------------";
    seqs[counter++] = "---------------------------------------FQQLGDPTRLKILWILCHCRECVSDIAAAVGMSDAAVSHHLQLLKRSGLIVGSRVGKEIHYTLSDERRAGLLHRMMDALFE--";
    seqs[counter++] = "-----------------------------------MADIFSVVADPTRRELLGTLLSAELSVGQLVERLGVSQPTVSKHLRVLRDIGLVTSREEGQHRYYRL--------------------";
    seqs[counter++] = "------------------------------EYFQTVALVFRQLSDANRVRLFWLLCHCEECVVNLAAMMGMSPPALSHHLRQLRESGLIVSRRDGKEVYY----------------------";
    seqs[counter++] = "------------------------------------AEVFNQLSDGTRLRILWLLCHSEECVNDIAAAVRMTAPAVSHHLKTLKQNGIIKSRRLGKEVLYTLED------------------";
    seqs[counter++] = "-------------------------------------QIYDALSDFTRFQILGALLLGEKSVTELQELLSVSQSATSHQLRLLRDRGLVTAKRDGRRVIYSLADDHVITLISVGLAH-----";
    seqs[counter++] = "--------------------------------------FLNLIADKRRIDIIYLIMKKRLCVQDIAEIINETVANTSYHLQQLKKGNIVKVEKEGKEVFYSLSDKHVYEILENVLEHI----";
    seqs[counter++] = "-----------------------------PQLLETAAGTLRMLAEPTRLNLLFQLTDGPKTVTELTAAVDVPRTVVSQHLAKLRLSGLVDTRKDGRHVIYSLHDGHLIRLIRETINH-----";
    seqs[counter++] = "--------------------------------AQAATALLKVLANENRLMILCTLMGGEMSVGELNTAVPLSQSALSQHLASLREAGLVSTRKEAQTVYYRLQ-------------------";
    seqs[counter++] = "------------------------------QAADAAVELLKALANPVRLKLLCFLVEQERSVGEIASRLGVRETLVSQHLSLLRRDKLVAYRRDGQTLWYRLAD------------------";
    seqs[counter++] = "-----------------------------PKTSELQAKLFRGFADPSRLAILETLRDGPLTVGEIVQATGLSQSNVSNHLGCLRDCGLVTATQQGRFVSYALSD------------------";
    seqs[counter++] = "------------------MAESQEMH---QEEAQNAASFLRSLGNPHRLQILCRLALGEQSVGQLHQFFDLSPSAFSQHLAVLRQQQLVSIRKESQTVYYSIKD------------------";
    seqs[counter++] = "------------------------------------------LSDAGRLRLLLWLAQREMCVSELVALEQDKVSSVSARLQMLHAVNLVTRRREAKHMFYALADVHVHRLLRNILDHAAE--";
    seqs[counter++] = "---------------------------------------FAVIAEPSRRRILDLLLQSESNVTDLAQALGLSQPLVSKHLRTLRQSGLVKVRKSQQHIY-----------------------";
    seqs[counter++] = "------------------------------------ARFFRVLGDPVRMGILELLLEGEKNVSEIVSRLGMSQSRVSNHLACLRWCGLVSVRRKGSFIYYSLADEQLRELLEIANDRVEK--";
    seqs[counter++] = "----------------------------------TLSDILHLMGEPNRLRLLVTCLEGAKSVSELAQQLQLSVPLTSHHLSLLRSARLLVANREGKHIYYSIYDAHVRCILDDMLKHFTE--";
    seqs[counter++] = "---------------------------------------FELLSDGNRLRLLLCLHHADICVGDLAAALDMTGTAVSHALRLLRNQGWVSATRDGRSMRYRLTD------------------";
    seqs[counter++] = "-------------------------------------DFFKALAHPTRIVLVEDLAEGEKCVCDLAQKIDADISTVSRHLRELRNAGIVANQKRGNQVFYSL--------------------";
    seqs[counter++] = "-----------------------------PEVDREIIEFLKALSNPIRLKILKLTRDNWLCVCLLSEVLGEDQTLISHHLRTLKTLDLVKERREGRMRFY----------------------";
    seqs[counter++] = "------------------------------ENADQAADFLSALANNKRLLILCKLLHNEMSVGALAKAIDLSQSALSQHLAKLRALDLVSTRRDAQTIYYMVSSPHI---------------";
    seqs[counter++] = "---------------------------------KNLSSYFKGLADENRLRILNLLFHGELCGCDIQYVLGASQSNVSRHLSYLKNAGLVNDRRKANRVYFSL--------------------";
    seqs[counter++] = "------------------------------------AELFKVLSSATRLRLLRTLAEEVSTVSRLAERSGLAQPLVSQHLRTLRSAGLVSVERVGREAHYSVADTHVTHIVEDAVHH-----";
    seqs[counter++] = "-----------------------------------LAETFGILSDSTRLSIVLACMETEVSAGDIATKLKVSPSLVSHHLRLLRAVRIVRSERRGKQVFYTMTDACVRDILTTMINHLPE--";
    seqs[counter++] = "------------------------------------AKFFRGLADPSRLALLLALRPGEKTVSTLSEETGLSQSNVSNHLACLKDCGLVVNRQEWRHVYYRIADSKVLTL------------";
    seqs[counter++] = "---------------------------------------FKCLSDPTRLQILHLLMEGEHCVGDIALKIGTTQANISKHLSLLKNAGLVVSNKQGMKVIYSLQ-------------------";
    seqs[counter++] = "----------------VPLPTSTLMQDIAAQLQELHARVCKAIADPKRLLIINELRDGELSVGDLCEALGFSQSNASQHLSVLRERGIVNARRSGNNVFYSLRSRKIV----QAVDLLRE--";
    seqs[counter++] = "---------------------------------KSLNEQFSVIANPNRLEMLEFLAQCEYSVDDLAKVMGLSVANTSHHLQQLRLAGLVASRKEAQRVFYRLKGDGVVEL------------";
    seqs[counter++] = "------------------------------------AEMLKALADPHRLGILLRLSKRELSVGELAEIEQEKVTTMSARLKVLLTAHLVKRRRKGQSVLYSLADTHVLNLVDNAIEH-----";
    seqs[counter++] = "-----------------------------PDVVQ----LFKVLADETRLEILRLLALTDLRVGEIVAHLGLPQNAVSYHLKQLRRLRLLRDHRSARDIYYSVDLDHLQALYAAA--------";
    seqs[counter++] = "-------------------------------------ETLKTLANQKRLEIVQLLGQGELTVSEMIEMLGISQSNLSQHLAVLRRYQIVATRKEGLYVYYRLTDGHI---------------";
    seqs[counter++] = "---------------------------------------FKILGDENRLRILNLLRKGELCVCEIELVLETTQSNVSRHLGKLRNEKIISFEKKAQWIYYRI--------------------";
    seqs[counter++] = "------------------------------------ADLFKALSSPARLRILSALIAGPSDVGSLADATELSQPLVSQHLRTLRLAGIVQVERIGRNAVYSLHDEHIAHIVGDAVSHVSE--";
    seqs[counter++] = "------------------------------------ARLFKVLGSESRLALLRILQAKPATVGVLVEKSGLTQPLVSQHLRVLRQTGLVTRDRQGKEVTYQIADHHVAHLIDDAIIH-----";
    seqs[counter++] = "-----------------------------------LANLFKVFSDSTRIRILFSLFDYEKNVNTISKELNLSQSAISHQLRYLKDSNLVKSQRDGQAMIYALSDRHVKFIIKLGLEHLYE--";
    seqs[counter++] = "-----------------------KVEAVKEELAASISQLFKVLADERRFKILYALTKQELCVCDVALIIGATVATTSHHLRTLSKQSILTHEKIGKMVYYQLSNPMIQQLVLDAMNQEKE--";
    seqs[counter++] = "---------------------------------KAVVRIFDVLGNRTRLRILLALASEELCVCDIAHALNLSISAASHQLRALHDRDWLRMRNDGKMVYY----------------------";
    seqs[counter++] = "---------------------------------ENVGEFAKALGHEKRLLIIELLSSHERCVEDLATAMGIGVKSVSAHLKVMRTQGILTTRKEGLRVYYRLRNDNILKLFQ----------";
    seqs[counter++] = "---------------------------------KELSNFFNAFGNPTRLKILLALKEEELCTCDLSNITGLSVSAISHQLRVLKGRKNVNYRGDGK--------------------------";
    seqs[counter++] = "---------------------------------------FHALGEPLRLKVIEILHREELCVCDLCERLHLRPSKLSFHLRALRQANLVLSRQQGRWVYYRL--------------------";
    seqs[counter++] = "-------------------------------------EVLRLLADRTRLAILAMLDGTEMPVNAIAEALGRPAPAVSQHLARLRAGRLVTSRRDGTTVFYGQPDEHVAALVANVLQHTEPHR";
    seqs[counter++] = "-------------------------------------EVFKAVADPCRLRIVKLLKEGELCVCEIMTALDKPQSTTSHHLSILREAGLVRERKDGKWSYYRLAD------------------";
    seqs[counter++] = "---------------------------------------FRALSDPIRLNVINLLQEKEMCVGDICLALKIAQPKLSFHLRVLRESGLLQTRQEGRWIYYRL--------------------";
    seqs[counter++] = "---------------------------------------FKALADANRRKILFLLKESDLTAGEIASEFDISKPSISHHLNILKNAGLVEARREGQQIYYSL--------------------";
    seqs[counter++] = "------------------------------------------LGEVNRLSLLALLHAGDLCVSDLAVAVGMSDSAVSHALRLLRAHGMVTAHREGRLVRYRL--------------------";
    seqs[counter++] = "---------------------------------------FKILSDETRLRIIILLAQEELCVCQISGVLNVSQPKVSKSLSRLRDLNLVIDERKEKFVFYKLKTENFVSTIRNIMDNLNESR";
    seqs[counter++] = "----------------------------------TLESLFSALADRTRLEIVLFIMRGKASVQEIARGINKSQSLVSHHLACLRNCGIVKTERKGKYVYYSLLDNEVVSIIKLAVEH-----";
    seqs[counter++] = "---------------------------------------FQALADPSRRAIFESLTRGEAAVKDLTTRFDISQPAVSQHLAALKDAGLVSGRREGRHVYYRVE-------------------";
    seqs[counter++] = "------------------------------------AALFHALSDAGRLRTLAILAEQSSSVSHLAEVTGERIGTVSARLKVLLQANLVTRRREGQSAIYSIADQHVLELIHNALEHVNE--";
    seqs[counter++] = "-------------------------------------DFFGIVADETRLRIIGLLNQKELCVCEMCEILGLSQPKVSRHLSKLRDAGIVIDSRQGQWVFYYL--------------------";
    seqs[counter++] = "---------------------------------------FKALGDNNRLRILSMLNVRELCVCEINAVLKVSMSTISSHLKILRNAGLVTSRKDGRWIIYRLE-------------------";
    seqs[counter++] = "------------------------------------AELFKALATPSRLKILLTLSHGPASVSNIVIATELSQPLVSQHLKVLRGIHLVSVQRDGREAIYSLMDDHVAHIILDAMAHVNE--";
    seqs[counter++] = "------------------------MMSVSEETSDEAARQLKAVADPVRLRILYALSKEPLCVCELSVLLNMSMPAVSHHLRILLSAGLLKVRKEGKFACYHLRDSH----------------";
    seqs[counter++] = "-----------------------------PQAAHEASDLLKALAHHTRLLILCILAKQERTVGEIENILGIQQAMVSQQLARLRLEGLVNTRRQGRLVYYSIGNVSVLAFLESLFD------";
    seqs[counter++] = "------------------------------------------LAEPTRLHLLWQLSNGPKTVTELTDASGAARTVVSQHLAKLRLSGLVDTRKDGRHVIYSLHDGHLVRLIRETINH-----";
    seqs[counter++] = "----------------------------------TISQIFKILSDETRVKIVALLTENELCVCDLANIVEATVAATSHHLRFLKKQGIANYRKDGKLVYYSL--------------------";
    seqs[counter++] = "------------------------------------------LGDPTRLRVTALLSGEELCVCDLAWVVGLAQNLVSHHLRLLKGAGLVTGRRHGRLVMYAL--------------------";
    seqs[counter++] = "------------------------------------AAIFKALGEVNRTRIVKALSLEELCVCDIATIIDATIATTSHHLRSLHGQGIIKSRKEGKMVYYSLDDDHIRQIVSMAFLHQEE--";
    seqs[counter++] = "------------------------------EDAEIAAGFLSAMANPKRLLILDSLVKEEMAVGALAHKVGLSQSALSQHLSKLRAQNLVSTRRDAQTIYY----------------------";
    seqs[counter++] = "------------------------------------------LSDPHRQSILKMLAHQEMGACEIIHSIGLSQPAVSHHLKILRQARLITSQKQGKMVFYSL--------------------";
    seqs[counter++] = "------------------------------------AEYFKALSHPTRIKIIELLSKKEMCVCQMMAALNLDQSHVSRHLMVLRANEMVKTRREGTIIFYSLTDENII--------------";
    seqs[counter++] = "-------------------------------------EMFRAFSDRTRLRILNLLLRGEMCVGDLVSILEMSQPRVSQHLSCLRNSGLVVGRREGQWNHYSL--------------------";
    seqs[counter++] = "---------------------------------------FKLLSNPTRLNILMLLEHEQLSVNEIVTQLEITQPQVSHQLAILKEQQLVSAKKIGKKSLYQLSDPHILSV------------";
    seqs[counter++] = "-------------------------------------DIFEALSDPHRRKILDMLKHGELCSSDIASQLDITPASVTHHLNKLRSANLIIKTRKGRNIYY----------------------";
    seqs[counter++] = "------------------------LERLEPQISEA-ARLMEMLSHPARLRILCTMLGGEKSVQELAINASLSQPAMSHHLRKLRDSELVNTRRDKQTIYYSLKGEHVAAVLE-VLEHL----";
    seqs[counter++] = "---------------------------------QARAERLRALGEPTRLRIYALHAGAELCVCDLAWIIGSSQGLVSHHLRQLRAAGLVTSRRDGKLVMYRL--------------------";
    seqs[counter++] = "------------------------------------ARIFKVLGDRNRTAIYALCENDTLCVCDIATIIDASVATTSHHLRTLYKEGVVTYEKKGKLAMYALDDNHIRQLMMTTLEHAEE--";
    seqs[counter++] = "---------------------------------------FELLSDANRLRLLLCLHHAPICVTDLSVALGMSGTAVSHALRLLRSQGWVSATRDGRSMRYQLAD------------------";
    seqs[counter++] = "------------------------------------------MADPLRLQVLNLLSKQELCVCDLCDRLQVKQPKLSFHLRQLREAGLIQARPQGRWTYYSL--------------------";
    seqs[counter++] = "-----------------------------PDFVETSAALLQAMANPARINILIILAEREVSVGPLSELVGLSQSALSQHLAKLRQAGLVSTRREAHTVYY----------------------";
    seqs[counter++] = "------------------------------------ADLFKVLSNPVRIQILDALRLGEQSVGYIAEWLEIEASAVSQQLAVLRSRNLVTSRKQGNYVFYSVRD------------------";
    seqs[counter++] = "---------------------------------------FQALSDPLRLQILQLLRHQELCVCELRDHLDIAQSKLSFHLKTLKEANLVRSRQEGRWIYYSL--------------------";
    seqs[counter++] = "---------------------------------QTTADIFKQLSDPTRIRIFWILCHCEECVINIASMMEMSSPAVAHHLRLLRSSGLIESRRDGKETYYRAVD------------------";
    seqs[counter++] = "-------------------------------------------ADEKRLKLVNLLLKQDYCVGALAKELEISKSAVSQHLKVLRESELVIGEKRGYWVHYSVQEDKLIEL------------";
    seqs[counter++] = "---------------------------------ERLTEIFKLLSDETRLRVVMLLAREETCVCEIVGVLGIPQPKVSKALSKLRDLGLVNDERKEKYVYY----------------------";
    seqs[counter++] = "------------------------------------AELFKALGHPLRLRILELLRTGEKTVGELQRLLMVEASSVSQQLAVMRAHHLVESRKQGTNVFYSVKD------------------";
    seqs[counter++] = "------------------------------------AEFFRTLGHPARIRALELLSEREWSVSELVPEIGLEASHLSQQLGVLRRAGLVTTRKQGTTVFYAVASPEIVTL------------";
    seqs[counter++] = "------------------------MQTPATTIPHLIAAGFYALCDPLIISVLELLRQQELCVCDLCKALGVNQSKLSFHLKTLKETALVHSRQEGRWIY-----------------------";
    seqs[counter++] = "---------------------------------EELSQSFRVLGDPTRLRILRLVAEAPLNVTELVSLVGVAQSSVSHHLGKLKGLGLLREERHAGYSYYSL--------------------";
    seqs[counter++] = "--------------------------------------------DEARLRLLVRLSEGERCVTDLAAGSDERMSTVSQRLKVLKGEGLVTGRREGKHVYYTLADRHV---------------";
    seqs[counter++] = "---------------------------MAVELVQSL----KALADDKRMQIIHLLLEGDLCVGALAQSLGISEPAVSQHLKVLREAGLVWGEKRG---------------------------";
    seqs[counter++] = "-----------------------------------------------------MLFLKEYSVNEIAENLHLRQSTVSHQLRFLKNLRLVKYRREGTTLYYSHDDAHVMNMLKETINH-----";
    seqs[counter++] = "----------------------GAMAAAQPPIYRLKADFFRLLGHPARVRILELLRDGERAVGELQAALGLDSSGTSQHLTAMRRQGLLESRRAGTSVLYRVKDPRIFQLLEVA--------";
    seqs[counter++] = "------------------------------------AELLALLADRTRLALLHALTGGEADVSTLTQVCGAARPAVSQHLARLRLAGLVNTRKEGRRVIYSLRDGHLRRVVDEAL-------";
    seqs[counter++] = "-------------------------------------ETFRLIGDPSRLKILYILSHTEENVRNISAAFDMSPPAVSHHLRLLKSMKIIKSERRGKEVYYTL--------------------";
    seqs[counter++] = "-------------------------------------KIYKVLSNMNRIKILYFLENHEADVSRIVDHVQLSQPIVSHQLAILYHYQLVTRHKRGKHVYYCLDDPHILEMVDAMLGHV----";
    seqs[counter++] = "---------------------------------KGVSQILKAIADENRAKIYALCQDEELCVCDIANILGVTIANASHHLRTLYKQGVVNFRKEGKLALYSLGDEHIRQIMMIALAHKKE--";
    seqs[counter++] = "------------------------------------ARVFKVLSVESRVRLIELLKQRSLCVNALARSLAITPAAVSQHLRVLRDAEVVIADKQGYHVHYRI--------------------";
    seqs[counter++] = "------------------------------KVAGQAAKLLAAIANARRLVILDIISQQETSVGSLAEQVGLSQSALSQHLAKLRSAKLVNTRRDAQTIYY----------------------";
    seqs[counter++] = "-----------------------------------------VLANANRLLLMCQLSQGEKCVGELEELLDLHQPTLSQQLGVLRSEGLVSTRRDGKKIYYSVADARVLAL------------";
    seqs[counter++] = "------------------------------EKSEQAARCLRAMAHPARLMILQLLSGSEMSVSELEKALDISQSNLSQHLNLMKDKQLLSSRRSGNQVYYSLKDPRLLGL------------";
    seqs[counter++] = "------------------------------------ANVFSLLSDPTRLRIILTLKEGEQPVGMIAEKLGRKPTIISQHLAKMRWGKLVRTRQEGTRIFYSLSDEHVSALVDQAI-------";
    seqs[counter++] = "-------------------------------------DIFKALGDENRLRIINLLSKGKLCVCDIEAILMMTQSNVSRHLNKLKNVGIISSEKKSQWVYY----------------------";
    seqs[counter++] = "-----------------------ELYQVEREELLSKAELLKVLGHPERLAIVLLTMDGERCVKELVEALGISQPKVSQHVGLMKELGILTFRKEGTKVLYRVNDRKVV--------------";
    seqs[counter++] = "-------------------------------------DIFRALGDPTRLRIVHLLRAMELAVGEIAQVVGQSQPRVSRHVRILAEAGLVERRKEGNWVFLRL--------------------";
    seqs[counter++] = "---------------------------------------FHILQSDTRLRILFLLSQKQMCVCELEAGLDVTQSAISHSLSIMKNAGIVGVKREGRFAIYFIHDEEIRKMMQICRKYAEESR";
    seqs[counter++] = "---------------------------------------FGILSDKTRLRILLLLQNRELCVCEIFGALRMSQPRVSRQLAILKQSRIIKDRRSGKWIYYRIEE------------------";
    seqs[counter++] = "--------CPMIYALSRNIVISIFLMNISSAALQEIADFFEVLAVPTRLGILLAIGEREVCVCHLEAVLKLRQAAISQHLQVFKKNGWVISRRQGRFVYYKLSNPSVLPL------------";
    seqs[counter++] = "-----------------------------------MADIFDVVADPTRRDLLRVLPTGEISVSELVQTLGISQPTVSKHLRVLRDSGLVSVREEGQHRYYRLE-------------------";
    seqs[counter++] = "--------------------------------ALSATELFRLLGDETRLRAVVLLRRGELCVCELTETLGVSQPKMSRHLATLRDSGLVETRRSGQWIHYQL--------------------";
    seqs[counter++] = "----------------------------APDAPEQAAKFLKSLGHPDRLKVLCSLVGGEQSVASIEAQVGASQSAVSQHLSRLRSEGLLQARRDGRQVYYSIAD------------------";
    seqs[counter++] = "-----------------------------------------VLGNPDRLLLLCQLSQGEYAVGELETLLGITQPTLSQQLAVLREEQLVSTRREGKQVFYRIDSEAALALMQ----------";
    seqs[counter++] = "---------------------------------------------------------------DLAQVLQMTPSAISHQLRVLKQMKLVTNRREGKTVFYSLADSHIKTIMNQGMEHIRK--";
    seqs[counter++] = "-------------------------------------EVLRVLADPTRLQLAGLLLDEEKSVSDLASQLDRPATGVSQHLAKMRMARLVSTRRRGTSVLYRVENDHVRQLVVDTIGHVE---";
    seqs[counter++] = "------------------------------EVADRLAGIFKQVGDPTRLKIFWLLCQQEECVTNIAYLLDMSSPAISHHLKSLKLADLIESERKGKEMFY----------------------";
    seqs[counter++] = "-------------------------------------DIFKQLSDPTRVRIFWLLSHREECVINIAALLDMSSPAVSHHLRSLTQSGLIESRRCGKEVYYKAGD------------------";
    seqs[counter++] = "-----------------------------------------VFAHPHRLMILSRLLRGECTVGEIDAATGIGQPALSQQLAQLRRAETVRTRREARQIHYSLADAHV---------------";
    seqs[counter++] = "-------------------------QLIGPELSRFKAEFFKALAHPLRIRIVDELRNGEVGVTHLCARLEVEQSSLSQQLAVLRARYIVNARKDGLSVLYSIRDPEIFSL------------";
    seqs[counter++] = "---------------------------------------FHALSDPIRLNILDILNNQEMCVGNICDLLSIKQSKVSFHLKILKESGFVETRQQGRCIYYRL--------------------";
    seqs[counter++] = "------------------------------EVFESTARYFSVLGEPTRLKILHVICHKEKCVNDIIRATGLLQANVSRHLGLMYQAGLLSKRRDGTQIFYRV--------------------";
    seqs[counter++] = "-----------------------------------LADVFRLLGEPNRLRILCAIGSDCKSVSELMSETGIGQSNTSFHLRFLRNAALVNAEPRGRNMYYRVRDKELLKL------------";
    seqs[counter++] = "--------------------------AAAKEELEEIASLLKLLGDKTRLTIFALLKVRELCVCELTELLHVSQPAISQHLRKLKLANLVRERKVGQWVHYSLRQRHIVLLEKSA--------";
    seqs[counter++] = "-------------------------------------ELFRILASQIKLEILSLLLENDLCVCQICAIVGTSQPNISQHLNTLRHLGVVDIRKDGTFIYYSL--------------------";
    seqs[counter++] = "-----------------------EFERICPFMLETFETVAKAVADPSRVRILKLLEGGELCVCQITTVLDLAPATISKHLAALKTAGLVQQRRDGKWVYYRLAERDFNAYARSFLD------";
    seqs[counter++] = "--------------------------------------FLRAISDPNRLKILCVLQGGSKCVCEIVPLVGISDKLASHHLKQLKNVGLLIEKREGKFIRYNL-DKKVIKEYKNV--------";
    seqs[counter++] = "-----------------------------------LSDILHLMGEVNRLKLLIECLKGPKSVSDLAEQLQLSVPLTSHHLSLLRSARLLMANREGKHIYYSIYDAHVRCILEDMLKHFTE--";
    seqs[counter++] = "---------------------------------------FDLLSDPHRLELLSLHRAPGICVSDLAAALGRSENAVSQALRVLRQQGWVSSTRVGRAVSYRLDD------------------";
    seqs[counter++] = "--------------------------------AEEVSELLRILAHPERLMVLCQLTKGEVGVGQLQQSSALSQSAFSQHLTVLRKHGLIEARKESQQVFYSLADTRVAQLIQ----------";
    seqs[counter++] = "--------------IEVEMATDEIMKKNAVEVA----ELLRVMAHPERLMVLCQLTHHEMGVGQLQQGSTLSQSAFSQHLTVLRKHGIIQARKESQQVFYRLADSRITAL------------";
    seqs[counter++] = "-----------------------------------------VLANPDRLKILCVLVDGEMNVQEIEESTDIHQPTLSQQLTVLRKADMVSTRREGKQIFYRLSDPKVLSLMQKLYEALNYC-";
    seqs[counter++] = "------------------------------------AEFFKTLGHPVRIRVLELLGQREHAVSEMLPEVGVEAANLSQQLAVLRRAGLVANRKEGSAVYYSL--------------------";
    seqs[counter++] = "------------------------------------ADLLLVMANAHRLRMLKTLAEREVAVNNLADIIGISQSALSQHLAKLRSRDLVKTRRDAQTIYY----------------------";
    seqs[counter++] = "------------------------------EVFESVARYFSVLGEPTRLRILHALCQEEKCVNEIIKVTALAQANVSRHLGLMYQAGMLSRRREGTQIFYKVAD------------------";
    seqs[counter++] = "------------------------------ETFEKISDLFKQLGDPTRMRIFWILCHHEECVIHISARMDMSSPAVAHHLRLLKTSGLVTSRRQGKETYYRASD------------------";
    seqs[counter++] = "------------------------------------------LSNEKRIRILYLLENHSFNVSELSEQLELPQPSVSHQLALLRQYQLVQAHRDGKQIFYTLDDPHIIEVLNDMLAHVQQ--";
    seqs[counter++] = "--------------------------------------FAKAISDPIRLRILYALREGELCVCELADALELRQSTLSTHLQIIRQAGLVQTRREGRWVYYALE-------------------";
    seqs[counter++] = "-------------------------------------EAFKAIADPTRRKILTLLRTGDLTAGEIASHFDMQKPSVSHHLKILKQADLVQDRREGQYIYYSL--------------------";
    seqs[counter++] = "---------------------------------------FKALGQHLRLRIIALLAEQELCVCELEEILGITQPAISQHLRVLKEADLVWEEKVSQWVFYHLKKEKLAAVLQSWLAYLQ---";
    seqs[counter++] = "-----------------------------PKITGKWEDFFKVLSDETRLRILMLLNQRELCVCEICQILDLPQPKVSRHLAKMRDLDIVRGKKEDQWVFYYL--------------------";
    seqs[counter++] = "------------------------------ELFEEVANYFSLLCEPTRLKILYAVCNGERSVGDIVNEVESTQANVSRQINMLYRAKILARRKEGTQVYYRVDDEKTVDL------------";
    seqs[counter++] = "-------------------------------------EVFSMLADATRIRIILALRDQELSVNHLADIVDKSAPAVSQHLAKLRLARIVSTRQEGTKVFYRLTNEHARQLVADAI-------";
    seqs[counter++] = "-------------------------------------ELLRALASPTRIAIVQSLGSESRCVHELVGELELSQPLVSQHLRVLKDAGVVRGERNGREIMYSLVDHHIVHIVDDALVHATE--";
    seqs[counter++] = "------------------------------ELLENAAATLRMLAEPTRLHLLWQLSQGPKSVTELTEAAAVPRTVVSQHLAKLRLSGMVDGRKNGRQVIYSLHDGHLVRLIRETINH-----";
    seqs[counter++] = "-------------------------------------EILKALSDENRLRILNLLRWGKLCVGEIQSILGITQSNASRHLNKLKGVGIIKFEKDAQWVHYKL--------------------";
    seqs[counter++] = "------------------------------------------LSDPARLQMLWALSTEDLSLSDLAQLVGVSSTVASQLLSRLRTAGVLQTRKSGRHVIYSMHD------------------";
    seqs[counter++] = "--------------------------------AEKTARMFKVLSVGSRVRMVELLKERSLCVNALARTLGITAAAVSQHLRVLRDAGLVCPEKHGYYVHYRI--------------------";
    seqs[counter++] = "---------------------------------ERLAEIFKALGHPTRVKIVEYLADGEKCVKDIWQEIGVPQPTVSQHINILKNAGIISFRKDG---------------------------";
    seqs[counter++] = "------------------------MENLTPEAMEQVAAYFRALSEPTRLAILNLLREGERNVGELAQLCSCSPANVSRHLSLLSQHGLVRREGRGTAVYYRIADDSVYAL------------";
    seqs[counter++] = "------------------------------EKASDISKAFRHLGDPKRLQIFWLLCHRKECVINIAAIMGMSSPAISHHLKILKTAGLISSKREGKEMFYKAND------------------";
    seqs[counter++] = "---------------------------------ENLSPLFHALADPNRLRIIELLRQEDLTVGSIAERLDISQPQTSKQLRVLYDAGLVS--------------------------------";
    seqs[counter++] = "-------------------------------------ELLRALSAPIRLAIVSQLAEGERCVHELVNQLGAAQPLVSQHLRVLRGAGVVRGSRRGREIAYTLVDEHVAHIVADAVSHASE--";
    seqs[counter++] = "-------------------------------------ELLKIMAHPERMMVLCQLIEGEVAVAQLQQASLLSQSALSQHLALLRRQRLISARKRSQQVFYSLADQRVQQLI-ASLQHIASC-";
    seqs[counter++] = "-----------------------------PEVFDRIAERLRILAHPHRLRMVEMLLAGKYSVGELAESCSIPSHMASEHLRLMQHCGLLGSEKEGRYTYYRI--------------------";
    seqs[counter++] = "------------------------------------------LSDQNRLRVLSLLDGNELTVKEMLEILQLSQSTLSSQLSQLKDSGLVQSRRDGQYVFYKLPRQYETQMVSNPID------";
    seqs[counter++] = "------------------------------------AELLRQLANTNRLLILCHIAAEERSVGQLEADLGIKQPALSQQLAELRQYGLVKTRRQSRSIYYSIAD------------------";
    seqs[counter++] = "------------------------------------------LSDETRMRILNLLEKGEMCVCEMEEILDISQSNASRHLTKLTNAEIINYNKVSKYVYYKI--------------------";
    seqs[counter++] = "--------------------------------------------------LLYQLKDGERCVGELV-VDGNKLSTVSARLQTLLNANLVKRRRDARHLYYRLADQHVVQLIDNALAHVDE--";
    seqs[counter++] = "--------------------------------AEEVAELLRVMAHPERLMVLCQLTQSEMGVGQLQQGSTLSQSAFSQHLTVLRKHGIIQARKESQQVFYRLADSRI---------------";
    seqs[counter++] = "---------------------------------REMAELLGVLSHPCRVQIVEELRDSERNVNALQELLGISHSGVSQHLALLRTRKLLKERRSGRHVYYRL--------------------";
    seqs[counter++] = "---------------------------------------FALLADPLRLRIVEALSREQLCTCHLVDITGARQTTISNHLRLLREAGVVASEPEGRYTWYRL--------------------";
    seqs[counter++] = "-------------------------------------EILKALADETRIRILNLLYRETLCVCDLEEILKLSQSNASRHITKLKQAKLIAGEKQAQWIYYQV--------------------";
    seqs[counter++] = "---------------------------------RNLVKFFAALADPTRLRLLNMMAGGEVCVCHFQGVLQTNQPKISRHLAYLKKAGLVEARRDGKWMHYRL--------------------";
    seqs[counter++] = "---------------------------------------FKALGDEKRLRILSLLRQGERCACVLLEHLNLSQPTLSHHMKILCEARLVTGRKEGKWVYYSL--------------------";
    seqs[counter++] = "-------------------------------------KLFKALAHPTRIQILNLLQEGELCVCEIYEALELSQSNISQHLKVLRDQNLVESQKVGVEVHYKIKN------------------";
    seqs[counter++] = "------------------------------------AEILSLLADRTRLALLRRLSLGEADVTTLTRACGVARPAVSQHLARLRLAGLVTTRKEGRRVVYALRHGHLRRLIDEALN------";
    seqs[counter++] = "-------------------------------------EIFKALSDKNRLLILDMISCGELCACDIMDVLNLTQPTISHHMKVLQKCELVDARKEGKWVFY----------------------";
    seqs[counter++] = "-------------------------------------EVFRMLADATRVQVLWSLADREMSVNELAEQVGKPAPSVSQHLAKLRMARLVRTRRDGTTIFYRLENEHVRQLVIDAVE------";
    seqs[counter++] = "---------------------------------------FKLLGNETRLNILLLLEKQPQTVSELVSALHLKQSNVSHQLAQLKHHQLIASTRRGKNLLYSLRDPHVITMIETTYEH-----";
    seqs[counter++] = "---------------------------------------FKALADENRIRILNLLKNGKLCVCDIEAVLGIKQSNTSRHLNKLKMAGIIVSEKKSQWVYYRLND------------------";
    seqs[counter++] = "-------------------------------VYQLISEIFKTLAHPLRIQILMMLSEKERCVCELLNEIGVEQSNLSQHLRILKKQGIIDSRKDGQKMFYRI--------------------";
    seqs[counter++] = "-----------------------ELPEMSSEQLARLASLFRLLGDEGRLKLVMACIDAPQPVCCLSEISGMSQPLTSHHLRGLREARILKSSRRGKQVLYELDDHHI---------------";
    seqs[counter++] = "------------------------------DMAQEQVTILKALADPNRLAIIQHLTEGEACVCELLQLFSVTQPTLSHHMRILSDADLVKGRREGKWIHY----------------------";
    seqs[counter++] = "-------------------------------------DIFKALADENRIKIIKMLACCDMCVCDICGNLNLSQPAVSHHLKILSDSGLLNTTRKGKWIYYSL--------------------";
    seqs[counter++] = "-------------------------------------DLFKALSDPTRRKILELLKEKDMSAGEIAEYFDISKPSISHHLNILKNAKLVLWEKDGQNIIY----------------------";
    seqs[counter++] = "-------------------------------------KIFKILGSETRLNILLLLEKKDMTVTDLFNELEVSQPAISKQLAILKEYKIISYDKKGVENIYKLNDLHILNVINSTMGH-----";
    seqs[counter++] = "---------------------------MAEQVFAQVASYFGLLADPTRLRILSCLCGEERPVHDVVERIGLTQANISRHLNILYRAGVVDRRREGSSVLYKVVD------------------";
    seqs[counter++] = "------------------------------------AECLKALASPVRLKILFTLKDKPMCVTDLEQELGISQSSLSQHLRTLRYKGIVAKTRKGNKVYY----------------------";
    seqs[counter++] = "------------------------------------ATLFKALAEPIRLRILALLKDGELCVCDLTETLALPQSTVSRHLAVLRTAGWIRGRKGGSWTYYSL--------------------";
    seqs[counter++] = "------------------------------------ADLFKALADPMRLRILALLRTREACVCELAGLLPITQPAVSQHLRKLRQAGLIHERRHKYWTYY----------------------";
    seqs[counter++] = "------------------------------------ADFFKALAHPLRIRILEVLSEGERNVNELQTALGSEGSAVSQQLAVLRAKNLVNSFKEGTTVVYSLRD------------------";
    seqs[counter++] = "-----------------------------PDRAGRIAEVLKAVAHPLRLRIVASLCREELNVSALAERLGASQAIVSQQLRILRSLGLVA--------------------------------";
    seqs[counter++] = "-----------------------------------------------------VLKRRALCVTELTSQLGISQSATSQHLRVLKDARIVKFQKRGLHVYYHL--------------------";
    seqs[counter++] = "-----------------------------------LTNFLKIISDKNRLIILYLLSRNILCVCDIQKLIPLTQGALSIQLKNLMSAGLLESFKQGKWVFYKL--------------------";
    seqs[counter++] = "-----------------------DMQMMMKDNANKASSLLKAISHESRLLILCLLLRREMTVGELAEYSSLSQSAFSQHLSVLRNNGLVKCRKEAQNVYYSIND------------------";
    seqs[counter++] = "--------------------------------------FFEAFSNKNRFEILMQLRNKELCAGELQQKLKIEQTNLSHDLKCLLNCRFISVRKDGR--------------------------";
    seqs[counter++] = "-----------------------------------------ILANEDRLLLLCQLSQGEKAVGELEDALGIHQPTLSQQLGVLRSDGLVNTRREGKRIFYSIADDKVLAL------------";
    seqs[counter++] = "-------------------------------------------ADANRLRILACLKKGEVCVCDFTDFLNISQPAVSQHLRKLKEAGIITERKVGTWKHYRIQE------------------";
    seqs[counter++] = "-----------------------------------LSNIFKALNDPIRVKILFALLEYEICVGEMVNLLQIPQSHVSHQLRILRKYGIVEFTKDKKMSFYYIKNEYIKTL------------";
    seqs[counter++] = "---------------------------------------FDMLSAPNRLHLVWLLATGEFDVSTLAELSGSNVPAASQHLAKLRAAGIVTARRDGRRQLYRVEDPHIVTVIEQMFSHI----";
    seqs[counter++] = "--------------------KAKEAQLLSMEILEQAAECLRTLAHPHRLRIVQILLDHEESVGELARACELPSHMVSEHLRLLKDRGFLESRRDGRKVFY----------------------";
    seqs[counter++] = "-------------------------------------EIFKALGDENRIRILNLLIRQELCVCEIETVLDMTQSNASRHLNKLKTSGIITSEKKSQWVYYRV--------------------";
    seqs[counter++] = "------------------------------EVEQYIDRFLDTVCDTRRRAIVELLAISEMRSGDIARAIGLSAATTSEHLRQLAQTGLLTSRRQGNTVYYSLCNHKLVQAFRDLLEAL----";
    seqs[counter++] = "------------------------------EMMEATARVLKLLGDPTRLTILAILQKRECCVCELMEVFSSSQPAISQHLRKLKDAGLLQEERRGQWVYYSL--------------------";
    seqs[counter++] = "------------------------------------AELLAVLGNERRLVILGHLTEGEISVGELAVLVGLSKSALSQHLSKLRKHQLVSTRRHRQTVYY----------------------";
    seqs[counter++] = "-------------------------------------ELIRVLGDPLRLKIVTLLARETLCTSHLVEETGARQTNLSNHLRVLREAGVVETEPCGRFTYYKLRPDVIAAL------------";
    seqs[counter++] = "------------------------VSAFTEQFARKASDLLKAMSHETRLVILCLLSEKERSVGDIESILSMPQAAVSQQLARLRFDRLVKTRREGRTVYYSLASEEVTSL------------";
    seqs[counter++] = "------------------------------------ADLFKIMGDRSRLSMVAMMNRRECCVCDFTECFGMSQPAVSQHLKKLRAMGLIKERKEG---------------------------";
    seqs[counter++] = "--------------------------------SQEAAKVMQLLSHPDRLLILCLLSEKEYSVGEIEKQLDIHQPMLSQHLNRLRQQSLVATRREGKYIYYQLCD------------------";
    seqs[counter++] = "--------------------------------ASAAAELLKLVANPNRLRILYLLTEGERSVSEIEQRLGIRQPTLSQQLGELRNAGTVTTRRAHKVVFYSL--------------------";
    seqs[counter++] = "--------------------------------------FFKALADDSRLKIVGILANQECSVEELAVLLQLKEPTVSHHLAKLKELNLVTMRPEGNSRLYQL--------------------";
    seqs[counter++] = "------------------------------------ASILKALGHPIRLKILYLLSEKEHCVCELLSQINTSQPNLSQHLSILRNLKLIKDERNGNMVIYKLQDNKIV--------------";
    seqs[counter++] = "-------------------------------------------------------------VGELTEEVGVSQSLVSQHLRLLRAGRLLKQTRSGRNVFYALPDCHVRTMLTNMMDHVLE--";
    seqs[counter++] = "------------------------------------------LASSNRLELLEALAQGERSVDALAQATGMSVANTSHHLQILRDSGLAESRKEGLQVIYRLSDDQIPVL------------";
    seqs[counter++] = "---------------------------------QKLIKFFHALSDETRLKIIKLLEKSELCVCEIVAALDMVQPKVSFHLGVLKEAGLVKIKRKGKWILYSLDD------------------";
    seqs[counter++] = "--------------------------------AEVASELMKILSNENRLMILCQLVDGEKSVGELVELLDLNQPTVSQQLSRMKNQGLVSYRKNAQTVYYSL--------------------";
    seqs[counter++] = "-----------------------------------------LLGDKTRLTILSYLKDQELCVCELVDLLDISQPAISQHLKKLRVAEIIRERKQGTWVYYSL--------------------";
    seqs[counter++] = "------------------------------------------LADSTRLKILNLLSRQEMAVCELIEALDLSQPAVSHHLKLLKQACLITDSREGKWVLY----------------------";
    seqs[counter++] = "----------------------------------------------------------------MATEVGMEQSACSHQLRLLRNLGLVVGTRKGRSVVYSLYDNHVAELLDQAIYHIPVC-";
    seqs[counter++] = "--------------------------------------FLKVLGNPLRLQILKILSHVDMCVCAISEILGQQQTLVSHHLSKLKSARIVEERQNGKYRIYSIKDKRVKSL------------";
    seqs[counter++] = "--------------------------------AERLADRLRPLAQPQRLMILSLLLAGEHTVGEIETRTGIGQPALSQQLAELRRSGLVTTRRAARQVHYRIAD------------------";
    seqs[counter++] = "-------------------------------------DFLKLLADETRLKIIMMLSQRDMCVCEIMDELAMSQPAVSHHLRILKKSGIVRDDKDGRWVFYSL--------------------";
    seqs[counter++] = "--------------------KTRELELSIPGVSDTLAKFFRAIADPNRLLLLEFLVSCEHTGNECVAHVRLAQSRVSSHLQCLVNCGFVRVRREGHFAYYRVVDERVIDL------------";
    seqs[counter++] = "------------------------------------------LADKNRLKIIQYLSTGQRNVSEVADRLNVEENLASHHLRVLASLGFLKNDKKGREVYYRINETRFVALLKDLL-------";
    seqs[counter++] = "---------------------SHELAAAAPGI-EAMAAVLALAGNEVRLKMLFLLLDQQLCVCDLADVLQMNVSAISQHLRKLKDGGVIQARKVGQTVFYSL--------------------";
    seqs[counter++] = "------------------------------------------LADPTRMRMLWLISGEEYDVASLAAAVDIARPAVSQHLAKLKLAGLVTQRRDGRRILYRARGGHVLAEVMNAADH-----";
    seqs[counter++] = "--------------------------------AREVSRLLSVLANENRLLIVCLMMRSEMKVGELVDALHLSQSALSQHLTKLREEGLVEFRRESQTLHYKIADERVTKL------------";
    seqs[counter++] = "-----------------------------------LTNIFKVLSDENRLRMIVLLYQEELCVCELSGILNVPQPRISQNLSRLRDLNLVDDERKEKFVFYSL--------------------";
    seqs[counter++] = "------------------------------------AEILRILSHPERLLVLCQLMEGELGAGQLQNSSTLSQSAFSQHLTVLRKHNLVKVRKESQQVFYSLADERIAALIHN---------";
    seqs[counter++] = "------------------------------------------MGNPQRLRILLLLAEHERSVIELEALVGLSQSAVSQHLARLRQIKLVRFRRDGQMTFYAL--------------------";
    seqs[counter++] = "-----------------------------PIYAQ-LARVGKALASPIRLRLLDLLDGAELTVEELSEQAGVPLKNTSAQLQQLRAANLVATRKEGTRVHYRLAD------------------";
    seqs[counter++] = "---------------------------MATDALDQVSHLFKLMGHPKRLQLLYLLIQQSMTVSQISERLKWEQSAVSHQLQVLRKYQIVERVKNGRQVVYRLVD------------------";
    seqs[counter++] = "------------------------------------------LADSTRVQVLWALVDRELSVNDLAEHVGKPAPSVSQHLAKLRMARLVRTRKEGTQVIYRLENDHVRQLVTDAVN------";
    seqs[counter++] = "------------------------------------AEFFKTLGHPVRIRVLELLSEREHAVSEMLNEVGVEAAHLSQQLAVLRRAGLVTARREGSAVHYTLAD------------------";
    seqs[counter++] = "------------------------------------------LADENRLRILRALVGTEKPVSKLVEELGISQPLVSHHLKELRRALLVSVERRGPFVYCRLAD------------------";
    seqs[counter++] = "--------------------------------AEHVAEMLKLMAHPHRLMILCLLVESEHNVGELVEALDINQTALSNHLSKLRSAGLIDYTRYHRVLQYRL--------------------";
    seqs[counter++] = "---------------------------IVPVVFQGAADLFAALSCPTRLRIVCALSQADHTVRDLARASQCSQANVSGHLRLLRRANIVRCERSGNYVLYHL--------------------";
    seqs[counter++] = "------------------------------EVFEEVANYFSLLCEPTRLKILYAVCNGERSVGDIVAQVESTQANVSRQLAMLYRAKILARRKEGTLVFYRVDD------------------";
    seqs[counter++] = "---------------------------------RQLADVGGALSNPHRLKMISLLAQGDKPIDELAKLTNQSLAAASANVKVLRNCHLIATEKRGRSVYCSLKDPRVAELW-----------";
    seqs[counter++] = "-------------------------------------ELLRALSAPIRLAIVSELAEGERCVHELVDKLGAPQPLVSQHLRVLRSAGVVRGSRRGREIAYTLVDEHVAHIVTDAVSH-----";
    seqs[counter++] = "-------------------------------------------AHPLRLKILCVLGEGEACVQDIVEAVGTSQSNISQHLAILRDKGVLQTRKDANRVYYRVGDQRTLQL------------";
    seqs[counter++] = "-----------------------------------------VAAEPTRRRLLQLLAPGERTVTQLASQFTVTRSAISQHLGMLAEAGLVTARKQGRERYYRL--------------------";
    seqs[counter++] = "-----------------------------------------VAAEPTRRRLLQLLAPGERTVTQLASQFTVTRSAISQHLGMLAEAGLVTARKQGRERYYRL--------------------";
    seqs[counter++] = "-------------------------------------EMLKILSDTNRLRILNLLYIQELCVCELEYLLTISQSNLSKHLRLMGEIGFLDSRRQNKFIYYKI--------------------";
    seqs[counter++] = "------------------------------------AESFRLLADPTRIKVLWALLQGESSVACLAELAGAAPTXXSXHXXKLRLAGLVTGRREGTFVYYSAVNNHVRGLLAQALFH-----";
    seqs[counter++] = "--------------------------------AEATATLFA-LANQNRLLLLCQLCNGEMSVSALEEALGIHQPTLSQQLGVLRSEGLIASRREGKRIYYSVANPKVLVLINTLVD------";
    seqs[counter++] = "------------------------------EILDAAGELLRALAAPVRIAIVLQLRESQRCVHELVDALHVPQPLVSQHLKILKAAGVVTGERSGREVLYRLADHHLAHIVLDAVAH-----";
    seqs[counter++] = "---------------------------------QDLLKVFYALSDSVRLGIVSLLECEELCVCQITQAFGLSQPNASFHLRVLREANLVLWEKRGKWTYYKINHH-----------------";
    seqs[counter++] = "---------------------------------------FKALGEPSRLKIIKLLSQQSMCVCELSEVLDMSQPRVSQHLRTLKEVDLVYEERQGFWTYYKL--------------------";
    seqs[counter++] = "---------------------------------------FKALSDQTRLRMVTLLSRREYCNCEFVSIFGISQPAISRHIARLKEARLIHERRPGQWIYYSL--------------------";
    seqs[counter++] = "---------------------------------------FKALADSNRLRILDYLKKGKSCACDLSDNLGIPQTALSYHMRILCQAKLVKSEQVGKWKHYQLND------------------";
    seqs[counter++] = "-----------------------ELEAKAEDAAQ----FLKMIASPPRLLLLCHMAERECSVGELAERTGMRMPTVSQQLSLLRAQGLVNTRRDGTTIYYRL--------------------";
    seqs[counter++] = "-------------------------------------KIFSALSDKNRLRIYLLLTQAELCVCELVNILDMEQSRISHSLRILKEAKLINNHRVGK--------------------------";
    seqs[counter++] = "-----------------------------PESLRSIASLLKALSDPLRLQVLEQLSTGERCVCDLTSSLALSQSRLSFHLKVMKEAGLLSDRQSGRWVYYRIRPESLNAL------------";
    seqs[counter++] = "------------------------------------AKLFRGFADPSRLAILEVLRSAPATVGEIAASTGQGLSNVSNHLRCLRDCGLVVRQRDGQRVRYSLSDQRVAAL------------";
    seqs[counter++] = "--------------------------AMAGNVEQA-EQLLKVLANKNRLMILCSLQDSEMSVSQLNEAVPLAQSALSQHLAALRKANIVATRRESQTIYYRVIDENAVVL------------";
    seqs[counter++] = "-------------------------------------------ADTLRVQVLSLLHKNSFSVGELVEILGVRQSALSHHLKVLAQAELVATRREGNSIFY----------------------";
    seqs[counter++] = "----------------------------AAQVFERAAELFGLLSSPLRLRIVGELCRGELNVGQLQERIGATQSNMSQHLSVLYRAGVVARRRDGAQVHYRI--------------------";
    seqs[counter++] = "----------------------------------ALLRWLKALSDDTRLRLLHLLSRYELSVGEVVQVLGMSQPRVSRHLKILADAGMVQVRRDGLWAFYSATSH-----------------";
    seqs[counter++] = "-----------------------DMQDIAAQLQELHARVCKAIADPKRLLIINELRDRELSVGELCEATGLSQSNASQHLTILRERGIVTTRRVKNNVFYSLRSQKIV----QAVDLLRE--";
    seqs[counter++] = "---------------------------------------FRALSDRTRLRILNLLRGGELCVCDLVDVLDVPQPTASRHLAYLRNAGLVLARKEGLWHYYRL--------------------";
    seqs[counter++] = "------------------------------------AAYFQALAEPTRLQILNFLRQQERNVGELAQLCGYSSANISRHLALLTQHGLVSRQARGNSAYYRIAD------------------";
    seqs[counter++] = "-------------------------------------DMFKAMADPTRRRILQLLSEKNLSAGEIAEEFTMSKPAISKHLDILKTSELITCEKQGQYVIYAINTSAVEQMYCRFLD------";
    seqs[counter++] = "--------------------------------AHEASDLLKALAHQTRLLILCILANEERTVGEIENILGIQQAMVSQQLARLRLEGLVHTRRQGRLVYYSIGNVSVLAFLESLFD------";
    seqs[counter++] = "--------------------------------------------DPLRLNVLRALANDSFGVLELAQIFGIGQSGMSHHLKVLAQADLVATRREGNAIFYRRALPHLNAVKDGALDH-----";
    seqs[counter++] = "------------------------------EMTPDIVSFLKTISEENRLKILCFLRDWEKCVCEIVEFLKIPQNLVSHHLRKLKDARILSARKDGMNVRYSINEDEI---------------";
    seqs[counter++] = "----------------------------AEPVFDRLAQVLDLAGNANRLKIIYLLEESNLCVCDLSDILGMSIPAVSQHLRKLKDAQLIQARKVGQTVFYSL--------------------";
    seqs[counter++] = "--------------------------------ASAAARLMKLMANEQRLILMCRLGEGECSVGDLAAHVGLAQSAASQHLAKLRAEGVVATRRDGQTIYYRLED------------------";
    seqs[counter++] = "------------------------------ENATEVAGILKQLSNPYRLMILCCLSENELTVGDLNQRIDLSQSALSQHLAKLRESNIVTTRRESQTIFYRI--------------------";
    seqs[counter++] = "-----------------------------------------VLSNPDRLKILCVLIDGELNVQQIEKTAQVYQPTLSQQLTILRKSKMVSTRREGKQIFYQFSDMRILQIMQTLYD------";
    seqs[counter++] = "---------------------------------------FHSLSDATRLAIVLRLARGEARVADLVGELGLAQSTVSAHVACLRDCQLVAGRPEGRQIFYRLARRELIDLLASALE------";
    seqs[counter++] = "-----------------------------------MAKFYRALGDPTRLDLLEFCAEDERTGNECVERAGLSQGRVSAHLACLVSCGLVSVRRQGRFAYYRVTDPRVAEL------------";
    seqs[counter++] = "---------------------------IETEISPELTNFIKVLSNPIRAGIIKMLKKRWMCVCLIAKALNQDQTLISHHLRTLKNMNLLHERREGK--------------------------";
    seqs[counter++] = "------------------------------------AQVFKALGNPVRMALVQELLAGERCVCDLAQALGGNMPAVSKHLATLREAGIVSCRREGTTIHYSL--------------------";
    seqs[counter++] = "------------------------------------AKLMEMLSQPVRLRILCILLDGEQSVLKLADMAGLSQPAMSHHLRKLRDADLVNTRRDAQTIYYSLKGQEVSAV------------";
    seqs[counter++] = "------------------------------------------LGSSNRLMLVCQLLDGERAVGELAEALGLAQSVVSQHLSLLRRDGLVTGRRDGQSIYYAISDDRVHAL------------";
    seqs[counter++] = "----------------------------------------AVLANINRLLLMCQLSQGEKCVGELEELLDLHQPTLSQQLGVLRGAGLVNTRRDGKKIHYSVADARVLTL------------";
    seqs[counter++] = "---------------------------------QTLLGFFQALADANRLRIVGVLAQGPQTVEQISALLGLGMSTTSHHLRKLAKAGLVEARADGHYSVYSLRTQTLEELAKNLL-------";
    seqs[counter++] = "-------------------------------------DLFKCIGNPTRYKILKVLCERPLCVNKLNEAVGYSQPNISQHLKLMRMSGIVTCSKNGMNICYQIADDDIIKLLELAEDILKNRR";
    char ** seqsCpy = new char*[counter];
    for (int k = 0; k < counter; ++k) {
        seqsCpy[k] = MultipleAlignment::initX(122);
        for (int pos = 0; pos < 122; ++pos) {
//            seqs[k][pos] = (seqs[k][pos] == '-') ? MultipleAlignment::GAP : subMat.aa2int[(int) seqs[k][pos]];
            seqsCpy[k][pos] = (seqs[k][pos] == '-') ? MultipleAlignment::GAP : subMat.aa2int[(int) seqs[k][pos]];
        }
    }

    MultipleAlignment::MSAResult res(122, 122, counter, seqsCpy);
    MultipleAlignment::print(res, &subMat);

    MsaFilter msaFilter(10000, counter, &subMat, par.gapOpen, par.gapExtend);
    size_t filterSetSize = res.setSize;
    msaFilter.filter(res.setSize, res.centerLength, 0, 0, -20.0f, 90, 100,
                     (const char**)res.msaSequence, &filterSetSize);
    msaFilter.shuffleSequences((const char**)res.msaSequence, res.setSize);
    std::cout << "Filtered:" << filterSetSize << std::endl;
//    for(size_t k = 0; k < res.setSize; k++){
//        std::cout << "k=" << k << "\t" << (int)filterResult.keep[k] << std::endl;
//    }
    std::cout <<"Filtered MSA" << std::endl;
    for(size_t k = 0; k < filterSetSize; k++){
        printf("k=%.3zu ", k);
        for (size_t pos = 0; pos < res.centerLength; pos++) {
            char aa = res.msaSequence[k][pos];
            printf("%c", (aa < MultipleAlignment::NAA) ? subMat.int2aa[(int) aa] : '-');
        }
        printf("\n");
    }

    //seqSet.push_back(s5);
    PSSMCalculator pssm(&subMat, 122, counter, 1.0, 1.5);
    pssm.computePSSMFromMSA(filterSetSize, res.centerLength, (const char**) res.msaSequence, false);
    //pssm.printProfile(res.centerLength);
    pssm.printPSSM(res.centerLength);
    for (int k = 0; k < counter; ++k) {
        free(seqsCpy[k]);
    }
    delete [] seqsCpy;
    return 0;
}

//PQITLWQRPLVTIKIGGQLKEALLDTGADDTVLEEMSLPGRWKPKMIGGIGGFIKVRQYDQILIEICGHKAIGTVLVGPTPVNIIGRNLLTQIGCTLNF
//                     ALLDTGADDTVISEEDWPTDWPVMEAANPQIHGIGGGIPVRKSRDMIELGVINRDGSLERPLLLFPLVAMTPVNILGRDCLQGLGLRLTNL
