# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1NodeStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'capacity': 'str',
            'phase': 'str',
            'conditions': 'list[V1NodeCondition]',
            'addresses': 'list[V1NodeAddress]',
            'node_info': 'V1NodeSystemInfo'
        }

        self.attribute_map = {
            'capacity': 'capacity',
            'phase': 'phase',
            'conditions': 'conditions',
            'addresses': 'addresses',
            'node_info': 'nodeInfo'
        }

        self._capacity = None
        self._phase = None
        self._conditions = None
        self._addresses = None
        self._node_info = None

    @property
    def capacity(self):
        """
        Gets the capacity of this V1NodeStatus.
        compute resource capacity of the node; see http://releases.k8s.io/v1.0.4/docs/compute_resources.md

        :return: The capacity of this V1NodeStatus.
        :rtype: str
        """
        return self._capacity

    @capacity.setter
    def capacity(self, capacity):
        """
        Sets the capacity of this V1NodeStatus.
        compute resource capacity of the node; see http://releases.k8s.io/v1.0.4/docs/compute_resources.md

        :param capacity: The capacity of this V1NodeStatus.
        :type: str
        """
        self._capacity = capacity

    @property
    def phase(self):
        """
        Gets the phase of this V1NodeStatus.
        most recently observed lifecycle phase of the node; see http://releases.k8s.io/v1.0.4/docs/node.md#node-phase

        :return: The phase of this V1NodeStatus.
        :rtype: str
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """
        Sets the phase of this V1NodeStatus.
        most recently observed lifecycle phase of the node; see http://releases.k8s.io/v1.0.4/docs/node.md#node-phase

        :param phase: The phase of this V1NodeStatus.
        :type: str
        """
        self._phase = phase

    @property
    def conditions(self):
        """
        Gets the conditions of this V1NodeStatus.
        list of node conditions observed; see http://releases.k8s.io/v1.0.4/docs/node.md#node-condition

        :return: The conditions of this V1NodeStatus.
        :rtype: list[V1NodeCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """
        Sets the conditions of this V1NodeStatus.
        list of node conditions observed; see http://releases.k8s.io/v1.0.4/docs/node.md#node-condition

        :param conditions: The conditions of this V1NodeStatus.
        :type: list[V1NodeCondition]
        """
        self._conditions = conditions

    @property
    def addresses(self):
        """
        Gets the addresses of this V1NodeStatus.
        list of addresses reachable to the node; see http://releases.k8s.io/v1.0.4/docs/node.md#node-addresses

        :return: The addresses of this V1NodeStatus.
        :rtype: list[V1NodeAddress]
        """
        return self._addresses

    @addresses.setter
    def addresses(self, addresses):
        """
        Sets the addresses of this V1NodeStatus.
        list of addresses reachable to the node; see http://releases.k8s.io/v1.0.4/docs/node.md#node-addresses

        :param addresses: The addresses of this V1NodeStatus.
        :type: list[V1NodeAddress]
        """
        self._addresses = addresses

    @property
    def node_info(self):
        """
        Gets the node_info of this V1NodeStatus.
        set of ids/uuids to uniquely identify the node; see http://releases.k8s.io/v1.0.4/docs/node.md#node-info

        :return: The node_info of this V1NodeStatus.
        :rtype: V1NodeSystemInfo
        """
        return self._node_info

    @node_info.setter
    def node_info(self, node_info):
        """
        Sets the node_info of this V1NodeStatus.
        set of ids/uuids to uniquely identify the node; see http://releases.k8s.io/v1.0.4/docs/node.md#node-info

        :param node_info: The node_info of this V1NodeStatus.
        :type: V1NodeSystemInfo
        """
        self._node_info = node_info

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
