
if(NOT LIBUSB3380_FOUND)
  if(NOT WIN32)
    include(FindPkgConfig)
    pkg_check_modules (LIBUSB3380_PKG libusb3380)
  endif(NOT WIN32)

  find_path(LIBUSB3380_INCLUDE_DIRS NAMES libusb3380.h
    PATHS
    ${LIBUSB3380_PKG_INCLUDE_DIRS}
    /usr/include
    /usr/local/include
  )

  find_library(LIBUSB3380_LIBRARIES NAMES usb3380
    PATHS
    ${LIBUSB3380_PKG_LIBRARY_DIRS}
    /usr/lib
    /usr/local/lib
  )

if(LIBUSB3380_INCLUDE_DIRS AND LIBUSB3380_LIBRARIES)
  set(LIBUSB3380_FOUND TRUE CACHE INTERNAL "libusb3380 found")
  message(STATUS "Found libusb3380: ${LIBUSB3380_INCLUDE_DIRS}, ${LIBUSB3380_LIBRARIES}")
else(LIBUSB3380_INCLUDE_DIRS AND LIBUSB3380_LIBRARIES)
  set(LIBUSB3380_FOUND FALSE CACHE INTERNAL "libusb3380 found")
  message(STATUS "libusb3380 not found.")
endif(LIBUSB3380_INCLUDE_DIRS AND LIBUSB3380_LIBRARIES)

mark_as_advanced(LIBUSB3380_LIBRARIES LIBUSB3380_INCLUDE_DIRS)

endif(NOT LIBUSB3380_FOUND)
