/*
 * @(#)ITestRecordUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1.itf;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the ITestRecord interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     July 14, 2002
 * @version   $Date: 2003/02/10 22:52:06 $
 */
public class ITestRecordUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ITestRecordUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public ITestRecordUTestI( String name, ImplFactory f )
    {
        super( name, ITestRecord.class, f );
    }

    
    public ITestRecord createITestRecord()
    {
        return (ITestRecord)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testGetTestName1()
    {
        ITestRecord tr = createITestRecord();
        String name = tr.getTestName();
    }
    
    
    public void testGetTestSuite1()
    {
        ITestRecord tr = createITestRecord();
        String name = tr.getTestSuite();
    }
    
    
    public void testGetLog1()
    {
        ITestRecord tr = createITestRecord();
        String log = tr.getLog();
    }
    
    
    public void testGetTestCount1()
    {
        ITestRecord tr = createITestRecord();
        int count = tr.getTestCount();
        assertTrue(
            "Not valid count "+count+".",
            count >= 0 );
    }
    
    
    public void testGetRuntime1()
    {
        ITestRecord tr = createITestRecord();
        long time = tr.getRuntime();
        assertTrue(
            "Not valid runtime "+time+".",
            time >= 0L );
    }
    
    
    public void testGetFailures1()
    {
        ITestRecord tr = createITestRecord();
        String f[] = tr.getFailures();
        assertNotNull(
            "Returned null failure list.",
            f );
        for (int i = 0; i < f.length; ++i)
        {
            assertNotNull(
                "Returned null failure at index "+i+".",
                f[i] );
            assertTrue(
                "Returned empty failure string at index "+i+".",
                f[i].length() > 0 );
        }
    }
    
    
    public void testGetErrors1()
    {
        ITestRecord tr = createITestRecord();
        String e[] = tr.getErrors();
        assertNotNull(
            "Returned null failure list.",
            e );
        for (int i = 0; i < e.length; ++i)
        {
            assertNotNull(
                "Returned null failure at index "+i+".",
                e[i] );
            assertTrue(
                "Returned empty failure string at index "+i+".",
                e[i].length() > 0 );
        }
    }
    
    
    public void testCombo1()
    {
        ITestRecord tr = createITestRecord();
        int count = tr.getTestCount();
        String e[] = tr.getErrors();
        String f[] = tr.getFailures();
        
        assertTrue(
            "Test Count ("+count+
            ") is less than the number of errors ("+e.length+
            ") and failures ("+f.length+").",
            count >= e.length + f.length );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

