package tests::functional::ReportsWithoutWarningsTest;

use strict;

use base qw/Lire::Test::FunctionalTestCase/;
use Lire::Config::Build qw/ac_info/;
use File::Basename qw/dirname/;
use Cwd 'realpath';
use Carp;

sub suite {
    my $suite =
      Test::Unit::TestSuite->empty_new( 'ReportsWithoutWarnings Test Suite' );

    my $logsdir = $ENV{'LR_TEST_LOGS_DIR'};
    my $reportsdir = $ENV{'LR_TEST_REPORTS_DIR'};

    croak "non-existent 'LR_TEST_LOGS_DIR': $logsdir"
      if defined $logsdir && ! -d $logsdir;

    croak "non-existent 'LR_TEST_REPORTS_DIR': $reportsdir"
      if defined $reportsdir && ! ( -d $reportsdir && -w $reportsdir );

    return $suite
      unless defined $logsdir;

    opendir DIR, $logsdir
      or die "opendir( '$logsdir' ) failed: $!\n";
    while ( my $file = readdir DIR ) {
        next unless $file =~ /^(\w+)(-.*?)?\.log(\.gz|\.bz2)?$/;

        $suite->add_test( new tests::functional::ReportsWithoutWarningsTest( $1, $logsdir, $file, $reportsdir ) );

    }
    closedir DIR;

    return $suite;
}


sub new {
    my $self = shift->SUPER::new(@_);

    my ( $service, $logsdir, $logfile, $reportsdir ) = @_;

    $self->{'service'} = $service;
    $self->{'logfile'} = $logsdir . "/" . $logfile;
    if ( $reportsdir ) {
        $logfile =~ /(.*?)\.log(\.gz|\.bz2)?$/;
        $self->{'reportfile'} = $reportsdir . "/" . $1 . ".txt";
    } else {
        $self->{'reportfile'} = '/dev/null';
    }
    return $self;
}

sub run_test {
    my $self = $_[0];

    my $result = $self->lire_run( "lr_log2report $self->{'service'} < $self->{'logfile'} > $self->{'reportfile'}" );
    $self->annotate( $result->stderr() );
    $self->assert_equals( 0, $result->status() );
    $self->assert( !$result->stdout(), "stdout should be empty" );
    $self->assert_does_not_match( qr/(ERROR|WARNING)/, $result->stderr(),
                                  "There were warnings or error messages." );
}

1;
