#
# Copyright (C) 2019-2025 Mathieu Parent <math.parent@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import annotations

from dataclasses import KW_ONLY, dataclass, field
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from typing import Literal


@dataclass
class PackageFile:
    url: str
    package_type: Literal["generic", "helm", "pypi"]
    package_name: str
    package_version: str = "0"
    file_name: str = ""
    _: KW_ONLY
    metadata: dict[str, str] = field(default_factory=dict)
    force: bool = False
    delete: bool = False

    def __post_init__(self) -> None:
        if not self.file_name:
            self.file_name = self.url.split("/").pop()
