#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

from __future__ import nested_scopes

import random, string, math, operator
from genetic import organism, lifecycle, prog

class Point:
  def __init__(self, x, y):
    self.x = x
    self.y = y
    
points = [
  Point(0.0, 0.0 ),
  Point(0.5, 0.45),
  Point(0.7, 0.7 ),
  Point(0.8, 0.82),
  ]


def square(equation):
  try:
    return reduce(operator.add, map(
      lambda point : (point.y - equation(x = point.x)) ** 2,
      points))
  except ZeroDivisionError:
    return None

equationcontext = prog.EquationContext(x = 0.0)


import sys, operator

#eq = equationcontext(data = [operator.add, -0.012010999445366544, equationcontext.args[0]])
#print eq, square(eq)
#sys.exit()




class EquationFinder(organism.Organism):
  characteristics = [
    organism.Characteristic("square", square, organism.RECESSIVE_PHENOTYPE)
    ]
  
  def __cmp__(self, other):
    return cmp(self.square, other.square)


organismA = EquationFinder([
  organism.Chromosom(equation = equationcontext()),
  ])

organismB = EquationFinder([
  organism.Chromosom(equation = equationcontext()),
  ])

organisms = [organismA, organismB]


# Define some parameters

# True for elitism (= always keep the best organism)
ELITISM = 1

# Number of generation to run
NB_GENERATION = 10

# Number of children each generation made
NB_CHILDREN  = 100

# Number of organisms kept per generation (other children doesn't survive)
NB_ORGANISMS = 10


# Ready !
#
# This will make live a lot of organism, and finally print the last and "best" one -- the
# one whose phenotype minimizes FUNC !

organisms = lifecycle.run(organisms, ELITISM, NB_GENERATION, NB_CHILDREN, NB_ORGANISMS)

print organisms[0].genotype[0][0].__dict__.keys()
print organisms[0].genotype[0][0].equation
print square(organisms[0].genotype[0][0].equation)

print organisms[0].genotype[0][1].equation
print square(organisms[0].genotype[0][1].equation)
