#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

import random, string, math
from genetic import organism, lifecycle


# Set the function to minimize.

def FUNC(x):
  if x < 0.0 or x > 6.0: return None # Organism with "None" phenotype cannot live !
  return math.cos(x)

class FUNCMinimizer(organism.Organism):
  characteristics = [
    organism.Characteristic("FUNC", FUNC)
    ]
  
  def __cmp__(self, other):
    return cmp(self.FUNC, other.FUNC)


# Create an initial set of organisms.
#
# Here, we've set the deletion to 0.5 = 50%. Remember, organisms hate loosing gene...
# So you will see the value of the __deletion__ gene falling down accross the generation !
#
# See how your organisms adaptate and reject the "bad" gene !

organismA = FUNCMinimizer([
  organism.Chromosom(__deletion__ = 0.5, __mutation__ = 0.5, __mutampl__ = 4.0, x = 5.0),
  ])

organismB = FUNCMinimizer([
  organism.Chromosom(__deletion__ = 0.5, __mutation__ = 1.0, __mutampl__ = 2.0, x = 1.0),
  ])

organisms = [organismA, organismB]


# Define some parameters

# True for elitism (= always keep the best organism)
ELITISM = 1

# Number of generation to run
NB_GENERATION = 8

# Number of children each generation made
NB_CHILDREN  = 75

# Number of organisms kept per generation (other children doesn't survive)
NB_ORGANISMS = 10


# Ready !

lifecycle.run(organisms, ELITISM, NB_GENERATION, NB_CHILDREN, NB_ORGANISMS)

# You should approach the PI value -- but worse than the previous demo, since
# the deletion slows the organisms evolution !
