/*
Copyright (C) 2002 Pedro Zorzenon Neto <pzn@vztech.com.br>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: ihex2txt.c,v 1.2 2003/06/30 17:20:25 pzn Exp $
*/
#include "common.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "intelhex.h"

int main (int argc, char *argv[]) {

  inteldata ihex;
  int i;
  FILE *f;
  char l[780]; /* > (256*3)+5 */
  char ll[4]; /* space + 2 chars + 0x00 */

  if ( argc == 2 ) {
    if ( (strcmp(argv[1],"--help")) ||
	 (strcmp(argv[1],"-h")) ||
	 (strcmp(argv[1],"-?")) ||
	 (strcmp(argv[1],"--usage")) ||
	 (strcmp(argv[1],"/?")) ) {
      fprintf(stderr,"ihex2txt is free software with ABSOLUTELY "
	      "NO WARRANTY. \nCopyright (c) 2002 - Pedro Zorzenon "
	      "Neto.\nihex2txt: converts Intelhex file to simple "
	      "text format\nUsage: ihex2txt inputfilename.hex "
	      "outputfilename.txt\nWarning: outputfilename.txt will "
	      "be overwritten.\n");
      return 1;
    }
  }

  if ( argc != 3 ) {
    fprintf(stderr,"Try: ihex2txt --help\n");
    return 1;
  }

  intelhex_fileopen ( &ihex, argv[1], 1);
  f=fopen(argv[2],"w");
  if (f==NULL) {
    perror("Error opening output file");
    intelhex_fileclose (&ihex);
    abort();
  }

  while ( intelhex_readline (&ihex)==1 ) {
    sprintf(l,"%04X",ihex.offset);
    for (i=0; i<ihex.reclen; i++) {
      sprintf(ll," %02X", (int) ihex.recdata[i]);
      strcat(l,ll);
    }
    strcat(l,"\n");
    fputs(l,f);
  }
  intelhex_fileclose (&ihex);
  fclose(f);

  return 0;
}
