## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Locale/Alias.pm: locale aliases for i18n support
## ----------------------------------------------------------------------
## Copyright (C) 1998-2004 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
package DebianDoc_SGML::Locale::Alias;
use strict;
use vars qw( @ISA @EXPORT );
use Exporter;
@ISA = qw( Exporter );
@EXPORT = qw( %locale_aliases );

## ----------------------------------------------------------------------
## locale alias definitions
##
## left side is the argument for -l option.
##  -> use of non-standard locale value makes it easy to build HTML
##     which use extension such as pt-br with the matching file name
##     for plain text.
##
## right side is the data directory name.
##
use vars qw( %locale_aliases );
%locale_aliases = (

		   'ca'				=> 'ca_ES.ISO8859-1',
		   'ca_ES'			=> 'ca_ES.ISO8859-1',
		   'ca_ES.ISO8859-1'		=> 'ca_ES.ISO8859-1',
		   'ca-es'			=> 'ca_ES.iso8859-1',
		   'ca-es.iso8859-1'		=> 'ca_ES.ISO8859-1',
		   'ca_ES@euro'			=> 'ca_ES.ISO8859-15',
		   'ca_ES.ISO8859-15'		=> 'ca_ES.ISO8859-15',
		   'ca_ES.ISO8859-15@euro'	=> 'ca_ES.ISO8859-15',
		   'ca-es@euro'			=> 'ca_ES.ISO8859-15',
		   'ca-es.iso8859-15'		=> 'ca_ES.ISO8859-15',
		   'ca-es.iso8859-15@euro'	=> 'ca_ES.ISO8859-15',
		   'ca.UTF-8'			=> 'ca_ES.UTF-8',
		   'ca_ES.UTF-8'		=> 'ca_ES.UTF-8',
		   'ca.utf-8'			=> 'ca_ES.UTF-8',
		   'ca-es.utf-8'		=> 'ca_ES.UTF-8',

		   'cs'				=> 'cs_CZ.ISO8859-2',
		   'cs_CZ'			=> 'cs_CZ.ISO8859-2',
		   'cs_CZ.ISO8859-2'		=> 'cs_CZ.ISO8859-2',
		   'cs'				=> 'cs_CZ.ISO8859-2',
		   'cs-cz'			=> 'cs_CZ.ISO8859-2',
		   'cs-cz.iso8859-2'		=> 'cs_CZ.ISO8859-2',
		   'cs.UTF-8'			=> 'cs_CZ.UTF-8',
		   'cs_CZ.UTF-8'		=> 'cs_CZ.UTF-8',
		   'cs.utf-8'			=> 'cs_CZ.UTF-8',
		   'cs-cz.utf-8'		=> 'cs_CZ.UTF-8',

		   'da'				=> 'da_DK.ISO8859-1',
		   'da_DK'			=> 'da_DK.ISO8859-1',
		   'da_DK.ISO8859-1'		=> 'da_DK.ISO8859-1',
		   'da-dk'			=> 'da_DK.ISO8859-1',
		   'da-dk.iso8859-1'		=> 'da_DK.ISO8859-1',
		   'da.UTF-8'			=> 'da_DK.UTF-8',
		   'da_DK.UTF-8'		=> 'da_DK.UTF-8',
		   'da.utf-8'			=> 'da_DK.UTF-8',
		   'da-dk.utf-8'		=> 'da_DK.UTF-8',

		   'de'				=> 'de_DE.ISO8859-1',
		   'de_DE'			=> 'de_DE.ISO8859-1',
		   'de_DE.ISO8859-1'		=> 'de_DE.ISO8859-1',
		   'de-de'			=> 'de_DE.ISO8859-1',
		   'de-de.iso8859-1'		=> 'de_DE.ISO8859-1',
		   'de_DE@euro'			=> 'de_DE.ISO8859-15',
		   'de_DE.ISO8859-15'		=> 'de_DE.ISO8859-15',
		   'de_DE.ISO8859-15@euro'	=> 'de_DE.ISO8859-15',
		   'de-de@euro'			=> 'de_DE.ISO8859-15',
		   'de-de.iso8859-15'		=> 'de_DE.ISO8859-15',
		   'de-de.iso8859-15@euro'	=> 'de_DE.ISO8859-15',
		   'de.UTF-8'			=> 'de_DE.UTF-8',
		   'de_DE.UTF-8'		=> 'de_DE.UTF-8',
		   'de.utf-8'			=> 'de_DE.UTF-8',
		   'de-de.utf-8'		=> 'de_DE.UTF-8',

		   'en'				=> 'en_US.ISO8859-1',
		   'en_US'			=> 'en_US.ISO8859-1',
		   'en_US.ISO8859-1'		=> 'en_US.ISO8859-1',
		   'en-us'			=> 'en_US.ISO8859-1',
		   'en-us.ISO8859-1'		=> 'en_US.ISO8859-1',
		   'en_US@euro'			=> 'en_US.ISO8859-15',
		   'en_US.ISO8859-15'		=> 'en_US.ISO8859-15',
		   'en_US.ISO8859-15@euro'	=> 'en_US.ISO8859-15',
		   'en-us@euro'			=> 'en_US.ISO8859-15',
		   'en-us.iso8859-15'		=> 'en_US.ISO8859-15',
		   'en-us.iso8859-15@euro'	=> 'en_US.ISO8859-15',
		   'en.UTF-8'			=> 'en_US.UTF-8',
		   'en_US.UTF-8'		=> 'en_US.UTF-8',
		   'en.utf-8'			=> 'en_US.UTF-8',
		   'en-us.utf-8'		=> 'en_US.UTF-8',

		   'en_GB'			=> 'en_US.ISO8859-1',
		   'en_GB.ISO8859-1'		=> 'en_US.ISO8859-1',
		   'en-gb'			=> 'en_US.iso8859-1',
		   'en-gb.iso8859-1'		=> 'en_US.ISO8859-1',
		   'en_GB@euro'			=> 'en_US.ISO8859-15',
		   'en_GB.ISO8859-15'		=> 'en_US.ISO8859-15',
		   'en_GB.ISO8859-15@euro'	=> 'en_US.ISO8859-15',
		   'en-gb@euro'			=> 'en_US.ISO8859-15',
		   'en-gb.iso8859-15'		=> 'en_US.ISO8859-15',
		   'en-gb.iso8859-15@euro'	=> 'en_US.ISO8859-15',
		   'en_GB.UTF-8'		=> 'en_US.UTF-8',
		   'en-gb.utf-8'		=> 'en_US.UTF-8',


		   'es'				=> 'es_ES.ISO8859-1',
		   'es_ES'			=> 'es_ES.ISO8859-1',
		   'es_ES.ISO8859-1'		=> 'es_ES.ISO8859-1',
		   'es-es'			=> 'es_ES.ISO8859-1',
		   'es-es.iso8859-1'		=> 'es_ES.ISO8859-1',
		   'es_ES@euro'			=> 'es_ES.ISO8859-15',
		   'es_ES.ISO8859-15'           => 'es_ES.ISO8859-15',
		   'es_ES.ISO8859-15@euro'	=> 'es_ES.ISO8859-15',
		   'es-es@euro'			=> 'es_ES.ISO8859-15',
		   'es-es.iso8859-15'           => 'es_ES.ISO8859-15',
		   'es-es.iso8859-15@euro'	=> 'es_ES.ISO8859-15',
		   'es.UTF-8'			=> 'es_ES.UTF-8',
		   'es_ES.UTF-8'		=> 'es_ES.UTF-8',
		   'es.utf-8'			=> 'es_ES.UTF-8',
		   'es-es.utf-8'		=> 'es_ES.UTF-8',

		   'eu'				=> 'eu_ES.ISO8859-1',
		   'eu_ES'			=> 'eu_ES.ISO8859-1',
		   'eu_ES.ISO8859-1'		=> 'eu_ES.ISO8859-1',
		   'eu-es'			=> 'eu_ES.ISO8859-1',
		   'eu-es.iso8859-1'		=> 'eu_ES.ISO8859-1',
		   'eu_ES@euro'			=> 'eu_ES.ISO8859-15',
		   'eu_ES.ISO8859-15'		=> 'eu_ES.ISO8859-15',
		   'eu_ES.ISO8859-15@euro'	=> 'eu_ES.ISO8859-15',
		   'eu-es@euro'			=> 'eu_ES.ISO8859-15',
		   'eu-es.iso8859-15'		=> 'eu_ES.ISO8859-15',
		   'eu-es.iso8859-15@euro'	=> 'eu_ES.ISO8859-15',
		   'eu.UTF-8'			=> 'eu_ES.UTF-8',
		   'eu_ES.UTF-8'		=> 'eu_ES.UTF-8',
		   'eu.utf-8'			=> 'eu_ES.UTF-8',
		   'eu-es.utf-8'		=> 'eu_ES.UTF-8',

		   'eu_FR'			=> 'eu_FR.ISO8859-1',
		   'eu_FR.ISO8859-1'		=> 'eu_FR.ISO8859-1',
		   'eu-fr'			=> 'eu_FR.ISO8859-1',
		   'eu-fr.iso8859-1'		=> 'eu_FR.ISO8859-1',
		   'eu_FR@euro'			=> 'eu_FR.ISO8859-15',
		   'eu_FR.ISO8859-15'		=> 'eu_FR.ISO8859-15',
		   'eu_FR.ISO8859-15@euro'	=> 'eu_FR.ISO8859-15',
		   'eu-fr@euro'			=> 'eu_FR.ISO8859-15',
		   'eu-fr.iso8859-15'		=> 'eu_FR.ISO8859-15',
		   'eu-fr.iso8859-15@euro'	=> 'eu_FR.ISO8859-15',
		   'eu.UTF-8'			=> 'eu_FR.UTF-8',
		   'eu_FR.UTF-8'		=> 'eu_FR.UTF-8',
		   'eu.utf-8'			=> 'eu_FR.UTF-8',
		   'eu-fr.utf-8'		=> 'eu_FR.UTF-8',

		   'fi'				=> 'fi_FI.ISO8859-1',
		   'fi_FI'			=> 'fi_FI.ISO8859-1',
		   'fi_FI.ISO8859-1'		=> 'fi_FI.ISO8859-1',
		   'fi-fi'			=> 'fi_FI.ISO8859-1',
		   'fi-fi.iso8859-1'		=> 'fi_FI.ISO8859-1',
		   'fi_FI@euro'			=> 'fi_FI.ISO8859-15',
		   'fi_FI.ISO8859-15'		=> 'fi_FI.ISO8859-15',
		   'fi_FI.ISO8859-15@euro'	=> 'fi_FI.ISO8859-15',
		   'fi-fi@euro'			=> 'fi_FI.ISO8859-15',
		   'fi-fi.iso8859-15'		=> 'fi_FI.ISO8859-15',
		   'fi-fi.iso8859-15@euro'	=> 'fi_FI.ISO8859-15',
		   'fi.UTF-8'			=> 'fi_FI.UTF-8',
		   'fi_FI.UTF-8'		=> 'fi_FI.UTF-8',
		   'fi.utf-8'			=> 'fi_FI.UTF-8',
		   'fi-fi.utf-8'		=> 'fi_FI.UTF-8',

		   'fr'				=> 'fr_FR.ISO8859-1',
		   'fr_FR'			=> 'fr_FR.ISO8859-1',
		   'fr_FR.ISO8859-1'		=> 'fr_FR.ISO8859-1',
		   'fr-fr'			=> 'fr_FR.ISO8859-1',
		   'fr-fr.iso8859-1'		=> 'fr_FR.ISO8859-1',
		   'fr_FR@euro'			=> 'fr_FR.ISO8859-15',
		   'fr_FR.ISO8859-15'		=> 'fr_FR.ISO8859-15',
		   'fr_FR.ISO8859-15@euro'	=> 'fr_FR.ISO8859-15',
		   'fr-fr@euro'			=> 'fr_FR.ISO8859-15',
		   'fr-fr.iso8859-15'		=> 'fr_FR.ISO8859-15',
		   'fr-fr.iso8859-15@euro'	=> 'fr_FR.ISO8859-15',
		   'fr.UTF-8'			=> 'fr_FR.UTF-8',
		   'fr_FR.UTF-8'		=> 'fr_FR.UTF-8',
		   'fr.utf-8'			=> 'fr_FR.UTF-8',
		   'fr-fr.utf-8'		=> 'fr_FR.UTF-8',

		   'gl'				=> 'gl_ES.ISO8859-1',
		   'gl_ES'			=> 'gl_ES.ISO8859-1',
		   'gl_ES.ISO8859-1'		=> 'gl_ES.ISO8859-1',
		   'gl-es'			=> 'gl_ES.ISO8859-1',
		   'gl-es.iso8859-1'		=> 'gl_ES.ISO8859-1',
		   'gl_ES@euro'			=> 'gl_ES.ISO8859-15',
		   'gl_ES.ISO8859-15'		=> 'gl_ES.ISO8859-15',
		   'gl_ES.ISO8859-15@euro'	=> 'gl_ES.ISO8859-15',
		   'gl-es@euro'			=> 'gl_ES.ISO8859-15',
		   'gl-es.iso8859-15'		=> 'gl_ES.ISO8859-15',
		   'gl-es.iso8859-15@euro'	=> 'gl_ES.ISO8859-15',
		   'gl.UTF-8'			=> 'gl_ES.UTF-8',
		   'gl_ES.UTF-8'		=> 'gl_ES.UTF-8',
		   'gl.utf-8'			=> 'gl_ES.UTF-8',
		   'gl-es.utf-8'		=> 'gl_ES.UTF-8',

		   'hr'				=> 'hr_HR.ISO8859-2',
		   'hr_HR'			=> 'hr_HR.ISO8859-2',
		   'hr_HR.ISO8859-2'		=> 'hr_HR.ISO8859-2',
		   'hr-hr'			=> 'hr_HR.ISO8859-2',
		   'hr-hr.iso8859-2'		=> 'hr_HR.ISO8859-2',
		   'hr.UTF-8'			=> 'hr_HR.UTF-8',
		   'hr_HR.UTF-8'		=> 'hr_HR.UTF-8',
		   'hr.utf-8'			=> 'hr_HR.UTF-8',
		   'hr-hr.utf-8'		=> 'hr_HR.UTF-8',

		   'it'				=> 'it_IT.ISO8859-1',
		   'it_IT'			=> 'it_IT.ISO8859-1',
		   'it_IT.ISO8859-1'		=> 'it_IT.ISO8859-1',
		   'it-it'			=> 'it_IT.ISO8859-1',
		   'it-it.iso8859-1'		=> 'it_IT.ISO8859-1',
		   'it_IT@euro'			=> 'it_IT.ISO8859-15',
		   'it_IT.ISO8859-15'		=> 'it_IT.ISO8859-15',
		   'it_IT.ISO8859-15@euro'	=> 'it_IT.ISO8859-15',
		   'it-it@euro'			=> 'it_IT.ISO8859-15',
		   'it-it.iso8859-15'		=> 'it_IT.ISO8859-15',
		   'it-it.iso8859-15@euro'	=> 'it_IT.ISO8859-15',
		   'it.UTF-8'			=> 'it_IT.UTF-8',
		   'it_IT.UTF-8'		=> 'it_IT.UTF-8',
		   'it.utf-8'			=> 'it_IT.UTF-8',
		   'it-it.utf-8'		=> 'it_IT.UTF-8',

		   'ja'				=> 'ja_JP.eucJP',
		   'ja_JP'			=> 'ja_JP.eucJP',
		   'ja_JP.eucJP'		=> 'ja_JP.eucJP',
		   'ja_JP.ujis'			=> 'ja_JP.eucJP',
		   'ja-jp'			=> 'ja_JP.eucJP',
		   'ja-jp.eucjp'		=> 'ja_JP.eucJP',
		   'ja-jp.ujis'			=> 'ja_JP.eucJP',
		   'ja.UTF-8'			=> 'ja_JP.UTF-8',
		   'ja_JP.UTF-8'		=> 'ja_JP.UTF-8',
		   'ja.utf-8'			=> 'ja_JP.UTF-8',
		   'ja-jp.utf-8'		=> 'ja_JP.UTF-8',

		   'ko'				=> 'ko_KR.eucKR',
		   'ko_KR'			=> 'ko_KR.eucKR',
		   'ko_KR.eucKR'		=> 'ko_KR.eucKR',
		   'ko-kr'			=> 'ko_KR.eucKR',
		   'ko-kr.euckr'		=> 'ko_KR.eucKR',
		   'ko.UTF-8'			=> 'ko_KR.UTF-8',
		   'ko_KR.UTF-8'		=> 'ko_KR.UTF-8',
		   'ko.utf-8'			=> 'ko_KR.UTF-8',
		   'ko-kr.utf-8'		=> 'ko_KR.UTF-8',

		   'lt'				=> 'lt_LT.ISO8859-13',
		   'lt_LT'			=> 'lt_LT.ISO8859-13',
		   'lt_LT.ISO8859-13'		=> 'lt_LT.ISO8859-13',
		   'lt-lt'			=> 'lt_LT.ISO8859-13',
		   'lt-lt.iso8859-13'		=> 'lt_LT.ISO8859-13',
		   'lt.UTF-8'			=> 'lt_LT.UTF-8',
		   'lt_LT.UTF-8'		=> 'lt_LT.UTF-8',
		   'lt.utf-8'			=> 'lt_LT.UTF-8',
		   'lt-lt.utf-8'		=> 'lt_LT.UTF-8',

		   'nl'				=> 'nl_NL.ISO8859-1',
		   'nl_NL'			=> 'nl_NL.ISO8859-1',
		   'nl_NL.ISO8859-1'		=> 'nl_NL.ISO8859-1',
		   'nl-nl'			=> 'nl_NL.ISO8859-1',
		   'nl-nl.iso8859-1'		=> 'nl_NL.ISO8859-1',
		   'nl_NL@euro'			=> 'nl_NL.ISO8859-15',
		   'nl_NL.ISO8859-15'		=> 'nl_NL.ISO8859-15',
		   'nl_NL.ISO8859-15@euro'	=> 'nl_NL.ISO8859-15',
		   'nl-nl@euro'			=> 'nl_NL.ISO8859-15',
		   'nl-nl.iso8859-15'		=> 'nl_NL.ISO8859-15',
		   'nl-nl.iso8859-15@euro'	=> 'nl_NL.ISO8859-15',
		   'nl.UTF-8'			=> 'nl_NL.UTF-8',
		   'nl_NL.UTF-8'		=> 'nl_NL.UTF-8',
		   'nl.utf-8'			=> 'nl_NL.UTF-8',
		   'nl-nl.utf-8'		=> 'nl_NL.UTF-8',

		   'pl'				=> 'pl_PL.ISO8859-2',
		   'pl_PL'			=> 'pl_PL.ISO8859-2',
		   'pl_PL.ISO8859-2'		=> 'pl_PL.ISO8859-2',
		   'pl-pl'			=> 'pl_PL.ISO8859-2',
		   'pl-pl.iso8859-2'		=> 'pl_PL.ISO8859-2',
		   'pl.UTF-8'			=> 'pl_PL.UTF-8',
		   'pl_PL.UTF-8'		=> 'pl_PL.UTF-8',
		   'pl.utf-8'			=> 'pl_PL.UTF-8',
		   'pl-pl.utf-8'		=> 'pl_PL.UTF-8',

		   'pt_BR'			=> 'pt_BR.ISO8859-1',
		   'pt_BR.ISO8859-1'		=> 'pt_BR.ISO8859-1',
		   'pt-br'			=> 'pt_BR.ISO8859-1',
		   'pt-br.iso8859-1'		=> 'pt_BR.ISO8859-1',
		   'pt_BR.UTF-8'		=> 'pt_BR.UTF-8',
		   'pt-br.utf-8'		=> 'pt_BR.UTF-8',

		   'pt'				=> 'pt_PT.ISO8859-1',
		   'pt_PT'			=> 'pt_PT.ISO8859-1',
		   'pt_PT.ISO8859-1'		=> 'pt_PT.ISO8859-1',
		   'pt-pt'			=> 'pt_PT.ISO8859-1',
		   'pt-pt.iso8859-1'		=> 'pt_PT.ISO8859-1',
		   'pt_PT@euro'			=> 'pt_PT.ISO8859-15',
		   'pt_PT.ISO8859-15'		=> 'pt_PT.ISO8859-15',
		   'pt_PT.ISO8859-15@euro'	=> 'pt_PT.ISO8859-15',
		   'pt-pt@euro'			=> 'pt_PT.ISO8859-15',
		   'pt-pt.iso8859-15'		=> 'pt_PT.ISO8859-15',
		   'pt-pt.iso8859-15@euro'	=> 'pt_PT.ISO8859-15',
		   'pt.UTF-8'			=> 'pt_PT.UTF-8',
		   'pt_PT.UTF-8'		=> 'pt_PT.UTF-8',
		   'pt.utf-8'			=> 'pt_PT.UTF-8',
		   'pt-pt.utf-8'		=> 'pt_PT.UTF-8',

		   'ro'				=> 'ro_RO.ISO8859-2',
		   'ro_RO'			=> 'ro_RO.ISO8859-2',
		   'ro_RO.ISO8859-2'		=> 'ro_RO.ISO8859-2',
		   'ro-ro'			=> 'ro_RO.ISO8859-2',
		   'ro-ro.iso8859-2'		=> 'ro_RO.ISO8859-2',
		   'ro.UTF-8'			=> 'ro_RO.UTF-8',
		   'ro_RO.UTF-8'		=> 'ro_RO.UTF-8',
		   'ro.utf-8'			=> 'ro_RO.UTF-8',
		   'ro-ro.utf-8'		=> 'ro_RO.UTF-8',

		   'ru'				=> 'ru_RU.KOI8-R',
		   'ru_RU'			=> 'ru_RU.KOI8-R',
		   'ru_RU.KOI8-R'		=> 'ru_RU.KOI8-R',
		   'ru-ru'			=> 'ru_RU.KOI8-R',
		   'ru-ru.koi8-r'		=> 'ru_RU.KOI8-R',
		   'ru.UTF-8'			=> 'ru_RU.UTF-8',
		   'ru_RU.UTF-8'		=> 'ru_RU.UTF-8',
		   'ru.utf-8'			=> 'ru_RU.UTF-8',
		   'ru-ru.utf-8'		=> 'ru_RU.UTF-8',

		   'sk'				=> 'sk_SK.ISO8859-2',
		   'sk_SK'			=> 'sk_SK.ISO8859-2',
		   'sk_SK.ISO8859-2'		=> 'sk_SK.ISO8859-2',
		   'sk-sk'			=> 'sk_SK.ISO8859-2',
		   'sk-sk.iso8859-2'		=> 'sk_SK.ISO8859-2',
		   'sk.UTF-8'			=> 'sk_SK.UTF-8',
		   'sk_SK.UTF-8'		=> 'sk_SK.UTF-8',
		   'sk.utf-8'			=> 'sk_SK.UTF-8',
		   'sk-sk.utf-8'		=> 'sk_SK.UTF-8',

		   'sl'                         => 'sl_SI.ISO8859-2',
		   'sl_SI'                      => 'sl_SI.ISO8859-2',
		   'sl_SI.ISO8859-2'            => 'sl_SI.ISO8859-2',
		   'sl-si'                      => 'sl_SI.ISO8859-2',
		   'sl-si.iso8859-2'            => 'sl_SI.ISO8859-2',
		   'sl.UTF-8'			=> 'sl_SI.UTF-8',
		   'sl_SI.UTF-8'		=> 'sl_SI.UTF-8',
		   'sl.utf-8'			=> 'sl_SI.UTF-8',
		   'sl-si.utf-8'		=> 'sl_SI.UTF-8',

		   'sv'                         => 'sv_SE.ISO8859-1',
		   'sv_SE'                      => 'sv_SE.ISO8859-1',
		   'sv_SE.ISO8859-1'            => 'sv_SE.ISO8859-1',
		   'sv-se'                      => 'sv_SE.ISO8859-1',
		   'sv-se.iso8859-1'            => 'sv_SE.ISO8859-1',
		   'sv.UTF-8'			=> 'sv_SE.UTF-8',
		   'sv_SE.UTF-8'		=> 'sv_SE.UTF-8',
		   'sv.utf-8'			=> 'sv_SE.UTF-8',
		   'sv-se.utf-8'		=> 'sv_SE.UTF-8',

		   'tr'				=> 'tr_TR.ISO8859-9',
		   'tr_TR'			=> 'tr_TR.ISO8859-9',
		   'tr_TR.ISO8859-9'		=> 'tr_TR.ISO8859-9',
		   'tr-tr'			=> 'tr_TR.ISO8859-9',
		   'tr-tr.iso8859-9'		=> 'tr_TR.ISO8859-9',
		   'tr.UTF-8'			=> 'tr_TR.UTF-8',
		   'tr_TR.UTF-8'		=> 'tr_TR.UTF-8',
		   'tr.utf-8'			=> 'tr_TR.UTF-8',
		   'tr-tr.utf-8'		=> 'tr_TR.UTF-8',

		   'uk'				=> 'uk_UA.UTF-8',
		   'uk_UA'			=> 'uk_UA.UTF-8',
		   'uk.UTF-8'			=> 'uk_UA.UTF-8',
		   'uk_UA.UTF-8'		=> 'uk_UA.UTF-8',
		   'uk-ua'			=> 'uk_UA.UTF-8',
		   'uk.utf-8'			=> 'uk_UA.UTF-8',
		   'uk-ua.utf-8'		=> 'uk_UA.UTF-8',

		   'vi'				=> 'vi_VN.UTF-8',
		   'vi_VN'			=> 'vi_VN.UTF-8',
		   'vi.UTF-8'			=> 'vi_VN.UTF-8',
		   'vi_VN.UTF-8'		=> 'vi_VN.UTF-8',
		   'vi-vn'			=> 'vi_VN.UTF-8',
		   'vi.utf-8'			=> 'vi_VN.UTF-8',
		   'vi-vn.utf-8'		=> 'vi_VN.UTF-8',
		   
		   'zh_CN'			=> 'zh_CN.GB2312',
		   'zh_CN.GB2312'		=> 'zh_CN.GB2312',
		   'zh-cn'			=> 'zh_CN.GB2312',
		   'zh-cn.gb2312'		=> 'zh_CN.GB2312',
		   'zh_CN.UTF-8'		=> 'zh_CN.UTF-8',
		   'zh-cn.utf-8'		=> 'zh_CN.UTF-8',

		   'zh_HK'			=> 'zh_TW.Big5',
		   'zh_HK.Big5' 		=> 'zh_TW.Big5',
		   'zh-hk'			=> 'zh_TW.Big5',
		   'zh-hk.big5' 		=> 'zh_TW.Big5',
		   'zh_HK.UTF-8' 		=> 'zh_TW.UTF-8',
		   'zh-hk.utf-8' 		=> 'zh_TW.UTF-8',

		   'zh_TW'			=> 'zh_TW.Big5',
		   'zh_TW.Big5'			=> 'zh_TW.Big5',
		   'zh-tw'			=> 'zh_TW.Big5',
		   'zh-tw.big5'			=> 'zh_TW.Big5',
		   'zh_TW.UTF-8'		=> 'zh_TW.UTF-8',
		   'zh-tw.utf-8'		=> 'zh_TW.UTF-8',

		   );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
